const
(* Errors constants *)
  ZERROR_OK		      = 0;	{ No error }
  ZERROR_WARNING		= 1; 	{ Just a warning (not an error) }
  ZERROR_DESTFILE		= 2;  { Destfile ( *.ZIP ) error }
  ZERROR_INTERNAL 	= 3;  { Internal error }
  ZERROR_FORMAT		  = 4;  { Not a Zip file }
  ZERROR_NOMEM		  = 5;  { Not enough memory }
  ZERROR_NOFILE		  = 6;  { Nothing to do ( can be just a warning ) }
  ZERROR_NODLL		  = 7;  { Can' t find required DLLs }
  ZERROR_COMMENT		= 8;  { Comment missing or NULL }

(* Overwrite mode *)
  OVERWRITE_ALWAYS	= 0;  { Always overwrite ( always zip files ) (default) }
  OVERWRITE_NEVER		= 1;  { Never overwrite }
  OVERWRITE_PROMPT	= 2;  { Ask the user }
  OVERWRITE_UPDATE	= 3;  { Overwrite if external file is newer }


(* Language mode ( for the replace dialog box ) *)
  LANGUAGE_FRENCH		= 0;	{ French mode }
  LANGUAGE_ENGLISH	= 1;	{ US Mode ( default ) }


(* More easy to use with AddFileToZip *)
  STOREPATH_NO		  = FALSE; { Don' t store paths }
  STOREPATH_YES		  = TRUE;  { Store paths }
  RECURSE_NO		    = FALSE; { Don' t recurse sub dirs }
  RECURSE_YES		    = TRUE;  { Recurse sub dirs }


(* Notification messages *)
  ZN_ZIPPING		    = WM_USER + 46;  { Zipping a file, WP = compressed size in K, LP = current file name }
  ZN_FILEZIPPED		  = WM_USER + 45;  { File is zipped, WP = compress rate, LP = file name }
  ZN_WRITING		    = WM_USER + 48;  { Replace the Zip file, LP = zip file name }
  ZN_DELETING	      = WM_USER + 47;  { Delete a file , LP = current file name }
  ZN_REPARING		    = WM_USER + 49;  { Repare a Zip file, WP = (int)state }
                                     {   Step =  1 : Read / Write ,  LP = current file name }
                                     {   Step = 3 : Checking zip file, LP = zip file name   }
  ZN_COMPUTE		    = WM_USER +52;   { Before zip read, WP = zip files ( over 500, computing can be very long ) }

