unit xmisc2;

interface

Type
	TByteArray = array[0..0] of byte;
	TIntArray  = array[0..0] of integer;
	TWordArray = array[0..0] of integer;

function  xinttostr( n : integer; w : byte ) : string;
function  xcompare( var a, b; l : word ) : boolean;
function  xexists( filename : string ) : boolean;
procedure xstrupcase( var s : string );

implementation

function xinttostr( n : integer; w : byte ) : string;
var
	s : string;
begin
	str( n:w, s );
	xinttostr := s;
end;

function xcompare( var a, b; l : word ) : boolean; assembler;
asm
	cld
	push ds
	lds  si, a
	les  di, b
	mov  cx, l
	repe cmpsb
	or   cx, cx
	jz   @@Ok
	mov  ax, 0
	jmp  @@Done

@@Ok:
	mov  ax, 1

@@Done:
	pop  ds

end;

function xexists( filename : string ) : boolean;
var
	f : file;
	tmp : boolean;
begin
	{$I-}
	assign( f, filename );
	reset( f );
	{$I+}
	tmp := ioresult=0;
	if tmp then close(f);
	xexists := tmp;
end;

procedure xstrupcase( var s : string ); assembler;
asm
	les di, s
	mov cx, 0
	mov cl, es:[di]
	inc di
	or  cl, cl
	jz @@Done

@@ChangeChar:
	mov al, es:[di]
	cmp al, 'a'
	jl @@Next
	cmp al, 'z'
	jg @@Next
	sub al, 32
	mov es:[di], al
@@Next:
	inc di
	loop @@ChangeChar
@@Done:
end;

end.