Unit MyMouse;

{ Unit MyMouse, Version 1.60.001, Copyright 1993 Matthias Kppe

  mymouse.inf mymouse.txt mymouse.doc
}

{$DEFINE Mode256 }

{$A+,B-,F-,G+,O-,R-,S-,X+}

{$IFDEF DPMI}
{$C FIXED PRELOAD PERMANENT}
{$ELSE}
{$IFNDEF Ver60}
{$DEFINE Regs386}
{$ENDIF}
{$ENDIF}

interface

uses Objects, Drivers;

{ Maus-Betriebsart
}

{ Betriebsarten     	Portvorgaben		Unterbrechungsanforderungen
}
const
  mm_Mode  = $000F;	mm_Port    = $0F00;	mm_IRQ    = $F000;
  mmDriver = $0000;	mmPortAuto = $0000;	mmIRQAuto = $0000;
  mmAuto   = $0001;	mmPort1    = $0100;	mmIRQ2    = $2000;
  mmMicro  = $0002;	mmPort2    = $0200;	mmIRQ3    = $3000;
  mmSystem = $0003;				mmIRQ4	  = $4000;
						mmIRQ5    = $5000;
  mmNoClk  = $0010;				mmIRQ6    = $6000;
						mmIRQ7    = $7000;

procedure SetMouseMode(AMode: Word);

const
  MouseMode: Word = mmDriver;

{ Initialisierung - Beendigung
}
procedure InitMyMouse;
procedure DoneMyMouse;
function MouseInstalled: Boolean;

procedure ReserveMouseSeg;
procedure SetBGIMode(Driver, Mode: Integer);

var
  ButtonCount: Byte			absolute Drivers.ButtonCount;
  MouseSaveSeg: Word;
  MouseSavePOfs: Word;
  MouseSavePSeg: Word;
  MouseSavePtr: pointer 		absolute MouseSavePOfs;

{ Ereignisverarbeitung
}
procedure GetMouseEvent(var Event: TEvent);

const
  evTimer = $400;

procedure GetTimerEvent(var Event: TEvent);

{ Maus-Position
}
procedure SetMousePos(x, y: Integer);

var
  MouseWhere: TPoint			absolute Drivers.MouseWhere;

{ Tasten-Status
}
var
  MouseButtons: Byte			absolute Drivers.MouseButtons;

{ Maus-Arbeitsbereich
}
procedure SetMouseArea(x1, y1, x2, y2: Integer);

var
  MouseArea: TRect;

{ Maus-Bildschirmseite
}
procedure SetMousePage(Page: Byte);

var
  MousePage: Byte;
  MousePagePtr: pointer;
  MousePageLinear: LongInt;

{ Kritischer Bereich
}
procedure SetCriticalArea(x1, y1, x2, y2: Integer);

var
  CriticalArea: TRect;

{ Kritische Bildschirmseite
}
procedure SetCriticalPage(Page: Byte);

var
  CriticalPage: Byte;

{ Zeigerform
}
const
  mcStd 	= 0;
  mcCross 	= 1;
  mcHourGlass 	= 2;
  mcLargeCross	= 3;

procedure SetMCursor(n: Integer);
procedure SetCursorPtr(p: pointer);

var
  CursorNum: Word;
  NewNum: Word;
  CursorPtr: pointer;

{ Zeigerfarbe
}
procedure SetPointerColor(AColor: Byte);

var
  PointerColor: Byte;

{ Anzeigen und Verstecken
}
procedure ShowMouse;
procedure HideMouse;

var
  MouseHidden: Integer;

{ Maximale Gre des Mauszeigers
}
const
  MaxWidth: Byte = 2;
  MaxLength: Byte = 32;

{ Reaktionszeiten
}
procedure SetDoubleSpeedTreshold(Value: Word);

var
  DoubleDelay: Word			absolute Drivers.DoubleDelay;
  RepeatDelay: Word			absolute Drivers.RepeatDelay;
  AutoDelay:   Word			absolute Drivers.RepeatDelay;

const
  DoubleSpeedTreshold: Word = 30;

{ ohne Funktion
}
var
  AutoSpeed: Word;

{ Service-Routine zur Anpassung der Maus
}
var
  ChangeCursor: procedure;

{ Service-Routine zur Ermittlung von Zeigerbitmaps
}
type
  TGetMCProc = procedure(n: Integer);

var
  GetMCursor: TGetMCProc;

{ Service-Routinen zur Darstellung des Zeigers
}
var
  DrawMouse:	  procedure;
  SaveScreen:     procedure;
  RestoreScreen:  procedure;
  SaveLatches:    procedure;
  RestoreLatches: procedure;

{ Mausports im BIOS-Segment
}
var
  Port1: Word 				absolute $40:$0;
  Port2: Word 				absolute $40:$2;

{ semi-interne Routinen
}
procedure MakeContain(var P: TPoint; R: TRect);

implementation

uses Dos, Gr;

{ Gespeicherte Interrupt-Routinen
}
var
  SavedIRQ: pointer;
  SavedDrvReq: pointer;
  SavedRetrace: pointer;
  SavedClock: pointer;

{ von DrawMouse und SaveScreen gespeicherte Parameter
}
var
  DrawData: array[0..15] of Byte;

{ Timerzyklen
}
var
  Ticks: Word				absolute $40:$6C;
  LastTicks: Word;

{ Direct processing
}
var
  HandleProc: Word;
  MPort: Word;

{ Allgemeines
}
var
  RegArea: array[0..6] of Byte;
  sMouseEvents: Boolean;
  IsDrawn: Boolean;
  LastWhere: TPoint;
  LastButtons: Byte;
  InMouse: Boolean;
  InService: Boolean;
  TimingState: Byte;
  Update: Byte;
  YEnd: Word;
  NextNotify: TNotifyProc;
  SavedFree: LongInt;

const
  Active: Boolean = false;
  GMReg = 5;

{ Included object files
}

{$L mymoint.obj     (mymoint.asm)	MyMouse, Internal Services }
{$L mymoque.obj	    (mymoque.asm)	MyMouse, Hardware Event Queue }
{$IFDEF DPMI}
{$L mymodpmi.obj    (mymodpmi.asm)	MyMouse, DPMI Support }
{$ELSE}
{$L mymoreal.obj    (mymoreal.asm)	MyMouse, Real Mode Support }
{$ENDIF}
{$L mymortrc.obj    (mymortrc.asm)	MyMouse, Retrace & Clock Processing }
{$L mymodrv.obj     (mymodrv.asm)	MyMouse, Driver Processing }
{$L mymodir.obj     (mymodir.asm)	MyMouse, Direct Processing }
{$L mymo16.obj	    (mymo16.asm)	MyMouse, 16 Colors, SVGA-capable }
{$IFDEF Mode256 }
{$L mymo256s.obj    (mymo256s.asm)	MyMouse, 256 Colors, SVGA-capable }
{$ENDIF}

procedure GetMouseCursor(n: Integer); far; assembler;
Asm
	MOV	AX, n
	OR	AX, AX
	MOV	SI, OFFSET @D0
	JZ	@@1
	DEC	AX
	MOV	SI, OFFSET @D1
	JZ	@@1
	DEC	AX
	MOV	SI, OFFSET @D2
	JZ	@@1
	DEC	AX
	MOV	SI, OFFSET @D3
	JNZ	@@2
@@1:    MOV	AX, n
	MOV	CursorNum, AX
	MOV	WORD PTR CursorPtr, SI
	MOV	WORD PTR CursorPtr+2, CS
	JMP	@@2

@D0:    DW	21, 2			{ Length in pixels, Width in bytes }
	DW	0, 0			{ Hotspot }
	DW      0000000000000000B	{ Screen Mask }
	DW	1100000000000000B
	DW	1110000000000000B
	DW	1111000000000000B
	DW	1111100000000000B
	DW	1111110000000000B
	DW	1111111000000000B
	DW	1111111100000000B
	DW	1111111110000000B
	DW	1111111111000000B
	DW	1111111111100000B
	DW	1111111111110000B
	DW	1111111100000000B
	DW	1111111100000000B
	DW	1110111110000000B
	DW	1100011110000000B
	DW	1000001111000000B
	DW	0000001111000000B
	DW	0000000111100000B
	DW	0000000111100000B
	DW	0000000011000000B
	DW	0000000000000000B	{ Pixel Mask }
	DW	0000000000000000B
	DW	0100000000000000B
	DW	0110000000000000B
	DW	0111000000000000B
	DW	0111100000000000B
	DW	0111110000000000B
	DW	0111111000000000B
	DW	0111111100000000B
	DW	0111111110000000B
	DW	0111111111000000B
	DW	0111111000000000B
	DW	0111011000000000B
	DW	0110011000000000B
	DW	0100001100000000B
	DW	0000001100000000B
	DW	0000000110000000B
	DW	0000000110000000B
	DW	0000000011000000B
	DW	0000000011000000B
	DW	0000000000000000B

@D1:	DW	16, 2, 8, 8		{ Cursortyp 1: Fadenkreuz }
	DW	0000000000000000B	{ Screen Mask }
	DW	0000000111000000B
	DW	0000000111000000B
	DW	0000000111000000B
	DW	0000000111000000B
	DW	0000000111000000B
	DW	0000000111000000B
	DW	0111111111111111B
	DW	0111111101111111B
	DW	0111111111111111B
	DW	0000000111000000B
	DW	0000000111000000B
	DW	0000000111000000B
	DW	0000000111000000B
	DW	0000000111000000B
	DW	0000000111000000B
	DW	0000000000000000B	{ Pixel Mask }
	DW	0000000010000000B
	DW	0000000010000000B
	DW	0000000010000000B
	DW	0000000010000000B
	DW	0000000010000000B
	DW	0000000010000000B
	DW	0000000010000000B
	DW	0111111101111111B
	DW	0000000010000000B
	DW	0000000010000000B
	DW	0000000010000000B
	DW	0000000010000000B
	DW	0000000010000000B
	DW	0000000010000000B
	DW	0000000010000000B

@D2:	DW	27, 2, 7, 13		{ Cursortyp 2: Sanduhr }
	DW	1111111111111110B
	DW	1111111111111110B
	DW	1111111111111110B
	DW	0111111111111100B
	DW	0111111111111100B
	DW	0111111111111100B
	DW	0111111111111100B
	DW	0111111111111100B
	DW	0111111111111100B
	DW	0011111111111000B
	DW	0001111111110000B
	DW	0000111111100000B
	DW	0000011111000000B
	DW	0000011111000000B
	DW	0000011111000000B
	DW	0000111111100000B
	DW	0001111111110000B
	DW	0011111111111000B
	DW	0111111111111100B
	DW	0111111111111100B
	DW	0111111111111100B
	DW	0111111111111100B
	DW	0111111111111100B
	DW	0111111111111100B
	DW	1111111111111110B
	DW	1111111111111110B
	DW	1111111111111110B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0011111111111000B
	DW	0000000000000000B
	DW	0001111111110000B
	DW	0001111111110000B
	DW	0001111110110000B
	DW	0001010101010000B
	DW	0001101010110000B
	DW	0000110101100000B
	DW	0000011011000000B
	DW	0000001110000000B
	DW	0000000100000000B
	DW	0000000100000000B
	DW	0000000100000000B
	DW	0000001110000000B
	DW	0000011111000000B
	DW	0000111011100000B
	DW	0001111111110000B
	DW	0001111011110000B
	DW	0001110101110000B
	DW	0001101010110000B
	DW	0001010101010000B
	DW	0000000000000000B
	DW	0011111111111000B
	DW	0000000000000000B
	DW	0000000000000000B

@D3:    DW      31, 4, 15, 15		{ Cursortyp 3: Groes Fadenkreuz }
	DW	0000000000000000B	{ Screen Mask, Spalte 1 }
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B	{ Screen Mask, Spalte 2 }
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000001B	{ Pixel Mask, Spalte 1 }
	DW	0000000000000001B
	DW	0000000000000001B
	DW	0000000000000001B
	DW	0000000000000001B
	DW	0000000000000001B
	DW	0000000000000001B
	DW	0000000000000001B
	DW	0000000000000001B
	DW	0000000000000001B
	DW	0000000000000001B
	DW	0000000000000001B
	DW	0000000000000001B
	DW	0000000000000001B
	DW	0000000000000001B
	DW	1111111111111110B
	DW	0000000000000001B
	DW	0000000000000001B
	DW	0000000000000001B
	DW	0000000000000001B
	DW	0000000000000001B
	DW	0000000000000001B
	DW	0000000000000001B
	DW	0000000000000001B
	DW	0000000000000001B
	DW	0000000000000001B
	DW	0000000000000001B
	DW	0000000000000001B
	DW	0000000000000001B
	DW	0000000000000001B
	DW	0000000000000001B
	DW	0000000000000000B	{ Pixel Mask, Spalte 2 }
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	1111111111111110B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B

@@2:
End;

{ Internally used routines
}
procedure MakeContain(var P: TPoint; R: TRect); external;
procedure MakeMouseContained; near; external;

procedure MSaveRegs; near; external;
procedure MRestoreRegs; near; external;

procedure DummyCC; far; external;
procedure NewCursor; near; external;
procedure ChangeAndNew; near; external;
function CritCont: Boolean; near; external;
function Exposed: Boolean; near; external;
procedure UpdateMouse; near; external;
procedure FlushUpdate; near; external;

{ Vertical retrace interrupt processing
}
procedure HandleRetrace; far; external;
procedure SetRetrace(on: Boolean); near; external;
procedure CalcYDivisor; near; external;

procedure InitRetrace; near;
Begin
  SetRetrace(false);
  GetIntVec(10, SavedRetrace);
  SetIntVec(10, @HandleRetrace)
End;

procedure DoneRetrace; near;
Begin
  SetIntVec(10, SavedRetrace)
End;

{ Real time clock interrupt processing
}
procedure HandleClock; far; external;
procedure SetClock(on: Boolean); near; external;

procedure InitClock; near;
Begin
  SetClock(false);
  GetIntVec($70, SavedClock);
  SetIntVec($70, @HandleClock)
End;

procedure DoneClock; near;
Begin
  SetIntVec($70, SavedClock)
End;

{ Hardware-event queue
}
procedure BeginCritical; near; external;
procedure StoreEvent; near; external;
procedure EndCritical; near; external;

{ System-specific routines
}
procedure HandleDrvReqDummy; far; external;
procedure HandleDrvReq; far; external;
procedure InitDrvReq(Service: pointer); near; external;
procedure DoneDrvReq; near; external;
procedure CallSavedDrvReq; near; external;

{$IFNDEF DPMI}
procedure HandleDrvReq386; far; external;
{$ENDIF}

{ Driver processing
}
procedure DrvMouseArea; near; external;
procedure DrvMousePos; near; external;

{ Direct processing
}
procedure HandleMicro; near; external;
procedure HandleSys; near; external;
procedure InitSerialPort(Base: Word; BitCode: Byte); near; external;
procedure DoneSerialPort(Base: Word); near; external;
procedure Handler; far; external;
procedure Handler386; far; external;

procedure InitHandler(IntNum: Byte); near;
Begin
  GetIntVec(IntNum, SavedIRQ);
{$IFDEF Regs386}
  If Test8086 >= 2
  then SetIntVec(IntNum, @Handler386)
  else
{$ENDIF}
       SetIntVec(IntNum, @Handler)
End;

procedure DoneHandler(IntNum: Byte); near;
Begin
  SetIntVec(IntNum, SavedIRQ)
End;

{ MouseMode services
}

procedure DetMouseMode; near; external;
function GetIntNum: Byte; near; external;
function GetMode: Byte; near; external;
function GetMPort: Word; near; external;

procedure SetMouseMode;
Begin
  If not Active then Begin
    MouseMode := AMode;
    DetMouseMode
  End
End;

function GetBiosWord(var P: Word): Word; near; assembler;
asm
	MOV	ES, Seg0040
	MOV	DI, WORD PTR p
	MOV	AX, [ES:DI]
end;

procedure SetMousePagePtr; near; external;

{ Service tables
}

procedure ServiceTbl16; near; external;
procedure ServiceTbl16s; near; external;
{$IFDEF Mode256 }
procedure ServiceTbl256; near; external;
procedure ServiceTbl256s; near; external;
{$ENDIF}
procedure ServiceTblNone; near; external;

procedure CopyServiceTbl(p: pointer); near; external;

procedure InstallServiceTbl; near;
Begin
  if GrActive then
  Case GrFlags of
    gf16:
      CopyServiceTbl(@ServiceTbl16);
    gf16 + gfMap:
      CopyServiceTbl(@ServiceTbl16s);
{$IFDEF Mode256}
    gf256:
      If MouseSaveSeg <> 0
      then CopyServiceTbl(@ServiceTbl256)
      else CopyServiceTbl(@ServiceTbl256s);
    gf256 + gfMap:
      CopyServiceTbl(@ServiceTbl256s);
{$ENDIF}
    else CopyServiceTbl(@ServiceTblNone);
  End
  else CopyServiceTbl(@ServiceTblNone);
End;

{ Reserving mouse background memory
}

procedure ReserveMouseSeg;
var
  Size: Integer;
  l: LongInt;
Begin
  If not GrActive then Exit;
  If GrFlags and gfMap = 0
  then Begin
    case GrFlags and 1 of
      gf16:
	Size := (MaxWidth + 1) * MaxLength + 1;
  {$IFDEF Mode256}
      gf256:
	Size := MaxWidth * 8 * MaxLength + 1;
  {$ENDIF}
      else Exit;
    End;
    SavedFree := GetFreeSegs;
    l := ReserveSegs((Size + 15) div 16);
    MouseSaveSeg := l;
    MouseSavePtr := SegAddr(MouseSaveSeg);
    If LongRec(l).Hi <> 0 then Exit;
  End;
  { Must use main memory }
  case GrFlags and 1 of
    gf16:
      Size := (MaxWidth + 1) * 4 * MaxLength;
  {$IFDEF Mode256}
    gf256:
      Size := MaxWidth * 8 * MaxLength;
  {$ENDIF}
    else Exit;
  End;
  SavedFree := Size;
  MouseSaveSeg := 0;
  GetMem(MouseSavePtr, Size)
End;

procedure UnreserveMouseSeg;
Begin
  If MouseSaveSeg <> 0
  then SetFreeSegsBack(SavedFree)
  else FreeMem(MouseSavePtr, SavedFree)
End;

{ Init/close graphics
}

procedure MyMouseInitGraphics;
Begin
  If not GrActive then Exit;
  BeginCritical;
  ReserveMouseSeg;
  InstallServiceTbl;
  MouseArea.Assign(0, 0, SizeX, SizeY);
  CriticalArea.Copy(MouseArea);
  MouseWhere.X	:= SizeX div 2;
  MouseWhere.Y	:= SizeY div 2;
  LastWhere	:= MouseWhere;
  If GetMode = mmDriver then Begin
    DrvMouseArea;
    DrvMousePos
  End;
  MouseHidden	:= 0;
  MousePage	:= 0;
  CriticalPage	:= 0;
  SetMousePagePtr;
  If TimingState and 1 = 1 then Begin
    CalcYDivisor;
    If TimingState and 1 = 0
    then Begin
      DoneRetrace;
      DoneClock
    End
  End;
  NewCursor;
  ChangeAndNew;
  MSaveRegs;
  SaveScreen; DrawMouse;
  MRestoreRegs;
  IsDrawn := true;
  EndCritical
End;

procedure MyMouseCloseGraphics;
Begin
  If not GrActive then Exit;
  BeginCritical;
  If IsDrawn then Begin
    MSaveRegs;
    RestoreScreen;
    MRestoreRegs;
    IsDrawn := false
  End;
  CopyServiceTbl(@ServiceTblNone);
  UnreserveMouseSeg;
  EndCritical
End;

{
}

function NotifyMyMouse(Notice: Word; Info: LongInt): LongInt; far;
Begin
  case Notice of
    gnpInitGraphics:
      MyMouseInitGraphics;
    gnpCloseGraphics:
      MyMouseCloseGraphics;
  end;
  NotifyMyMouse := DefaultNotify(Notice, Info, NotifyMyMouse, NextNotify, 30);
End;

procedure InitMyMouse;
Begin
  If MouseInstalled then Begin
    sMouseEvents := MouseEvents;
    If not MouseEvents then InitEvents;
    Drivers.HideMouse;
    ChangeCursor	:= DummyCC;
    GetMCursor		:= GetMouseCursor;
    Active		:= true;
    PointerColor	:= 15;
    CursorNum		:= $FFFF;
    NewNum		:= 0;
    InMouse		:= false;
    InService		:= false;
    If MouseMode and mmNoClk <> 0
    then TimingState	:= 0		{ permit timing functions }
    else TimingState	:= 1;		{ assume timing be functionable }
    BeginCritical;
    InstallNotifyProc(GrNotifyProc, NotifyMyMouse);
    If GetMode = mmDriver
    then
{$IFDEF Regs386}
      If Test8086 >= 2
      then InitDrvReq(@HandleDrvReq386)
      else
{$ENDIF}
      InitDrvReq(@HandleDrvReq)
    else Begin
      MPort := GetMPort;
      InitDrvReq(@HandleDrvReqDummy);
      If GetMode = mmMicro
      then Begin
	HandleProc := Ofs(HandleMicro);
	InitSerialPort(MPort, $82)
      End else Begin
	HandleProc := Ofs(HandleSys);
	InitSerialPort(MPort, $83)
      End;
      InitHandler(GetIntNum);
    End;
    If TimingState and 1 = 1 then Begin
      InitClock;
      InitRetrace
    End;
    SetDoubleSpeedTreshold(DoubleSpeedTreshold);
  End;
  EndCritical;
  MyMouseInitGraphics
End;

procedure DoneMyMouse;
Begin
  If Active then Begin
    MyMouseCloseGraphics;
    BeginCritical;
    UninstallNotifyProc(GrNotifyProc, NotifyMyMouse);
    If TimingState and 1 = 1 then Begin
      DoneRetrace;
      DoneClock
    End;
    DoneDrvReq;
    If GetMode <> mmDriver
    then Begin
      DoneHandler(GetIntNum);
      DoneSerialPort(MPort)
    End;
    If not sMouseEvents then DoneEvents;
    Active := false;
    EndCritical
  End;
End;

function MouseInstalled;
{ Drivers.DetectMouse hat alles bernommen. }
Begin
  MouseInstalled := (GetMode <> mmDriver) or (ButtonCount <> 0);
End;

procedure SetBGIMode; assembler;
Asm
	MOV	AX, Driver
	CMP	AX, 9
	JZ	@@3
	CMP	AX, 3
	JNZ	@@1
@@3:	MOV	AX, Mode
	MOV	CX, grVgaLoStd
	OR	AX, AX
	JZ	@@2
	MOV	CX, grVgaMedStd
	DEC	AX
	JZ	@@2
	MOV	CX, grVgaHiStd
	DEC	AX
	JNZ	@@1
@@2:	PUSH	CX
	CALL	SetGrMode
@@1:
End;

procedure GetMouseEvent; assembler;
asm
	LEAVE
	JMP	Drivers.GetMouseEvent
end;

procedure GetTimerEvent;
var
  t: Word;
Begin
  t := GetBiosWord(Ticks);
  with Event do
  If t <> LastTicks then Begin
    What := evTimer;
    InfoWord := t;
    LastTicks := t
  End else
    What := evNothing
End;

procedure SetMCursor; assembler;
Asm
	CMP	Active, 0
	JZ	@@2
	CMP     InService, 0
	JZ	@@3
	MOV	AX, n
	MOV	NewNum, AX
	JMP	@@2
@@3:	CALL	BeginCritical
	CALL	MSaveRegs
	call	FlushUpdate
	CMP	IsDrawn, 0
	JZ	@@1
	CALL	RestoreScreen
@@1:	MOV	AX, n
	MOV	NewNum, AX
	CALL	NewCursor
	CALL	ChangeAndNew
	MOV	IsDrawn, 0
	CALL	Exposed
	JZ	@@4
	CALL	SaveScreen
	CALL	DrawMouse
	MOV	IsDrawn, 1
@@4:    CALL	MRestoreRegs
	CALL	EndCritical
@@2:
End;

procedure SetCursorPtr; assembler;
asm
	CMP	Active, 0
	JZ	@@2
	CMP     InService, 0
	JZ	@@3
	MOV	AX, WORD PTR p
	MOV	DX, WORD PTR p.2
	MOV	WORD PTR CursorPtr, AX
	MOV	WORD PTR CursorPtr.2, DX
	JMP	@@2
@@3:	CALL	BeginCritical
	CALL	MSaveRegs
	call	FlushUpdate
	CMP	IsDrawn, 0
	JZ	@@1
	CALL	RestoreScreen
@@1:	MOV	IsDrawn, 0
	MOV	AX, WORD PTR p
	MOV	DX, WORD PTR p.2
	MOV	WORD PTR CursorPtr, AX
	MOV	WORD PTR CursorPtr.2, DX
	CALL	Exposed
	JZ	@@4
	CALL	SaveScreen
	CALL	DrawMouse
	MOV	IsDrawn, 1
@@4:    CALL	MRestoreRegs
	CALL	EndCritical
@@2:
end;

procedure ShowMouse; assembler;
Asm
	CMP	Active, 0
	JNZ	@@2
	JMP	Drivers.ShowMouse
@@2:    CALL	BeginCritical
	INC 	MouseHidden
	JS	@@1
	JZ	@@3
	MOV	MouseHidden, 0
@@3:	CMP	IsDrawn, 0
	JNZ	@@1
	call	FlushUpdate
	CALL	ChangeAndNew
	CALL	MSaveRegs
	CALL	SaveScreen
	CALL	DrawMouse
	CALL	MRestoreRegs
	MOV	IsDrawn, 1
@@1:	CALL	EndCritical
End;

procedure HideMouse; assembler;
Asm
	CMP	Active, 0
	JNZ	@@2
	JMP	Drivers.HideMouse
@@2:    CALL	BeginCritical
	DEC	MouseHidden
	CMP	IsDrawn, 0
	JZ	@@1
	CALL	CritCont
	OR	AL, AL
	JZ	@@1
	CALL	MSaveRegs
	call	FlushUpdate
	CALL	RestoreScreen
	CALL	MRestoreRegs
	MOV	IsDrawn, 0
@@1:	CALL	EndCritical
End;

procedure SetMouseArea;
Begin
  If not Active then Exit;
  BeginCritical;
  MouseArea.Assign(x1, y1, x2, y2);
  MakeMouseContained;
  If GetMode = mmDriver then Begin
    DrvMouseArea;
    DrvMousePos
  End;
  TimingState := TimingState or 2;
  UpdateMouse;
  TimingState := TimingState and not 2;
  EndCritical
End;

procedure SetMousePos;
Begin
  If not Active then Exit;
  BeginCritical;
  MouseWhere.x := x;
  MouseWhere.y := y;
  MakeMouseContained;
  If GetMode = mmDriver then DrvMousePos;
  TimingState := TimingState or 2;
  UpdateMouse;
  TimingState := TimingState and not 2;
  EndCritical
End;

procedure SetCriticalArea;
var
  mc: pointer;
  n: Word;
Begin
  If not Active then Exit;
  BeginCritical;
  CriticalArea.Assign(x1, y1, x2, y2);
  mc:=CursorPtr; ChangeAndNew;
  If IsDrawn <> Exposed then Begin
    MSaveRegs;
    FlushUpdate;
    if IsDrawn
      then RestoreScreen
      else begin SaveScreen; DrawMouse end;
    MRestoreRegs;
    IsDrawn := not IsDrawn;
  End else If IsDrawn and (mc <> CursorPtr) then Begin
    MSaveRegs;
    FlushUpdate;
    RestoreScreen;
    SaveScreen; DrawMouse;
    MRestoreRegs;
  End;
  EndCritical
End;

procedure SetMousePage;
Begin
  If not Active or (MousePage = Page) then Exit;
  BeginCritical;
  MSaveRegs;
  FlushUpdate;
  If IsDrawn then Begin
    RestoreScreen;
    IsDrawn := false
  End;
  MousePage := Page;
  SetMousePagePtr;
  ChangeAndNew;
  If Exposed
  then Begin
    SaveScreen;
    DrawMouse;
    IsDrawn := true;
  End;
  MRestoreRegs;
  EndCritical
End;

procedure SetCriticalPage;
Begin
  If not Active or (CriticalPage = Page) then Exit;
  BeginCritical;
  MSaveRegs;
  FlushUpdate;
  If IsDrawn then Begin
    RestoreScreen;
    IsDrawn := false
  End;
  CriticalPage := Page;
  ChangeAndNew;
  If Exposed
  then Begin
    SaveScreen;
    DrawMouse;
    IsDrawn := true
  End;
  MRestoreRegs;
  EndCritical
End;

procedure SetPointerColor;
Begin
  If not Active then Exit;
  If InService then Begin
    PointerColor := AColor;
    Exit
  End;
  BeginCritical;
  If IsDrawn then Begin
    FlushUpdate;
    RestoreScreen;
    PointerColor := AColor;
    SaveScreen;
    DrawMouse
  End
  else PointerColor := AColor;
  EndCritical
End;

procedure SetDoubleSpeedTreshold; assembler;
Asm
	MOV	DX, Value
	MOV	DoubleSpeedTreshold, DX
	call	GetMode
	CMP	al, mmDriver
	JNZ	@@1
	MOV	AX, 13H
	INT	33H
@@1:
End;

End.
