UNIT ODBCInst;

{ :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::: }


INTERFACE

{ :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::: }

USES

   WinTypes,
   WinProcs;

{ :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::: }

CONST

   {-SQLConfigDataSource request flags}
   ODBCAddDataSource     = 1;
   ODBCEditDataSource    = 2;
   ODBCRemoveDataSource  = 3;

TYPE

   TSQLInstallDriver = function(lpszInfFile : pchar;
                                lpszDriver : pchar;
                                lpszPath : pchar;
                                cbPathMax : word;
                                var cbPathOut : word) : bool;

   TSQLInstallDriverManager = function(lpszPath : pchar;
                                       cbPathMax : word;
                                       var cbPathOut : word) : bool;

   TSQLGetInstalledDrivers =  FUNCTION  (Buffer : pchar;
                                         BufferLen : Word;
                                         VAR BufferLenReturned : Word) : Bool;

   TSQLGetAvailableDrivers = FUNCTION(lpszInfFile : pchar;
                                      lpszBuf : pchar;
                                      cbBufMax : word;
                                      var cbBufOut : word) : bool;

   TSQLConfigDataSource = function(Parent : hwnd;
                                   fRequest : word;
                                   lpszDriver : pchar;
                                   lpszAttributes : pchar) : bool;

   TSQLRemoveDefaultDataSource = function : bool;

   TSQLWriteDSNToIni = function(lpszDSN : pchar;
                                lpszDriver : pchar) : bool;

   TSQLRemoveDSNFromIni = function(lpszDSN : pchar) : bool;

   { --- Record for dynamically linking DLL functions --- }

   POdbcInstDLLRec = ^TOdbcInstDLLRec;

   TOdbcInstDLLRec = RECORD
      TheHandle : THandle;
      SQLInstallDriver : TSQLInstallDriver;
      SQLInstallDriverManager : TSQLInstallDriverManager;
      SQLGetInstalledDrivers : TSQLGetInstalledDrivers;
      SQLGetAvailableDrivers : TSQLGetAvailableDrivers;
      SQLConfigDataSource : TSQLConfigDataSource;
      SQLRemoveDefaultDataSource : TSQLRemoveDefaultDataSource;
      SQLWriteDSNToIni : TSQLWriteDSNToIni;
      SQLRemoveDSNFromIni : TSQLRemoveDSNFromIni;
   END;

CONST

   OdbcInstDLL : POdbcInstDLLRec = NIL;

{ :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::: }

   FUNCTION LoadOdbcInstDLL : BOOLEAN;

   PROCEDURE UnloadOdbcInstDLL;

{ :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::: }

   { wrapper functions for use with 'SwitchStackTo' function. }

   FUNCTION sSQLInstallDriver(lpszInfFile   : pchar;
                              lpszDriver    : pchar;
                              lpszPath      : pchar;
                              cbPathMax     : word;
                              var cbPathOut : word) : bool;

   FUNCTION sSQLInstallDriverManager(lpszPath : pchar;
                                     cbPathMax : word;
                                     var cbPathOut : word) : bool;

   FUNCTION sSQLGetInstalledDrivers(Buffer : pchar;
                                    BufferLen : Word;
                                    VAR BufferLenReturned : Word) : Bool;

   FUNCTION sSQLGetAvailableDrivers(lpszInfFile : pchar;
                                    lpszBuf : pchar;
                                    cbBufMax : word;
                                    var cbBufOut : word) : bool;

   FUNCTION sSQLConfigDataSource(Parent : hwnd;
                                 fRequest : word;
                                 lpszDriver : pchar;
                                 lpszAttributes : pchar) : bool;

   FUNCTION sSQLRemoveDefaultDataSource : bool;

   FUNCTION sSQLWriteDSNToIni(lpszDSN : pchar;
                              lpszDriver : pchar) : bool;

   FUNCTION sSQLRemoveDSNFromIni(lpszDSN : pchar) : bool;

{ :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::: }

implementation

{ :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::: }


USES

   Strings,
   OtherStk;

{ :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::: }

FUNCTION LoadOdbcInstDLL : BOOLEAN;
CONST
   DLLName = 'ODBCInst.DLL';
VAR
   L : BOOLEAN;
   h : THandle;
   APath,AFile : PChar;
BEGIN
   L := FALSE;
   IF OdbcInstDLL <> NIL THEN
      L := TRUE
   ELSE
   BEGIN
      h := LoadLibrary(AFile);
      IF h < 32 THEN
         L := FALSE
      ELSE
      BEGIN
         NEW(OdbcInstDLL);
         WITH OdbcInstDLL^ DO
         BEGIN
            TheHandle := h;
            @SQLGETAVAILABLEDRIVERS := GetProcAddress(h,PChar(5));
            @SQLGETINSTALLEDDRIVERS := GetProcAddress(h,PChar(4));
            @SQLINSTALLDRIVER := GetProcAddress(h,PChar(2));
            @SQLCONFIGDATASOURCE := GetProcAddress(h,PChar(6));
            @SQLREMOVEDSNFROMINI := GetProcAddress(h,PChar(9));
            @SQLINSTALLDRIVERMANAGER := GetProcAddress(h,PChar(3));
            @SQLREMOVEDEFAULTDATASOURCE := GetProcAddress(h,PChar(7));
            @SQLWRITEDSNTOINI := GetProcAddress(h,PChar(8));
         END
      END;
      FreeMem(APath,255);
      FreeMem(AFile,255);
   END;
   LoadOdbcInstDLL := L;
END;

{ --------------------------------------------------------------------- }

PROCEDURE UnloadOdbcInstDLL;
BEGIN
   IF OdbcInstDLL <> NIL THEN
   BEGIN
      FreeLibrary(OdbcInstDLL^.TheHandle);
      DISPOSE(OdbcInstDLL);
      OdbcInstDLL := NIL;
   END
END;

{ :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::: }

FUNCTION sSQLInstallDriver(lpszInfFile   : pchar;
                           lpszDriver    : pchar;
                           lpszPath      : pchar;
                           cbPathMax     : word;
                           var cbPathOut : word) : bool;
BEGIN
   IF OdbcInstDLL = NIL THEN
      sSQLInstallDriver := bool(FALSE)
   ELSE
   BEGIN
      stPChar1 := lpszInfFile;
      stPChar2 := lpszDriver;
      stPChar3 := lpszPath;
      stWORD1 := cbPathMax;
      stWORD2 := cbPathOut;
      SwitchStackTo(OtherStackUDS,OtherStackSize,SIZEOF(WORD));
      stBOOL1 := odbcInstDLL^.sqlInstallDriver(stPChar1,
                                               stPChar2,
                                               stPChar3,
                                               stWORD1,
                                               stWORD2);
      SwitchStackBack;
      cbPathOut := stWORD2;
      sSQLInstallDriver := stBOOL1;
   END
END;

{ ---------------------------------------------------------------------- }

FUNCTION sSQLInstallDriverManager(lpszPath : pchar;
                                  cbPathMax : word;
                                  var cbPathOut : word) : bool;
BEGIN
   IF OdbcInstDLL = NIL THEN
      sSQLInstallDriverManager := bool(FALSE)
   ELSE
   BEGIN
      stPChar1 := lpszPath;
      stWORD1 := cbPathMax;
      stWORD2 := cbPathOut;
      SwitchStackTo(OtherStackUDS,OtherStackSize,SIZEOF(WORD));
      stBOOL1 := odbcInstDLL^.sqlInstallDriverManager(stPChar1,
                                                      stWORD1,
                                                      stWORD2);
      SwitchStackBack;
      cbPathOut := stWORD2;
      sSQLInstallDriverManager := stBOOL1;
   END
END;

{ ---------------------------------------------------------------------- }

FUNCTION sSQLGetInstalledDrivers(Buffer : pchar;
                                 BufferLen : Word;
                                 VAR BufferLenReturned : Word) : Bool;
BEGIN
   IF OdbcInstDLL = NIL THEN
      sSQLGetInstalledDrivers := bool(FALSE)
   ELSE
   BEGIN
      stPChar1 := Buffer;
      stWORD1 := BufferLen;
      stWORD2 := BufferLenReturned;
      SwitchStackTo(OtherStackUDS,OtherStackSize,SIZEOF(WORD));
      stBOOL1 := odbcInstDLL^.sqlGetInstalledDrivers(stPChar1,
                                                     stWORD1,
                                                     stWORD2);
      SwitchStackBack;
      BufferLenReturned := stWORD2;
      sSQLGetInstalledDrivers := stBOOL1;
   END
END;

{ ---------------------------------------------------------------------- }

FUNCTION sSQLGetAvailableDrivers(lpszInfFile : pchar;
                                 lpszBuf : pchar;
                                 cbBufMax : word;
                                 var cbBufOut : word) : bool;
BEGIN
   IF OdbcInstDLL = NIL THEN
      sSQLGetAvailableDrivers := bool(FALSE)
   ELSE
   BEGIN
      stPChar1 := lpszInfFile;
      stPChar2 := lpszBuf;
      stWORD1 := cbBufMax;
      stWORD2 := cbBufOut;
      SwitchStackTo(OtherStackUDS,OtherStackSize,SIZEOF(WORD));
      stBOOL1 := odbcInstDLL^.sqlGetAvailableDrivers(stPChar1,
                                                     stPChar2,
                                                     stWORD1,
                                                     stWORD2);
      SwitchStackBack;
      cbBufOut := stWORD2;
      sSQLGetAvailableDrivers := stBOOL1;
   END
END;

{ ---------------------------------------------------------------------- }

FUNCTION sSQLConfigDataSource(Parent : hwnd;
                              fRequest : word;
                              lpszDriver : pchar;
                              lpszAttributes : pchar) : bool;
BEGIN
   IF OdbcInstDLL = NIL THEN
      sSQLConfigDataSource := bool(FALSE)
   ELSE
   BEGIN
      stParent := Parent;
      stWORD1 := fRequest;
      stPChar1 := lpszDriver;
      stPChar2 := lpszAttributes;
      SwitchStackTo(OtherStackUDS,OtherStackSize,SIZEOF(WORD));
      stBOOL1 := odbcInstDLL^.sqlConfigDataSource(stParent,
                                                  stWORD1,
                                                  stPChar1,
                                                  stPChar2);
      SwitchStackBack;
      sSQLConfigdataSource := stBOOL1;
   END
END;

{ ---------------------------------------------------------------------- }

FUNCTION sSQLRemoveDefaultDataSource : bool;
BEGIN
   IF OdbcInstDLL = NIL THEN
      sSQLRemoveDefaultDataSource := bool(FALSE)
   ELSE
   BEGIN
      SwitchStackTo(OtherStackUDS,OtherStackSize,SIZEOF(WORD));
      stBOOL1 := odbcInstDLL^.sqlRemoveDefaultDataSource;
      SwitchStackBack;
      sSQLRemoveDefaultDataSource := stBOOL1
   END
END;

{ ---------------------------------------------------------------------- }

FUNCTION sSQLWriteDSNToIni(lpszDSN : pchar;
                           lpszDriver : pchar) : bool;
BEGIN
   IF OdbcInstDLL = NIL THEN
      sSQLWriteDSNToIni := bool(FALSE)
   ELSE
   BEGIN
      stPChar1 := lpszDSN;
      stPChar2 := lpszDriver;
      SwitchStackTo(OtherStackUDS,OtherStackSize,SIZEOF(WORD));
      stBOOL1 := odbcInstDLL^.SQLWriteDSNToIni(stPChar1,stPChar2);
      SwitchStackBack;
      sSQLWriteDSNToIni := stBOOL1
   END
END;

{ ---------------------------------------------------------------------- }

FUNCTION sSQLRemoveDSNFromIni(lpszDSN : pchar) : bool;
BEGIN
   IF OdbcInstDLL = NIL THEN
      sSQLRemoveDSNFromIni := bool(FALSE)
   ELSE
   BEGIN
      stPChar1 := lpszDSN;
      SwitchStackTo(OtherStackUDS,OtherStackSize,SIZEOF(WORD));
      stBOOL1 := odbcInstDLL^.SQLRemoveDSNFromIni(stPChar1);
      SwitchStackBack;
      sSQLRemoveDSNFromIni := stBOOL1
   END
END;

{ :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::: }

BEGIN

END.
