library mtools;

uses
  Strings,
  WinTypes,
  WinProcs,
  CommDlg;

{ Trim --------------------------------------------------------------
     Supresses trailing blanks in NULL-terminated string
  ------------------------------------------------------------------- }
function Trim(TrimStr: PChar): PChar; export;
var
  i: Integer;
begin
  Trim := TrimStr;
  for i := StrLen(TrimStr) - 1 downto 0 do
  begin
    if TrimStr[i] = ' ' then
      TrimStr[i] := #0
    else
      Exit;
  end;
end;

function GetFont(var LogFont: pLogFont; Owner: HWnd; var Color: tColorRef): Boolean; export;
var
  CFont      : tChooseFont;
  lStyle     : array [0..lf_facesize] of Char;
begin
  with CFont do
  begin
    lStructSize := SizeOf(tChooseFont);
    hWndOwner := Owner;
    hDC := 0;
    lpLogFont := LogFont;
    rgbColors := Color;
    Flags := cf_forcefontexist or cf_inittologfontstruct or cf_limitsize or cf_screenfonts or cf_effects;
    lpszStyle := @lStyle;
    nSizeMin := 8;
    nSizeMax := 32;
  end;
  if ChooseFont(CFont) then
  begin
    Color := CFont.rgbColors;
    GetFont := True
  end
  else
    GetFont := False;
end;

Exports
  Trim, GetFont;

begin
end.