{ Revisions history -------------------------------------------------
   18/03/94 - Fixed bug in DrawBitmap
   19/03/94 - Excluded vertical scroll bar width from buttonbar width
   20/03/94 - Added pop-up menu for Choosing Font & item location
              Revised wm_MeasureItem message processing accordintly
   03/04/94 - Added ItemsColor in tMLBCtl object
              Changed GetFont procedure to set items colors
              Changed drawing colors of items with own color in WMDrawItem
   31/05/94 - Localized global LBFont and lLBFont variables.
              Added CreateLBFont method called from SetupWindow.
  ------------------------------------------------------------------- }
unit MLBCtl;

interface

uses WinTypes,
     WinProcs,
     ODialogs,
     OWindows,
     Strip,
     BtnBar,
     MLBTypes,
     Strings,
     Win31,
     Wtools,
     Table;

{ Input dialog template }
{$R MLBCTL.RES}

const
  BarButtonsIDFirst = 400;
  ListBoxID         = BarButtonsIDFirst + MaxColNum + 1;
  BmpIndent         = 2;

  idm_Font          = 6001; { Popup menu commands }
  idm_Locate        = 6003;

type
  PLocateDlg = ^TLocateDlg;
  TLocateDlg = object(TDialog)
    LocStr: array [0..101] of Char;
    FirstEntry: Boolean;
    constructor Init(AParent: PWindowsObject; AName: PChar; ALocStr: PChar);
    destructor Done; virtual;
    procedure SetupWindow; virtual;
    procedure EditBox(var Msg: TMessage); virtual id_First + 101;
  end;

  PMListBox = ^TMListBox;
  TMListBox = object(TListBox)
    procedure   WMKeyDown(var Msg: TMessage); virtual wm_First + wm_KeyDown;
    procedure   WMRButtonUp(var Msg: TMessage); virtual wm_First + wm_RButtonUp;
  end;

  PMLBCtl = ^TMLBCtl;
  TMLBCtl = object(TWindow)
    MLBox:      pMListBox;
    Bar:        pButtonBar;
    List:       pListTable;
    Opened:     Boolean;
    LastXPos:   Integer;
    ItemsColor: tColorRef;
    LBFont:     hFont;
    lLBFont:    tLogFont;
    constructor Init(AParent: pWindowsObject; R: TRect; AnItemList: pItemsList; ABarColor: TColorRef; AList: pListTable);
    destructor  Done; virtual;
    procedure   AddItem(RecNo: longint; var Index: Integer);
    procedure   CreateLBFont; virtual;
    procedure   DeleteItemIndex(Index: Word);
    function    GetClassName: PChar; virtual;
    procedure   GetWindowClass(var AWndClass: TWndClass); virtual;
    procedure   FillListBox; virtual;
    procedure   Locate(LocStr: PChar);
    function    OpenTable: Boolean; virtual;
    procedure   SetItemColor(ItemHandle: tItemHandle; AColor: LongInt; OwnColor: Boolean); virtual;
    procedure   SetupWindow; virtual;
    function    SkipItem(ItemHandle: tItemHandle): Boolean; virtual;
    function    UpdateItem(RecNo: longint; var Index: Integer): Boolean;
    { ButtonBar messages processing routines }
    procedure   TMFirstColSize(var Msg: TMessage); virtual wm_First + tm_FirstColSize;
    procedure   TMNewColSize(var Msg: TMessage); virtual wm_First + tm_NewColSize;
    procedure   TMSizingEnd(var Msg: TMessage); virtual wm_First + tm_SizingEnd;
    { Windows messages processing routines }
    procedure   WMSetFocus(var Msg: TMessage); virtual wm_First + wm_SetFocus;
    procedure   WMMeasureItem(var Msg: TMessage); virtual wm_First + wm_MeasureITem;
    procedure   WMDrawItem(var Msg: TMessage); virtual wm_First + wm_DrawItem;
    procedure   WMCompareItem(var Msg: TMessage); virtual wm_First + wm_CompareItem;
    procedure   WMCommand(var Msg: TMessage); virtual wm_First + wm_Command;
    procedure   WMCharToItem(var Msg: TMessage); virtual wm_First + wm_CharToItem;
  end;

implementation

{ TMListBox --------------------------------------------------------- }

{ WMKeyDown --------------------------------------------------------
     Fix a Windows bug
  ------------------------------------------------------------------- }
procedure TMListBox.WMKeyDown(var Msg: TMessage);
(* an apparent bug in Windows 3.1 causes a VK_NEXT keypress to be
  non-functional in a ownerdraw-variable list box *)
var
  SelItem,TopItem,MaxItem: Integer;
  ItemHeight,ItemsPerPage: Integer;
  PageDim: TRect;
begin
  if Msg.wParam = vk_Return then
     PostMessage(Parent^.HWindow, wm_Command, Attr.ID,
       (lbn_DBLCLK shl 16) or HWindow);
  if Msg.wParam <> vk_Next then
  begin
    DefWndProc(Msg);
    Exit;
  end;
  MaxItem := Pred(GetCount);
  ItemHeight := SendMessage(HWindow, lb_GetItemHeight, 0, 0);
  GetClientRect(HWindow,PageDim);
  with PageDim do
    ItemsPerPage := Pred(Bottom div ItemHeight);
  SelItem := GetSelIndex;
  if SelItem = MaxItem then Exit;
  Inc(SelItem,ItemsPerPage);
  if SelItem >= GetCount then SelItem := MaxItem;
  SendMessage(HWindow, wm_SetRedraw, 0, 0);
  SendMessage(HWindow, lb_SetCurSel, SelItem, 0);
  SendMessage(HWindow, wm_SetRedraw, 1 ,0);
  InvalidateRect(HWindow, nil, True);
  PostMessage(Parent^.Parent^.HWindow, wm_SelChange, 0, 0);
end;

procedure TMListBox.WMRButtonUp(var Msg: TMessage);
var
  CTLMenu: hMenu;
begin
  CTLMenu := LoadMenu(hInstance, 'MLBCTL_MENU');
  if CTLMenu = 0 then
    Exit;
  ClientToScreen(HWindow, TPoint(Msg.LParam));
  TrackPopUpMenu(GetSubMenu(CTLMenu, 0), TPM_LEFTALIGN or TPM_LEFTBUTTON,
                 Msg.LParamLo, Msg.LParamHi, 0, Parent^.HWindow, nil);
  DestroyMenu(CTLMenu);
end;

{ TMLBCtl object ---------------------------------------------------- }

constructor TMLBCtl.Init(AParent: pWindowsObject; R: TRect; AnItemList: pItemsList;
                         ABarColor: TColorRef; AList: pListTable);
var
  i: Integer;
begin
  inherited Init(AParent, '');

  { Assign sort buttons IDs }
  for i := 1 to AnItemList^.ColNumber do
    AnItemList^.Items^[i].ItemID := BarButtonsIDFirst + i;

  Bar := New(PButtonBar, Init(@Self, AnItemList, ABarColor));

  MLBox := New(PMListBox, Init(@Self, ListBoxID, 1, Bar^.GetHeight + 1,
                               R.right - R.left - 2, R.bottom - R.top - Bar^.GetHeight - 2 - 15));
  with MLBox^.Attr do
  begin
    Style := Style or lbs_Sort;
    Style := Style or lbs_DisableNoScroll;
    Style := Style or lbs_OwnerDrawVariable;
    Style := Style or lbs_WantKeyboardInput;
  end;

  Attr.Style := ws_Child or ws_Visible or ws_TabStop;

  Attr.X := R.left; Attr.Y := R.top;
  Attr.W := R.right - R.left; Attr.H := R.bottom - R.top;

  List := AList;

  ItemsColor := 0;

  Opened := False;
end;

destructor TMLBCtl.Done;
begin
  inherited Done;
  DeleteObject(LBFont);
  Dispose(List, Done);
end;

procedure TMLBCtl.AddItem(RecNo: longint; var Index: integer);
var
  hItem: tItemHandle;
begin
  hItem := List^.UpdateItem(0, RecNo, True);
  Index := SendMessage(MLBox^.HWindow, LB_ADDSTRING, 0, hItem);
  MLBox^.SetSelIndex(Index);
end;

procedure TMLBCtl.CreateLBFont;
begin
  { create listbox font }
  with lLBFont do
  begin
    lfHeight        := 10;
    lfWidth         := 0;
    lfEscapement    := 0;
    lfOrientation   := 0;
    lfWeight        := fw_Bold;
    lfItalic        := 0;
    lfUnderline     := 0;
    lfStrikeOut     := 0;
    lfCharSet       := Default_CharSet;
    lfOutPrecision  := Out_Default_Precis;
    lfClipPrecision := Clip_Default_Precis;
    lfQuality       := Proof_Quality;
    lfPitchAndFamily:= Variable_Pitch or FF_Swiss;
    StrCopy(lfFaceName, 'MS Sans Serif');
  end;
  LBFont := CreateFontIndirect(lLBFont);
end;

procedure TMLBCtl.DeleteItemIndex(Index: Word);
var
  hItem: tItemHandle;
begin
  hItem := SendMessage(MLBox^.HWindow, LB_GETITEMDATA, Index, 0);
  List^.DeleteItem(hItem);
  MLBox^.DeleteString(Index);
  SetFocus(MLBox^.HWindow);
end;

function TMLBCtl.GetClassName;
begin
  GetClassName := 'MLBControl';
end;

procedure TMLBCtl.GetWindowClass(var AWndClass: TWndClass);
begin
  TWindow.GetWindowClass(AWndClass);
  AWndClass.hbrBackGround := GetStockObject(Null_Brush);
end;

procedure TMLBCtl.FillListBox;
var
  RowNum: Longint;
  i: Longint;
  hItem: tItemHandle;
  Result: Longint;
begin
  SendMessage(MLBox^.HWindow, LB_RESETCONTENT, 0, 0);

  RowNum := List^.GetRows;
  if RowNum = 0 then
 { Nothing to do }
    Exit;

  { Create progress window }
  List^.CreateStrip('Sorting/Filtering table...', RowNum);

  for i := 0 to RowNum - 1 do
  begin
    hItem := List^.GetItemHandle(i);

    { Set item color }
    SetItemColor(hItem, ItemsColor, True);

    { Filter items }
    if not SkipItem(hItem) then
      { Add new line to listbox }
      Result := SendMessage(MLBox^.HWindow, LB_ADDSTRING, 0, Longint(hItem));

    { It can happend !!! Really }
    if Result = LB_ERRSPACE then
    begin
      { It's a field for work, how to handle it
        Tip: for databases it's better to use indexes for sorting,
        but if you fill that your database record count will never be greater then
        ~5000 - you will never catch this problem }
      MessageBox(0, 'Not enougnt listbox memory', nil, MB_OK or MB_ICONSTOP);
      List^.CloseStrip;
      SetFocus(MLBox^.HWindow);
      Exit;
    end;

    { Update progress window }
    List^.NewStrip(i + 1);
  end;

  { Close progress window }
  List^.CloseStrip;

  MLBox^.SetSelIndex(0);
  PostMessage(Parent^.HWindow, wm_SelChange, 0, 0);
  SetFocus(MLBox^.HWindow);
end;

procedure TMLBCtl.Locate(LocStr: PChar);
var
  MaxPos, CurPos, MinPos, i : Longint;
  Order                     : Word;    { Current sort order }
  Flag                      : Boolean;
  hItem                     : tItemHandle;
  Rc                        : Integer;
  ItemStr                   : array [0..MaxFieldWidth] of Char; { Buffer string }
begin
  { Initializations to perform searching }
  MinPos := 0;
  MaxPos := Pred(MLBox^.GetCount);
  CurPos := MaxPos shr 1;

  Order := Bar^.GetSortOrder;
  Order := List^.ID2Index(Integer(Order)) - 1;
  Flag := True;

  while Flag do
  begin
    hItem := SendMessage(MLBox^.HWindow, LB_GETITEMDATA, CurPos, 0);
    List^.GetFieldString(hItem, Order, @ItemStr);
    Rc := StrIComp(LocStr, ItemStr);
    if (Rc = 0) or (CurPos = MinPos) or (CurPos = MaxPos) then
      Flag := False
    else
      if Rc < 0 then
      begin
        MaxPos := CurPos;
        CurPos := (MaxPos + MinPos) shr 1;
      end
      else
      begin
        MinPos := CurPos;
        CurPos := (MaxPos + MinPos) shr 1;
      end;
  end;
  if (Rc > 0) then Inc(CurPos);

  MLBox^.SetSelIndex(CurPos);
  SendMessage(MLBox^.HWindow, LB_SETTOPINDEX, CurPos, 0);

  { Notify parent, because LB_SETCURSEL does not do it }
  PostMessage(HWindow, WM_COMMAND, GetDlgCtrlID(MLBox^.HWindow), MAKELONG(MLBox^.HWindow, lbn_SelChange));
end;

function TMLBCtl.OpenTable: Boolean;
begin
  Opened := (List^.BuildTable = tSuccess);
  OpenTable := Opened;
end;

procedure TMLBCtl.SetItemColor(ItemHandle: tItemHandle; AColor: LongInt; OwnColor: Boolean);
begin
  { Have to be overriden to set items colors          }
  { But there are two ways to change item color:
    1. Override SetItemColor in tMLBCtl - preferrable
    2. Override GetItemColor in tListTable            }
  List^.SetItemColor(ItemHandle, AColor, OwnColor);
end;

procedure TMLBCtl.SetupWindow;
var
  RP: TRect;
  i: Integer;
begin
  inherited SetupWindow;
  { Create ListBox font }
  CreateLBFont;
  { Set Listbox font }
  SendMessage(MLBox^.HWindow, wm_SetFont, LBFont, 0);
  { Adjust ButtonBar }
  GetClientRect(HWindow, RP);
  Dec(RP.right, 16);  { Do not include width of listbox's scroll bar }
  SendMessage(Bar^.HWindow, tm_CalcParentClientRect, 1, Longint(@RP));
  { Open table and fill list box }
  if OpenTable then
    FillListBox;
end;

function TMLBCtl.SkipItem(ItemHandle: tItemHandle): Boolean;
begin
  { Filter function. Have to be overriden for real filtering }
  SkipItem := False;
end;

function TMLBCtl.UpdateItem(RecNo: longint; var Index: Integer): Boolean;
var
  hItem: tItemHandle;
begin
  hItem := SendMessage(MLBox^.HWindow, LB_GETITEMDATA, Index, 0);
  MLBox^.DeleteString(Index);
  hItem := List^.UpdateItem(hItem, RecNo, False);
  Index := SendMessage(MLBox^.HWindow, LB_ADDSTRING, 0, Longint(hItem));
end;

procedure TMLBCtl.TMFirstColSize(var Msg: TMessage);
var
  LBDC: HDC;
  OldBrush: HBrush;
  P: TPoint;
  R: TRect;
  ROP: Integer;
  PS: TPaintStruct;
begin
  { Start ButtonBar button sizing }
  P := TPoint(Msg.lParam);
  LastXPos := P.X;
  GetClientRect(HWindow, R);
  if Boolean(PtInRect(R, P)) then
  begin
    BeginPaint(MLBox^.HWindow, PS);
    LBDC := GetDC(MLBox^.HWindow);
    OldBrush := SelectObject(LBDC, GrayingBrush);
    ROP := GetROP2(LBDC);
    SetROP2(LBDC, R2_XORPEN);
    SetROP2(LBDC, ROP);
    PatBlt(LBDC, P.X, 0, 1, R.bottom - 22, PATINVERT);
    SelectObject(LBDC, OldBrush);
    ReleaseDC(MLBox^.HWindow, LBDC);
    EndPaint(MLBox^.HWindow, PS);
  end;
end;

procedure TMLBCtl.TMNewColSize(var Msg: TMessage);
var
  LBDC: HDC;
  OldBrush: HBrush;
  P: TPoint;
  R: TRect;
  ROP: Integer;
  PS: TPaintStruct;
begin
  { Continue ButtonBar Button sizing }
  P := TPoint(Msg.lParam);
  GetClientRect(HWindow, R);
  if Boolean(PtInRect(R, P)) then
  begin
    BeginPaint(MLBox^.HWindow, PS);
    LBDC := GetDC(MLBox^.HWindow);
    OldBrush := SelectObject(LBDC, GrayingBrush);
    ROP := GetROP2(LBDC);
    SetROP2(LBDC, R2_XORPEN);
    PatBlt(LBDC, LastXPos, 0, 1, R.bottom - 22, PATINVERT);
    PatBlt(LBDC, P.X, 0, 1, R.bottom - 22, PATINVERT);
    SetROP2(LBDC, ROP);
    LastXPos := P.X;
    SelectObject(LBDC, OldBrush);
    ReleaseDC(MLBox^.HWindow, LBDC);
    EndPaint(MLBox^.HWindow, PS);
  end;
end;

procedure TMLBCtl.TMSizingEnd;
var
  R: TRect;
  Index: Word;
  Cols, i: Integer;
begin
  { End of ButtonBar button sizing }
  GetClientRect(HWindow, R);
  InvalidateRect(HWindow, @R, True);
  Cols := List^.GetColNumber;
  { Store new part sizes in ItemsList }
  for i := 1 to Cols do
    List^.ItemsList^.Items^[i].Part := Bar^.GetToolPart(i + BarButtonsIDFirst);
end;

procedure TMLBCtl.WMDrawItem;
var
  DS: PDrawItemStruct;
  DC, MemDC: HDC;
  hItem: tItemHandle;
  Cols, Origin, Align, Indent: Integer;
  ItemColor: Longint;
  ItemStr: array [0..MaxFieldWidth] of Char;
  Rect: TRect;

function Min(X1, X2: Integer): Integer;
begin
  if X1 < X2 then
    Min := X1
  else
    Min := X2;
end;

function Max(X1, X2: Integer): Integer;
begin
  if X1 > X2 then
    Max := X1
  else
    Max := X2;
end;

procedure Draw(BkGndCol, TextCol: Longint);
var
  Bmp: TBitmap;
  Bitmap, OldBmp: HBitmap;
  Brush, OldBrush: HBrush;
  i: integer;
  BmpSize: Integer;
  Bits: PChar;
  MemBmp: HBitmap;
begin
  Brush := CreateSolidBrush(BkGndCol);
  FillRect(DC, DS^.rcItem, Brush);
  SetTextColor(DC, TextCol);
  for i := 0 to cols - 1 do
  begin
    List^.GetFieldString(hItem, i, ItemStr);
    move(DS^.rcItem, Rect, SizeOf(TRect));
    Bar^.GetToolPos(List^.Index2ID(i + 1), Rect.left, Rect.right);
    Inc(Rect.left, DS^.rcItem.left);
    Inc(Rect.right, DS^.rcItem.left);
    if List^.GetItemType(i + 1) = ct_String then
    begin
      {*
       * Draw string
       *}
      DrawText(DC, ItemStr, StrLen(ItemStr), Rect,
               List^.GetColAlign(i + 1) or DT_NOPREFIX or List^.GetColWrap(i + 1));
    end
    else
    begin
      {*
       * Draw bitmap
       *}
      move(ItemStr, Bitmap, SizeOf(HBitmap));
      MemDC := CreateCompatibleDC(DC);
      GetObject(Bitmap, SizeOf(TBitmap), @Bmp);
      BmpSize := Bmp.bmHeight * Bmp.bmWidthBytes * Bmp.bmPlanes * Bmp.bmBitsPixel;
      GetMem(Bits, BmpSize);
      GetBitmapBits(Bitmap, BmpSize, Bits);
      MemBmp := CreateBitmap(Bmp.bmWidth, Bmp.bmHeight, Bmp.bmPlanes, Bmp.bmBitsPixel, Bits);
      OldBmp := SelectObject(MemDC, MemBmp);
      OldBrush := SelectObject(MemDC, Brush);
      ExtFloodFill(MemDC, 1, 1, $00FF0000, FloodFillSurface);
      SelectObject(MemDC, OldBrush);
      origin := Rect.top + ((Rect.bottom - Rect.top) - Bmp.bmHeight) div 2;
      Align := List^.GetColAlign(i + 1);
      case Align of
        DT_LEFT:
          Indent := BmpIndent;
        DT_RIGHT:
          Indent := (Rect.right - Rect.left) - BmpIndent - Bmp.bmWidth;
        DT_CENTER:
          Indent := (Rect.right - Rect.left) div 2 - Bmp.bmWidth div 2;
      end;
      BitBlt(DC, Rect.left + Indent, origin, Min(Rect.right - Rect.left - Indent, Bmp.bmWidth), Bmp.bmHeight,
             MemDC, 0, 0, srcCopy);
      SelectObject(MemDC, OldBmp);
      DeleteObject(MemBmp);
      DeleteDC(MemDC);
      FreeMem(Bits, BmpSize);
    end;
  end;
  DeleteObject(Brush);
end;

begin
  DS := PDrawItemStruct(Msg.lParam);
  DC := DS^.hDC;

  hItem := DS^.itemData;
  if DS^.itemID = Word(-1) then
  begin
    if ((DS^.itemAction and ODA_FOCUS) <> 0) then
    begin
      if (DS^.rcItem.bottom - DS^.rcItem.top) < 1 then
        DS^.rcItem.bottom := DS^.rcItem.top + Max(16, Abs(lLBFont.lfHeight));
      DrawFocusRect(DC, DS^.rcItem);
    end;
    Exit;
  end;
  if not List^.GetItemColor(hItem, ItemColor) then
    ItemColor := GetSysColor(COLOR_WINDOWTEXT);
  if (DS^.itemState and ODS_DISABLED) <> 0 then
    SetTextColor(DC, GetSysColor(COLOR_GRAYTEXT));
  Cols := List^.GetColNumber;
  SetBkMode(DC, Transparent);
  if ((DS^.itemAction and ODA_DRAWENTIRE) <> 0) then
  begin
    if (DS^.itemState and ODS_SELECTED) = 0 then
    begin
      Draw(GetSysColor(COLOR_WINDOW), ItemColor);
    end
    else
    if (DS^.itemState and ODS_SELECTED) <> 0 then
      begin
        if ItemColor = GetSysColor(COLOR_WINDOWTEXT) then
          Draw(GetSysColor(COLOR_HIGHLIGHT), GetSysColor(COLOR_HIGHLIGHTTEXT))
        else
          { 03/04/94 - This looks better }
          Draw(ItemColor, not ItemColor);
      end;
  end
  else
  begin
    if ((DS^.itemAction and ODA_SELECT) <> 0) then
      if (DS^.itemState and ODS_SELECTED) = 0 then
      begin
        Draw(GetSysColor(COLOR_WINDOW), ItemColor);
      end
      else
      if (DS^.itemState and ODS_SELECTED) <> 0 then
        begin
          if ItemColor = GetSysColor(COLOR_WINDOWTEXT) then
            Draw(GetSysColor(COLOR_HIGHLIGHT), GetSysColor(COLOR_HIGHLIGHTTEXT))
          else
            { 03/04/94 - This looks better }
            Draw(ItemColor, not ItemColor);
        end;
  end;
  if ((DS^.itemAction and ODA_FOCUS) <> 0) then
  begin
    DrawFocusRect(DC, DS^.rcItem);
  end;
end;

procedure TMLBCtl.WMCompareItem;
var
  CompStruct: PCompareItemStruct;
  Order: Word;
  S1, S2: PChar;
begin
  { Simply compare two strings }
  { Have to be overriden to compare more complicated data - date for example }
  CompStruct := PCompareItemStruct(Msg.lParam);
  Order := Bar^.GetSortOrder;
  Order := List^.ID2Index(Integer(Order));
  GetMem(S1, MaxFieldWidth);
  GetMem(S2, MaxFieldWidth);
  List^.GetFieldString(CompStruct^.itemData1, Order-1, S1);
  List^.GetFieldString(CompStruct^.itemData2, Order-1, S2);
  Msg.Result := StrComp(StrUpper(S1), StrUpper(S2));
  FreeMem(S1, MaxFieldWidth);
  FreeMem(S2, MaxFieldWidth);
end;

procedure TMLBCtl.WMMeasureItem;
begin
  { 16 - standart height of Bitmap I'm using in tables
    !!! See also wm_DrawItem handling with ItemData = -1 }
  with PMeasureItemStruct(Msg.lParam)^ do
  begin
    if Abs(lLBFont.lfHeight) > 16 then
      itemHeight := Abs(lLBFont.lfHeight)
    else
      itemHeight := 16;
  end;
end;

procedure TMLBCtl.WMCommand;
var
  hItem: tItemHandle;
  pLF  : pLogFont;
begin
  if (Msg.wParam - BarButtonsIDFirst) <= List^.ItemsList^.ColNumber then
  begin
    { This command from ButtonBar button }
    hItem := SendMessage(MLBox^.HWindow, LB_GETITEMDATA, 0, 0);
    List^.SetSortOrder(Msg.wParam);
    FillListBox;
    MLBox^.SetSelIndex(0);
    SendMessage(Parent^.HWindow, wm_SelChange, 0, 0);
  end
  else
    if Msg.lParamHi = LBN_SELCHANGE then
      { Notify parent that the selection was changed }
      SendMessage(Parent^.HWindow, wm_SelChange, 0, 0)
    else
      if Msg.lParamHi = LBN_DBLCLK then
        { Send input message to parent }
        SendMessage(Parent^.HWindow, wm_DblClicked, 0, 0)
      else
      begin
        case Msg.wParam of
          idm_Font:
            begin
              pLF := @lLBFont;
              if GetFont(pLF, HWindow, ItemsColor) then
              begin
                DeleteObject(LBFont);
                LBFont := CreateFontIndirect(lLBFont);
                SendMessage(MLBox^.HWindow, wm_SetFont, LBFont, MAKELONG(1, 0));
                FillListBox;
              end;
            end;
          idm_Locate:
            begin
              PostMessage(HWindow, wm_CharToItem, 0, MAKELONG(MLBox^.HWindow, 0));
            end;
          else
           inherited WMCommand(Msg);
        end;
      end
end;

procedure TMLBCtl.WMCharToItem(var Msg: TMessage);
var
  LS: array [0..2] of Char;
  LD: tLocateDlg;
begin
  LS[0] := Char(Msg.wParam);
  LS[1] := #0;

  if (LS[0] >= ' ') or (LS[0] = #0) then
    Application^.MakeWindow(New(PLocateDlg, Init(@Self, 'Locate_Dlg', LS)));

  Msg.Result := -2; { We handle all aspects of selecting the item }
end;

procedure TMLBCtl.WMSetFocus(var Msg: TMessage);
begin
  { Always keep listbox focused }
  SetFocus(MLBox^.HWindow);
end;

{ ------------------------------------------------------------------- }

constructor TLocateDlg.Init(AParent: PWindowsObject; AName: PChar; ALocStr: PChar);
begin
  StrCopy(LocStr, ALocStr);
  FirstEntry := True;
  inherited Init(AParent, AName);
end;

destructor TLocateDlg.Done;
begin
  SetFocus(PMLBCtl(Parent)^.MLBox^.HWindow);
  inherited Done;
end;

procedure TLocateDlg.SetupWindow;
begin
  inherited SetupWindow;
  SetDlgItemText(HWindow, 101, LocStr);
end;

procedure TLocateDlg.EditBox(var Msg: TMessage);
begin
  if SendDlgItemMsg(101, EM_GETSEL, 0, 0) <> 0 then
    if FirstEntry then
    begin
      { Clear selection }
      SendDlgItemMsg(101, EM_SETSEL, 1, MAKELONG(StrLen(LocStr) + 1, StrLen(LocStr) + 1));
      FirstEntry := False;
    end;
  if (Msg.LParamHi = EN_CHANGE) then
  begin
    GetDlgItemText(HWindow, 101, LocStr, 100);
    PMLBCtl(Parent)^.Locate(LocStr);
  end;
end;

end.
