#define Uses_TStringCollection

//define NoBlink to disable Turbo Vision's screen clear at termination
//if black flash is annoying.
#ifdef NoBlink
#define Uses_TScreen
#endif

#if defined (TV2)
#   include <tvision\tv.h>
#elif defined (TV1)
#   include <tv.h>
#else
#   error TV1 or TV2 must be defined
#endif

#include <stdlib.h>
#include <dos.h>
#include <dir.h>
#include <fcntl.h>
#include <string.h>
#include <iostream.h>
#include <fstream.h>
#include <stdio.h>
#include "readscpt.h"

#pragma warn -sig

#define MAXBUFF 350
char *ch, buff[MAXBUFF];
int lineNo;
ifstream *inf;
TNSCollection *ScriptColl;   //holds all the controls read
ViewObj *Dialog;             //hols the dialog itself
Boolean present[ScrollB + 1];  //tells which Kinds are present
Boolean valPresent[StringLookup + 1];  //tells which ValKinds are present
TStringCollection *classCollection;  //a collection of all the class names
ushort tvVersion;

void getch();
long getNumber();
char* getString();       //never NULL
void skipWhiteSpace();
void error(const char *S);

ViewObj::ViewObj()
//the base struct constructor.  Read all the field common to all controls and dialog.
{
 BaseObj = getString();
 Obj = getString();
 X1 = getNumber();
 Y1 = getNumber();
 X2 = getNumber();
 Y2 = getNumber();
 DefOptns = getNumber() & ~0x1000; //make sure version 2 bit isn't present
 Optns = getNumber() & ~0x1000;
 DefEvMsk = getNumber();
 EvMsk = getNumber();
 HCtx = getNumber();
 Grow = getNumber();
 for (int i = 0; i < MAXPARAM; i++)
   Param[i] = getString();
 HelpCtxSym = getString();
 FieldName = getString();
 VarName = getString();
}

DialogObj::DialogObj() : ViewObj()
//dialog constructor. read fields special to the dialog.
{
 Palette  = getNumber();
 WinFlags  = getNumber();
 DlgFuncName  = getString();
 KeyString = getString();
 Title  = getString();
}

ButtonObj::ButtonObj() : ViewObj()
{
 CommandName = getString();
 ButtonText = getString();
 CommandValue = getNumber();
 Flags = getNumber();
}

LabelObj::LabelObj() : ViewObj()
{
  LabelText = getString();
  LinkName = getString();
}

StaticTextObj::StaticTextObj() : ViewObj()
{
  Attrib = getNumber();
  Text = getString();
}

HistoryObj::HistoryObj() : ViewObj()
{
  HistoryID = getNumber();
  HistoryLink = getString();
}

InputLongObj::InputLongObj() : ViewObj()
{
  LongLabelText = getString();
  LongStrLeng = getNumber();
  LLim = getNumber();
  ULim = getNumber();
  ILOptions = getNumber();
}

ListBoxObj::ListBoxObj() : ViewObj()
{
  Columns = getNumber();
  ScrollBar = getString();
}

MemoObj::MemoObj() : ViewObj()
{
  TextFieldName = getString();
  BufSize = getNumber();
  VScroll = getString();
  HScroll = getString();
}

ClusterObj::ClusterObj() : ViewObj()
{ int i;
  Items = getNumber();
  Mask = getNumber();
  if (Items > 0) {
    LabelColl = new TStringCollection(10,10);
    for (i = 0; i < Items; i++)
      LabelColl->atInsert(i, getString());   //entered in received order.
                                             //prevent sorting
    }
}
MultiCheckBoxObj::MultiCheckBoxObj() : ClusterObj()
{
  MCBFlags = getNumber();
  SelRange = getNumber();
  States = getString();
}


     PictureValidatorObj::PictureValidatorObj() : ValidatorObj()
     {
       ValPtrName = getString();
       int i;
       if (!classCollection->search(ValPtrName, i))
          classCollection->insert(newStr(ValPtrName));
       AutoFill = getNumber();
       PictureString = getString();
     }

     RangeValidatorObj::RangeValidatorObj() : ValidatorObj()
     {
       ValPtrName = getString();
       int i;
       if (!classCollection->search(ValPtrName, i))
          classCollection->insert(newStr(ValPtrName));
       LowLim = getNumber();
       UpLim = getNumber();
       Transfer = getNumber();
     }

     FilterValidatorObj::FilterValidatorObj() : ValidatorObj()
     {
       ValPtrName = getString();
       CharSet = getString();
       int i;
       if (!classCollection->search(ValPtrName, i))
         classCollection->insert(newStr(ValPtrName));
       for (i = 0; i <= 7; i++)
         ActualCharSet[i] = getNumber();
     }

     StringLookupValidatorObj::StringLookupValidatorObj() : ValidatorObj()
     {
      ValPtrName = getString();
      List = getString();
      int i;
      if (!classCollection->search(ValPtrName, i))
        classCollection->insert(newStr(ValPtrName));
     }

InputLineObj::InputLineObj() : ViewObj()
{
  StringLeng = getNumber();
  ValKind = (valType)getNumber();
  val = getValKind(ValKind);
  if (ValKind != none)
    valPresent[ValKind] = True;
  else {
    char *s = getString(); //must read a blank string here
    delete s;
    }
}

char* myNewStr(const char* S)
//like newStr but never returns a NULL pointer
{
 char *P;
 if (S[0] == '\0') {
    P = new char[ 1 ];     //kind of silly, but saves a lot of testing here
    *P = '\0';
   }
 else P = newStr(S);
 return P;
}

void getch()    //read next character in script file
{
 if (*ch == '\0') {     //need to read a line
    if (!inf->eof()) {
      inf->getline(buff, 255);
      lineNo++;
      ch = buff;
      }
    else error("Unexpected end of file");
   }
 else ch++;
}

void spaces(int n)
{for (int i = 1; i <= n; i++)
  cout << ' ';
}

void error(const char *S)  //handles error reporting
{
 short X;
 char newS[80], tmp[20];

 cout << buff << endl;
 X = ch-buff-1;
 if (X < 1) X = 1;
 strcpy(newS, "Line ");
 itoa(lineNo, tmp, 10);
 strcat(newS, tmp);
 strcat(newS, " Error, ");
 strncat(newS, S, 79-strlen(newS));
 if (X > strlen(newS)) {
   spaces(X-strlen(newS)-1);
   cout << newS << '^' <<endl;
   }
 else {
   spaces(X-1);
   cout << '^' << newS << endl;
   }
 inf->close();
 exit(1);
}

void checkMemory()
{
 if (lowMemory()) {
   cout << "Out of memory\n";
   exit(1);
   }
}

void skipWhiteSpace()
{
 char c = *ch;
 while (c == ' ' || c == '\t' || c == '\0')  {
   getch();
   c = *ch;
   }
}

char* getString()
//reads a string in double quotes "like this \"one\"".  Never returns NULL
{
 char S[MAXBUFF] = "";
 int i = 0;
 skipWhiteSpace();
 if (*ch != '\"')
   error("Quoted string expected");
 getch();
 while ((*ch != '\"' || ch[1] == '+') && i < MAXBUFF-3) {
   if (ch[0] == '\\' && ch[1] =='\"') {
     S[i++] = '\\';
     S[i++] = '\"';
     getch();        //use up the extra character
     }
   else if (ch[0] == '\"' && ch[1] == '+') {  // a string continuation
     getch();  //skip '"'
     getch();  //skip '+'
     skipWhiteSpace();
     if (*ch != '\"')
        error("Quoted string continuation expected");
     }
   else S[i++] = *ch;  //Normal case
   getch();
   }
 getch();    //use up last "
 S[i] = '\0';
 return myNewStr(S);  //getString is never NULL
}

long getNumber()  //reads a decimal number
{
 char S[20] = "";
 int i = 0;
 skipWhiteSpace();
 if (*ch == '-') {
   S[i++] = '-';
   getch();
   }
 if (*ch < '0' || *ch > '9')
   error("Number expected");
 while (*ch >= '0' && *ch <= '9' && i < 20) {
   S[i++] = *ch;
   getch();
   }
 return atol(S);
}

void readScriptFile(char* scriptName)
{
#ifdef NoBlink
//disable clearScreen() by inserting a Retf instruction
 *(uchar*) TScreen::clearScreen = 0xCB;
#endif

 inf = new ifstream(scriptName);
 if (!inf->good()) {
   cout << "Can't open script file, " << scriptName << endl;
   inf->close();
   exit(1);
   }

 char tmp[10];
 inf->getline(tmp, 10);
 if (strcmp(VersionID, tmp) != 0) {
   cout << scriptName << " is not a valid script file\n";
   inf->close();
   exit(1);
   }

 lineNo = 1;
 buff[0] = '\0';  //start the reading
 ch = buff;
 getch();
 getString();    // reserved
 tvVersion = getNumber();    //100 or 200 for version 1 or 2

 ScriptColl = new TNSCollection(10,10); //start collection for the controls
 classCollection = new TStringCollection(10,10);

 recType Kind;

 Kind = (recType)getNumber();
 if (Kind != Dlg)
   error("First item is not TDialog type");
 Dialog = getKind(Kind);
 classCollection->insert(newStr(Dialog->Obj));
 present[Kind] = True;
 skipWhiteSpace;

 ViewObj *P;
 Kind = (recType)getNumber();
 while (Kind != Done)  {
   checkMemory();
   //getKind must be defined elsewhere.  It returns the final ViewObj extension
   //appropriate for Kind.
   P = getKind(Kind);
   if (P == 0)
     error("Unrecognized control type");
   ScriptColl->insert(P);
   ccIndex i;
   if (!classCollection->search(P->Obj, i))
       classCollection->insert(newStr(P->Obj));
   present[Kind] = True;   //keep track of which types are present
   skipWhiteSpace();
   Kind = (recType)getNumber();
   }
}
