

{Exception trap for BugSlay (TM). Traps processor exceptions to give
detailed error reports.

Must be seperate from the other functions as the code segment attributes
are different. Handler must be installed by InterruptRegister at startup
and removed with InterruptUnRegister at termination.

Rex K. Perkins, 10th February, 1994.

 Copyright Apsley-Bolton Computers, Inc.}


Unit ExceptionHandler;

{$C Fixed Preload Permanent}
{$S-}  {Don't bother to check the stack. We couldn't do anything about it anyway}
{$W-}  {BugSlay does not support Windows stack frames, so turn them off}

Interface

  Procedure ExceptionCallback; Export;
    {Exception handler. Install using InterruptRegister}

Implementation

Uses BugSlayImports;

{$IfDef Ver15}  {Local in TPW1.5, default in BPW7}
  {$G+}  {Enable 286 instructions}
{$EndIf}


  Procedure ExceptionCallback; Assembler;

  {Exception handler. Install using InterruptRegister}

  Const IntNumOffset=8; {Stack frame adds two bytes to the stack, so sp+6=bp+8}
        SSOffset=$14;
        SPOffset=$12;
        CSOffset=$0E;
        IPOffset=$0C;

  Asm
    db $66;pusha    {32 bit prefix=pushad}

    push es

    mov ax,[bp+IntNumOffset]  {Get the Exception number}

    cmp ax,$0100    {Don't process Ctrl-Alt-SysReq interrupts (IntNum=$0100)}
    jz @DoNotProcess
    cmp ax,$01  {Breakpoint. Don't process}
    jz @DoNotProcess
    cmp ax,$03  {Breakpoint. Don't process}
    jz @DoNotProcess

    mov bx,ss
      {If a low-stack error occured, the MSb of ax will be set, the
       SS on error is at [bp+SSOffset] and SS will be one supplied by
       the DPMI host [Windows]}
    cmp ah,$80  {SS parameter present?}
    jnz @NoStackParam
    mov bx,[bp+SSOffset]
   @NoStackParam:    {We now have the SS on error in BX, regardless of a stack switch}

    mov cx,ds
    cmp bx,cx        {Was/Is our task running?}
    jnz @DoNotProcess  {No, OldSS<>DS so don't process exception}

               {Set up the stack for a call to the Pascal handler}
    push ax    {Param: ErrorNumber}
    mov bx,[bp+CSOffset]    {this is a selector. Is it valid?}
    lsl cx,bx
    jnz @SelectorNotValid
    push bx     {Param: FaultCS; yes}
    jmp @GotCS

  @SelectorNotValid:    {The CS is not valid, so push a nil selector}
    push 0      {Param: FaultCS}

  @GotCS:
    mov bx,[bp+IPOffset]
    push bx     {Param: FaultIP}

    mov bx,[bp]  {Get stack frame when error occured. Pushed on this stack by the prolog code}
    push bx   {Param BP}
    and ax,$8000    {If high bit is set, SS and SP are present on the stack frame}
    jnz @HasStackInfo
    push SS      {Param: FaultSS; no stack info. Push SS...}
    push SP      {Param: FaultSP; ...and SP}
    jmp @StackSetup

  @HasStackInfo:    {This is a stack low fault. Get the stack details}
    mov ax,[bp+SSOffset]
    push ax     {Param: FaultSS}
    mov ax,[bp+SPOffset]
    push ax     {Param: FaultSP}
  @StackSetup:

    push HeapList  {Param: AppHeapList}
    Call BugSlayImports.HandleException

  @DoNotProcess:
    pop es
    db $66;popa    {32 bit prefix=popad}
  End;

End.
