
{A simple program that crashes in it's paint method. Used to demonstrate
BugSlay.

This will leave a window allocated on termination.

Rex K. Perkins, 11th July 1994

 Copyright Apsley-Bolton Computers, Inc.}


Program CrashMe;

{$C PRELOAD}

Uses BugSlay,WinTypes, WinProcs,
  {$IfDef Ver15}
    WObjects;    {WObjects for TPW1.5... or}
  {$Else}
    OWindows;    {OWindows for BPW7}
  {$EndIf}

{$D CrashMe!}
{$R+}    {We will be causing a 201:Range Check Error, so we need range checking on!}
{$W-}    {BugSlay does not support Windows stack frames, so turn them off}

Const
  BoxSize=16;    {Size of each box}
  NumColors=4096;{Max X+Y of window size}

Type

  TCrashMeApplication=Object(TApplication)
    Procedure InitMainWindow; Virtual;
  End;


  PCrashMeWindow=^TCrashMeWindow;
  TCrashMeWindow=Object(TWindow)
    Procedure Paint(PaintDC:HDC; Var PaintInfo:TPaintStruct); Virtual;
  End;


  PColorTable=^TColorTable;
  TColorTable=Array[1..NumColors] Of TColorRef;



Procedure TCrashMeApplication.InitMainWindow;

Begin
  MainWindow:=New(PCrashMeWindow,Init(Nil,'CrashMe!'))
End;


{--------Main Window----------}


Procedure TCrashMeWindow.Paint(PaintDC:HDC; Var PaintInfo:TPaintStruct);

{Draw a series of boxes on the screen. Will crash with a range check error}

Var ColorTable:PColorTable;

  Procedure CreateColorArray;

  {Create a big table of random colors}

  Var BrushColor:TColorRef;
      ColorIndex:Word;

  Begin
    For ColorIndex:=1 To NumColors Do
      ColorTable^[ColorIndex]:=RGB(Random($100),Random($100),Random($100))
  End;



  Procedure DrawBoxes;

  {Fill the window with boxes}

  Var WindowSize:TRect;
      Line:Integer;

    Procedure DrawLine(Line:Integer);

    {Draw a line of boxes on Line}

    Var Col:Integer;

      Procedure DrawBox(Col,Line:Integer);

      {Draw one box at Col,Line in a random color}

      Var BoxToDraw:TRect;
          ColoredBrush:HBrush;

      Begin
        ColoredBrush:=CreateSolidBrush(ColorTable^[Col+Line]);

        With BoxToDraw Do  {Build the Rect record}
          Begin
            Top:=(Line*BoxSize)+1;
            Bottom:=(Line+1)*BoxSize;
            Left:=(Col*BoxSize)+1;
            Right:=(Col+1)*BoxSize
          End;

        FillRect(PaintDC,BoxToDraw,ColoredBrush);  {Draw the rectangle}

        DeleteObject(ColoredBrush)    {Tidy up}
      End;

    Begin
      Col:=WindowSize.Right DIV BoxSize;  {Calculate number of boxes in a column}
      While Col>=0 Do
        Begin
          DrawBox(Col,Line);
          DEC(Col)
        End
    End;

  Begin
    GetClientRect(HWindow,WindowSize);
    Line:=WindowSize.Bottom DIV BoxSize;  {Calculate number of boxes on a line}
    While Line>=0 Do
      Begin
        DrawLine(Line);
        DEC(Line)
      End
  End;

Begin
  New(ColorTable);    {Allocate the color table on the heap}
  If ColorTable<>Nil Then
    Begin
      CreateColorArray; {Fill color table with random colors}
      DrawBoxes         {Draw the boxes}
    End;
  Dispose(ColorTable) {Free the color table}
End;



Var
  CrashMeApp:TCrashMeApplication;

Begin
  CrashMeApp.Init('CrashMe');
  CrashMeApp.Run;
  CrashMeApp.Done
End.


