

{BugSlayImports. Import unit for BugSlay.

Uses an unorthodox approach of explicitly linking to BugSlay.DLL. This
allows the application to continue even if the DLL is not found.

Rex K. Perkins, 5th July 1994

 Copyright Apsley-Bolton Computers, Inc.
}

Unit BugSlayImports;


Interface

Uses WinTypes;

{$W-}    {BugSlay does not support Windows stack frames, so turn them off}


Const

    {td_xxxx flags. Combine these to give the level of detail in the stack trace.
    Used in SetBugSlayOptions}
  td_DoStackTrace=$0001;    {Must be set, otherwise a stack trace will not take place}
  td_Vars=$0002;            {Include local vars and parameters in stack dump}
  td_LineNos=$0004;         {Include line numbers and file names for each stack frame}
  td_HeapDump=$0008;        {Dump allocations on the heap}
  td_ModuleName=$0010;      {Include 'Module.' prefix for each stack frame}
      {For LogFileTrace only:}
  td_DumpGlobalSegs=$0020;  {Dump global segments}
  td_DumpGlobalVars=$0040;  {Dump global variables (Typed constants)}
  td_DumpGlobalConsts=$0080;{Dump global Constants (Typed and Untyped constants). Use with td_DumpGlobalVars}
  td_DumpGlobalsInAllModules=$0100;  {Dump globals in all modules if set, in main module only if clear}

  td_AllDetails=$FFFF;
  td_Normal=td_AllDetails AND NOT(td_DumpGlobalConsts);


Type

  {Don't use CONST in function/procedure declarations to allow
   compatibility with TPW 15.}

  TAppStatusDump=Procedure (Module:THandle;
                            SS,BP,CS,IP,ErrorCode,AppHeapList:Word;
                            CSIsLogicalSegment:Boolean);
  {Do a status dump. Can be called in an error situation to trace an error, or
  a non error situation to do a heap dump. Parameters:

  Error condition:
     Module              Specifies handle of the module the error occured in
     SS,BP               SS:BP specifies the stack frame of the error
     CS,IP               CS:IP specifies the error CS:IP. CS can be a selector or segment
     ErrorCode           Specifies the run time error code
     AppHeapList         System.HeapList variable from application
     CSIsLogicalSegment  True is CS is a logical segment, false if selector

  Non-error condition:
     Module              Undefined
     SS,BP               Undefined
     CS                  0
     IP                  Undefined
     ErrorCode           Undefined
     AppHeapList         System.HeapList variable from application
     CSIsLogicalSegment  Undefined}



  THandleException=Procedure (ErrorNumber,FaultCS,FaultIP,
                                  FaultBP,FaultSS,FaultSP,AppHeapList:Word);

  {ExecptionCallback (in the app) calls this routine for further processing
  if the exception is of interest. Parameters are:

  ErrorNumber                Exception code, as defined by ToolHelp/InterruptRegister
  FaultCS:FaultIP            CS:IP of faulting instruction. Note CS is a selector
  FaultBP                    BP when fault occured
  FaultSS:FaultSP            SS:SP of stack when fault occured, or current if fault not stack related
  AppHeapList         System.HeapList variable from application}


  TSetBugSlayOptions=Procedure (Reserved1,Reserved2:Longint;
                                td_LogFileTrace,td_LogFileOverview,td_AuxTrace,
                                MaxFrames,HeapBytesToDump,OWLSafetyPoolSize,
                                MaxDumpSize:Word;
                                MaxUnroll:Byte;
                                DoHeapAllocationCheck:Boolean;
                                AuxName:PChar;
                                Reserved3,Reserved4:Longint);

   {Set BugSlay options:

    NAME                  DEFAULT DESCRIPTION
    ~~~~                  ~~~~~~~ ~~~~~~~~~~~
    Reserved1,Reserved2         0 Reserved: Internal flags.
    td_LogFileTrace         $FF7F Options for main stack trace in log file. Combination of td_xxxx flags.
    td_LogFileOverview      $0011 Options for overview stack trace in log file. Combination of td_xxxx flags.
    td_AuxTrace             $0019 Options for stack trace on debugging terminal. Combination of td_xxxx flags.
    MaxFrames               10000 Maximum number of stack frames to dump.
    HeapBytesToDump            13 Number of bytes per heap block to dump if heap allocations exist on exit.
    OWLSafetyPoolSize        8192 Size of OWL Safety pool. Used to identify in Global dumps.
    MaxDumpSize                32 Number of bytes dumped in a stack frame for an unsupported variable type.

    MaxUnroll                   3 Maximum number of levels to unroll a record or pointer

    DoHeapAllocationCheck True    If true, check for small heap allocations on app termination
    AuxName               Nul     Name of debugging screen, or Nul if none.
    Reserved3,Reserved4         0 Reserved: Internal flags}


Var
    AppStatusDump:TAppStatusDump;
    HandleException:THandleException;
    SetBugSlayOptions:TSetBugSlayOptions;
    BugSlayLoaded:Boolean;    {True if BugSlay was found}

Implementation

Uses WinProcs, Win31;

Const

  DLLName='BugSlay.DLL';


Var
    hLibrary:THandle;
    OldExitProc:Pointer;


  Procedure TryToLoadLibrary;

  {Attempt to load the DLL}

  Var OldErrorMode:Word;

  Begin
    OldErrorMode:=SetErrorMode(sem_NoOpenFileErrorBox);  {Don't display an warning if not found}
    hLibrary:=LoadLibrary(DLLName);    {Try to load the library}
    SetErrorMode(OldErrorMode)  {Restore original value}
  End;



  Procedure GetProcedures;

  {Get the procedure addresses}

  Var TempProc:TFarProc;

  Begin
    TempProc:=GetProcAddress(hLibrary,'AppStatusDump');
    AppStatusDump:=TAppStatusDump(TempProc);
    TempProc:=GetProcAddress(hLibrary,'HandleException');
    HandleException:=THandleException(TempProc);
    TempProc:=GetProcAddress(hLibrary,'SetBugSlayOptions');
    SetBugSlayOptions:=TSetBugSlayOptions(TempProc)
  End;


  Procedure FreeLib; Far;

  {Free the BugSlay DLL}

  Begin
    ExitProc:=OldExitProc;
    FreeLibrary(hLibrary)
  End;



Begin
  TryToLoadLibrary;
  If hLibrary>HInstance_Error Then   {Got it. Get the procedure addresses}
    Begin
      OldExitProc:=ExitProc;  {Add our exit procedure to the exit chain}
      ExitProc:=@FreeLib;
      GetProcedures;          {Get the addresses of the imported procedures}
      BugSlayLoaded:=True
    End
  Else
    BugSlayLoaded:=False
End.

