/***************************************************************************\
          (c) 1993, Simple Software, Inc., All rights reserved

	THLMSG.CPP

HList Message/Method interface code

\***************************************************************************/
								 
/*
	HList Method Wrappers
*/

_WRAP_INLINE int _WRAPNAME(HList)::AddItem(LPVOID lpData) 
	{
  return HLAddItem(HWindow, lpData);
  }

_WRAP_INLINE int _WRAPNAME(HList)::AddItemEx(LPVOID lpData, LPVOID lpCode) 
	{
	return HLAddItemEx(HWindow, lpData, lpCode);
	}

_WRAP_INLINE int _WRAPNAME(HList)::AddItems(int iCount, LPVOID lpData) 
	{
	return HLAddItems(HWindow, iCount, lpData);
	}

_WRAP_INLINE int _WRAPNAME(HList)::AddItemsEx(int iCount, LPVOID lpData, LPVOID lpCode) 
	{
	return HLAddItemsEx(HWindow, iCount, lpData, lpCode);
	}

_WRAP_INLINE BOOL _WRAPNAME(HList)::DeleteItem(int iIndex) 
	{
	return HLDeleteItem(HWindow, iIndex);
	}

_WRAP_INLINE int _WRAPNAME(HList)::DeleteItems(WORD wSearch, int iCount, LPVOID lpInfo) 
	{
	return HLDeleteItems(HWindow, wSearch, iCount, lpInfo);
	}

_WRAP_INLINE BOOL _WRAPNAME(HList)::EmptyList(void) 
	{
	return HLEmptyList(HWindow);
	}

_WRAP_INLINE int _WRAPNAME(HList)::FindCode(int iStart, LPVOID lpCode) 
	{
	return HLFindCode(HWindow, iStart, lpCode);
	}

_WRAP_INLINE int _WRAPNAME(HList)::FindData(int iStart, LPVOID lpData) 
	{
	return HLFindData(HWindow, iStart, lpData);
	}

_WRAP_INLINE BOOL _WRAPNAME(HList)::GetCode(int iIndex, LPVOID lpCode) 
	{
	return HLGetCode(HWindow, iIndex, lpCode);
	}

_WRAP_INLINE BOOL _WRAPNAME(HList)::GetData(int iIndex, LPVOID lpData) 
	{
	return HLGetData(HWindow, iIndex, lpData);
	}

_WRAP_INLINE int _WRAPNAME(HList)::GetItems(int iCount, WORD wReturn, LPVOID lpReturn, WORD wSearch, LPVOID lpInfo) 
	{
	return HLGetItems(HWindow, iCount, wReturn, lpReturn, wSearch, lpInfo);
	}

_WRAP_INLINE int _WRAPNAME(HList)::InsertItem(int iPos, LPVOID lpData) 
	{
	return HLInsertItem(HWindow, iPos, lpData);
	}

_WRAP_INLINE int _WRAPNAME(HList)::InsertItemEx(int iPos, LPVOID lpData, LPVOID lpCode) 
	{
	return HLInsertItemEx(HWindow, iPos, lpData, lpCode);
	}

_WRAP_INLINE int _WRAPNAME(HList)::InsertItems(int iPos, int iCount, LPVOID lpData) 
	{
	return HLInsertItems(HWindow, iPos, iCount, lpData);
	}

_WRAP_INLINE int _WRAPNAME(HList)::InsertItemsEx(int iPos, int iCount, LPVOID lpData, LPVOID lpCode) 
	{
	return HLInsertItemsEx(HWindow, iPos, iCount, lpData, lpCode);
	}

_WRAP_INLINE BOOL _WRAPNAME(HList)::IsSelected(int iIndex) 
	{
	return HLIsSelected(HWindow, iIndex);
	}

_WRAP_INLINE BOOL _WRAPNAME(HList)::SelectCode(LPVOID lpCode, WORD wAction) 
	{
	return HLSelectCode(HWindow, lpCode, wAction);
	}

_WRAP_INLINE BOOL _WRAPNAME(HList)::SelectData(LPVOID lpData, WORD wAction) 
	{
	return HLSelectData(HWindow, lpData, wAction);
	}

_WRAP_INLINE BOOL _WRAPNAME(HList)::SelectItem(int iIndex, WORD wAction) 
	{
	return HLSelectItem(HWindow, iIndex, wAction);
	}

_WRAP_INLINE BOOL _WRAPNAME(HList)::SelectItems(WORD wAction, WORD wSearch, int iCount, LPVOID lpInfo) 
	{
	return HLSelectItems(HWindow, wAction, wSearch, iCount, lpInfo);
	}

_WRAP_INLINE BOOL _WRAPNAME(HList)::SetCode(int iIndex, LPVOID lpCode) 
	{
	return HLSetCode(HWindow, iIndex, lpCode);
	}

_WRAP_INLINE BOOL _WRAPNAME(HList)::SetCodeLink(LPVOID lpCode, BOOL bSelect) 
	{
	return HLSetCodeLink(HWindow, lpCode, bSelect);
	}

_WRAP_INLINE BOOL _WRAPNAME(HList)::SetDataLink(LPVOID lpData, BOOL bSelect) 
	{
	return HLSetDataLink(HWindow, lpData, bSelect);
	}


_WRAP_INLINE BOOL _WRAPNAME(HList)::MarkItems(WORD wSearch, int iCount, LPVOID lpInfo) 
	{
	return HLMarkItems(HWindow, wSearch, iCount, lpInfo);
	}



/*
	HList Message Wrappers
*/
_WRAP_INLINE char _WRAPNAME(HList)::GetCodeClass(void) 
	{
	return (char)_WRAP_SM(HLM_GETCODECLASS, 0, 0L);
	}
	
_WRAP_INLINE LPVOID _WRAPNAME(HList)::GetCodeLink(void) 
	{
	return (LPVOID)_WRAP_SM(HLM_GETCODELINK, 0, 0L);
	}
	
_WRAP_INLINE int _WRAPNAME(HList)::GetCodeSize(int iIndex) 
	{
	return (int)_WRAP_SM(HLM_GETCODESIZE, iIndex, 0L);
	}
	
_WRAP_INLINE int _WRAPNAME(HList)::GetCodeType(void) 
	{
	return (int)_WRAP_SM(HLM_GETCODETYPE, 0, 0L);
	}
	
_WRAP_INLINE BOOL _WRAPNAME(HList)::GetCurCode(LPVOID lpBuf, WORD wSize) 
	{
	return (BOOL)_WRAP_SM(HLM_GETCURCODE, wSize, (LONG)lpBuf);
	}
	
_WRAP_INLINE BOOL _WRAPNAME(HList)::GetCurData(LPVOID lpBuf, WORD wSize) 
	{
	return (BOOL)_WRAP_SM(HLM_GETCURDATA, wSize, (LONG)lpBuf);
	}

_WRAP_INLINE WORD _WRAPNAME(HList)::GetCurSel(void) 
	{
		return (WORD)_WRAP_SM(HLM_GETCURSEL, 0, 0L);
  }
	
_WRAP_INLINE char _WRAPNAME(HList)::GetDataClass(void) 
	{
	return (char)_WRAP_SM(HLM_GETDATACLASS, 0, 0L);
	}
	
_WRAP_INLINE LPVOID _WRAPNAME(HList)::GetDataLink(void) 
	{
	return (LPVOID)_WRAP_SM(HLM_GETDATALINK, 0, 0L);
	}
	
_WRAP_INLINE int _WRAPNAME(HList)::GetDataSize(int iIndex) 
	{
	return (int)_WRAP_SM(HLM_GETDATASIZE, iIndex, 0L);
	}
	
_WRAP_INLINE int _WRAPNAME(HList)::GetDataType(void) 
	{
	return (int)_WRAP_SM(HLM_GETDATATYPE, 0, 0L);
	}
	
_WRAP_INLINE void _WRAPNAME(HList)::GetFormat(LPSTR lpBuf, int iMaxLen) 
	{
	_WRAP_SM(HLM_GETFORMAT, iMaxLen, (LONG)lpBuf);
	}
	
_WRAP_INLINE int _WRAPNAME(HList)::GetHExtent(void) 
	{
	return (int)_WRAP_SM(HLM_GETHEXTENT, 0, 0L);
	}
	
_WRAP_INLINE BOOL _WRAPNAME(HList)::GetItemRect(int iIndex, LPRECT lpR) 
	{
	return (BOOL)_WRAP_SM(HLM_GETITEMRECT, iIndex, (LONG)lpR);
	}
	
_WRAP_INLINE int _WRAPNAME(HList)::GetScrollPos(void) 
	{
	return (int)_WRAP_SM(HLM_GETSCROLLPOS, 0, 0L);
	}
	
_WRAP_INLINE BOOL _WRAPNAME(HList)::GetSel(int iIndex) 
	{
	return (BOOL)_WRAP_SM(HLM_GETSEL, iIndex, 0L);
	}
	
_WRAP_INLINE int _WRAPNAME(HList)::GetSelCount(void) 
	{
	return (int)_WRAP_SM(HLM_GETSELCOUNT, 0, 0L);
	}
	
_WRAP_INLINE int _WRAPNAME(HList)::GetSelItems(LPINT lpBuf, int iMaxItems) 
	{
	return (int)_WRAP_SM(HLM_GETSELITEMS, iMaxItems, (LONG)lpBuf);
	}
	
_WRAP_INLINE LONG _WRAPNAME(HList)::GetState(void) 
	{
	return (LONG)_WRAP_SM(HLM_GETSTATE, 0, 0L);
	}
	
_WRAP_INLINE int _WRAPNAME(HList)::GetText(LPSTR lpBuf, int iIndex) 
	{
	return (int)_WRAP_SM(HLM_GETTEXT, iIndex, (LONG)lpBuf);
	}
	
_WRAP_INLINE int _WRAPNAME(HList)::GetTextLen(int iIndex) 
	{
	return (int)_WRAP_SM(HLM_GETTEXTLEN, iIndex, 0L);
	}

_WRAP_INLINE LONG _WRAPNAME(HList)::GetStyle(void) 
	{
	return (LONG)_WRAP_SM(HLM_GETSTYLE, 0, 0L);
	}
	
_WRAP_INLINE COLORREF _WRAPNAME(HList)::GetTextColor(BOOL bNeg) 
	{
	return (COLORREF)_WRAP_SM(HLM_GETTEXTCOLOR, (WPARAM)bNeg, 0L);
	}	                                                        
	
_WRAP_INLINE void _WRAPNAME(HList)::SetTextColor(COLORREF crNew, BOOL bNeg) 
	{
	_WRAP_SM(HLM_SETTEXTCOLOR, (WPARAM)bNeg, crNew);
	}	  	
	
_WRAP_INLINE void _WRAPNAME(HList)::SelectRange(int iAction, int iStart, int iEnd) 
	{
	_WRAP_SM(HLM_SELECTRANGE, iAction, MAKELONG(iStart, iEnd));
	}
	
	
_WRAP_INLINE BOOL _WRAPNAME(HList)::SetColumnWidth(int iWidth) 
	{
	return (BOOL)_WRAP_SM(HLM_SETCOLUMNWIDTH, iWidth, 0L);
	}
	
_WRAP_INLINE int _WRAPNAME(HList)::SetCurSel(int iIndex) 
	{
	return (int)_WRAP_SM(HLM_SETCURSEL, iIndex, 0L);
	}
	 
	 
#ifdef _OWLWRAP	    

	
_WRAP_INLINE HBRUSH _WRAPNAME(HList)::GetBkgndBrush(void) 
	{
	return (HBRUSH)_WRAP_SM(HLM_GETBKGNDBRUSH, 0, 0L);
	}
	
_WRAP_INLINE HFONT _WRAPNAME(HList)::GetFont(void) 
	{
	return (HFONT)_WRAP_SM(HLM_GETFONT, 0, 0L);
	}
	
_WRAP_INLINE HBRUSH _WRAPNAME(HList)::GetHiliteBrush(void) 
	{
	return (HBRUSH)_WRAP_SM(HLM_GETHILITEBRUSH, 0, 0L);
	}
	
_WRAP_INLINE HBRUSH _WRAPNAME(HList)::SetBkgndBrush(HBRUSH hBknd, BOOL bRedraw) 
	{
	return (HBRUSH)_WRAP_SM(HLM_SETBKGNDBRUSH, (WORD)hBknd, bRedraw);
	} 
	
_WRAP_INLINE HBRUSH _WRAPNAME(HList)::SetHiliteBrush(HBRUSH hBrush, BOOL bRedraw) 
	{
	return (HBRUSH)_WRAP_SM(HLM_SETHILITEBRUSH, (WORD)hBrush, (LONG)bRedraw);
	}
	
_WRAP_INLINE HFONT _WRAPNAME(HList)::SetFont(HFONT hFont, BOOL bRedraw) 
	{
	return (HFONT)_WRAP_SM(HLM_SETFONT, (WORD)hFont, bRedraw);
	}   
	      
	
#elif _AFX  


_WRAP_INLINE CBrush *_WRAPNAME(HList)::GetBkgndBrush(void) 
	{
	return CBrush::FromHandle((HBRUSH)_WRAP_SM(HLM_GETBKGNDBRUSH, 0, 0L));
	}
	
_WRAP_INLINE CFont *_WRAPNAME(HList)::GetFont(void) 
	{
	return CFont::FromHandle((HFONT)_WRAP_SM(HLM_GETFONT, 0, 0L));
	}
	
_WRAP_INLINE CBrush *_WRAPNAME(HList)::GetHiliteBrush(void) 
	{
	return CBrush::FromHandle((HBRUSH)_WRAP_SM(HLM_GETHILITEBRUSH, 0, 0L));
	}
	
_WRAP_INLINE CBrush *_WRAPNAME(HList)::SetBkgndBrush(CBrush *pBknd, BOOL bRedraw) 
	{
	return CBrush::FromHandle((HBRUSH)_WRAP_SM(HLM_SETBKGNDBRUSH, (WPARAM)pBknd->GetSafeHandle(), bRedraw));
	} 
	
_WRAP_INLINE CBrush *_WRAPNAME(HList)::SetHiliteBrush(CBrush *pBrush, BOOL bRedraw) 
	{
	return CBrush::FromHandle((HBRUSH)_WRAP_SM(HLM_SETHILITEBRUSH, (WPARAM)pBrush->GetSafeHandle(), (LONG)bRedraw));
	}
	
_WRAP_INLINE CFont *_WRAPNAME(HList)::SetFont(CFont *pFont, BOOL bRedraw) 
	{
	return CFont::FromHandle((HFONT)_WRAP_SM(HLM_SETFONT, (WPARAM)pFont->GetSafeHandle(), bRedraw));
	}         


#endif	
	
_WRAP_INLINE int _WRAPNAME(HList)::SetFormat(LPSTR lpszFormat, BOOL bRedraw) 
	{
	return (int)_WRAP_SM(HLM_SETFORMAT, bRedraw, (LONG)lpszFormat);
	}
	
_WRAP_INLINE void _WRAPNAME(HList)::SetScrollPos(int iPos) 
	{
	_WRAP_SM(HLM_SETSCROLLPOS, iPos, 0L);
	}
	
_WRAP_INLINE BOOL _WRAPNAME(HList)::SetSel(int iAction, int iIndex) 
	{
	return (BOOL)_WRAP_SM(HLM_SETSEL, iAction, iIndex);
	}
	
_WRAP_INLINE LONG _WRAPNAME(HList)::SetState(WORD wFlag, BOOL bSetting) 
	{
	return (LONG)_WRAP_SM(HLM_SETSTATE, wFlag, bSetting);
	}
	
_WRAP_INLINE BOOL _WRAPNAME(HList)::SetTabStops(int iNum, LPINT lpStops) 
	{
	return (BOOL)_WRAP_SM(HLM_SETTABSTOPS, iNum, (LONG)lpStops);
	}

_WRAP_INLINE int _WRAPNAME(HList)::FindString(int iStart, LPSTR lpString) 
	{
	return (int)_WRAP_SM(HLM_FINDSTRING, iStart, (LONG)(LPSTR)lpString);
	}
	
_WRAP_INLINE int _WRAPNAME(HList)::SelectString(int iStart, LPSTR lpString) 
	{
	return (int)_WRAP_SM(HLM_SELECTSTRING, iStart, (LONG)(LPSTR)lpString);
	}
	
_WRAP_INLINE int _WRAPNAME(HList)::GetTopIndex(void) 
	{
	return (int)_WRAP_SM(HLM_GETTOPINDEX, 0, 0L);
	}
	
_WRAP_INLINE int _WRAPNAME(HList)::SetTopIndex(int iTop) 
	{
	return (int)_WRAP_SM(HLM_SETTOPINDEX, iTop, 0L);
	}
	
_WRAP_INLINE int _WRAPNAME(HList)::Scroll(int iAmount) 
	{
	return (int)_WRAP_SM(HLM_SCROLL, iAmount, 0L);
	}             
	
_WRAP_INLINE BOOL _WRAPNAME(HList)::SetRedraw(BOOL bRedraw, BOOL bRedrawNow) 
	{
	return (BOOL)_WRAP_SM(HLM_SETREDRAW, bRedraw, bRedrawNow);
	}
	
_WRAP_INLINE BOOL _WRAPNAME(HList)::HasChanged(void) 
	{
	return (BOOL)_WRAP_SM(HLM_HASCHANGED, 0, 0L);
	}
	
_WRAP_INLINE BOOL _WRAPNAME(HList)::SetChanged(BOOL bChanged) 
	{
	return (BOOL)_WRAP_SM(HLM_SETCHANGED, bChanged, 0L);
	}
	
_WRAP_INLINE void _WRAPNAME(HList)::BeQuiet(BOOL bQuiet) 
	{
	_WRAP_SM(HLM_BEQUIET, bQuiet, 0L);
	}
	
_WRAP_INLINE BOOL _WRAPNAME(HList)::IsQuiet(void) 
	{
	return (BOOL)_WRAP_SM(HLM_ISQUIET, 0, 0L);
	}
	
_WRAP_INLINE BOOL _WRAPNAME(HList)::Update(void) 
	{
	return (BOOL)_WRAP_SM(HLM_UPDATE, 0, 0L);
	}
	
 
