/***************************************************************************\
          (c) 1993, Simple Software, Inc., All rights reserved

	THGMSG.CPP

_WRAPNAME(HGrid) Message/Method interface code

\***************************************************************************/
									 
//HGrid Method Wrappers for HGrid object
_WRAP_INLINE HFLD _WRAPNAME(HGrid)::FieldCreate(LPSTR lpName, WORD wState, int iWidth, int iHeight, char cDataClass, 
									 char cDataType, char cCodeClass, char cCodeType,int iSize, char cCtlType,
									 DWORD lCtlStyle, LPCSTR lpFormat) 
	{
	return HGFieldCreate(lpName, wState, iWidth, iHeight, cDataClass, cDataType,
	                     cCodeClass, cCodeType, iSize, cCtlType, lCtlStyle, lpFormat);

	}


_WRAP_INLINE BOOL _WRAPNAME(HGrid)::GetCellData(int iField, int iRec, LPVOID lpData) 
	{
	return HGGetCellData(HWindow, iField, iRec, lpData);
	}
	
_WRAP_INLINE WORD _WRAPNAME(HGrid)::GetCellText(int iField, int iRec, LPSTR lpText, WORD wMax) 
	{
	return HGGetCellText(HWindow, iField, iRec, lpText, wMax);
	}

_WRAP_INLINE BOOL _WRAPNAME(HGrid)::SetCellData(int iField, int iRec, LPVOID lpData) 
	{
	return HGSetCellData(HWindow, iField, iRec, lpData);
	}

_WRAP_INLINE BOOL _WRAPNAME(HGrid)::SetCellString(int iField, int iRec, LPSTR lpData) 
	{
	return HGSetCellString(HWindow, iField, iRec, lpData);
	}

_WRAP_INLINE BOOL _WRAPNAME(HGrid)::SetCurSel(int iField, int iRec)  
	{                                                                                     
	return (BOOL)_WRAP_SM(HGM_SETSELEXTENT, 0, MAKELONG(iField, iRec));
	}

_WRAP_INLINE BOOL _WRAPNAME(HGrid)::InvalidateRange(int iFld1, int iRec1, int iFld2, int iRec2) 
	{
	return HGridInvalidateRange(HWindow, iFld1, iRec1, iFld2, iRec2);
	}

_WRAP_INLINE BOOL _WRAPNAME(HGrid)::InvalidateCell (int iFld, int iRec) 
	{
	return HGridInvalidateCell (HWindow, iFld, iRec);
	}

_WRAP_INLINE LPSTR _WRAPNAME(HGrid)::OffsetPtr (int iFld, LPVOID lpRec) 
	{
	return HGOffsetPtr (HWindow, iFld, lpRec);
	}

//HGrid Message Wrappers for HGrid object
_WRAP_INLINE LONG _WRAPNAME(HGrid)::GetBaseRec(void) 
	{
	return _WRAP_SM(HGM_GETBASEREC, 0, 0L);
	}
	
_WRAP_INLINE BOOL _WRAPNAME(HGrid)::IsQuiet(void) 
	{
	return (BOOL)_WRAP_SM(HGM_ISQUIET, 0, 0L);
	}	 
	
_WRAP_INLINE void _WRAPNAME(HGrid)::BeQuiet(BOOL bValue) 
	{
	_WRAP_SM(HGM_BEQUIET, (WPARAM)bValue, 0L);
	}	
	
_WRAP_INLINE void _WRAPNAME(HGrid)::SetBaseRec(LONG lBaseRec) 
	{
	_WRAP_SM(HGM_SETBASEREC, 0, lBaseRec);
	}
	
_WRAP_INLINE int _WRAPNAME(HGrid)::GetBtnHeight(void) 
	{
	return (WORD)_WRAP_SM(HGM_GETBTNHEIGHT, 0, 0L);
	}
	
_WRAP_INLINE void _WRAPNAME(HGrid)::SetBtnHeight(int iHeight, BOOL bRedraw) 
	{
	_WRAP_SM(HGM_SETBTNHEIGHT, iHeight, bRedraw);
	}
	
_WRAP_INLINE int _WRAPNAME(HGrid)::GetBtnWidth(void) 
	{
	return (int)_WRAP_SM(HGM_GETBTNWIDTH, 0, 0L);
	}
	
_WRAP_INLINE void _WRAPNAME(HGrid)::SetBtnWidth(int iWidth, BOOL bRedraw) 
	{
	_WRAP_SM(HGM_SETBTNWIDTH, iWidth, bRedraw);
	}

_WRAP_INLINE LONG _WRAPNAME(HGrid)::GetFirstRec(void) 
	{
	return (LONG)_WRAP_SM(HGM_GETFIRSTREC, 0, 0L);
	}

_WRAP_INLINE LONG _WRAPNAME(HGrid)::SetFirstRec(LONG lRecIndex) 
	{
	return (LONG)_WRAP_SM(HGM_SETFIRSTREC, 0, lRecIndex); 
	}

	
_WRAP_INLINE WORD _WRAPNAME(HGrid)::GetFirstCol(void) 
	{
	return (WORD)_WRAP_SM(HGM_GETFIRSTCOL, 0, 0L);
	}
	
_WRAP_INLINE void _WRAPNAME(HGrid)::SetFirstCol(int iColIndex) 
	{
	_WRAP_SM(HGM_SETFIRSTCOL, iColIndex, 0L);
	}

_WRAP_INLINE int _WRAPNAME(HGrid)::GetRowCount() 
	{
	return (int)_WRAP_SM(HGM_GETROWCOUNT, 0, 0L);
	}
	
_WRAP_INLINE int _WRAPNAME(HGrid)::GetColCount(void) 
	{
	return (int)_WRAP_SM(HGM_GETCOLCOUNT, 0, 0L);
	}  
	
#ifdef _OWLWRAP	
	
_WRAP_INLINE HFONT _WRAPNAME(HGrid)::GetFont(void) 
	{
	return (HFONT)_WRAP_SM(HGM_GETFONT, 0, 0L);
	}
	
_WRAP_INLINE HFONT _WRAPNAME(HGrid)::SetFont(HFONT hFont, BOOL bRedraw) 
	{
	return (HFONT)_WRAP_SM(HGM_SETFONT, (WORD)hFont, bRedraw);
	}  
	
_WRAP_INLINE HBRUSH _WRAPNAME(HGrid)::GetBkgndBrush(void)
	{
	return (HBRUSH)_WRAP_SM(HGM_GETBKGNDBRUSH, 0, 0L);
	}
	
_WRAP_INLINE HBRUSH _WRAPNAME(HGrid)::SetBkgndBrush(HBRUSH hFont, BOOL bRedraw)
	{
	return (HBRUSH)_WRAP_SM(HGM_SETBKGNDBRUSH, (WORD)hFont, bRedraw);
	}  

#elif _AFX 

_WRAP_INLINE CFont * _WRAPNAME(HGrid)::GetFont(void) 
	{
	return CFont::FromHandle ((HFONT)_WRAP_SM(HGM_GETFONT, 0, 0L));
	}
	
_WRAP_INLINE CFont *_WRAPNAME(HGrid)::SetFont(CFont *pFont, BOOL bRedraw) 
	{
	return CFont::FromHandle ((HFONT)_WRAP_SM(HGM_SETFONT, (WPARAM)pFont->GetSafeHandle(), bRedraw));
	}  
	
_WRAP_INLINE CBrush *_WRAPNAME(HGrid)::GetBkgndBrush(void) 
	{
	return CBrush::FromHandle((HBRUSH)_WRAP_SM(HGM_GETBKGNDBRUSH, 0, 0L));
	}
	
_WRAP_INLINE CBrush *_WRAPNAME(HGrid)::SetBkgndBrush(CBrush *pBrush, BOOL bRedraw) 
	{
	return CBrush::FromHandle((HBRUSH)_WRAP_SM(HGM_SETBKGNDBRUSH, (WPARAM)pBrush->GetSafeHandle(), bRedraw));
	}  
	
#endif

	
_WRAP_INLINE int _WRAPNAME(HGrid)::GetFrozenCols(void) 
	{
	return (int)_WRAP_SM(HGM_GETFROZENCOLS, 0, 0L);
	}
	
_WRAP_INLINE void _WRAPNAME(HGrid)::SetFrozenCols(int iFrznCols) 
	{
	_WRAP_SM(HGM_SETFROZENCOLS, iFrznCols, 0L);
	}
	
_WRAP_INLINE int _WRAPNAME(HGrid)::GetRowHeight(void) 
	{
	return (int)_WRAP_SM(HGM_GETROWHEIGHT, 0, 0L);
	}
	
_WRAP_INLINE void _WRAPNAME(HGrid)::SetRowHeight(int iHeight, BOOL bRedraw) 
	{
	_WRAP_SM(HGM_SETROWHEIGHT, iHeight, bRedraw);
	}
	
_WRAP_INLINE LONG _WRAPNAME(HGrid)::GetSelAnchor(LPCELL lpCell) 
	{
	return (LONG)_WRAP_SM(HGM_GETSELANCHOR, 0, DLP(lpCell));
	}
	
_WRAP_INLINE void _WRAPNAME(HGrid)::SetSelAnchor(int iCol, int iRow) 
	{
	_WRAP_SM(HGM_SETSELANCHOR, 0, MAKELONG(iCol, iRow));
	}
	
_WRAP_INLINE LONG _WRAPNAME(HGrid)::GetSelExtent(LPCELL lpCell) 
	{
	return (LONG)_WRAP_SM(HGM_GETSELEXTENT, 0, DLP(lpCell));
	}
	
_WRAP_INLINE void _WRAPNAME(HGrid)::SetSelExtent(BOOL bExtend, int iCol, int iRow) 
	{
	_WRAP_SM(HGM_SETSELEXTENT, (WPARAM)bExtend, MAKELONG(iCol, iRow));
	}
	
_WRAP_INLINE LONG _WRAPNAME(HGrid)::GetState(void) 
	{
	return (LONG)_WRAP_SM(HGM_GETSTATE, 0, 0L);
	}
	
_WRAP_INLINE void _WRAPNAME(HGrid)::SetState(BOOL bValue, WORD wFlag) 
	{
	_WRAP_SM(HGM_SETSTATE, bValue, wFlag);
	}   
	
_WRAP_INLINE LONG _WRAPNAME(HGrid)::GetStyle(void) 
	{
	return (LONG)_WRAP_SM(HGM_GETSTYLE, 0, 0L);
	}
	
_WRAP_INLINE void _WRAPNAME(HGrid)::SetStyle(BOOL bValue, LONG lFlag) 
	{
	_WRAP_SM(HGM_SETSTYLE, bValue, lFlag);
	}     
	  
	
_WRAP_INLINE LONG _WRAPNAME(HGrid)::GetMarker(void) 
	{
	return (LONG)_WRAP_SM(HGM_GETMARKER, 0, 0L);
	}
	
_WRAP_INLINE void _WRAPNAME(HGrid)::SetMarker(int iColIndex, int iRowIndex) 
	{
	_WRAP_SM(HGM_SETMARKER, 0, MAKELONG(iColIndex, iRowIndex));
	}	
	
_WRAP_INLINE void _WRAPNAME(HGrid)::GetTitle(int iCount, LPSTR lpsTitle) 
	{
	_WRAP_SM(HGM_GETTITLE, iCount, DLP(lpsTitle));
	}
	
_WRAP_INLINE void _WRAPNAME(HGrid)::SetTitle(int iCount, LPSTR lpsTitle) 
	{
	_WRAP_SM(HGM_SETTITLE, iCount, DLP(lpsTitle));
	}         
	 
_WRAP_INLINE void _WRAPNAME(HGrid)::GetColMap(int FAR *lpMap) 
	{
	_WRAP_SM(HGM_GETCOLMAP, 0, DLP(lpMap));
	}	 
	
_WRAP_INLINE void _WRAPNAME(HGrid)::SetColMap(int FAR *lpMap) 
	{
	_WRAP_SM(HGM_SETCOLMAP, 0, DLP(lpMap));
	}	 	
	
_WRAP_INLINE int _WRAPNAME(HGrid)::GetOffset(int iFldIndex) 
	{
	return (int)_WRAP_SM(HGFM_GETOFFSET, (WPARAM) iFldIndex, 0L);
	}	 		
     
     
_WRAP_INLINE void _WRAPNAME(HGrid)::Update(BOOL bErase) 
	{
	_WRAP_SM(HGM_UPDATE, bErase, 0L);
	}        
	
_WRAP_INLINE int _WRAPNAME(HGrid)::GetHScrollPos(void)
{
	return (int)_WRAP_SM(HGM_GETHSCROLLPOS, 0, 0L);
}

_WRAP_INLINE int _WRAPNAME(HGrid)::GetVScrollPos(void)
{
	return (int)_WRAP_SM(HGM_GETVSCROLLPOS, 0, 0L);
}          

_WRAP_INLINE int _WRAPNAME(HGrid)::SetHScrollPos(int iPos)
{
	return (int)_WRAP_SM(HGM_SETHSCROLLPOS, iPos, 0L);
}    

_WRAP_INLINE int _WRAPNAME(HGrid)::SetVScrollPos(int iPos)
{
	return (int)_WRAP_SM(HGM_SETVSCROLLPOS, iPos, 0L);  
}  

_WRAP_INLINE int _WRAPNAME(HGrid)::GetHScrollRange(void)
{
	return (int)_WRAP_SM(HGM_GETHSCROLLRANGE, 0, 0L);
}    

_WRAP_INLINE int _WRAPNAME(HGrid)::GetVScrollRange(void)
{
	return (int)_WRAP_SM(HGM_GETVSCROLLRANGE, 0, 0L);
}
  

	
//Record Buffering
_WRAP_INLINE BUFFERPROC _WRAPNAME(HGrid)::GetBufferProc(void) 
	{
	return (BUFFERPROC)_WRAP_SM(HGM_GETBUFFERPROC, 0, 0L);
	}

_WRAP_INLINE BUFFERPROC _WRAPNAME(HGrid)::SetBufferProc(BUFFERPROC lpfnBufProc) 
	{
	return (BUFFERPROC)_WRAP_SM(HGM_SETBUFFERPROC, 0, DLP(lpfnBufProc));
	}

_WRAP_INLINE int _WRAPNAME(HGrid)::GetBufferSize(void) 
	{
	return (int)_WRAP_SM(HGM_GETBUFFERSIZE, 0, 0L);
	}

_WRAP_INLINE int _WRAPNAME(HGrid)::SetBufferSize(int iSize) 
	{
	return (int)_WRAP_SM(HGM_SETBUFFERSIZE, 0, iSize);
	}

_WRAP_INLINE LONG _WRAPNAME(HGrid)::GetMaxRec(void) 
	{
	return _WRAP_SM(HGM_GETMAXREC, 0, 0L);
	}

_WRAP_INLINE LONG _WRAPNAME(HGrid)::SetMaxRec(LONG lMax) 
	{
	return _WRAP_SM(HGM_SETMAXREC, 0, lMax);
	}


	
//Field Management
_WRAP_INLINE void _WRAPNAME(HGrid)::AddFld(HFLD& Fld) 
	{
		_WRAP_SM(HGM_ADDFLD, 0, DLP(Fld));
    return;
	}
	
_WRAP_INLINE void _WRAPNAME(HGrid)::DeleteFld(int iFldIndex) 
	{
	 _WRAP_SM(HGM_DELETEFLD, iFldIndex, 0L);
   return;
	}
	
_WRAP_INLINE int _WRAPNAME(HGrid)::FindFld(LPSTR lpszFldName) 
	{
	return (int)_WRAP_SM(HGM_FINDFLD, 0, DLP(lpszFldName));
	}
	
_WRAP_INLINE void _WRAPNAME(HGrid)::InsertFld(int iBeforeFld, HFLD& Fld) 
	{
	_WRAP_SM(HGM_INSERTFLD, iBeforeFld, DLP(Fld));
  return;
	}
	
_WRAP_INLINE void _WRAPNAME(HGrid)::MoveCol(int iOldIndex, int iNewIndex) 
	{
	_WRAP_SM(HGM_MOVECOL, iOldIndex, iNewIndex);
	return;
	}
	

//Record Management
_WRAP_INLINE int _WRAPNAME(HGrid)::AddRec(LPVOID lpRecStruct) 
	{
	return (int)_WRAP_SM(HGM_ADDREC, 0, DLP(lpRecStruct)); 
	}
	
_WRAP_INLINE BOOL _WRAPNAME(HGrid)::DeleteRec(int iRecIndex) 
	{
	return (BOOL)_WRAP_SM(HGM_DELETEREC, iRecIndex, 0L);
	}
	
_WRAP_INLINE BOOL _WRAPNAME(HGrid)::GetCurRec(LPVOID lpRecStruct) 
	{
	return (BOOL)_WRAP_SM(HGM_GETCURREC, 0, DLP(lpRecStruct));
	}
	
_WRAP_INLINE LPVOID _WRAPNAME(HGrid)::GetRecLink(void) 
	{
	return (LPVOID)_WRAP_SM(HGRM_GETLINK, 0, 0L);
	}
	
_WRAP_INLINE int _WRAPNAME(HGrid)::InsertRec(int iRecIndex, LPVOID lpRecStruct) 
	{
		return (int)_WRAP_SM(HGM_INSERTREC, iRecIndex, DLP(lpRecStruct));
	}
	
_WRAP_INLINE int _WRAPNAME(HGrid)::MoveRow(int iOldIndex, int iNewIndex) 
	{
	return (int)_WRAP_SM(HGM_MOVEROW, iOldIndex, iNewIndex);    
	}
	
_WRAP_INLINE void _WRAPNAME(HGrid)::ResetContent(BOOL bRedraw) 
	{
	_WRAP_SM(HGM_RESETCONTENT, bRedraw, 0L);              
	return;
	}
	
_WRAP_INLINE void _WRAPNAME(HGrid)::SetRecLink(LPVOID lpRecStruct) 
	{
	_WRAP_SM(HGRM_SETLINK, 0, DLP(lpRecStruct));
	return;
	}
	
_WRAP_INLINE int _WRAPNAME(HGrid)::GetRecSize(void) 
	{
	return (int)_WRAP_SM(HGRM_GETSIZE, 0, 0L);
	}
	
//Field Messages                
#ifdef _OWLWRAP  

_WRAP_INLINE HWND _WRAPNAME(HGrid)::GetHCtl(int iFldIndex) 
	{
	return (HWND)_WRAP_SM(HGFM_GETHCTL, iFldIndex, 0L);
	} 
	
#else    

_WRAP_INLINE CWnd *_WRAPNAME(HGrid)::GetHCtl(int iFldIndex) 
	{   
	HWND hCtl=NULL;
	           
	if (hCtl = (HWND)_WRAP_SM(HGFM_GETHCTL, iFldIndex, 0L))
		{
		switch(GetCtlType(iFldIndex))  
			{ 
			case HGCTL_COMBO:
			case HGCTL_DROP:	
				return hCtl ? (CWnd *)CHComb::FromHandle(hCtl) : (CWnd *)NULL;
				
			case HGCTL_EDIT:
				return hCtl ? (CWnd *)CHEdit_SS::FromHandle(hCtl) : (CWnd *)NULL;
				
			case HGCTL_LIST:
				return hCtl ? (CWnd *)CHList::FromHandle(hCtl) : (CWnd *)NULL;
				
			case HGCTL_CHECK:	
				return hCtl ? (CWnd *)CHBCheck::FromHandle(hCtl) : (CWnd *)NULL;
				
			default:
				return (CWnd *)NULL;
			}
		}	           
	return (CWnd *)NULL;
	}  
	
_WRAP_INLINE void _WRAPNAME(HGrid)::FreeHCtl(int iFldIndex, CWnd *pCtl)
	{
		_WRAP_SM(HGFM_FREEHCTL, iFldIndex, (LPARAM)(LPVOID)pCtl->GetSafeHwnd());
	} 
#endif
	

_WRAP_INLINE LONG _WRAPNAME(HGrid)::GetCtlStyle(int iFldIndex) 
	{
	return (LONG)_WRAP_SM(HGFM_GETCTLSTYLE, iFldIndex, 0L);
	}
	
_WRAP_INLINE WORD _WRAPNAME(HGrid)::GetCtlType(int iFldIndex) 
	{
	return (WORD)_WRAP_SM(HGFM_GETCTLTYPE, iFldIndex, 0L);
	}
	
_WRAP_INLINE char _WRAPNAME(HGrid)::GetCodeClass(int iFldIndex) 
	{
	return (char)_WRAP_SM(HGFM_GETCODECLASS, iFldIndex, 0L);
	}
	
_WRAP_INLINE char _WRAPNAME(HGrid)::GetCodeType(int iFldIndex) 
	{
	return (char)_WRAP_SM(HGFM_GETCODETYPE, iFldIndex, 0L);
	}
	
_WRAP_INLINE char _WRAPNAME(HGrid)::GetDataClass(int iFldIndex) 
	{
	return (char)_WRAP_SM(HGFM_GETDATACLASS, iFldIndex, 0L);
	}
	
_WRAP_INLINE char _WRAPNAME(HGrid)::GetDataType(int iFldIndex) 
	{
	return (char)_WRAP_SM(HGFM_GETDATATYPE, iFldIndex, 0L);
	}
	
_WRAP_INLINE int _WRAPNAME(HGrid)::GetDataSize(int iFldIndex) 
	{
	return (int)_WRAP_SM(HGFM_GETDATASIZE, iFldIndex, 0L);
	}
	
_WRAP_INLINE void _WRAPNAME(HGrid)::GetFormat(int iFldIndex, LPSTR lpszFormat) 
	{
	_WRAP_SM(HGFM_GETFORMAT, iFldIndex, DLP(lpszFormat));
	return;
	}
	
_WRAP_INLINE int _WRAPNAME(HGrid)::GetFormatLen(int iFldIndex) 
	{
	return (int)_WRAP_SM(HGFM_GETFORMATLEN, iFldIndex, 0L);
	}
	
_WRAP_INLINE void _WRAPNAME(HGrid)::SetFormat(int iFldIndex, LPSTR lpszFormat) 
	{
	_WRAP_SM(HGFM_SETFORMAT, iFldIndex, DLP(lpszFormat));
	return;
	}
	
_WRAP_INLINE int _WRAPNAME(HGrid)::GetDropHeight(int iFldIndex) 
	{
	return (int)_WRAP_SM(HGFM_GETDROPHEIGHT, iFldIndex, 0L);
	}
	
_WRAP_INLINE void _WRAPNAME(HGrid)::SetDropHeight(int iFldIndex, int iNewHeight) 
	{
	_WRAP_SM(HGFM_SETDROPHEIGHT, iFldIndex, (LPARAM)iNewHeight);
	return;
	}
	
_WRAP_INLINE void _WRAPNAME(HGrid)::GetName(int iFldIndex, LPSTR lpszName) 
	{
	_WRAP_SM(HGFM_GETNAME, iFldIndex, DLP(lpszName));
	return;
	}
	
_WRAP_INLINE int _WRAPNAME(HGrid)::GetNameLen(int iFldIndex) 
	{
	return (int)_WRAP_SM(HGFM_GETNAMELEN, iFldIndex, 0L);
	}
	
_WRAP_INLINE void _WRAPNAME(HGrid)::SetName(int iFldIndex, LPSTR lpszName) 
	{
	_WRAP_SM(HGFM_SETNAME, iFldIndex, DLP(lpszName));
	return;
	}
	
_WRAP_INLINE int _WRAPNAME(HGrid)::GetColWidth(int iFldIndex) 
	{
	return (int)_WRAP_SM(HGFM_GETCOLWIDTH, iFldIndex, 0L);
	}
	
_WRAP_INLINE void _WRAPNAME(HGrid)::SetColWidth(int iColIndex, int iNewWidth) 
	{
	_WRAP_SM(HGFM_SETCOLWIDTH, iColIndex, (LPARAM)iNewWidth);     
	return;
	}
	
_WRAP_INLINE WORD _WRAPNAME(HGrid)::GetFieldState(int iFldIndex) 
	{
	return (WORD)_WRAP_SM(HGFM_GETSTATE, iFldIndex, 0L);
	}
	
_WRAP_INLINE WORD _WRAPNAME(HGrid)::SetFieldState(int iFldIndex, WORD wFlag, BOOL bValue) 
	{
	return (WORD)_WRAP_SM(HGFM_SETSTATE, iFldIndex, MAKELONG(bValue, wFlag));
	}
	

//Record Messages
_WRAP_INLINE BOOL _WRAPNAME(HGrid)::GetData(int iRecIndex, LPVOID lpRecStruct) 
	{
	return (BOOL)_WRAP_SM(HGRM_GETDATA, iRecIndex, DLP(lpRecStruct));
	}
	
_WRAP_INLINE BOOL _WRAPNAME(HGrid)::SetData(int iRecIndex, LPVOID lpRecStruct) 
	{
	return (BOOL)_WRAP_SM(HGRM_SETDATA, iRecIndex, DLP(lpRecStruct));
	}
	
_WRAP_INLINE WORD _WRAPNAME(HGrid)::GetRecState(int iRecIndex) 
	{
	return (WORD)_WRAP_SM(HGRM_GETSTATE, iRecIndex, 0L);
	}
	
_WRAP_INLINE void _WRAPNAME(HGrid)::SetRecState(int iRecIndex, WORD wFlag, BOOL bValue) 
	{
	_WRAP_SM(HGRM_SETSTATE, iRecIndex, MAKELONG(wFlag, bValue));
	return;
	}

// Whole Rows
_WRAP_INLINE int _WRAPNAME(HGrid)::GetSelCount(void)
	{
	return (int)_WRAP_SM(HGM_GETSELCOUNT, 0, 0L);
	}

_WRAP_INLINE int _WRAPNAME(HGrid)::GetSelRows(int iBufSize, int FAR *lpBuffer)
	{
	return (int)_WRAP_SM(HGM_GETSELROWS, iBufSize, DLP(lpBuffer));
	}

_WRAP_INLINE BOOL _WRAPNAME(HGrid)::IsSelected(int iRow)
	{
	return (BOOL)_WRAP_SM(HGRM_ISSELECTED, iRow, 0L);
	}

_WRAP_INLINE BOOL _WRAPNAME(HGrid)::SelectRow(int iRow)
	{
	return (BOOL)_WRAP_SM(HGM_SELECTROW, iRow, 0L);
	}

//Index Conversions    
_WRAP_INLINE int _WRAPNAME(HGrid)::ColToFld(int iCol) 
	{
	return (int)_WRAP_SM(HGM_GETFLD, iCol, 0L);
	}
	

_WRAP_INLINE int _WRAPNAME(HGrid)::FldToCol(int iFld) 
	{
	return (int)_WRAP_SM(HGM_GETCOL, iFld, 0L);
	}
	
_WRAP_INLINE int _WRAPNAME(HGrid)::RecToRow(LONG lRec) 
	{
	return (int)_WRAP_SM(HGM_GETROW, 0, lRec);
	} 
	
_WRAP_INLINE LONG _WRAPNAME(HGrid)::RowToRec(int iRow) 
	{
	return (LONG)iRow + (LONG)_WRAP_SM(HGM_GETBASEREC, 0, 0L);
	}	
	
