/***************************************************************************\
          (c) 1993, Simple Software, Inc., All rights reserved

	THEMSG.CPP

_WRAPNAME(HEdit_SS) Message/Method interface code

\***************************************************************************/


/*
Message Interface
*/

_WRAP_INLINE BOOL  _WRAPNAME(HEdit_SS)::HasChanged(void) 
  {
	return (BOOL)_WRAP_SM(HEM_HASCHANGED, 0, 0L);
  }

_WRAP_INLINE LONG  _WRAPNAME(HEdit_SS)::GetData(LPVOID lpData, int iMaxBytes)
  {
	return (LONG)_WRAP_SM(HEM_GETDATA, iMaxBytes, (LPARAM)lpData);
  }

_WRAP_INLINE char  _WRAPNAME(HEdit_SS)::GetDataClass(void) 
  {
	return (char)_WRAP_SM(HEM_GETDATACLASS, 0, 0L);
  }

_WRAP_INLINE LONG  _WRAPNAME(HEdit_SS)::GetDataSize(void) 
	{
	if (HT_STRING == GetDataType())
#ifdef _OWLWRAP	
		return TextLen;// + 1;  
#else
		return GetMaxTextLen();// + 1; 
#endif		
  else
		return (LONG)_WRAP_SM(HEM_GETDATASIZE, 0, 0L);
  }

_WRAP_INLINE char  _WRAPNAME(HEdit_SS)::GetDataType(void) 
  {
	return (char)_WRAP_SM(HEM_GETDATATYPE, 0, 0L);
  }

_WRAP_INLINE LONG  _WRAPNAME(HEdit_SS)::GetFormat(LPSTR lpszFormat, int iMaxBytes) 
  {
	return (LONG)_WRAP_SM(HEM_GETFORMAT, iMaxBytes, (LPARAM)lpszFormat);
  }

_WRAP_INLINE void  _WRAPNAME(HEdit_SS)::GetFormatRect(LPRECT lpFormatRect) 
  {
	_WRAP_SM(HEM_GETFORMATRECT, 0, (LPARAM)lpFormatRect);
  }

_WRAP_INLINE LONG  _WRAPNAME(HEdit_SS)::GetScrollPos(void) 
  {
	return (LONG)_WRAP_SM(HEM_GETSCROLLPOS, 0, 0L);
  }

_WRAP_INLINE LONG  _WRAPNAME(HEdit_SS)::GetSel(void) 
  {
	return (LONG)_WRAP_SM(HEM_GETSEL, 0, 0L);
  }  
  
_WRAP_INLINE void  _WRAPNAME(HEdit_SS)::GetSelText(LPSTR lpSelText, int iMaxBytes) 
  {
	_WRAP_SM(HEM_GETSELTEXT, iMaxBytes, (LPARAM)lpSelText);
  }  
  
_WRAP_INLINE void  _WRAPNAME(HEdit_SS)::ReplaceSel(LPSTR lpStr) 
  {
	_WRAP_SM(HEM_REPLACESEL, 0, (LPARAM)lpStr);
  }  

_WRAP_INLINE LONG  _WRAPNAME(HEdit_SS)::GetState(void) 
  {
	return (LONG)_WRAP_SM(HEM_GETSTATE, 0, 0L);
  }

_WRAP_INLINE LONG  _WRAPNAME(HEdit_SS)::GetText(LPSTR lpBuf, int iMaxBytes) 
  {
	return (LONG)_WRAP_SM(HEM_GETTEXT, iMaxBytes, (LPARAM)lpBuf);
  }
  
_WRAP_INLINE BOOL  _WRAPNAME(HEdit_SS)::SetText(LPSTR lpBuf) 
  {
	return (BOOL)_WRAP_SM(HEM_SETTEXT, 0, (LPARAM)lpBuf);
  }  

_WRAP_INLINE LONG  _WRAPNAME(HEdit_SS)::GetTextLen(void) 
  {
	return (LONG)_WRAP_SM(HEM_GETTEXTLEN, 0, 0L);
  }

_WRAP_INLINE VALIDATEPROC  _WRAPNAME(HEdit_SS)::GetValidate(void) 
  {
	return (VALIDATEPROC)_WRAP_SM(HEM_GETVALIDATE, 0, 0L);
  }

_WRAP_INLINE void  _WRAPNAME(HEdit_SS)::SetChanged(BOOL bChanged) 
  {
	_WRAP_SM(HEM_SETCHANGED, (WPARAM)bChanged, 0L);
  }

_WRAP_INLINE LONG  _WRAPNAME(HEdit_SS)::SetData(LPVOID lpBuf) 
  {
	return (LONG)_WRAP_SM(HEM_SETDATA, 0, (LPARAM)lpBuf);
  }

_WRAP_INLINE LONG  _WRAPNAME(HEdit_SS)::SetDataLink(LPVOID lpBuf, BOOL bSetData) 
  {
	return (LONG)_WRAP_SM(HEM_SETDATALINK, bSetData, (LPARAM)lpBuf);
  }

_WRAP_INLINE LONG  _WRAPNAME(HEdit_SS)::SetFormat(LPSTR lpString, BOOL bRedraw) 
  {
	return (LONG)_WRAP_SM(HEM_SETFORMAT, (WPARAM)bRedraw, (LPARAM)lpString);
  }  
  
_WRAP_INLINE void  _WRAPNAME(HEdit_SS)::SetFormatRect(BOOL bRedraw, LPRECT lpFormatRect) 
  {
	_WRAP_SM(HEM_SETFORMATRECT, (WPARAM)bRedraw, (LPARAM)lpFormatRect);
  }

#ifdef _OWLWRAP  

_WRAP_INLINE HBRUSH  _WRAPNAME(HEdit_SS)::GetBkgndBrush(void) 
  {
	return (HBRUSH)_WRAP_SM(HEM_GETBKGNDBRUSH, 0, 0L);
  }

_WRAP_INLINE HBRUSH  _WRAPNAME(HEdit_SS)::GetHiliteBrush(void) 
  {
	return (HBRUSH)_WRAP_SM(HEM_GETHILITEBRUSH, 0, 0L);
  }

_WRAP_INLINE HFONT _WRAPNAME(HEdit_SS)::GetFont(void) 
	{  
	return (HFONT) _WRAP_SM(HEM_GETFONT, 0, 0L); 
	}	       
	
_WRAP_INLINE HBRUSH  _WRAPNAME(HEdit_SS)::SetBkgndBrush(HBRUSH hBkgnd) 
  {
	return (HBRUSH)_WRAP_SM(HEM_SETBKGNDBRUSH, (WPARAM)hBkgnd, 0L);
  }

_WRAP_INLINE HBRUSH  _WRAPNAME(HEdit_SS)::SetHiliteBrush(HBRUSH hbHilite) 
  {
	return (HBRUSH)_WRAP_SM(HEM_SETHILITEBRUSH, (WPARAM)hbHilite, 0L);
  }
  
_WRAP_INLINE HFONT  _WRAPNAME(HEdit_SS)::SetFont(HFONT hFont, BOOL bRedraw) 
  {
	return (HFONT)_WRAP_SM(HEM_SETFONT, (WPARAM)hFont, (LPARAM)bRedraw);
  }

#elif _AFX

_WRAP_INLINE CBrush *_WRAPNAME(HEdit_SS)::GetBkgndBrush(void) 
  {
	return CBrush::FromHandle((HBRUSH)_WRAP_SM(HEM_GETBKGNDBRUSH, 0, 0L));
  }

_WRAP_INLINE CBrush *_WRAPNAME(HEdit_SS)::GetHiliteBrush(void) 
  {
	return CBrush::FromHandle((HBRUSH)_WRAP_SM(HEM_GETHILITEBRUSH, 0, 0L));
  }

_WRAP_INLINE CFont *_WRAPNAME(HEdit_SS)::GetFont(void) 
	{  
	return CFont::FromHandle((HFONT) _WRAP_SM(HEM_GETFONT, 0, 0L)); 
	}	       
	
_WRAP_INLINE CBrush *_WRAPNAME(HEdit_SS)::SetBkgndBrush(CBrush *pBkgnd) 
  {
	return CBrush::FromHandle((HBRUSH)_WRAP_SM(HEM_SETBKGNDBRUSH, (WPARAM)pBkgnd->GetSafeHandle(), 0L));
  }

_WRAP_INLINE CBrush *_WRAPNAME(HEdit_SS)::SetHiliteBrush(CBrush *pHilite) 
  {
	return CBrush::FromHandle((HBRUSH)_WRAP_SM(HEM_SETHILITEBRUSH, (WPARAM)pHilite->GetSafeHandle(), 0L));
  }
  
_WRAP_INLINE CFont * _WRAPNAME(HEdit_SS)::SetFont(CFont *pFont, BOOL bRedraw) 
  {
	return CFont::FromHandle((HFONT)_WRAP_SM(HEM_SETFONT, (WPARAM)pFont->GetSafeHandle(), (LPARAM)bRedraw));
  }

#endif  

_WRAP_INLINE LONG  _WRAPNAME(HEdit_SS)::SetScrollPos(int iNumChars, BOOL bRedraw) 
  {
	return (LONG)_WRAP_SM(HEM_SETSCROLLPOS, (WPARAM)iNumChars, (LPARAM)bRedraw);
  }

_WRAP_INLINE void  _WRAPNAME(HEdit_SS)::SetSel(int iAnchor, int iExtent) 
  {
	_WRAP_SM(HEM_SETSEL, 0, MAKELONG((WPARAM)iAnchor, (LPARAM)iExtent));
  }

_WRAP_INLINE void  _WRAPNAME(HEdit_SS)::SetMaxTextLen(int iMaxLen) 
  {
#ifdef  _OWLWRAP  
	TextLen = iMaxLen; 
#endif
	_WRAP_SM(HEM_SETMAXTEXTLEN, (WPARAM)iMaxLen, 0L);
  }

_WRAP_INLINE void  _WRAPNAME(HEdit_SS)::SetPasswordChar(char c) 
  {
	_WRAP_SM(HEM_SETPASSWORDCHAR, (WPARAM)c, 0L);
  }

_WRAP_INLINE void  _WRAPNAME(HEdit_SS)::SetOverwriteMode(BOOL bMode) 
  {
	_WRAP_SM(HEM_SETOVERWRITEMODE, (WPARAM)bMode, 0L);
  }

_WRAP_INLINE void  _WRAPNAME(HEdit_SS)::SetValidate(VALIDATEPROC lpfnValidate) 
  {
	_WRAP_SM(HEM_SETVALIDATE, 0, (LPARAM)lpfnValidate);
  }

_WRAP_INLINE void  _WRAPNAME(HEdit_SS)::Update(BOOL bParseText, BOOL bUpdateText) 
  {
	_WRAP_SM(HEM_UPDATE, bParseText, bUpdateText);
  }

_WRAP_INLINE int _WRAPNAME(HEdit_SS)::Validate(void) 
  {
	return (int)_WRAP_SM(HEM_VALIDATE, 0, 0L);
	}


_WRAP_INLINE BOOL _WRAPNAME(HEdit_SS)::GetOverwriteMode(void) 
	{  
	return (BOOL) _WRAP_SM(HEM_GETOVERWRITEMODE, 0, 0L); 
	}	  
	
_WRAP_INLINE char _WRAPNAME(HEdit_SS)::GetPasswordChar(void) 
	{  
	return (char) _WRAP_SM(HEM_GETPASSWORDCHAR, 0, 0L); 
	}
	
_WRAP_INLINE int _WRAPNAME(HEdit_SS)::GetMaxTextLen(void) 
	{  
	return (char) _WRAP_SM(HEM_GETMAXTEXTLEN, 0, 0L); 
	}
	
_WRAP_INLINE COLORREF _WRAPNAME(HEdit_SS)::GetTextColor(BOOL bNeg) 
	{  
	return (COLORREF) _WRAP_SM(HEM_GETTEXTCOLOR, (WPARAM)bNeg, 0L); 
	}
	
_WRAP_INLINE BOOL _WRAPNAME(HEdit_SS)::SetState(LONG lStateFlag, BOOL bValue) 
	{  
	return (BOOL) _WRAP_SM(HEM_SETSTATE, bValue, lStateFlag); 
	}
	
_WRAP_INLINE BOOL _WRAPNAME(HEdit_SS)::SetTextColor(COLORREF cr, BOOL bNeg) 
	{  
	return (BOOL) _WRAP_SM(HEM_SETTEXTCOLOR, (WPARAM)bNeg, (LPARAM)cr); 
	}
	
_WRAP_INLINE BOOL _WRAPNAME(HEdit_SS)::IsQuiet(void) 
	{  
	return (BOOL) _WRAP_SM(HEM_ISQUIET, 0, 0L); 
	}
	
_WRAP_INLINE BOOL _WRAPNAME(HEdit_SS)::BeQuiet(BOOL bQuiet) 
	{  
	return (BOOL) _WRAP_SM(HEM_BEQUIET, bQuiet, 0L); 
	}



/* Undoes the last change to the to the text of the associated
   edit control. */
_WRAP_INLINE void _WRAPNAME(HEdit_SS)::Undo() 
  {
  _WRAP_SM(WM_UNDO, 0, 0);
  }

/* Pastes the contents of the clipboard into the text of the associated
  edit control. */
_WRAP_INLINE void _WRAPNAME(HEdit_SS)::Paste() 
  {
  _WRAP_SM(WM_PASTE, 0, 0);
  }

/* Copies the text selected in the associated edit control to the
  clipboard. */
_WRAP_INLINE void _WRAPNAME(HEdit_SS)::Copy() 
  {
  _WRAP_SM(WM_COPY, 0, 0);
  }

/* Cuts the text selected in the associated edit control into the
  clipboard. */
_WRAP_INLINE void _WRAPNAME(HEdit_SS)::Cut() 
  {
  _WRAP_SM(WM_CUT, 0, 0);
  }

_WRAP_INLINE void _WRAPNAME(HEdit_SS)::Clear()  
  {
	_WRAP_SM(WM_CLEAR, 0, 0);
  }
