
/***************************************************************************\
          (c) 1993, Simple Software, Inc., All rights reserved

	OWLWIDG.H

WinWidgets class wrappers header file

\***************************************************************************/

#ifndef __OOWLWIDG_H
#define __OOWLWIDG_H

/*
#pragma option -Vo-
#if     defined(__BCOPT__) && !defined(_ALLOW_po)
#pragma option -po-
#endif
*/
#include <owl\owlcore.h>

//#include <control.h>
#include <widgets.h>

#define _WRAPNAME(name) T##name
#define _WRAP_INLINE
#define _WRAP_SM(msg, wParam, lParam) SendMessage(msg, wParam, lParam)

typedef class TModule *PTModule;
typedef void *Pvoid;
#define PTWindowsObject 	TWindow*
#define TF_GETDATA				tdGetData
#define TF_SETDATA				tdSetData

/* --------------------------------------------------------
	THButt object
	-------------------------------------------------------- */

_CLASSDEF(THButt)

class _OWLCLASS THButt : public TControl
{
public:
	THButt(TWindow* AParent, int AnId, LPSTR AText,
		int X, int Y, int W, int H,
		DWORD dwStyle = (WS_CHILD | WS_VISIBLE | WS_TABSTOP | HBS_PUSHBUTTON),
		PTModule AModule = NULL);
	THButt(TWindow* AParent, int ResourceId, PTModule AModule = NULL);

	int GetPAlign(void);
	HANDLE GetPic(int iIndex=0);
	HBRUSH  GetBkgndBrush(void);
	int GetCount(void);
	HFONT GetFont(void);
	COLORREF GetMaskColor (void);
	int GetRAlign(void);
	HANDLE GetSound(void);
	int GetState(void);
	int GetStateCount(void);
	int GetTAlign(void);
	int GetText(LPSTR lpBuf, int iMaxBytes=-1);
	COLORREF GetTextColor(void);
	BOOL IsPressed(void);
	void Press(BOOL bPress);
	void SetPAlign(int iAlign);
	HANDLE SetPic (HANDLE hBM, WORD wType, int iIndex=0);
	HBRUSH  SetBkgndBrush(HBRUSH hBkgnd);
	HFONT  SetFont(HFONT hFont, BOOL bRedraw=TRUE);
  void SetMaskColor (COLORREF clrMask);
	void SetRAlign(int iAlign);
	HANDLE SetSound(HANDLE hSnd);
	int	SetState(int iState, BOOL bRedraw = TRUE);
	void SetTAlign(int iAlign);
	void SetText(LPSTR lpszText);
	void SetTextColor(COLORREF clrText);
  HPALETTE GetPalette(void);

//	static PTStreamable build();
//	virtual void write (Ropstream os);
//	virtual Pvoid read (Ripstream is);

protected:

	virtual LPSTR GetClassName() { return "HBUTT"; }

//	THButt(StreamableInit) : TControl(streamableInit) {};

private:
//	virtual const Pchar streamableName() const { return "THButt"; }
};


//inline Ripstream operator >> ( Ripstream is, RTHButt cl )
//    { return is >> (RTStreamable)cl; }
//inline Ripstream operator >> ( Ripstream is, RPTHButt cl )
//    { return is >> (RPvoid)cl; }

//inline Ropstream operator << ( Ropstream os, RTHButt cl )
//    { return os << (RTStreamable)cl; }
//inline Ropstream operator << ( Ropstream os, PTHButt cl )
//		{ return os << (PTStreamable)cl; }


/* --------------------------------------------------------
	THBCheck object
	-------------------------------------------------------- */

_CLASSDEF(THBCheck)

class _OWLCLASS THBCheck : public THButt
{
public:
	THBCheck(TWindow* AParent, int AnId, LPSTR AText,
		int X, int Y, int W, int H,
		DWORD dwStyle = (WS_CHILD | WS_VISIBLE | WS_TABSTOP | HBS_CHECKBOX),
		PTModule AModule = NULL);
	THBCheck(TWindow* AParent, int ResourceId, PTModule AModule = NULL);

	int GetData(LPVOID lpData);
	int GetDataSize(void);
	int SetData(LPVOID lpBuf);
	int SetDataLink(BOOL bUseIndex, LPVOID lpBuf=NULL);

	UINT Transfer(Pvoid DataPtr, TTransferDirection direction);
//	static PTStreamable build();
//	virtual void write (Ropstream os);
//	virtual Pvoid read (Ripstream is);

protected:


//	THBCheck(StreamableInit) : THButt(streamableInit) {};

private:
//	virtual const Pchar streamableName() const { return "THBCheck"; }
};


//inline Ripstream operator >> ( Ripstream is, RTHBCheck cl )
//    { return is >> (RTStreamable)cl; }
//inline Ripstream operator >> ( Ripstream is, RPTHBCheck cl )
//		{ return is >> (RPvoid)cl; }

//inline Ropstream operator << ( Ropstream os, RTHBCheck cl )
//    { return os << (RTStreamable)cl; }
//inline Ropstream operator << ( Ropstream os, PTHBCheck cl )
//		{ return os << (PTStreamable)cl; }


/* --------------------------------------------------------
	THB3State object
	-------------------------------------------------------- */

_CLASSDEF(THB3State)

class _OWLCLASS THB3State : public THBCheck
{
public:
	THB3State(TWindow* AParent, int AnId, LPSTR AText,
		int X, int Y, int W, int H,
		DWORD dwStyle = (WS_CHILD | WS_VISIBLE | WS_TABSTOP | HBS_3STATE),
		PTModule AModule = NULL);
	THB3State(TWindow* AParent, int ResourceId, PTModule AModule = NULL);


	UINT Transfer(Pvoid DataPtr, TTransferDirection direction);
//	static PTStreamable build();
//	virtual void write (Ropstream os);
//	virtual Pvoid read (Ripstream is);

protected:


//	THB3State(StreamableInit) : THBCheck(streamableInit) {};

private:
//	virtual const Pchar streamableName() const { return "THB3State"; }
};


//inline Ripstream operator >> ( Ripstream is, RTHB3State cl )
//    { return is >> (RTStreamable)cl; }
//inline Ripstream operator >> ( Ripstream is, RPTHB3State cl )
//		{ return is >> (RPvoid)cl; }

//inline Ropstream operator << ( Ropstream os, RTHB3State cl )
//    { return os << (RTStreamable)cl; }
//inline Ropstream operator << ( Ropstream os, PTHB3State cl )
//		{ return os << (PTStreamable)cl; }


/* --------------------------------------------------------
	THBDefault object
	-------------------------------------------------------- */

_CLASSDEF(THBDefault)

class _OWLCLASS THBDefault : public THButt
{
public:
	THBDefault(TWindow* AParent, int AnId, LPSTR AText,
		int X, int Y, int W, int H,
		DWORD dwStyle = (WS_CHILD | WS_VISIBLE | WS_TABSTOP | HBS_DEFPUSHBUTTON),
		PTModule AModule = NULL);
	THBDefault(TWindow* AParent, int ResourceId, PTModule AModule = NULL);


//	static PTStreamable build();
//	virtual void write (Ropstream os);
//	virtual Pvoid read (Ripstream is);

protected:


//	THBDefault(StreamableInit) : THButt(streamableInit) {};

private:
//	virtual const Pchar streamableName() const { return "THBDefault"; }
};


//inline Ripstream operator >> ( Ripstream is, RTHBDefault cl )
//    { return is >> (RTStreamable)cl; }
//inline Ripstream operator >> ( Ripstream is, RPTHBDefault cl )
//		{ return is >> (RPvoid)cl; }

//inline Ropstream operator << ( Ropstream os, RTHBDefault cl )
//    { return os << (RTStreamable)cl; }
//inline Ropstream operator << ( Ropstream os, PTHBDefault cl )
//		{ return os << (PTStreamable)cl; }


/* --------------------------------------------------------
	THBRadio object
	-------------------------------------------------------- */

_CLASSDEF(THBRadio)

class _OWLCLASS THBRadio : public THBCheck
{
public:
	THBRadio(TWindow* AParent, int AnId, LPSTR AText,
		int X, int Y, int W, int H,
		DWORD dwStyle = (WS_CHILD | WS_VISIBLE | WS_TABSTOP | HBS_RADIOBUTTON),
		PTModule AModule = NULL);
	THBRadio(TWindow* AParent, int ResourceId, PTModule AModule = NULL);


	BOOL IsLastInGroup(void);

	UINT Transfer(Pvoid DataPtr, TTransferDirection direction);
//	static PTStreamable build();
//	virtual void write (Ropstream os);
//	virtual Pvoid read (Ripstream is);

protected:


//	THBRadio(StreamableInit) : THBCheck(streamableInit) {};

private:
//	virtual const Pchar streamableName() const { return "THBRadio"; }
};


//inline Ripstream operator >> ( Ripstream is, RTHBRadio cl )
//    { return is >> (RTStreamable)cl; }
//inline Ripstream operator >> ( Ripstream is, RPTHBRadio cl )
//		{ return is >> (RPvoid)cl; }

//inline Ropstream operator << ( Ropstream os, RTHBRadio cl )
//    { return os << (RTStreamable)cl; }
//inline Ropstream operator << ( Ropstream os, PTHBRadio cl )
//		{ return os << (PTStreamable)cl; }


_CLASSDEF(THComb)

/* --------------------------------------------------------
	THComb object
	-------------------------------------------------------- */

class _OWLCLASS THComb : public TControl
{
public:
		THComb(TWindow* AParent, int AnId, LPSTR AText, int X, int Y,
						 int W, int H, int iMaxSize=-1, PTModule AModule = NULL);
		THComb(TWindow* AParent, int ResourceId, int iMaxSize=-1,
							PTModule AModule = NULL);

	/*
		HComb Method Wrappers
	*/

	int AddItem(LPVOID lpData);
	int AddItemEx(LPVOID lpData, LPVOID lpCode);
	int AddItems(int iCount, LPVOID lpData);
	int AddItemsEx(int iCount, LPVOID lpData, LPVOID lpCode);
	int DeleteItem(int iIndex);
	BOOL DeleteItems(WORD wSearch, int iCount, LPVOID lpInfo);
	BOOL EmptyList(void);
	int FindCode(int iStart, LPVOID lpCode);
	int FindData(int iStart, LPVOID lpData);
	BOOL GetCode(int iIndex, LPVOID lpCode);
	BOOL GetData(int iIndex, LPVOID lpData);
	int GetItems(int iCount, WORD wReturn, LPVOID lpReturn, WORD wSearch, LPVOID lpInfo);
	int InsertItem(int iPos, LPVOID lpData);
	int InsertItemEx(int iPos, LPVOID lpData, LPVOID lpCode);
	int InsertItems(int iPos, int iCount, LPVOID lpData);
	int InsertItemsEx(int iPos, int iCount, LPVOID lpData, LPVOID lpCode);
	BOOL IsSelected(int iIndex);
	BOOL SelectCode(LPVOID lpCode);
	BOOL SelectData(LPVOID lpData);
	//BOOL SelectItems(WORD wAction, WORD wSearch, int iCount, LPVOID lpInfo);
	BOOL SetCode(int iIndex, LPVOID lpCode);
	BOOL SetCodeLink(LPVOID lpCode, BOOL bSelect = TRUE);
	BOOL SetDataLink(LPVOID lpData, BOOL bSelect = TRUE);


	/*
		HComb Message Wrappers
	*/

	HBRUSH  GetBkgndBrush(void);
	BOOL HasChanged(void);
	HFONT GetFont(void);
	void GetFormat(LPSTR lpFormat, int iMaxLen=-1);
	HBRUSH GetHiliteBrush(void);
	HBRUSH SetBkgndBrush(HBRUSH hBknd, BOOL bRedraw=TRUE);
	BOOL SetChanged(BOOL bChanged);
	HFONT SetFont(HFONT hFont, BOOL bRedraw=TRUE);
	int SetFormat(LPSTR lpFormat, BOOL bRedraw=TRUE);
	HBRUSH SetHilteBrush(HBRUSH hBrush, BOOL bRedraw=TRUE);
	int SetTabStops(int iNum, LPINT lpTStops);
	void SetTextColor(COLORREF crNew, BOOL bNeg=FALSE);
	COLORREF GetTextColor(BOOL bNeg=FALSE);


	int GetEditData(LPVOID lpData, int iMaxLen=-1);
	int SetEditData(LPVOID lpData);
	LONG GetEditSel(void);
	void SetEditSel(int iAnchor, int iExtent);
	int GetEditText(LPSTR lpText, int iMaxLen=-1);
	int GetEditTextLen(void);
	int GetEditScrollPos(void);
	int SetEditScrollPos(int iScroll, BOOL bRedraw);
	void SetMaxTextLen(int iLen);
	void SetOverwrite(BOOL bOverwrite);
	void Update(BOOL bUpdateData);


	char GetCodeClass(void);
	LPVOID GetCodeLink(void);
	int GetCodeSize(int iIndex=-1);
	int GetCodeType(void);
	int GetCount(void);
	BOOL GetCurCode(LPVOID lpBuf);
	BOOL GetCurData(LPVOID lpBuf);
	char GetDataClass(void);
	LPVOID GetDataLink(void);
	int GetDataSize(int iIndex=-1);
	int GetDataType(void);
	int GetText(LPSTR lpBuf, int iIndex);
	int GetTextLen(int iIndex);
	int SetCurSel(int iIndex);
	int GetCurSel(void);
	void SetScrollPos(int iPos);
	int GetDropHeight(void);
	BOOL SetDropHeight(int iNewHeight);


//	static PTStreamable build();
	virtual BOOL Initialize(void)
		{
		return FALSE;
		}
	UINT Transfer(Pvoid DataPtr, TTransferDirection direction);
//	void THComb::write(Ropstream os);
//	void *THComb::read(ipstream& is);

protected:
		int iDataSize; //Size of transfer buffer element
		virtual LPSTR GetClassName()
				{ return "HComb"; }

//		THComb(StreamableInit) : TControl(streamableInit) {};

private:
	BOOL bInitialized;
//    virtual const Pchar streamableName() const
//				{ return "THComb"; }
};

//inline Ripstream operator >> ( Ripstream is, RTHComb cl )
//    { return is >> (RTStreamable )cl; }
//inline Ripstream operator >> ( Ripstream is, RPTHComb cl )
//		{ return is >> (RPvoid)cl; }

//inline Ropstream operator << ( Ropstream os, RTHComb cl )
//    { return os << (RTStreamable )cl; }
//inline Ropstream operator << ( Ropstream os, PTHComb cl )
//    { return os << (PTStreamable )cl; }


/* --------------------------------------------------------
	THEdit_SS object
	-------------------------------------------------------- */

_CLASSDEF(THEdit_SS)

class _OWLCLASS THEdit_SS : public TControl
{
public:
	THEdit_SS(TWindow* AParent, int AnId, LPSTR AText, int X, int Y, int W, int H,
		int iMaxLen=-1,
		DWORD dwStyle=(WS_CHILD | WS_VISIBLE | WS_TABSTOP | HES_INDENT | HES_AUTOHSCROLL),
		PTModule AModule = NULL);
	THEdit_SS(TWindow* AParent, int ResourceId,
		int iMaxLen=-1, PTModule AModule = NULL);

	void Clear();
	void Undo();
	void Paste();
	void Copy();
	void Cut();
	HBRUSH  GetBkgndBrush(void);
	BOOL  HasChanged(void);
	LONG  GetData(LPVOID lpData, int iMaxBytes=-1);
	char  GetDataClass(void);
	LONG  GetDataSize(void);
	char  GetDataType(void);
	LONG  GetFormat(LPSTR lpszFormat, int iMaxBytes=-1);
	void  GetFormatRect(LPRECT lpFormatRect);
	HBRUSH  GetHiliteBrush(void);
	LONG  GetScrollPos(void);
	LONG  GetSel(void);
	void  GetSelText(LPSTR lpSelText, int iMaxBytes=-1);
	void  ReplaceSel(LPSTR lpStr);
	LONG  GetState(void);
	LONG  GetText(LPSTR lpBuf, int iMaxBytes=-1);
	BOOL  SetText(LPSTR lpBuf);
	LONG  GetTextLen(void);
	VALIDATEPROC  GetValidate(void);
	HBRUSH  SetBkgndBrush(HBRUSH hBkgnd);
	void  SetChanged(BOOL bChanged);
	LONG  SetData(LPVOID lpBuf);
	LONG  SetDataLink(LPVOID lpBuf, BOOL bSetData = TRUE);
	HFONT  SetFont(HFONT hFont, BOOL bRedraw=TRUE);
	LONG  SetFormat(LPSTR lpString, BOOL bRedraw=TRUE);
	void  SetFormatRect(BOOL bRedraw, LPRECT lpFormatRect);
	HBRUSH  SetHiliteBrush(HBRUSH hbHilite);
	LONG  SetScrollPos(int iNumChars, BOOL bRedraw=TRUE);
	void  SetSel(int iAnchor, int iExtent);
	void  SetMaxTextLen(int iMaxLen);
	void  SetPasswordChar(char c);
	void  SetOverwriteMode(BOOL bMode=TRUE);
	void  SetValidate(VALIDATEPROC lpfnValidate);
	void  Update(BOOL bParseText=FALSE, BOOL bUpdateText=TRUE);
	int Validate(void);

	HFONT GetFont(void);
	BOOL  GetOverwriteMode(void);
	char  GetPasswordChar(void);
	int   GetMaxTextLen(void);
	COLORREF GetTextColor(BOOL bNeg = FALSE);
	BOOL  SetState(LONG lStateFlag, BOOL bValue);
	BOOL  SetTextColor(COLORREF cr, BOOL bNeg = FALSE);
	BOOL  IsQuiet(void);
	BOOL  BeQuiet(BOOL bQuiet);

	UINT Transfer(Pvoid DataPtr, TTransferDirection direction);
//	static PTStreamable build();
//	virtual void write (Ropstream os);
//	virtual Pvoid read (Ripstream is);

protected:

	int TextLen;
	virtual LPSTR GetClassName() { return "HEdit_SS"; }

//	THEdit_SS(StreamableInit) : TControl(streamableInit) {};

private:
//	virtual const Pchar streamableName() const { return "THEdit_SS"; }
};


//inline Ripstream operator >> ( Ripstream is, RTHEdit_SS cl )
//    { return is >> (RTStreamable)cl; }
//inline Ripstream operator >> ( Ripstream is, RPTHEdit_SS cl )
//		{ return is >> (RPvoid)cl; }

//inline Ropstream operator << ( Ropstream os, RTHEdit_SS cl )
//    { return os << (RTStreamable)cl; }
//inline Ropstream operator << ( Ropstream os, PTHEdit_SS cl )
//		{ return os << (PTStreamable)cl; }



_CLASSDEF(THGrid)

/* --------------------------------------------------------
	THGrid object
	-------------------------------------------------------- */

class _OWLCLASS THGrid : public TControl
{
public:
		THGrid(TWindow* AParent, int AnId, LPSTR AText, int X, int Y,
						 int W, int H, PTModule AModule = NULL);
		THGrid(TWindow* AParent, int ResourceId, PTModule AModule = NULL);


	/*
		HGrid Method Wrappers
	*/
	HFLD FieldCreate(LPSTR lpName, WORD wState, int iWidth, int iHeight, char cDataClass,
									 char cDataType, char cCodeClass, char cCodeType,int iSize, char cCtlType,
									 DWORD lCtlStyle, LPCSTR lpFormat);
	BOOL GetCellData(WORD wField, WORD wRec, LPVOID lpData);
	WORD GetCellText(WORD wField, WORD wRec, LPSTR lpText, WORD wMax);
	BOOL SetCellData(WORD wField, WORD wRec, LPVOID lpData);
	BOOL SetCellString(WORD wField, WORD wRec, LPSTR lpData);
	BOOL SetCurSel(WORD wField, WORD wRec);
	BOOL GetCellData(int iField, int iRec, LPVOID lpData);
	WORD GetCellText(int iField, int iRec, LPSTR lpText, WORD wMax);
	BOOL SetCellData(int iField, int iRec, LPVOID lpData);
	BOOL SetCellString(int iField, int iRec, LPSTR lpData);
	BOOL SetCurSel(int iField, int iRec);
	BOOL InvalidateRange(int iFld1, int iRec1, int iFld2, int iRec2);
	BOOL InvalidateCell (int iFld, int iRec);
	LPSTR OffsetPtr (int iFld, LPVOID lpRec);


	/*
		HGrid Message Wrappers
	*/
	LONG GetBaseRec(void);
	void SetBaseRec(LONG lBaseRec);
	int GetBtnHeight(void);
	void SetBtnHeight(int iHeight, BOOL bRedraw=TRUE);
	int GetBtnWidth(void);
	void SetBtnWidth(int iWidth, BOOL bRedraw=TRUE);
	LONG GetFirstRec(void);
	LONG SetFirstRec(LONG lRecIndex);
	WORD GetFirstCol(void);
	void SetFirstCol(int iColIndex);
	int GetColCount(void);
	int GetRowCount(void);
	HBRUSH GetBkgndBrush(void);
	HBRUSH SetBkgndBrush(HBRUSH hBrush, BOOL bRedraw=TRUE);
	HFONT GetFont(void);
	HFONT SetFont(HFONT hFont, BOOL bRedraw=TRUE);
	int GetFrozenCols(void);
	void SetFrozenCols(int iFrznCols);
	int GetRowHeight(void);
	void SetRowHeight(int iHeight, BOOL bRedraw=TRUE);
	LONG GetSelAnchor(LPCELL lpCell=NULL);
	void SetSelAnchor(int iCol, int iRow);
	LONG GetSelExtent(LPCELL lpCell=NULL);
	void SetSelExtent(BOOL bExtend, int iCol, int iRow);
	LONG GetState(void);
	void SetState(BOOL bValue, WORD wFlag);
	LONG GetStyle(void);
	void SetStyle(BOOL bValue, LONG lFlag);
	LONG GetMarker(void);
	void SetMarker(int iColIndex, int iRowIndex);
	void GetTitle(int iCount, LPSTR lpsTitle);
	void SetTitle(int iCount, LPSTR lpsTitle);
	void Update(BOOL bErase);
	BOOL IsQuiet(void);
	void BeQuiet(BOOL bValue);
	void GetColMap(int FAR *lpMap);
	void SetColMap(int FAR *lpMap);
	int GetHScrollPos(void);
	int GetVScrollPos(void);
	int SetHScrollPos(int iPos);
	int SetVScrollPos(int iPos);
	int GetHScrollRange();
	int GetVScrollRange();

	//Record Buffering
	BUFFERPROC GetBufferProc(void);
	BUFFERPROC SetBufferProc(BUFFERPROC lpfnBufProc);
	int GetBufferSize(void);
	int SetBufferSize(int iSize);
	LONG GetMaxRec(void);
	LONG SetMaxRec(LONG lMax);
	//Field Management
	void AddFld(HFLD& Fld);
	void DeleteFld(int iColIndex);
	int FindFld(LPSTR lpszFldName);
	void InsertFld(int wBeforeFld, HFLD& Fld);
	void MoveCol(int wOldIndex, int wNewIndex);
	//Record Management
	int AddRec(LPVOID lpRecStruct=NULL);
	BOOL DeleteRec(int iRecIndex);
	BOOL GetCurRec(LPVOID lpRecStruct);
	LPVOID GetRecLink(void);
	int InsertRec(int iRecIndex, LPVOID lpRecStruct=NULL);
	int MoveRow(int iOldIndex, int iNewIndex);
	void ResetContent(BOOL bRedraw = TRUE);
	void SetRecLink(LPVOID lpRecStruct);
	int GetRecSize(void);
	//Field Messages
	HWND GetHCtl(int iColIndex);
	LONG GetCtlStyle(int iColIndex);
	WORD GetCtlType(int iColIndex);
	char GetCodeClass(int iColIndex);
	char GetCodeType(int iColIndex);
	char GetDataClass(int iColIndex);
	char GetDataType(int iColIndex);
	int GetDataSize(int iColIndex);
	void GetFormat(int iColIndex, LPSTR lpszFormat);
	int GetFormatLen(int iColIndex);
	void SetFormat(int iColIndex, LPSTR lpszFormat);
	int GetDropHeight(int iColIndex);
	void SetDropHeight(int iColIndex, int iNewHeight);
	void GetName(int iColIndex, LPSTR lpszName);
	int GetNameLen(int iColIndex);
	void SetName(int iColIndex, LPSTR lpszName);
	int GetColWidth(int iColIndex);
	void SetColWidth(int iColIndex, int iNewWidth);
	WORD GetFieldState(int iColIndex);
	WORD SetFieldState(int iColIndex, WORD wFlag, BOOL bValue);
	int GetOffset(int iFldIndex);

	//Record Messages
	BOOL GetData(int iRecIndex, LPVOID lpRecStruct);
	BOOL SetData(int iRecIndex, LPVOID lpRecStruct);
	WORD GetRecState(int iRecIndex);
	void SetRecState(int iRecIndex, WORD wFlag, BOOL bValue);

	//Whole Rows
	int GetSelCount(void);
	int GetSelRows(int iBufSize, int FAR *lpBuffer);
	BOOL IsSelected(int iRow);
	BOOL SelectRow(int iRow);
	
//Index Conversions
	int ColToFld(int c);
	int FldToCol(int f);
	LONG RowToRec(int row);
	int RecToRow(LONG rec);

//	static PTStreamable build();
//	void THGrid::write(Ropstream os);
//	void *THGrid::read(ipstream& is);

protected:
	int iDataSize; //Size of transfer buffer element
	virtual LPSTR GetClassName()
		{ return "HGRID"; }

	virtual BOOL Initialize(void)
		{return FALSE;}
	virtual BOOL Terminate(void)
		{return FALSE;}
//	THGrid(StreamableInit) : TControl(streamableInit) {};

private:
	BOOL bInitialized;
//  virtual const Pchar streamableName() const
//				{ return "THGrid"; }
};

//inline Ripstream operator >> ( Ripstream is, RTHGrid cl )
//    { return is >> (RTStreamable )cl; }
//inline Ripstream operator >> ( Ripstream is, RPTHGrid cl )
//		{ return is >> (RPvoid)cl; }

//inline Ropstream operator << ( Ropstream os, RTHGrid cl )
//    { return os << (RTStreamable )cl; }
//inline Ropstream operator << ( Ropstream os, PTHGrid cl )
//    { return os << (PTStreamable )cl; }



_CLASSDEF(THList)

/* --------------------------------------------------------
	THList object
	-------------------------------------------------------- */

class _OWLCLASS THList : public TControl
{
public:
		THList(TWindow* AParent, int AnId, LPSTR AText, int X, int Y,
						 int W, int H, int iMaxSize=-1, PTModule AModule = NULL);
		THList(TWindow* AParent, int ResourceId, int iMaxSize=-1,
							PTModule AModule = NULL);

	/*
		HList Method Wrappers
	*/

	int AddItem(LPVOID lpData);
	int AddItemEx(LPVOID lpData, LPVOID lpCode);
	int AddItems(int iCount, LPVOID lpData);
	int AddItemsEx(int iCount, LPVOID lpData, LPVOID lpCode);
	int DeleteItem(int iIndex);
	BOOL DeleteItems(WORD wSearch, int iCount, LPVOID lpInfo);
	BOOL EmptyList(void);
	int FindCode(int iStart, LPVOID lpCode);
	int FindData(int iStart, LPVOID lpData);
	BOOL GetCode(int iIndex, LPVOID lpCode);
	BOOL GetData(int iIndex, LPVOID lpData);
	int GetItems(int iCount, WORD wReturn, LPVOID lpReturn, WORD wSearch, LPVOID lpInfo);
	int InsertItem(int iPos, LPVOID lpData);
	int InsertItemEx(int iPos, LPVOID lpData, LPVOID lpCode);
	int InsertItems(int iPos, int iCount, LPVOID lpData);
	int InsertItemsEx(int iPos, int iCount, LPVOID lpData, LPVOID lpCode);
	BOOL IsSelected(int iIndex);
	BOOL SelectCode(LPVOID lpCode, WORD wAction);
	BOOL SelectData(LPVOID lpData, WORD wAction);
	BOOL SelectItem(int iIndex, WORD wAction);
	BOOL SelectItems(WORD wAction, WORD wSearch, int iCount, LPVOID lpInfo);
	BOOL SetCode(int iIndex, LPVOID lpCode);
	BOOL SetCodeLink(LPVOID lpCode, BOOL bSelect);
	BOOL SetDataLink(LPVOID lpData, BOOL bSelect);
	BOOL MarkItems(WORD wSearch, int iCount, LPVOID lpInfo);


	/*
		HList Message Wrappers
	*/
	HBRUSH  GetBkgndBrush(void);
	char GetCodeClass(void);
	LPVOID GetCodeLink(void);
	int GetCodeSize(int iIndex=-1);
	int GetCodeType(void);
	BOOL GetCurCode(LPVOID lpBuf, WORD wSize=-1);
	BOOL GetCurData(LPVOID lpBuf, WORD wSize=-1);
	WORD GetCurSel(void);
	char GetDataClass(void);
	LPVOID GetDataLink(void);
	int GetDataSize(int iIndex=-1);
	int GetDataType(void);
	HFONT GetFont(void);
	void GetFormat(LPSTR lpBuf, int iMaxLen=-1);
	int GetHExtent(void);
	HBRUSH GetHiliteBrush(void);
	BOOL GetItemRect(int iIndex, LPRECT lpR);
	int GetScrollPos(void);
	BOOL GetSel(int iIndex);
	int GetSelCount(void);
	int GetSelItems(LPINT lpBuf, int iMaxItems);
	LONG GetState(void);
	int GetText(LPSTR lpBuf, int iIndex);
	int GetTextLen(int iIndex);
	COLORREF GetTextColor(BOOL bNeg=FALSE);
	void SetTextColor(COLORREF crNew, BOOL bNeg=FALSE);
	LONG GetStyle(void);
	void SelectRange(int iAction, int iStart, int iEnd);
	HBRUSH SetBkgndBrush(HBRUSH hBknd, BOOL bRedraw=TRUE);
	HBRUSH SetHiliteBrush(HBRUSH hBrush, BOOL bRedraw=TRUE);
	BOOL SetColumnWidth(int iWidth);
	int SetCurSel(int iIndex);
	HFONT SetFont(HFONT hFont, BOOL bRedraw=TRUE);
	int SetFormat(LPSTR lpszFormat, BOOL bRedraw=TRUE);
	void SetScrollPos(int iPos);
	BOOL SetSel(int iAction, int iIndex);
	LONG SetState(WORD wFlag, BOOL bSetting);
	BOOL SetTabStops(int iNum, LPINT lpStops);

	//undocumented
	int FindString(int iStart, LPSTR lpString);
	int SelectString(int iStart, LPSTR lpString);
	int GetTopIndex(void);
	int SetTopIndex(int iTop);
	int Scroll(int iAmount);
	BOOL SetRedraw(BOOL bRedraw, BOOL bRedrawNow);
	BOOL HasChanged(void);
	BOOL SetChanged(BOOL bChanged);
	void BeQuiet(BOOL bQuiet);
	BOOL IsQuiet(void);
	BOOL Update(void);

//	static PTStreamable build();
	virtual BOOL Initialize(void)
		{
		return FALSE;
		}
	UINT Transfer(Pvoid DataPtr, TTransferDirection direction);
//	void THList::write(Ropstream os);
//	void *THList::read(ipstream& is);

protected:
		int iDataSize; //Size of transfer buffer element
		virtual LPSTR GetClassName()
				{ return "HLIST"; }

//		THList(StreamableInit) : TControl(streamableInit) {};

private:
		BOOL bInitialized;
//    virtual const Pchar streamableName() const
//				{ return "THList"; }

};

//inline Ripstream operator >> ( Ripstream is, RTHList cl )
//    { return is >> (RTStreamable )cl; }
//inline Ripstream operator >> ( Ripstream is, RPTHList cl )
//		{ return is >> (RPvoid)cl; }

//inline Ropstream operator << ( Ropstream os, RTHList cl )
//    { return os << (RTStreamable )cl; }
//inline Ropstream operator << ( Ropstream os, PTHList cl )
//    { return os << (PTStreamable )cl; }

//enum msgname {MN_ADDSTRING,    MN_INSERTSTRING, MN_DELETESTRING,
//              MN_RESETCONTENT, MN_GETCOUNT,     MN_GETTEXT,
//              MN_GETTEXTLEN,   MN_SELECTSTRING, MN_SETCURSEL,
//							MN_GETCURSEL,    MN_FINDSTRING };

/* --------------------------------------------------------
	THStat object
	-------------------------------------------------------- */

_CLASSDEF(THStat)

class _OWLCLASS THStat : public TControl
{
public:
	THStat(TWindow* AParent, int AnId, LPSTR AText, int X, int Y, int W, int H,
		DWORD dwStyle=(WS_CHILD | WS_VISIBLE | WS_TABSTOP | HSS_TEXT | HSS_LEFT | HSS_TRANSPARENT),
		PTModule AModule = NULL);
	THStat(TWindow* AParent, int ResourceId, PTModule AModule = NULL);

	int GetAlign(void);
	COLORREF GetBkgndColor(void);
	COLORREF GetFrgndColor(void);
	HPALETTE GetPalette(void);
	HANDLE GetPic(void);
	int GetText(LPSTR lpBuf, int iMaxLen=-1);
	int GetType(void);
	void SetAlign(int iCode);
	void SetBkgndColor(COLORREF cr, BOOL bRedraw);
	void SetFrgndColor(COLORREF cr, BOOL bRedraw);
	HANDLE SetPic(HANDLE hImage, WORD wType, BOOL bRedraw=TRUE);
	void SetText(LPSTR lpszText);
	void SetType(int iType, BOOL bRedraw);

//	static PTStreamable build();
//	virtual void write (Ropstream os);
//	virtual Pvoid read (Ripstream is);

protected:

	virtual LPSTR GetClassName() { return "HSTAT"; }

//	THStat(StreamableInit) : TControl(streamableInit) {};

private:
	int TextLen;
//	virtual const Pchar streamableName() const { return "THStat"; }
};


//inline Ripstream operator >> ( Ripstream is, RTHStat cl )
//    { return is >> (RTStreamable)cl; }
//inline Ripstream operator >> ( Ripstream is, RPTHStat cl )
//		{ return is >> (RPvoid)cl; }

//inline Ropstream operator << ( Ropstream os, RTHStat cl )
//    { return os << (RTStreamable)cl; }
//inline Ropstream operator << ( Ropstream os, PTHStat cl )
//		{ return os << (PTStreamable)cl; }


/* --------------------------------------------------------
	THTool object
	-------------------------------------------------------- */

_CLASSDEF(THTool)

class _OWLCLASS THTool : public TDialog
{
public:
	THTool(TWindow* AParent, LPSTR AName, DWORD dwStyle = HTS_TOP, WORD wId=-1, PTModule AModule = NULL);

	HBRUSH GetBrush(void);
	int GetCaption(LPSTR lpBuf, int iMaxLen=-1);
	HWND GetNotify(void);
	HBRUSH SetBrush(HBRUSH hBkgnd);
	void SetCaption(LPSTR lpszCaption);
	HWND SetNotify(HWND hNotify);
	void Update();
	BOOL Create();
	BOOL Create(int iX, int iY);
	BOOL Execute() {return 0;}  //Never Modal

	void SetId(int);
	int GetId(void);
	void SetStyle(DWORD);
	DWORD GetStyle(void);

//	static PTStreamable build();
//	virtual void write (Ropstream os);
//	virtual Pvoid read (Ripstream is);

protected:

	virtual LPSTR GetClassName() { return "HTOOL"; }

//	THTool(StreamableInit) : TDialog(streamableInit) {};

private:
	int Id;
	DWORD Style;
//	virtual const Pchar streamableName() const { return "THTool"; }
};


//inline Ripstream operator >> ( Ripstream is, RTHTool cl )
//    { return is >> (RTStreamable)cl; }
//inline Ripstream operator >> ( Ripstream is, RPTHTool cl )
//    { return is >> (RPvoid)cl; }

//inline Ropstream operator << ( Ropstream os, RTHTool cl )
//    { return os << (RTStreamable)cl; }
//inline Ropstream operator << ( Ropstream os, PTHTool cl )
//		{ return os << (PTStreamable)cl; }


#pragma option -Vo.
#if     defined(__BCOPT__) && !defined(_ALLOW_po)
#pragma option -po.
#endif

#endif
