/* Roids 2.2 installation program */

  Call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'	/* Make REXX functions available */
  Call SysLoadFuncs

  Parse Arg InstallDir     					/* Command line parameter */
  Signal On Halt Name ErrorHandler       			/* Error handler */

  Say
  Say
  Say
  Say " Roids 2.2 Installation"

  If InstallDir=" " Then Do					/* If no path is given, get one from the user */
    Say
    Say " Please specify the name of the subdirectory to"
    Say " which you would like to install Roids, hit <Enter>"
    Say " to use the current directory, or type 'Q'<Enter>"
    Say " to quit."
    Say
    Say " For Example:	C:\OS2\ROIDS<Enter>"
    Say
    Say " Please specify:"					/* Prompt for input */

    Parse Value SysCurPos() with Row Col
    Col=Col+17
    Row=Row-1
    Call SysCurPos Row, Col
    Pull InstallDir
    If (InstallDir="Q")|(InstallDir="q") Then Exit		/* Quit if they hit 'Q' */
  End

  If InstallDir=" " Then InstallDir=directory()			/* Find the current directory if none given */

  Else Do                                                       /* Otherwise do the copying bit */

    Call SysFileTree InstallDir, FileDirectory, 'D'		/* Search for installation directory */

    If FileDirectory.0='0' Then Do				/* If not found, create installation directory */
      Say
      Say " Now creating directory "InstallDir" . . ."
      rc=SysMkDir(InstallDir)
      If rc\=0 Then Do
	Say
	Say " UURGH! Sorry, the desired directory couldn't be created, "
	Say " probably because you specified an invalid directory name. "
	Say " Please re-run this command file and try again."
	Exit
      End
    End

    Say
    Say " Now copying files . . ."          			/* Now copy files */
    Call FileCopy 'INSTALL.CMD', InstallDir
    Call FileCopy 'ROIDS.EXE', InstallDir
    Call FileCopy 'ROIDS.HLP', InstallDir
    Call FileCopy 'README.TXT', InstallDir
    Call FileCopy '*.WAV', InstallDir
  End

  Say
  Say " Now creating WPS program object . . ."			/* Now create the Desktop object*/
  SetupString="EXENAME="InstallDir"\ROIDS.EXE;STARTUPDIR="InstallDir
                                       
  rc=SysCreateObject("WPProgram","Roids 2.2","<WP_DESKTOP>",SetupString)
  If rc=0 Then Do
    Say
    Say " Sorry, couldn't create the Roids program object.  You" 
    Say " probably already have a program object for Roids 2.2."
    Say " Please remove any Roids program objects from your"
    Say " system and re-run this command file."
    Exit
  End

  Say
  Say " Now you get to read the README.TXT file . . ."

  Command='@E README.TXT'					/* Look at the README.TXT */
  Command

  Say
  Say " Hooray!  Roids 2.2 has been installed successfully!"

  Exit


/******* FileCopy procedure */

  FileCopy: Arg FileName, Destination
    
    Command='@Copy 'FileName' 'Destination' >NUL'
    Command
    If rc\=0 Then Do						/* Error copying file */
      Say
      Say " AAAGH! Error copying files, probably file not found."
      Say " Please make sure that this program can find all the"
      Say " files listed in the README.TXT file and try again."
      Exit
    End
    Return


/******* ErrorHandler procedure */

  ErrorHandler:

    Call SysCls
    Say " AAAARGH! Unknown error! - aborting installation . . ."
  Exit

