/** ABEDemo.cmd **/
/**********************************************/
/*                                            */
/* Command line syntax:                       */
/*                                            */
/* ABEDemo  db_path user_password user_name   */
/*                                            */
/*                                            */
/**********************************************/
ARG db_path user_pw user_name
'@echo off'
'@cls'
Say 'RexxVIM Address Book Entry Demonstration Program'
Say

/* Unload the function upon error */
SIGNAL ON ERROR NAME done

/* Prompt for the parameters if not passed on the */
/* command line                                   */
if LENGTH(STRIP(db_path)) = 0 then do
   Say 'Enter Postoffice Directory -'
   PARSE PULL db_path .
   Say
   Say 'Enter User Name -'
   PARSE PULL user_name
   Say 'Enter Password -'
   PARSE PULL user_pw
end  /* Do */


/* Load the RexxVIM extensions to Rexx */
rc = RxFuncAdd('RxVIMLoadFuncs', 'REXXVIM', 'RxVIMLoadFuncs')
if rc <> 0 then do
   Say
   Say 'RexxVIM failed to load, return code' rc
   Say
   Say 'Functions have been released.  Retry program.'
   signal done
end  /* Do */
call RxVIMLoadFuncs
Say 'Functions are now loaded'
Say


/* Initialize the VIM subsystem */
rc = RxVIMInitialize()
if (rc > 0) then call vimerr

/* Open a session with the postoffice using the parameters */
/* provided by the user                                    */
rc = RxVIMOpenSession(db_path,user_name,user_pw,Session)
if (rc > 0) then call vimerr


     /* Enumerate the addressbooks */
     pos = ''                           /* Start at the beginning */
     skipcnt = 1                        /* Move forward one at a time */
     acount  = 1                        /* Retrieve 1 addressbook for each call */
     more    = ''                       /* Set the value of more to nul */
     action  = 'N'                      /* Set the value of repeat loop indicator to N */

     AttrDesc.0 = 2                               /* Retrieve 2 attributes for each addressbook */
     AttrDesc.1.Selector = 'VIMSEL_NAME'          /* 1st attribute is the addressbook name */
     AttrDesc.1.Buffer   = 'AddrName'             /* store results in this stem variable */
     AttrDesc.2.Selector = 'VIMSEL_TOTAL_ENTRIES' /* 2nd attribute is total entries */
     AttrDesc.2.Buffer   = 'AddrTotal'            /* store results in this stem variable */

     /* Continue retrieving addressbook info until user enters X */

     rc = RxVIMEnumerateAddressBooks(Session,'pos',skipcnt,'AttrDesc','acount','more')
     if (rc > 0) then call vimerr

     do until TRANSLATE(SUBSTR(action,1,1)) = 'X'

          /* Display results */
         'cls'
          Say 'RexxVIM - (c) Innovative Business Technologies, Inc'
          Say
          Say 'Address Book Demo'
          Say
          Say '--------------------------------------------------------'
          Say '    Address Book Name =' AddrName.1
          Say '    Total Entries     =' AddrTotal.1
          Say '--------------------------------------------------------'
          Say
          Say
          Say 'Select an action for this message'
          Say
          Say '   N - Go to next Address Book'
          Say '   C - Create a new entry'
          Say '   S - Search for an entry'
          Say '   L - Change the location of an entry'
          Say '   F - Create a new group'
          Say '   G - Display all members of a group'
          Say '   X - Exit demo now'
          Say
          Say 'Enter your selection below:'
          PULL action

          /* Process the selection entered.  X will fall through the select statement */
          select
             when TRANSLATE(SUBSTR(action,1,1)) = 'N' then do
                /* Go to the next address book */

                rc = RxVIMEnumerateAddressBooks(Session,'pos',skipcnt,'AttrDesc','acount','more')
                if (rc > 0) then call vimerr

             end  /* Do */
             when TRANSLATE(SUBSTR(action,1,1)) = 'C' then do
                /* Create a new entry in this address book */

                Say '--------------------------------------------------------'
                Say 'Enter the name'
                Pull ename
                Say 'Enter a comment'
                Pull ecomment
                Say 
                Say 'Adding' ename 'to the addressbook'
                Say '--------------------------------------------------------'

                /* Open the addressbook */
                rc = RxVIMOpenAddressBook(Session,AddrName.1,'AddrBkPtr')
                if (rc > 0) then call vimerr

                /* Create the description stem for the create */
                attrItem.0 = 3
                attrItem.1.Selector = 'VIMSEL_NAME'
                attrItem.1.Value    = ename
                attrItem.2.Selector = 'VIMSEL_COMMENTS'
                attrItem.2.Value    = ecomment
                attrItem.3.Selector = 'VIMSEL_LOCATION'
                attrItem.3.Value    = 'VIMSEL_REMOTE'

                /* Add the entry to the address book */
                rc = RxVIMCreateAddressBookEntry(AddrBkPtr,'VIMSEL_ENTITY','attrItem')
                if (rc > 0) then call vimerr

                /* Close the address book */
                rc = RxVIMCloseAddressBook(addrBkPtr)
                if (rc > 0) then call vimerr

             end  /* Do */
             when TRANSLATE(SUBSTR(action,1,1)) = 'S' then do
                /* Search for an entry in this address book */

                Say '--------------------------------------------------------'
                Say 'Enter the name for the search'
                Pull ename
                Say 
                Say 'Searching for' ename 'in the addressbook'

                /* Open the addressbook */
                rc = RxVIMOpenAddressBook(Session,AddrName.1,'AddrBkPtr')
                if (rc > 0) then call vimerr

                /* Create the description stem for the create */
                searchon = 'VIMSEL_NAME'
                epos     = ''
                matchby  = 'VIMSEL_FULL'
                enumb    = ''

                /* Search for the entry in the address book */
                rc = RxVIMMatchAddressBook(AddrBkPtr,searchon,ename,matchby,'epos','enumb')
                if (rc > 0) then do
                    /* Entry not found */
                    Say '--------------------------------------------------------'
                    Say '  Entry not found in the addressbook'
                    Say '--------------------------------------------------------'
                end  /* Do */
                else do

                    /* Get additional info about specific entry */
                    itemdesc.0 = 3
                    itemdesc.1.selector = 'VIMSEL_LOCATION'
                    itemdesc.1.buffer   = 'location'
                    itemdesc.2.selector = 'VIMSEL_ADDRESS'
                    itemdesc.2.buffer   = 'address'
                    itemdesc.3.selector = 'VIMSEL_TYPE'
                    itemdesc.3.buffer   = 'typebuf'

                    rc = RxVIMGetABEntryAttributes(addrBkPtr,epos,'','itemdesc')
                    if (rc > 0) then call vimerr

                    Say '--------------------------------------------------------'
                    Say '  Name     -' ename
                    Say '  Ref No   -' epos
                    Say
                    Say '  Address  -' address
                    Say '  Type     -' typebuf
                    Say '  Location -' location
                    Say '--------------------------------------------------------'
                end  /* Do */
                'pause'

                /* Close the address book */
                rc = RxVIMCloseAddressBook(addrBkPtr)
                if (rc > 0) then call vimerr

             end  /* Do */
             when TRANSLATE(SUBSTR(action,1,1)) = 'G' then do

                /* Retrieve the name of the group to display */
                Say 'Enter the name of the group to display'
                PULL gname

                /* Open the current address book */
                rc = RxVIMOpenAddressBook(Session,AddrName.1,'AddrBkPtr')
                if (rc > 0) then call vimerr

                /* Enumerate the group member entries */
                epos = ''                           /* Start at the beginning */
                eskipcnt = 1                        /* Move forward one at a time */
                eacount  = 1                        /* Retrieve 1 group member for each call */
                emore    = ''                       /* Set the value of more to nul */
                eaction  = 'N'                      /* Set the value of repeat loop indicator to N */

                ItemDesc.0 = 3                               /* Retrieve 3 attributes for each entry */
                ItemDesc.1.Selector = 'VIMSEL_REF'           /* 1st attribute is the reference number */
                ItemDesc.1.Buffer   = 'ABE_Ref'              /* store results in this stem variable */
                ItemDesc.2.Selector = 'VIMSEL_NAME'          /* 2nd attribute is the entry name */
                ItemDesc.2.Buffer   = 'ABE_Name'             /* store results in this stem variable */
                ItemDesc.3.Selector = 'VIMSEL_ADDRESS'       /* 3rd attribute is entry address */
                ItemDesc.3.Buffer   = 'ABE_Address'          /* store results in this stem variable */

                do until TRANSLATE(SUBSTR(eaction,1,1)) = 'X'

                     /* Continue retrieving group member info until user enters X */

                     rc = RxVIMEnumerateGroupMembers(AddrBkPtr,'',gname,'epos',eskipcnt,,
                                           'ItemDesc','eacount','emore')
                     if (rc > 0) then call vimerr

                     /* Display results */
                    'cls'
                     Say 'RexxVIM - (c) Innovative Business Technologies, Inc'
                     Say
                     Say 'Group Member Information'
                     Say
                     Say '--------------------------------------------------------'
                     Say '    Group Name =' gname
                     Say '--------------------------------------------------------'
                     Say '    Name =   ' ABE_Name.1
                     Say '    Address =' ABE_Address.1
                     Say '    Ref No  =' ABE_Ref.1
                     Say '--------------------------------------------------------'
                     Say
                     Say
                     Say 'Select an action for this message'
                     Say
                     Say '   N - Go to next Group Member entry'
                     Say '   A - Add a new entry to the group'
                     Say '   D - Delete this entry from the group'
                     Say '   X - Exit to the main screen'
                     Say
                     Say 'Enter your selection below:'
                     PULL eaction

                     select
                        when TRANSLATE(SUBSTR(eaction,1,1)) = 'N' then do
                           /* Go to the next group member entry */
                           /* Nothing to do.....will loop to the next entry */
                        end  /* Do */
                        when TRANSLATE(SUBSTR(eaction,1,1)) = 'D' then do
                           /* Delete the current entry from the group */
                           rc = RxVIMRemoveGroupMember(AddrBkPtr,'',gname,ABE_Name.1)
                           if (rc > 0) then call vimerr
                        end  /* Do */
                        when TRANSLATE(SUBSTR(eaction,1,1)) = 'A' then do
                           /* Add a new entry to the group */
                           Say 'Enter the new name to add'
                           PULL new_name

                           rc = RxVIMAddGroupMember(AddrBkPtr,'',gname,new_name)
                           if (rc > 0) then call vimerr
                        end  /* Do */
                     otherwise
                     end  /* select */

                     /* End the loop if no more entries */
                     if emore = 'False' then do
                        Say 'All entries for this group have been retrieved'
                        eaction = 'X'
                     end  /* Do */

                end /* Do */

                /* Close the  address book */
                rc = RxVIMCloseAddressBook(AddrBkPtr)
                if (rc > 0) then call vimerr

             end  /* Do */
             when TRANSLATE(SUBSTR(action,1,1)) = 'F' then do
                /* Create a new group entry in this address book */

                Say '--------------------------------------------------------'
                Say 'Enter the group name'
                Pull gname
                Say
                Say 'Adding' gname 'to the addressbook'
                Say '--------------------------------------------------------'

                /* Open the addressbook */
                rc = RxVIMOpenAddressBook(Session,AddrName.1,'AddrBkPtr')
                if (rc > 0) then call vimerr

                /* Create the description stem for the create */
                attrItem.0 = 1
                attrItem.1.Selector = 'VIMSEL_NAME'
                attrItem.1.Value    = gname

                /* Add the entry to the address book */
                rc = RxVIMCreateAddressBookEntry(AddrBkPtr,'VIMSEL_GROUP','attrItem')
                if (rc > 0) then call vimerr

                /* Close the address book */
                rc = RxVIMCloseAddressBook(addrBkPtr)
                if (rc > 0) then call vimerr

             end  /* Do */
             when TRANSLATE(SUBSTR(action,1,1)) = 'L' then do
                /* Search for an entry in this address book */

                Say '--------------------------------------------------------'
                Say 'Enter the name to change location'
                Pull ename
                Say 
                Say 'Searching for' ename 'in the addressbook'

                /* Open the addressbook */
                rc = RxVIMOpenAddressBook(Session,AddrName.1,'AddrBkPtr')
                if (rc > 0) then call vimerr

                /* Create the description stem for the create */
                searchon = 'VIMSEL_NAME'
                epos     = ''
                matchby  = 'VIMSEL_FULL'
                enumb    = ''

                /* Search for the entry in the address book */
                rc = RxVIMMatchAddressBook(AddrBkPtr,searchon,ename,matchby,'epos','enumb')
                if (rc > 0) then do
                    /* Entry not found */
                    Say '--------------------------------------------------------'
                    Say '  Entry not found in the addressbook'
                    Say '--------------------------------------------------------'
                end  /* Do */
                else do

                    /* Get additional info about specific entry */
                    itemdesc.0 = 3
                    itemdesc.1.selector = 'VIMSEL_LOCATION'
                    itemdesc.1.buffer   = 'location'
                    itemdesc.2.selector = 'VIMSEL_ADDRESS'
                    itemdesc.2.buffer   = 'address'
                    itemdesc.3.selector = 'VIMSEL_TYPE'
                    itemdesc.3.buffer   = 'typebuf'

                    rc = RxVIMGetABEntryAttributes(addrBkPtr,epos,'','itemdesc')
                    if (rc > 0) then call vimerr

                    Say '--------------------------------------------------------'
                    Say '  Name     -' ename
                    Say '  Ref No   -' epos
                    Say
                    Say '  Address  -' address
                    Say '  Type     -' typebuf
                    Say '  Location -' location
                    Say '--------------------------------------------------------'
                end  /* Do */
                Say 'Enter new location - (L)ocal, (R)emote, (M)obile or enter for no change'
                PULL nlocation

                if LENGTH(STRIP(nlocation)) > 0 then do

                    itemdesc.0 = 1
                    itemdesc.1.selector = 'VIMSEL_LOCATION'
 
                    /* Set value of new location from input */
                    Select
                       when TRANSLATE(SUBSTR(nlocation,1,1)) = 'L' then
                         itemdesc.1.value = 'VIMSEL_LOCAL'
                       when TRANSLATE(SUBSTR(nlocation,1,1)) = 'R' then
                         itemdesc.1.value = 'VIMSEL_REMOTE'
                       when TRANSLATE(SUBSTR(nlocation,1,1)) = 'M' then
                         itemdesc.1.value = 'VIMSEL_DIALIN'
                    otherwise
                         itemdesc.1.value = location
                    end  /* select */
                    itemdesc.1.buffer   = 'location'
 
                    /* Call function to set location */
                    rc = RxVIMSetABEntryAttributes(addrBkPtr,epos,'','itemdesc')
                    if (rc > 0) then call vimerr

                end  /* Do */

                /* Close the address book */
                rc = RxVIMCloseAddressBook(addrBkPtr)
                if (rc > 0) then call vimerr

             end  /* Do */
          otherwise
          end  /* select */

          if more = 'False' then do
             Say 'All Address Books have been retrieved'
             action = 'X'
          end  /* Do */

     end /* do */

/* Close the session with the postoffice */
rc = RxVIMCloseSession(Session)
if (rc > 0) then call vimerr


/* Terminate the active VIM subsystem connection */
rc = RxVIMTerminate()
if (rc > 0) then call vimerr
signal done


/***** VIMErr *******/

/* If an error occurs, this function will return the text */
/* associated with the error.  Extended text may be       */
/* displayed if it exists for the specified error.        */

VIMERR:

erc = RxVIMStatusText(Session,rc,'Status')
Say
Say '|-Error Information ------------------------------------|'
Say '  Error Text -' status.1
Say
Say '  Ext Status -' status.2
rc = RxVIMTerminate()
signal done


/* The done section will unload the RexxVIM extensions */
/* and exit the program                                */
DONE:
/*** Drop all of the external functions ***/
call RxVIMDropFuncs
Say '|-------------------------------------------------------|'
Say 'Demo Complete.  All functions released'
'pause'
exit
