/*REXX*/

  /***
  signal on HALT    name HaltExit
  signal on ERROR   name ErrorExit
  signal on FAILURE name FailureExit
  signal on SYNTAX  name SyntaxExit
  ***/

main:
parse arg p1
  sGlobal.fDebug  = 'N'
  fDebugQ  = sGlobal.fDebug
  fDispStax= 'N'
  fDispHelp= 'N'

  CALL rParseParms p1

  if fDebugQ = 'Y' then
   do
    trace ?r
   end

  if fDispStax = 'Y' then
   do
    CALL rDispSyntax 0, 0
   end

  if fDispHelp = 'Y' then
   do
    CALL rDispSyntax 1, 0
   end

  /* Actual routine */
  rc   = rLoadFuncs('SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs')
  if rc <> 0 then
   do
    Call rSiren 1, 1
    say 'REMOVE - Unable to initialize the "REXXUTIL" subsystem'
    exit 8
   end

  testrc = rTestRXPD()

  sysinirc = SysIni('USER','HSS.PDS','DELETE:')

  say ''
  say 'The PDS package has been removed from the OS/2 system files.'
  say ''
  say 'The removal of the rest of the "Panel Display System" requires that'
  say 'the "HSSPD.DLL" library be deleted. How it is deleted is dependent'
  say 'upon how it was installed. If this library was copied from the PDS'
  say 'installation directory then delete the library from the directory which'
  say 'contains the copy.'
  say ''
  say 'If this library was installed by adding the PDS installation directory'
  say 'to the LIBPATH statement in CONFIG.SYS, then remove the installation'
  say 'directory from that statement.'
  say ''
  say 'If the PDS installation directory was added to the DPATH statement in'
  say 'CONFIG.SYS then simply remove it from that statement.'
  say ''
  say 'If any REXX PDS sample script has been executed or if any PDS program'
  say 'is currently executing since this OS/2 system was last IPLed, then it'
  say 'may be necessary to reIPL this system in order to delete the "HSSPD.DLL"'
  say 'library and installation directory.'
  if testrc = 0 then
   do
  say ''
  say 'Tests indicate that a REXX PDS script was/is executing.'
   end
  else
   do
  say ''
  say 'Tests indicate that a REXX PDS script has not been executed and it'
  say 'should be possible to delete the PDS library an installation directory.'
   end
  say ''

  exit 0

HaltExit:
  Call BEEP 882, 40
  Call BEEP 882, 40
  say 'REMOVE processing halted by request;'
  exit 0

ErrorExit:
  Call BEEP 882, 40
  Call BEEP 882, 40
  say 'REMOVE processing failed due to unknown error;'
  exit 24

FailureExit:
  Call BEEP 882, 40
  Call BEEP 882, 40
  say 'REMOVE processing failed due to unknown failure;'
  exit 32

SyntaxExit:
  Call BEEP 882, 40
  Call BEEP 882, 40
  say 'REMOVE processing failed due to syntax error;'
  exit 64

rParseParms:
parse arg p1

  do Forever
   w1 = word(p1,1)
   parse var w1 with "/" f1 ":" v1
   select
    when (w1 = '') then
     do
      return 0
     end
    when TRANSLATE(w1) = '/DEBUG' then
     do
      fDebugQ='Y'
      p1 = SUBWORD(p1,2)
     end
    when TRANSLATE(f1) = 'D' then
     do
      fDebugQ = TRANSLATE(v1)
      p1 = SUBWORD(p1,2)
     end
    when TRANSLATE(f1) = '?' then
     do
      fDispStax='Y'
      fDispHelp='N'
      p1 = SUBWORD(p1,2)
     end
    when TRANSLATE(f1) = 'H' then
     do
      fDispStax='N'
      fDispHelp='Y'
      p1 = SUBWORD(p1,2)
     end
    otherwise
     do
      select
       when TRUE = FALSE then
        do
        end
       otherwise
        do
         Call rSiren 8, 1
         say 'REMOVE - Too many parms specified; Parm "'w1'" unknown;'
         CALL rDispSyntax 0 8
        end
      end /*select*/
     end
   end
  end

  return 0

rDispSyntax: Procedure
parse upper arg iHelp iExit

  say ' Syntax  : REMOVE '
  say '           REMOVE {/?|/h}'
  if iHelp > 0 then
   do
    CALL rDispHelp
   end

  exit iExit

rDispHelp: Procedure

  say ' Parms   : *N/A*      - No parms apply.'
  say ''
  say ' Options : /?         - Display command syntax.'
  say '           /h         - Display this help info.'
  say ' Examples:'
  say '    REMOVE /h'
  say ' '
  say '    REMOVE'

  return ''

/* rSiren: does the siren bit by running the scale based upon a       */
/*    frequency specified by the caller.                              */
rSiren: Procedure
   Parse Arg freq, cycle
   note.1 = 262 * freq /* middle C */
   note.2 = 294 * freq /* D */
   note.3 = 330 * freq /* E */
   note.4 = 349 * freq /* F */
   note.5 = 392 * freq /* G */
   note.6 = 440 * freq /* A */
   note.7 = 494 * freq /* B */
   note.8 = 524 * freq /* C */
   do j = 1 to cycle
    call beep note.8,250 /* hold each note for a 1/4 second */
    call beep note.1,250 /* hold each note for a 1/4 second */
   end j
   Return

rLoadFuncs:
parse arg sREP, sDll, sRtn
  rxrc = RxFuncAdd(sREP, sDll, sRtn)
  signal on syntax name xTrapFuncs
  interpret 'Call 'sRtn
  return 0

rTestRXPD:
  signal on syntax name xTrapFuncs
  CALL rxPDZVarDefine 'ZENTER'
  return 0

xTrapFuncs:
  return 127
