/* FRANCAIS.CMD - Installation de CLOCK en franais. */

'@Echo Off'

/* Chargement de REXXUTIL */

Call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs'
Call SysLoadFuncs


/* Initialisations */
 
Signal On Failure Name FAILURE
Signal On Halt Name HALT
Signal On Syntax Name SYNTAX

Call SysCls
Say 'Installation de l'D2C(39)'horloge...'
Say ''


/* Vrification de l'existance des diffrents fichier ncessaires */

Language = 'FRANCAIS'

Result = SysFileTree( 'CLOCK.EXE', 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'Erreur : CLOCK.EXE introuvable !'
  Signal DONE
  End

Result = SysFileTree( Language".DLL", 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'Erreur : 'Language'.DLL introuvable !'
  Signal DONE
  End

Result = SysFileTree( Language".HLP", 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'Erreur : 'Language'.HLP introuvable !'
  Signal DONE
  End

/* Saisie par l'utilisateur du rpertoire destination */
 
Say 'Veuillez entrer le nom complet du rpertoire o l'D2C(39)'horloge doit'
Say 'tre installe (par dfaut, C:\OS2\APPS) : '
Pull Directory
If Directory = "" Then Directory = 'C:\OS2\APPS'


/* Cration du rpertoire destination si ncessaire */

Result = SysFileTree( Directory, 'Dirs', 'D' )
If Dirs.0 = 0 Then
  Do
  Result = SysMkDir( Directory )
  if Result == 0 Then
    Do
    End
  Else
    Do
    Say 'Erreur : impossible de crer le rpertoire destination.'
    Signal DONE
    End
  End
Say ''


/* Saisie par l'utilisateur du dossier destination. */

Say 'Dsirez-vous ajouter l'D2C(39)'horloge au dossier de lancement ? (O/N) '
Pull YesNo
If YesNo = "O" Then
  Do
  Folder = '<WP_START>'
  Say 'L'D2C(39)'objet sera plac dans le dossier de lancement.'
  End
Else
  Do
  Folder = '<WP_DESKTOP>'
  Say 'L'D2C(39)'objet sera plac sur le bureau.'
  End
Say ''


/* Installation */

Say 'Copie de l'D2C(39)'horloge vers ' Directory '...'
Copy CLOCK.EXE Directory                  '1>NUL'
Copy Language".DLL" Directory"\CLOCK.DLL" '1>NUL'
Copy Language".HLP" Directory"\CLOCK.HLP" '1>NUL'

Say 'Cration de l'D2C(39)'objet programme...'
Type = 'WPProgram'
Title = 'Horloge'
Parms = 'MINWIN=DESKTOP;PROGTYPE=PM;EXENAME='Directory'\CLOCK.EXE;STARTUPDIR='Directory';OBJECTID=<CLOCK>;NOPRINT=YES;'
Result = SysCreateObject( Type, Title, Folder, Parms, 'ReplaceIfExists' )
 
If Result = 1 Then
  Say 'Objet cr ! Termin.'
Else             
  Say 'Erreur : l'D2C(39)'objet n'D2C(39'a pas pu tre cr.'

Signal DONE

FAILURE:
Say 'chec REXX.'
Signal DONE

HALT:
Say 'Halte REXX.'
Signal DONE

SYNTAX:
Say 'Erreur de syntaxe REXX.'
Signal DONE

DONE:
Exit
