/*
Below is a sample implementation of the SmartLog 3.0 similar to the demo
program. It can be pasted directly to your application and modified
to your needs. For more information see the Norton Guides documentation.
*/

#include "smartlog.ch"

   SMARTLOG INSTALL NOVLIB                                       ;
       FILE "error.log"                                          ;
       PATH "(application's .EXE path goes here)"                ;
       HEADER "SmartLog(tm) log file for runtime Clipper errors" ;
       MESSAGE "If this error persists contact;" +               ;
               " the developer of this application."             ;
       BREAK      OFF          ;
       PRINT      OFF          ;
       CREATE     OFF          ;
       RETRY      ON           ;
       SUBSTITUTE OFF          ;
       DEFAULT    OFF          ;
       TOFILE     ON           ;
       STRUCTURE  ON           ;
       SCREEN     ON           ;
       AUTOEXEC   ON           ;
       INFORM     ON           ;
       SHADOW     ON           ;
       BOXCOLOR  "r/w"         ;
       MENUCOLOR "w/b"         ;
       VIEWCOLOR "b/w"         ;
       TONE {|| TONE(150, 5) } ;
       CUSTOM NIL              ;
       INITBLOCK {|| NIL }     ;
       EXITBLOCK {|| NIL }

/* If the above looks complicated, note that SL can be called
with NO PARAMETERS at all, default values will then be used
for all parameters. For a list of defaults see the documentation.
Here is a "bare-bone" installation: */
   
   SMARTLOG INSTALL NOVLIB
   
/* Here's a typical SmartLog installation command used for production
(end-user) systems. It uses a combination of character strings, string
constants and code blocks to record custom statistics. */

 SMARTLOG INSTALL NOVLIB                      ; // install SmartLog with NovLib support
   HEADER  "ERROR LOG FILE FOR " + pAPP_NAME  ; // header for error file identifies application
   MESSAGE "Contact Joe Smart at ext. 1234;" +; // custom message if error detected
           "or fax log to CIS dept."          ;
   BREAK ON PRINT ON RETRY OFF                ; // turn selected menu options on/off
   CUSTOM  ;                                    // start CUSTOM:
     "   System: " + pAPP_NAME, ;               // application name (preprocessed)
     "  Version: " + pAPP_VERSION, ;            // application version (preprocessed)
     " Serial #: " + pAPP_SERIAL, ;             // application serial number (preprocessed)
     {|| "User name: " + GetUser()}, ;          // user name (UDF function in code block)
     {|| "Security: " + GetSecurity() }, ;      // security level (UDF function in code block)
     {|| "Blinker Version: " + ;                // Blinker version used
         STR(BLIVERNUM()/100, 4, 2) }, ;
     " FUNCky Version: 2.02", ;                 // funcky version, simple char (no function available)
     {|| " NovLib Version: " + NovLibVer() }, ; // NovLib version
     {|| IIF(SWPRUNCMD("mem /c > mem.log",60),; // complex code block logging output from
         MEMOREAD("mem.log"), ;                 // DOS MEM command called thru Blinker's
         "SL: Error running MEM.EXE!!!" ) }     // shell function (or error message)


//** end of: sample.prg **//
