/*
 * File......: PEEKWORD.C
 * Author....: David Pearson
 * BBS.......: The Dark Knight Returns
 * Net/Node..: 050/069
 * User Name.: Dave Pearson
 * Date......: 30/03/93
 * Revision..: 1.0
 *
 * This is an original work by Dave Pearson and is placed in the public
 * domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */

#include "GT_Mem.H"
#include <Extend.H>

/*
 *  $DOC$
 *  $FUNCNAME$
 *      GT_PEEKW()
 *  $CATEGORY$
 *      Memory
 *  $ONELINER$
 *      Return the contents of a word in memory.
 *  $SYNTAX$
 *      GT_PeekW(<nSegment>,<nOffset>) --> nWord
 *  $ARGUMENTS$
 *      <nSegment> is the segment of the word in memory.
 *
 *      <nOffset> is the offset of the word in memory.
 *  $RETURNS$
 *      The numeric content of the specified word in memory.
 *  $DESCRIPTION$
 *      GT_PeekW() can be used for getting numeric word values from
 *      specific locations in memory.
 *  $EXAMPLES$
 *      // Check if this machine as a floppy drive.
 *
 *      nEquipment := GT_PeekW(^b64,16^B)
 *      if GT_And(nEquipment,1) != 0
 *         ? "Machine has a floppy drive."
 *      else
 *         ? "Machine does not have a floppy drive."
 *      endif
 *  $SEEALSO$
 *      GT_PEEKB()
 *  $END$
 */

CLIPPER GT_PeekW()
{
        if (PCOUNT == 2 && ISNUM(1) && ISNUM(2))
        {
                _retni((unsigned int)_GT_peek(_parnl(1),_parnl(2)));
        }
        else
        {
                _retni(0);
        }
}
