/*
    File......: GT_Shadow.prg
    Author....: Martin Bryant
    BBS.......: The Dark Knight Returns
    Net/Node..: 050/069
    User Name.: Martin Bryant
    Date......: 04/02/93
    Revision..: 1.0

    This is an original work by Martin Bryant and is placed
    in the public domain.

    Modification history:
    ---------------------

    Rev 1.0 04/02/93
    PD Revision.
*/

/*  $DOC$
 *  $FUNCNAME$
 *      GT_SHADOW()
 *  $CATEGORY$
 *      Video
 *  $ONELINER$
 *      Function to display a shadow around a box
 *  $SYNTAX$
 *      GT_Shadow(<nTop>,<nLeft>,<nBottom>,<nRight>) -> lSuccess
 *  $ARGUMENTS$
 *      <nTop>,<nLeft>,<nBottom> and <nRight> are the
 *      co-ordinates of the box. The shadow will be drawn
 *      two spaces below and to the right.
 *  $RETURNS$
 *      GT_Shadow() returns logical success.
 *  $DESCRIPTION$
 *      Function to display a shadow to the bottom and
 *      right of a box.
 *  $EXAMPLES$
 *      GT_Shadow(10,05,15,20)
 *  $SEEALSO$
 *
 *  $INCLUDE$
 *
 *  $END$
 */

#include "GT_LIB.ch"

#define SHADOW  CHR(08)

FUNCTION GT_Shadow(nTop,nLeft,nBottom,nRight)

LOCAL cTemp := ''
LOCAL lSuccess := .F.
LOCAL nCount := 0

Default nTop to -1
Default nLeft to -1
Default nBottom to -1
Default nRight to -1

// Adjust
nTop ++
nLeft += 2
nRight += 2
nBottom ++

IF nBottom <= MAXROW() .AND. nRight <= MAXCOL()

    // Horizontal line
    FOR nCount := nLeft TO nRight

        cTemp := SUBSTR(SAVESCREEN(nBottom,nCount,nBottom, ;
            nCount),1,1) + SHADOW
        RESTSCREEN(nBottom,nCount,nBottom,nCount,cTemp)

    NEXT

    nRight --

    // Vertical lines
    FOR nCount := nTop TO nBottom
        cTemp := SUBSTR(SAVESCREEN(nCount,nRight,nCount, ;
            nRight),1,1) + SHADOW
        RESTSCREEN(nCount,nRight,nCount,nRight,cTemp)
    NEXT
    nRight ++
    FOR nCount := nTop TO nBottom
        cTemp := SUBSTR(SAVESCREEN(nCount,nRight,nCount, ;
            nRight),1,1) + SHADOW
        RESTSCREEN(nCount,nRight,nCount,nRight,cTemp)
    NEXT

    lSuccess :=.T.

ENDIF

/*
    End of GT_Shadow()
*/
RETURN(lSuccess)
