/*
    File......: GT_File2.prg
    Author....: Martin Bryant
    BBS.......: The Dark Knight Returns
    Net/Node..: 050/069
    User Name.: Martin Bryant
    Date......: 04/02/93
    Revision..: 1.0

    This is an original work by Martin Bryant and is placed
    in the public domain.

    Modification history:
    ---------------------

    Rev 1.0 04/02/93
    PD Revision.
*/


/*  $DOC$
 *  $FUNCNAME$
 *      GT_FILE2A()
 *  $CATEGORY$
 *      Array
 *  $ONELINER$
 *      Convert a text file to an array
 *  $SYNTAX$
 *      GT_File2a(<cFile>,[<aData>]) -> aData
 *  $ARGUMENTS$
 *      <cFile> is the name (including any path and
 *      extension) of the text file to read from.
 *
 *      <aData> is an array to use to put the data into
 *      added.
 *  $RETURNS$
 *      GT_File2a() returns an array.
 *  $DESCRIPTION$
 *      To read a text file in line by line and build an
 *      array of the text, one line for each array element.
 *  $EXAMPLES$
 *      // Build a new array
 *      aData := GT_File2a('C:\Import.txt')
 *
 *      // And add some more ....
 *      aData := GT_File2a('C:\Import2.txt',aData)
 *  $SEEALSO$
 *
 *  $INCLUDE$
 *
 *  $END$
 */

#include "GT_LIB.ch"

//  64K max data size
#define MAXFILELEN  (64 * 1024)

FUNCTION GT_File2a(cFile,aData)

Local cData := ''
Local nHandle := 0
Local nLineLen := 0
Local nPos := 0
Local nMaxLen := 0

Default cFile To ''
Default aData To {}

BEGIN SEQUENCE

    // Found ?
    IF .NOT. FILE(cFile)
        BREAK(NIL)
    ENDIF

    // Open for read only
    nHandle := FOPEN(cFile,0)
    IF nHandle < 0
        BREAK(NIL)
    ENDIF

    // Read
    cData := FREADSTR(nHandle,MAXFILELEN)
    nPos := AT(CRLF,cData)

    DO WHILE nPos > 0

        AADD(aData,SUBSTR(cData,1,nPos-1))
        cData := SUBSTR(cData,nPos+2)

        // Complete line ?
        nPos := AT(CRLF,cData)

    ENDDO

END SEQUENCE

// Reset
FCLOSE(nHandle)

/*
    End of GT_File2a()
*/
RETURN(aData)
