/*
    File......: GT_Append.prg
    Author....: Martin Bryant
    BBS.......: The Dark Knight Returns
    Net/Node..: 050/069
    User Name.: Martin Bryant
    Date......: 11/02/93
    Revision..: 1.0

    This is an original work by Martin Bryant and is placed
    in the public domain.

    Modification history:
    ---------------------

    Rev 1.0 11/02/93
    PD Revision.
*/

/*  $DOC$
 *  $FUNCNAME$
 *      GT_APPEND()
 *  $CATEGORY$
 *      General
 *  $ONELINER$
 *      Append a blank record to a DBF file. It is also locked.
 *  $SYNTAX$
 *      GT_Append([<nTimeout>],[<nPause>]) -> lSuccess
 *  $ARGUMENTS$
 *  $RETURNS$
 *      lSuccess
 *  $DESCRIPTION$
 *      Append a blank record to a DBF file. It is also locked.
 *  $EXAMPLES$
 *      // Add new, default waiting values
 *      IF .NOT. GT_Append()
 *          ? 'Error'
 *      ENDIF
 *  $SEEALSO$
 *
 *  $INCLUDE$
 *
 *  $END$
 */

*/
#include "GT_LIB.ch"

#define HEIGHT  06
#define WIDTH   16

FUNCTION GT_Append(nSeconds,nPause)

LOCAL cScreen := ''
LOCAL lMessage := .F.
LOCAL lSuccess := .F.
LOCAL nBottom := INT((MAXROW() + HEIGHT)/2)
LOCAL nKey := 0
LOCAL nLeft := INT((MAXCOL() - WIDTH)/2)
LOCAL nRight := nLeft - WIDTH
LOCAL nTop := nBottom - HEIGHT

Default nSeconds to 120
Default nPause to 0.5

DO WHILE nSeconds > 0 .AND. (.NOT. lSuccess) .AND. ;
    (nKey != K_ESC)

    // Attempt append
    DBAPPEND()
    lSuccess := .NOT. NetErr()

    IF .NOT. lSuccess

        // Message ?
        IF .NOT. lMessage

            // Save
            cScreen := SAVESCREEN(nTop,nLeft,nBottom,nRight)

            // Display
            GT_Window(nTop,nLeft,nBottom,nRight,BOX_SS, ;
                NIL,'Appending ....',.T.)

            // Position for message
            @ nTop+02, nLeft+02 SAY 'Timeout:'
            @ nTop+04, nLeft+02 SAY PADC('EscExit',WIDTH-03)

            lMessage := .T.

        ENDIF

        @ nTop+02, nLeft+09 SAY PADR(INT(nSeconds),3)

        // Wait
        nKey := INKEY(nPause)
        nSeconds -= nPause

    ENDIF

ENDDO

IF lMessage
    RESTSCREEN(nTop,nLeft,nBottom,nRight,cScreen)
ENDIF

/*
    End GT_Append()
*/
RETURN(lSuccess)

