/*
 * GT CLIPPER STANDARD HEADER
 *
 * File......: argv.c
 * Author....: Andy M Leighton
 * BBS.......: The Dark Knight Returns
 * Net/Node..: 050/069
 * User Name.: Andy Leighton
 * Date......: $Date$
 * Revision..: $Revision$
 *
 * This is an original work by Andy Leighton and is placed in the
 * public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */

/*
 *  $DOC$
 *  $FUNCNAME$
 *      GT_ARGV()
 *  $CATEGORY$
 *      Environment
 *  $ONELINER$
 *      Returns a command line parameter
 *  $SYNTAX$
 *      GT_argv(<nParam>) --> cParam
 *  $ARGUMENTS$
 *      <nParam>  -  The number of the parameter on the command line
 *  $RETURNS$
 *      <cParam>  -  The parameter asked for
 *  $DESCRIPTION$
 *      Return a command line parameter
 *      Reads the C startup variable to find the specified parameter.
 *
 *      If <nParam> == 0, the function will return the name of the EXE
 *      including it's path on non-prehistoric DOSes.
 *  $EXAMPLES$
 *      local i
 *
 *      for i := 0 to GT_Argc()
 *          ? "Parameter N " + str(i, 2) + " = " + GT_Argv(i)
 *      next
 *  $CAVEATS$
 *      Does not check <nParam> is a valid parameter.
 *  $END$
 */

#include "extend.h"
extern char **__argv;

CLIPPER
GT_argv()
{
  _retc(__argv[_parni(1)]);
}
