#include "fast.ch"
#include "inkey.ch"



/********************************************************************
*      Fast Library For Clipper Demo Program
*
*      (c) 1992-94 Manu Roibal
*
*      Compile with : clipper demo /A /M /N /W
*
*      Link with rtlink      : tlink FI demo LIB fast, apistd
*                blinker < 3 : blinker FI demo LIB fast, apistd
*                blinker 3   : blinker FI demo LIB fast, apibli
*                exospace    : exospace FI demo LIB fast PAC int10, mouse
*/


Function Main()
Local nX := Col ()
Local nY := Row ()
Local cColor  := SetColor()
Local nCursor := SetCursor( 0 )
Local nInd
Local aE

    SET DATE TO AMERICAN
    Set ( _SET_SCOREBOARD, .F. )
    SetColor ( "W+/B" )
    BoxWarning( { "Fast Library For Clipper", ;
                  "", ;
                  "The best library ever created for Clipper", ;
                  "", ;
                  "(C) 1992-94 Manu Roibal", ;
                  "", ;
                  "De omni re scibili et quibusdam aliis" } )
    AplicName( "FAST.lib for CA-Clipper demo program" )
    DemoScreen( .T. )
    Banner()
    DemoScreen( .F. )
    aE := GaugeNew ( 8, "Fast Library For Clipper. L'enfant Terrible", "B" )
    For nInd := 1 To 30
      GaugeUpdate( aE, 1 / 30 )
      Delay( 0.01 )
    Next
    SetFont ( "Roman.Fon" )
    Screen ( "", "B+/B" )
    Clock( .T., 0, 71, "B+/B" )
    BoxWarning( "To register, read the file REGISTER.DOC" )
    SetColor ( "N/BG,N/W" )
    NewBox ( 3, 22, 22, 59, "Fast Library Demo Program", "ͻȺ ", .T. )
    @  4, 59 SAY CHR( 24 )
    @ 21, 59 SAY CHR( 25 )
    aChoice ( 5, 25, 21, 56, ;
              { " 1. Clipper GIF decoder", ;
                " 2. PCX in EGA-VGA", ;
                " 3. Calculator", ;
                " 4. Autodesk FLI animations!!!", ;
                " 5. Calendar", ;
                " 6. Serpent game", ;
                " 7. Screen Saver", ;
                " 8. Clipper Notes", ;
                " 9. 3D Graph Bar Demo", ;
                "10. 3D Graph Bar Demo", ;
                "11. 3D Graph Bar Demo", ;
                "12. 3D Graph Bar Demo", ;
                "13. 3D Graph Bar Demo", ;
                "14. 3D Graph Bar Demo", ;
                "15. 3D Graph Line Demo", ;
                "16. 3D Graph Zone Demo", ;
                "17. 3D Graph Tart Demo", ;
                "18. 3D Graph Ellipse Demo", ;
                "19. File Manager", ;
                "20. Backup", ;
                "21. Restore", ;
                "22. Window System Demo", ;
                "23. Directory Structure", ;
                "24. Load INI files", ;
                "25. Load and modify INI files", ;
                "26. A little Text Editor", ;
                "27. Windows with light focus", ;
                "28. Get Password", ;
                "29. Encrypt string", ;
                "30. Deencrypt string", ;
                "31. Graphics Demo", ;
                "32. Choose Color", ;
                "33. Keyboard demo", ;
                "34. Menu System Demo", ;
                "35. System information", ;
                "36. Mouse demo", ;
                "37. Font Editor", ;
                "38. Footing with Clipper", ;
                "39. Big Clock", ;
                "40. Puzzle", ;
                "41. A mini debugger", ;
                "42. Ascii Table", ;
                "43. A message with scroll", ;
                "44. Sound Blaster demo", ;
                "45. Parallel DAC demo", ;
                "46. Speaker demo", ;
                "47. New Memo edit function", ;
                "48. More Speed please", ;
                "49. Fast Icons", ;
                "50. CD Audio Support!!!", ;
                "51. GraySumming", ;
                "52. Caos", ;
                "53. Make your own debugger" }, ;
              .T., "USERFUNC" )
    DemoScreen ( .F. )
    SetPos ( nY, nX )
    SetColor ( cColor )
    SetCursor ( nCursor )
    SetFont ( "Standard.Fon" )
Return ( Nil )


Function UserFunc ( nMode, nElement, nRel )
Local aScr
Local nRet   := 2
Local nInd
Local cMemo  := "To be or not to be, that's the fastquestion"
Local cColor
    If Lastkey () == K_ESC
      If BoxQuery( "Are you sure you want to exit to DOS?", 20 )
        Return( 0 )
      Else
        Return( 32 )
      EndIf
    ElseIf Lastkey () == K_RETURN
      aScr := SaveScr ( , , , , 1 + nRandom ( 3 ) )
      DemoScreen ( .F. )
      Do Case
        Case nElement == 1
          SetVGA256()
          If GIFShow256( "demo.gif" )
            rCursorOn()
            rInkey( 0 )
            rCursorOff()
            Degrade( GetPalette() )
          EndIf
          TxtMode()
          SetBlink(.F.)
        Case nElement == 2
          PCXDemo()
        Case nElement == 3
          Calculator ( "N/W", "G+/N", "R+/N" )
        Case nElement == 4
          FliEver( "fast.fli" )
        Case nElement == 5
          Calendar ( 5, 20, "N/BG", "R/BG", "GR+/B" )
        Case nElement == 6
          Serpent ( "W+/B*", "R+/B*", "G+/B*" )
        Case nElement == 7
          ScreenSave ( "BG+/N", "Fast Library For Clipper. (C) 1994 Manu Roibal" )
        Case nElement == 8
          Notes( "W/B,N/BG", "W/B,N/BG,G/B,W/B,R+/B", "HojaCalc.hc" )
        Case nElement == 9
          BarDemo( 0 )
        Case nElement == 10
          BarDemo( 1 )
        Case nElement == 11
          BarDemo( 2 )
        Case nElement == 12
          BarDemo( 3 )
        Case nElement == 13
          Graph2Demo()
        Case nElement == 14
          Graph3Demo()
        Case nElement == 15
          GraphLineDemo( 1 )
        Case nElement == 16
          GraphLineDemo( 2 )
        Case nElement == 17
          TartDemo()
        Case nElement == 18
          EllipseDemo ()
        Case nElement == 19
          Manager ( "N/W,N/BG", "N/BG", "*.prg" )
        Case nElement == 20
          Backup ( Date (), Time (), "Root", "A:\", ;
                   { { "C:\DOS\",      "*.*"   }, ;
                     { "C:\OS2\MDOS\", "*.COM" } }, ;
                   .T., "N/W,N/W" )
        Case nElement == 21
          Restore ( "A:\", { "D:\DOS" }, "N/W,N/W" )
        Case nElement == 22
          DemoWindows ()
        Case nElement == 23
          TreeDemo ( "C:\", "\*.*" )
        Case nElement == 24
          LoadIniFile( "FAST", "MANU", "CPUTYPE" )
        Case nElement == 25
          ChangeIniFile( "FAST", "MANU", "TIMESLIZE" )
        Case nElement == 26
          Editor ( "Fast.Ini", "W/B" )
        Case nElement == 27
          DemoFocus()
        Case nElement == 28
          GivePass()
        Case nElement == 29
          TopSecret()
        Case nElement == 30
          TopSecret()
        Case nElement == 31
          GraphDemo()
        Case nElement == 32
          SetBlink( .F. )
          cColor := ChooseColor()
          If cColor != Nil
            BoxWarning( "The selected color is: "+ cColor )
          EndIf
        Case nElement == 33
          KeyDemo()
        Case nElement == 34
          Menues ()
        Case nElement == 35
          ClipMem()
        Case nElement == 36
          DemoMouse()
        Case nElement == 37
          FontEdit( "cubo.fon" )
        Case nElement == 38
          Footing()
        Case nElement == 39
          BigClock()
        Case nElement == 40
          BoxWarning( "The winner is... " + If( Puzzle( , , "W" ), "the User", "the Computer" ) )
        Case nElement == 41
          MiniDebug( 7, "Replicate( 'Fast ', 2 )" )
        Case nElement == 42
          AsciiTab()
        Case nElement == 43
          MsgScroll( 10, 20, 30, "Fast Library For Clipper, the best Clipper extender", "GR+/B" )
        Case nElement == 44
          If sbInit()
            sbVocPlay ( "Fast.voc", 8192 )
          EndIf
        Case nElement == 45
          If BoxQuery( "Do you have a Parallel DAC in LPT2?", 20 )
            dacPort( 2 )
            dacVocPlay( "Fast.voc", 8192 )
         EndIf
        Case nElement == 46
          spkVocPlay( "Fast.voc", 8192 )
        Case nElement == 47
          cMemo := FastMemo( 10, 10, 20, 60, cMemo, "Demo", "W+/B", .T., .T. )
        Case nElement == 48
          MoreSpeed()
        Case nElement == 49
          DemoIcons()
        Case nElement == 50
          cdDemo()
        Case nElement == 51
          GraySumming()
        Case nElement == 52
          Caos()
        Case nElement == 53
          MyDebugger()
      EndCase
      SetFont ( "Roman.Fon" )
      SetCursor ( 1 )
      SetCursor ( 0 )
      RestScr ( , , , , aScr )
    ElseIf LastKey () == K_ESC
      nRet := 0
    EndIf
Return ( nRet )


Function DemoScreen ( lModo )
Static cScr
    If lModo
      cScr := SaveScreen ( 0, 0, MaxRow(), MaxCol() )
    Else
      Return ( Implode ( 0, 0, MaxRow(), MaxCol(), cScr ) )
    EndIf
Return ( Nil )


Function GivePass()
Local cScreen := SaveScreen ( 0, 0, 24, 79 )
Local nCursor := SetCursor ( 0 )
Local cColor  := SetColor ( "W+/B" )
    NewBox ( 5, 5, 9, 74, "Security", "ͻȺ ", .T. )
    GetPass ( 7, 12, "Input your access key (15 letters Max.):", 15 )
    SetColor ( cColor )
    SetCursor ( nCursor )
    Implode ( 0, 0, 24, 79, cScreen )
Return ( Nil )


Function TopSecret()
Local cScreen  := SaveScreen ( 0, 0, 24, 79 )
Local nCursor := SetCursor ( 0 )
Local cColor  := SetColor ( "W+/B" )
Local cEncrip
Local cDeEncrip
    NewBox ( 5, 5, 10, 74, "De/Encrypt", "ͻȺ ", .T. )
    cEncrip := Encrypt( "Manu Roibal", "Password" )
    Message ( 7, 12, "<Manu Roibal> -> encrypt -> " + cEncrip )
    cDeEncrip := DeEncrypt( cEncrip, "Password" )
    Message ( 8, 12, "<" + cEncrip + "> -> deEncrypt -> " + cDeEncrip )
    Inkey (0)
    SetColor ( cColor )
    SetCursor ( nCursor )
    Implode ( 0, 0, 24, 79, cScreen )
Return ( Nil )


Function TreeDemo ( cDisk, cMask )
Local cScreen  := SaveScreen ( 0, 0, 24, 79 )
Local nCursor := SetCursor ( 0 )
Local cColor  := SetColor ( "W+/B,N/W" )
Local aDisk   := DirTree ( cMask, cDisk )
    Window ( 4, 0, 22, 29, "Directory " + cDisk, "ͻȺ ", .T. )
    Achoice ( 5, 2, 21, 27, aDisk, .T. )
    SetColor ( cColor )
    SetCursor ( nCursor )
    Implode ( 0, 0, 24, 79, cScreen )
Return ( Nil )


Function DemoWindows ()
Local aColor := { "N/BG", "W+/R", "R/W",  "G/W",  "B/W",  "W/B", ;
                  "G+/W", "W+/G", "BG/N", "N/BG", "R+/B", "GR+/N" }
Local nType
Local cColor
Local nInd := 0
Local nX1  := 0
Local nY1  := 0
Local nX2  := 0
Local nY2  := 0
Local aScr := {}
Local cScr := ""
    For nInd := 1 To 25
      nX1 := nRandom ( 77 ) + 1
      nY1 := nRandom ( 22 ) + 1
      nX2 := nRandom ( 77 - nX1 ) + nX1 + 1
      nY2 := nRandom ( 22 - nY1 ) + nY1 + 1
      cColor  := aColor [ nRandom ( 11 ) + 1 ]
      nType := nRandom ( 3 ) + 1
      If nX2 - nX1 < 22
        nType := 4
      EndIf
      If nType == 1
        If Seconds () % 2 == 0
          Window ( nY1, nX1, nY2, nX2, "Window with shadow", "ͻȺ ", .T., cColor )
        Else
          NewBox ( nY1, nX1, nY2, nX2, "NewBox with shadow", "ͻȺ ", .T., cColor )
        EndIf
      ElseIf nType == 2
        If Seconds () % 2 == 0
          Window ( nY1, nX1, nY2, nX2, "Window without shadow", "ͻȺ ", .F., cColor )
        Else
          NewBox ( nY1, nX1, nY2, nX2, "NewBox without shadow", "ͻȺ ", .F., cColor )
        EndIf
      ElseIf nType == 3
        Wall ( nY1, nX1, nY2, nX2, cColor )
      Else
        If Seconds () % 2 == 0
          Window ( nY1, nX1, nY2, nX2, , "ͻȺ ", .T., cColor )
        Else
          NewBox ( nY1, nX1, nY2, nX2, , "ͻȺ ", .T., cColor )
        EndIf
      EndIf
    Next
    Inkey(5)
    Stars()
    cScr := SaveScreen ( 0, 0, 24, 79 )
    Fascinate( "G", "BG" )
    Inkey(0)
    aScr := SaveScr ( , , , , 1 )
    RestScreen ( 0, 0, 24, 79, cScr )
    RestScr ( , , , , aScr )
    aScr := SaveScr ( , , , , 2 )
    RestScreen ( 0, 0, 24, 79, cScr )
    RestScr ( , , , , aScr )
    aScr := SaveScr ( , , , , 3 )
    RestScreen ( 0, 0, 24, 79, cScr )
    RestScr ( , , , , aScr )
    aScr := SaveScr ( , , , , 4 )
    RestScreen ( 0, 0, 24, 79, cScr )
    RestScr ( , , , , aScr )
Return ( Nil )


Function LoadIniFile( cFile, cApplication, cData )
Local cValue
Local cScreen  := SaveScreen ( 0, 0, 24, 79 )
Local aIniFile := IniLoad ( cFile, cApplication )
    cValue := IniSearch( aIniFile, cData, "386SX" )
    Window ( 9, 15, 16, 64, "Configuration", "ͻȺ ", .T., "N/BG" )
    Message ( 11, 20, "The .Ini shows CPU Type -> " + cValue, "N/BG" )
    Message ( 12, 20, "Default value is        -> 386SX" , "N/BG" )
    Message ( 14, 20, "For more information read Fast.ini", "N/BG" )
    Inkey ( 0 )
    Implode ( 0, 0, 24, 79, cScreen )
Return ( Nil )


Function ChangeIniFile( cFile, cApplication, cData )
Local cValue
Local cNew
Local cScreen  := SaveScreen ( 0, 0, 24, 79 )
Local aIniFile := IniLoad ( cFile, cApplication )
    cValue := IniSearch( aIniFile, cData, "50" )
    Window ( 9, 15, 16, 64, "Configuration", "ͻȺ ", .T., "N/BG" )
    Message ( 11, 20, "The .Ini shows Time Slize -> " + cValue, "N/BG" )
    cNew := TransForm ( nRandom ( 99 ), "99" )
    IniSave( aIniFile, cData, cNew )
    IniWrite( aIniFile, cFile, cApplication )
    Message ( 12, 20, "New value will be         -> " + cNew, "N/BG" )
    Message ( 14, 20, "For more information read Fast.ini", "N/BG" )
    Inkey ( 0 )
    Implode ( 0, 0, 24, 79, cScreen )
Return ( Nil )


Function DemoFocus()
Local aButton
    aButton := BoxOpen ( 3, 10, 5, 50, "B", .1 )
    Message ( 4, 13, "- Original idea by Urbano Garca -", "W+/B" )
    While Inkey ( 0 ) != K_ESC
      BoxPush ( aButton )
    End
    BoxClose ( aButton )
Return ( Nil )


Function GraphDemo ()
    SetVGA()
    DispStr ( "Now, i am going to generate lines until you press any key", 35, 50, 9, 0, 10 )
    Inkey(0)
    While Inkey() == 0
      gLine( nRandom(639), nRandom(479), nRandom(639), nRandom(479), nRandom( 15 ) )
    End
    TxtMode()
    SetBlink(.F.)
Return ( Nil )


Function BarDemo( nType )
    SetVGA ()
    GraphBar ( "This is a VGA special efects demo", ;
               { "Item 1",          { 2481, 3212, 4212, 1266, 1699, 6312 } }, ;
               { "Item 2",          { 4000, 2000, 4000, 2000, 8000, 9000 } }, ;
               { "Item 3",          { 2481, 3212, 4212, 1266, 1699, 6312 } }, ;
               { "Item 4 and last", { 2281, 3332, 3212, 2557, 7499, 2612 } }, ;
               nType )
    Inkey (0)
    TxtMode ()
    SetBlink (.F.)
Return ( Nil )


Function Graph2Demo ()
    SetVGA ()
    GraphBar2( "This is a VGA special efects demo", ;
                { { 9481, 4212, 5212, 4266, 8699, 9442, 9298, 9481, 4212, 5212, 4266, 8699 }, ;
                  { 2481, 3212, 4212, 1266, 1699, 6312, 7921, 7481, 2212, 5412, 3266, 4699 }, ;
                  { 2281, 3332, 3212, 2557, 7499, 2612, 3120, 6481, 1212, 3212, 4266, 7699 }, ;
                  { 7481, 1212, 4642, 1234, 6542, 9312, 1921, 8481, 3212, 4212, 2266, 6699 } } )
    Legend (  20, 420, 15,  9, "Fast Library" )
    Legend ( 340, 420, 15, 10, "Other" )
    Legend (  20, 450, 15, 11, "Other" )
    Legend ( 340, 450, 15, 12, "Other" )
    Inkey (0)
    TxtMode ()
    SetBlink (.F.)
Return ( Nil )


Function Graph3Demo ()
    SetVGA ()
    GraphBar3 ( "This is a VGA special efects demo", ;
               { "Item 1", "Item 2", "Item 3", "Item 4", "Item 5", "Item 6", ;
                 "Item 7", "Item 8", "Item 9", "Item A", "Item B", "Item C", ;
                 "Item D", "Item E", "Item F", "Item 0" }, ;
               {     9481,     4212,     5212,     4266,     8699,     9442, ;
                    19481,    23212,     5212,     2166,     1699,    19442, ;
                     7212,    12266,      699,    22442 } )
    Inkey (0)
    TxtMode ()
    SetBlink (.F.)
Return ( Nil )


Function GraphLineDemo( nMode )
    SetVGA ()
    If nMode == 1
      GraphLine( "This is a VGA special efects demo", ;
                 { { 1481, 1212, 2642, 1234, 1542, 1312, 1921, 2481, 1212, 2212, 2266, 2699 }, ;
                   { 2281, 3332, 3212, 2557, 2499, 2612, 3120, 2481, 1312, 3212, 4266, 3699 }, ;
                   { 2481, 3212, 4212, 1266, 1699, 6312, 7921, 7481, 2212, 5412, 3266, 4699 }, ;
                   { 9481, 6212, 5212, 4266, 8699, 9442, 9298, 9481, 5212, 6212, 5266, 8699 } } )
    Else
      GraphZone( "This is a VGA special efects demo", ;
                 { { 1481, 1212, 2642, 1234, 1542, 1312, 1921, 2481, 1212, 2212, 2266, 2699 }, ;
                   { 2281, 3332, 3212, 2557, 2499, 2612, 3120, 2481, 1312, 3212, 4266, 3699 }, ;
                   { 2481, 3212, 4212, 1266, 1699, 6312, 7921, 7481, 2212, 5412, 3266, 4699 }, ;
                   { 9481, 6212, 5212, 4266, 8699, 9442, 9298, 9481, 5212, 6212, 5266, 8699 } } )
    EndIf
    Legend (  20, 420, 15,  9, "Other" )
    Legend ( 340, 420, 15, 10, "Other" )
    Legend (  20, 450, 15, 11, "Other" )
    Legend ( 340, 450, 15, 12, "Fast Library" )
    Inkey (0)
    TxtMode ()
    SetBlink (.F.)
Return ( Nil )


Function TartDemo()
Local cTitulo := "Statistics"
    SetVGA ()
    GraphTart ( 540, 60, 40, { 17, 3, 15, 60, 15 } )
    GraphTart ( 80, 120, 30, { 17, 3, 15, 60, 15 } )
    gBox ( 210, 130, 430, 350, 10 )
    GraphTart ( 320, 240, 100, { 17, 3, 15, 60, 15 } )
    DispStr ( cTitulo, 320 - Len ( cTitulo ) * 4, 370, 15, 0 )
    Legend ( 320, 460, 15, 4, "Fast Library For Clipper" )
    Inkey (0)
    TxtMode ()
    SetBlink (.F.)
Return ( Nil )


Function EllipseDemo ()
Local cTitulo := "Statistics"
    SetVGA ()
    GraphEllipse ( 540, 60, 40, { 17, 3, 15, 60, 15, 21, 21, 23, 54 } )
    GraphEllipse ( 80, 120, 30, { 17, 3, 15, 60, 15, 21, 47, 11, 11, 64, 11 } )
    gBox ( 210, 130, 430, 350, 10 )
    GraphEllipse ( 320, 240, 100, { 17, 23, 12, 72, 3, 15, 60, 21, 15 } )
    DispStr ( cTitulo, 320 - Len ( cTitulo ) * 4, 370, 15, 0 )
    Legend ( 320, 460, 15, 4, "Fast Library For Clipper" )
    Inkey (0)
    TxtMode ()
    SetBlink (.F.)
Return ( Nil )


Function DemoMouse()
    Cls
    If rIsMouse()
      ? "Well, you have a mouse; Them, press any key or mouse button"
      rSoftCur()
      rInkey(0)
      rCursorOn ()
      rSetPos ( 12, 39 )
      ? "Now mouse cursor is on 12,39"
      rSetPos ( 12, 39 )
      rInkey(0)
      rCursorOff ()
      ? "good bye mouse"
      rInkey(0)
      rCursorOn()
      ? "hello mouse"
      rInkey(0)
      ? "Now, press any key or mouse button"
      rInkey(0)
      rCursorOff()
    Else
      BoxWarning ( "There is no mouse on system" )
    EndIf
Return ( Nil )


Function Menues ()
Local aMenu
Local nOpt
Local cColor   := "W+/BG,N+/BG"
local cGet1    := "Manu Roibal                 "
local cGet2    := "Fast Library For Clipper "
local GetList  := {}
local nChoice1 := 2
local nChoice2 := 1
local nChoice3 := 1
local nChoice4 := 3
local nChoice5 := 2
    Fascinate ( "GR", "BG" )
    Set wrap On
    Set message To 24 Center
    @ 24, 0 Say Space ( 80 ) Color "N/W"
    aMenu := NewMenu( { "^System", "^Tools", "^States", "^Last" }, ;
                      { "N/W", "R/W", "N/G", "R/G", "N/W", "N/G", "N+/W", ;
                        "R/W", "R/G" }, ;
                      .T. )
    AddItem ( aMenu, 1, "^New", "Nothing" )
    AddItem ( aMenu, 1, "^Open" )
    AddLine ( aMenu, 1 )
    AddItem ( aMenu, 1, "^Save", "More messages", , { "Item 1", "Item 2", "Item 3" } )
    AddItem ( aMenu, 1, "^Discard", , , { "First Item", "Second Item", "Third Item" } )
    AddLine ( aMenu, 1 )
    AddItem ( aMenu, 1, "Good m^orning sir", , 3 )
    AddItem ( aMenu, 1, "^Quit", "Are you sure you want exit from here?" )
    DelItem ( aMenu, 1, 3 )
    OffItem ( aMenu, 1, 2 )
    AddItem ( aMenu, 2, "^Cut" )
    AddItem ( aMenu, 2, "^Paste" )
    AddItem ( aMenu, 2, "^Copy" )
    AddItem ( aMenu, 3, "^Search" )
    AddItem ( aMenu, 3, "^Replace" )
    AddItem ( aMenu, 4, "^Help" )
    AddItem ( aMenu, 4, "And ^more Help" )
    AddItem ( aMenu, 4, "And more, ^and more..." )
    AddLine ( aMenu, 4 )
    AddItem ( aMenu, 4, "Little rabbit ^Duracell", , , { "1 Item", "2 Item", "3 Item" } )
    nOpt := DispMenu ( aMenu, 3 )
    BoxWarning ( "And the winer is... " + Str ( nOpt ) )
    Cls
    SetCursor ( 1 )
    @ 4,5  say "Get Normal 1:" get cGet1
    @ 6,5  say "Clipper Lib"   get nChoice1 VALID nChoice1 == 3 COLOR cColor ;
           with radiobuttons { "1 Option1", "2 No buttons 2", "3 Not Selected" }
    @ 6,40 say "Fast Library"  get nChoice2 when nChoice1 != 2 COLOR cColor ;
           with radiobuttons { "1 Adios", "2 Agur", "3 Bye bye", "4 Adeu" }
    @ 7,60 get nChoice3        COLOR cColor ;
           with radiobuttons { "1 Fast", "2 Normal", "3 Slow" } ;
           nobox
    @ 12,5 say "Get Normal 2:" get cGet2
    @ 15,5 say "Botones 4:"
    @ 15,col()+1 get nChoice4 COLOR cColor ;
                 with radiobuttons { "1 Option 1", "2 Option 2", "3 Option 3" } ;
                 nobox ;
                 horizontal
    @ 17,5 Say "Botones 5:" get nChoice5 COLOR cColor ;
           with radiobuttons { "1 Option1", "2 Option 2", "3 Option 3" } ;
           double ;
           horizontal
    read
Return ( Nil )


Function MoreSpeed()
Local nTime
Local aButton
Local nInd
    aButton := BoxOpen ( 8, 2, 14, 76, "B", .1 )
    @ 10, 10 Say "Writes 1 to 15,000 with @ Say ->" Color "W+/B"
    nTime := Seconds()
    For nInd := 1 to 15000
      @ 10, 40 Say Str( nInd ) Color "W+/B"
    Next
    @ 10, 60 Say Str( Seconds() - nTime ) Color "GR+/B"
    @ 12, 10 Say "Writes 1 to 15,000 with Fast  ->" Color "W+/B"
    nTime := Seconds()
    For nInd := 1 to 15000
      FastPrint( 12, 40, Str( nInd ), 31 )
    Next
    @ 12, 60 Say Str( Seconds() - nTime ) Color "GR+/B"
    Inkey(0)
    BoxClose( aButton )
Return( Nil )


Function DemoIcons()
Local aExit, aCube, aLine
    Cls
    SetFont( "Cubo.Fon" )
    Screen( Chr( 235 ), "N+/W" )
    aExit := BoxOpen( 5, 30, 7, 34, "B", 0.2 )
    @ 6, 31 Say "" Color "GR+/B"
    aCube := BoxOpen( 5, 38, 7, 42, "B", 0.2 )
    @ 6, 39 Say "  " Color "GR+/B"
    aLine := BoxOpen( 5, 46, 7, 50, "B", 0.2 )
    @ 6, 47 Say " " Color "GR+/B"
    Inkey( 0 )
    BoxPush( aExit )
    Inkey( 0 )
    BoxPush( aCube )
    Inkey( 0 )
    BoxPush( aLine )
    SetFont( "Standard.Fon" )
Return( Nil )


Function Footing()
Local nI      := 0
Local nCont   := 1
Local cC      := ""
Local nN      := 1
Local cColor  := setcolor( "Gr+/B" )
Local aWords  := {}
Local cMsg    := "Fast-Fonts Demo ideated by Yosu Unibaso"
Local nLenMsg := Len( cMsg ) + 12 - 1
Local aBox
    aWords := Array( 80 )
    aFill( aWords, " " )
    For nI := 12 To nLenMsg
      aWords[ nI ] := SubStr( cMsg, nI - 11, 1 )
    Next
    SetFont( "cubo.fon" )
    aBox := BoxOpen( 4, 0, 6, 79, "b", 0.2 )
    @ 5, 2 Say ""
    For nI := 2 To 78
      If nCont == 1
        cC := ""
      ElseIf nCont == 2
        cC := ""
      ElseIf nCont == 3
        cC := ""
      ElseIf nCont == 4
        cC := ""
      EndIf
      @ 5, nI say cC
      nCont := If( nCont < 4, ++nCont, 1 )
      Delay( 0.1 )
      @ 5, nI say aWords[ nI ]
    Next
    cC := ""
    For nI := 2 To 77
      @ 5, nI Say cC
      Delay( 0.1 )
      @ 5, nI Say "  "
    Next
    BoxPush( aBox )
    BoxClose( aBox )
    SetFont( "standard.fon" )
    SetColor( cColor )
Return( Nil )


Function KeyDemo()
    Cls
    While Inkey() != K_ESC
      @  1, 2 say "Insert     " + If( IsInsert(), "Yes", "No " )
      @  2, 2 say "Caps       " + If( IsCaps(),   "Yes", "No " )
      @  3, 2 say "Num        " + If( IsNum(),    "Yes", "No " )
      @  4, 2 say "Scroll     " + If( IsScroll(), "Yes", "No " )
      @  5, 2 say "Alt        " + If( IsAlt(),    "Yes", "No " )
      @  6, 2 say "Ctrl       " + If( IsCtrl(),   "Yes", "No " )
      @  7, 2 say "lShift     " + If( IsLShift(), "Yes", "No " )
      @  8, 2 say "rShift     " + If( IsRShift(), "Yes", "No " )
      @ 10, 2 say "Joystick 1 " + If( jButton1(), "Yes", "No " )
      @ 11, 2 say "Joystick 2 " + If( jButton2(), "Yes", "No " )
      @ 14, 2 say "Push Esc to exit"
    End
Return Nil


Function cdDemo()
Local nKey
Local aButtons := Array( 5 )
Local aTracks
Local nInd
   BoxOpen( 1, 1, 7, 70, "B" )
   @  3, 3 say "CD Install & ready : " + if( cdInstall(), "Yes", "No" )  Color "GR+/B"
   @  4, 3 say "MSCDEX Version     : " + MSCDEXVer()                     Color "GR+/B"
   @  5, 3 say "First CD unit      : " + cdDrive()                       Color "GR+/B"
   aButtons[ 1 ] := BoxMessage( "<F1>  Start the CD ", 11,  5 )
   aButtons[ 2 ] := BoxMessage( "<F2>  Stop the CD  ", 15,  5 )
   aButtons[ 3 ] := BoxMessage( "<F3>  Resume the CD", 11, 40 )
   aButtons[ 4 ] := BoxMessage( "<F4>  Eject the CD",  15, 40 )
   aButtons[ 5 ] := BoxMessage( "<Esc> Exit         ", 19,  5 )
   While ( nKey := Inkey( 0 ) ) != K_ESC
     if nKey == K_F1
       BoxPush( aButtons[ 1 ] )
       cdPlay( 1 )
     ElseIf nKey == K_F2
       BoxPush( aButtons[ 2 ] )
       cdStop()
     ElseIf nKey == K_F3
       BoxPush( aButtons[ 3 ] )
       cdResume()
     ElseIf nKey == K_F4
       BoxPush( aButtons[ 4 ] )
       cdEject()
     EndIf
   End
   BoxPush( aButtons[ 4 ] )
Return( Nil )


Function PCXDemo ()
Local i
    SetVGA()
    PCXShow ( "fast.pcx", .F., 100,  10 )
    DispStr ( "Press any key to continue", 350, 60, 15, 0 )
    While Inkey() == 0
      For i := 0 To -340 Step -2
        Origin( 0, i )
      Next
      For i := -340 To 0 Step +2
        Origin( 0, i )
      Next
      Origin( 0, 0 )
    End
    TxtMode ()
    SetBlink(.F.)
Return ( Nil )


Function ClipMem()
LOCAL aBox       := BoxOpen( 3, 3, 22, 76, "B" )
LOCAL cColor     := SETCOLOR( "GR+/B" )
Local cProcessor
Local aProcessor  := { "8088",    "8086",    "80286", "80386", "80486", ;
                       "Pentium", "6tium",   "7tium", "8tium", "9tium", ;
                       "NEC V20", "NEC V30", "80188", "80186" ;
                      }
    cProcessor := aProcessor[ CpuType() + 1 ]
    @  5,  5 SAY FastVersion()
    @  6,  5 SAY FastRight()
    @  8,  5 SAY "Processor          " + cProcessor
    @  9,  5 SAY "CoProcessor        " + If( IsCopro(), "Yes", "No" )
    @ 11,  5 SAY "Paralel ports      " + Str( NumParalel(), 1 )
    @ 12,  5 SAY "Serial ports       " + Str( NumSerial(),  1 )
    @ 14,  5 SAY "Disk Serial Number " + DiskSerNum( 0 )
    @ 15,  5 SAY "Disk Volume Label  " + GetLabel( 0 )
    @ 17,  5 SAY "DPMI Version       " + IF( IsDPMI(),     DPMIVersion(), "00.00" )
    @ 18,  5 SAY "WIN 3 Version      " + IF( IsWin3(),     WinVersion(),  "00.00" )
    @ 19,  5 SAY "DESQVIEW Version   " + IF( IsDesqView(), DesqVer(),     "00.00" )
    @ 20,  5 SAY "MSCDEX Version     " + MSCDEXVer()
    @  5, 45 SAY "Data Memory  (Kb)  " + Str( memory( 0 ) )
    @  6, 45 SAY "Longer block (Kb)  " + Str( memory( 1 ) )
    @  7, 45 SAY "Run Memory   (Kb)  " + Str( memory( 2 ) )
    @  9, 45 SAY "PRINT    loaded  " + IF( IsPrint(),    "Yes", "No" )
    @ 10, 45 SAY "ANSI     loaded  " + IF( IsAnsi(),     "Yes", "No" )
    @ 11, 45 SAY "KEYB     loaded  " + IF( IsKeyb(),     "Yes", "No" )
    @ 12, 45 SAY "QEMM     loaded  " + IF( IsQEMM(),     "Yes", "No" )
    @ 13, 45 SAY "SHARE    loaded  " + IF( IsShare(),    "Yes", "No" )
    @ 14, 45 SAY "SMARTDRV loaded  " + IF( IsSmartDrv(), "Yes", "No" )
    @ 15, 45 SAY "XMS Drv. loaded  " + IF( IsXMS(),      "Yes", "No" )
    @ 17, 45 SAY "NOVELL present   " + IF( IsNovell(),   "Yes", "No" )
    @ 18, 45 SAY "MSLAN  present   " + IF( IsMSLAN(),    "Yes", "No" )
    @ 20, 45 SAY "Computer Type    " + STR( BiosModel(), 3 ) + STR( BiosSubMod(), 3 ) + STR( BiosRev(), 3 )
    INKEY( 0 )
    SETCOLOR( cColor )
Return( Nil )


Function GraySumming()
Local cPalette := GetPalette()
    BoxMessage( "This is a test for SetGray() funcion", 2 )
    BoxWarning( "Now, i'm going to change your monitor to b/w" )
    SetGray( .T. )
    BoxWarning( "And... Now, the monitor will return to your original state" )
    SetGray( .F. )
    SetPalette( cPalette )
    BoxWarning( { "This function allows to test an application in a system with", ;
                  "a color monitor or in a system with a B/W monitor" } )
Return( Nil )


FUNCTION Banner()
    CLS
    BigString  (  6,  7, "FAST.lib",   "G+/B" )
    SmallString(  0,  0, "Welcome to", "GR+/B" )
    SmallString( 18, 23, "3.20",       "W+/B" )
    Inkey( 0 )
RETURN NIL



Function MyDebugger()
Local aArray :=  { "Hello", 12, .T., { || Version() }, ;
                   { { "new", "other" }, 12 } }
    BoxWarning( "I'm going to inspect an object or array" )
    InspectOBJ( "aArray", aArray )
    BoxWarning( "I'm going to inspect the active workareas" )
    use test new
    InspectDBF()
    close test
    BoxWarning( "I'm going to inspect the SETs" )
    InspectSETS()
Return( Nil )


