**---**---**---**---**---**---**---**--**--**---**---**---**---**---**---**
*
*    Program Name: tb_files.prg  AKA UDEM02.PRG
*         Version: 1.1
*      Written By: Michael Stephens
*            Date: February 1994
*         Purpose: Toolbox file management routines
*     Last Change: 30MAY94 1200
*         Comment: In progress
*         Compile: clipper tb_files /N /A /V /W 
*            Link: rtlink fi tb_files lib frankie /STACK:4900
*          Notice: This Computer Program is a work in progress.
*                  It may be reproduced in whole or in part.
*
*                  Stephens Publishing Company
*                  7717 1/2 W 16 ST
*                  Tulsa, Ok 74127-4810
*                  (918) 241-1142
*                  CompuServe 73303,2410
*
**---**---**---**---**---**---**---**--**--**---**---**---**---**---**---**

/*

        This program is designed to allow disk drive maintenance, 
        file viewing, and printing.    Anyone who finds it useful 
        may use all or part of the following code in applications 
        they write. 

        If you experience a processor stack fault, set the linker 
        to increase the stack size, as in the following example.

        Compile: clipper tb_files /N /A /V /W 
           Link: rtlink fi tb_files lib frankie /STACK:4900
         
        Please feel free to contact me with any comments, 
        questions, etc.
        
*/    

#include "inkey.ch"
#include "common.ch"
#include "frankie.ch"

STATIC cFileMask := "*.*", aSel[ 0 ]

**---**---**---**---**---**---**---**--**--**---**---**---**---**---**---**---**

//------------
Func udemo02()    // just a wrapper
tbf_main()
return NIL

PROC TBF_Main()      

LOCAL bConfig, bProcess, aScn := ADsaveScn( 0, 0, MaxRow(), MaxCol() )
LOCAL nDrive := TBF_CurDrive(), bMoveEnd, nBoxLeftColumn
LOCAL nTime, nmRow, nmCol, aCursor := ADsaveCsr( 0 )

IF !"F_TOUR.EXE" $ ADprogName()
   ADdevBlock( { || ADdevTools() } )
   ErrorBlock( { | o | ADerrTrace( o ) } )
ENDIF

SET CURSOR OFF   
ADcls( "", "W+/B", 0, 0, MaxRow(), MaxCol() )
ADm_Limits( 0, 0, MaxRow(), MaxCol() )
ADm_Move( MaxRow(), MaxCol() )
TBF_Credit()

ADmessage( { " " , ;
             "  Select a Drive and Directory from the      ", ;
             "   menus that follow by double clicking.      ", ;
             "                                              ", ;
             "  When the desired Drive/Directory filespec  ", ;
             "   appears across the top of the pop up menu  ", ;
             "   boxes, press a Hot Key or click the top    ", ;
             "   row menu option you wish to execute.       ", ;
             " " , ;
             "  Press any key or button to continue...     ", ;
             " " },,, FALSE, FALSE, { "B/W" } )

ADm_rWait()
ADwait( 60 )
ADm_rWait()

ADcls( "", "W+/B", 0, 0, MaxRow(), MaxCol() )

ADsay( 0, 0, "   F2-Copy   F3-Delete   F4-Filter  " ; // paint a pseudo menu
  +" F5-Print   F6-Select   F7-View   F8-Quit   ", "B/W" )
ADsay( 1, 0, Replicate( "", 80 ), "B/W" )

TBF_Footer()

nBoxLeftColumn := 2

bProcess := { | cDrive | nmRow := ADm_Row(), ;
                         nmCol := ADm_Col(), ;
                         nTime := Seconds(), ;
                         ADwait( 1 ), ;
                         IF( Seconds() - nTime < .34 .AND. nmRow == ADm_Row() ;
                        .AND. nmCol == ADm_Col(), ;
                         TBF_Directory( "", cDrive, ADvm_Right() ), ) }

bMoveEnd := { || ADsay( ADvm_Top()+1, nBoxLeftColumn+1, Replicate( ;
               " ", ( ( ADvm_Right() - nBoxLeftColumn ) -1 ) ), "R/W" ), ;
                 ADcSay( ADvm_Top()+1, nBoxLeftColumn+1, ADvm_Right()-1, ;
                       " "+ADvm_Current()+" ", "R/W" ) }

bConfig := { || ADvm_Header( "...." ), ; // reserve some space 
                ADvm_InitSel( nDrive ), ;
                ADvm_Escape( { || TBF_Bell() } ), ;
                ADvm_Move( , bMoveEnd ), ;
                ADvm_Keys( { K_F2, K_F3, K_F4, K_F5, K_F6, K_F7, K_F8 }, ;
                   { | n,k | TBF_HotKeys( n,k,ADvm_Current()+"\" ) } ), ;
                ADvm_lButtons( { { 0, 3, 0, 9 },  { 0, 13, 0, 21 }, ;
                   { 0, 25, 0, 33 }, { 0, 37, 0, 44 }, ;
                   { 0, 48, 0, 56 }, { 0, 60, 0, 66 }, ;
                   { 0, 70, 0, 76 } }, ;
                   { | n, r, c | TBF_LButtons( n, r, c, ADvm_Current()+"\" ) } ), ;
                ADvm_TimeOut( 60, { || TBF_BlankScn() } ) }

ADpl_Drives( 3, nBoxLeftColumn, 3, bProcess, bConfig ) // pop up a drive menu

CLS

ADrestScn( aScn )

ADrestCsr( aCursor )

RETURN

** Service Routine Below **

PROC TBF_BlankScn()

ADblankScn( { " File Manager 1.1 ", ;
              " by Mike Stephens " }, 10 )

RETURN              

** Service Routine Below **

FUNC TBF_CurDrive()  // tells TBF_Main() which drive is the current drive.

LOCAL cDrives := ADdrives( 1 ), i, nDriveNumber := 0

FOR i = 1 TO Len( cDrives )
    IF ADcurDrive() $ SubStr( cDrives, i, 1 )
       nDriveNumber := i
       EXIT
    ENDIF
NEXT

RETURN nDriveNumber

** Service Routine Below **

PROC TBF_Directory( cSel, cPath, nBoxLeftColumn ) // recursive dir picklist

LOCAL bMoveEnd := { || ADsay( ADvm_Top()+1, nBoxLeftColumn+1, Replicate( ;
                  " ", ( ( ADvm_Right() - nBoxLeftColumn ) -1 ) ), "R/W" ), ;
                   ADcSay( ADvm_Top()+1, nBoxLeftColumn+1, ADvm_Right()-1, ;
                           "\"+ADvm_Current(), "R/W" ) }

LOCAL bConfig := { || ;
   ADvm_Header( "........." ), ; 
   IF( cSel == "", ,ADvm_InitSel( 3 ) ), ;      
   ADvm_Keys( { K_F2, K_F3, K_F4, K_F5, K_F6, K_F7, K_F8 }, ;
              { | n,k | TBF_HotKeys( n,k,cPath+ADvm_Current()+"\" ) } ) , ;
   ADvm_lButtons( { { 0, 3, 0, 9 },  { 0, 13, 0, 21 }, ;
              { 0, 25, 0, 33 }, { 0, 37, 0, 44 }, ;
              { 0, 48, 0, 56 }, { 0, 60, 0, 66 }, ;
              { 0, 70, 0, 76 } }, ;
              { | n,r,c | TBF_LButtons( n,r,c, cPath+ADvm_Current()+"\" ) } ), ;
   ADvm_Move( ,bMoveEnd ) , ;
   ADvm_MaxBottom( MaxRow() - 3 ) , ;
   ADvm_TimeOut( 60, { || TBF_BlankScn() } ), ;
   ADvm_Extra( , { || ADvm_VersBar() }, ) }

LOCAL nTime, nmRow, nmCol
LOCAL bProcess := { | c | nmRow := ADm_Row(), ;
                          nmCol := ADm_Col(), ;
                          nTime := Seconds(), ;
                          ADwait( 1 ), ;
                          IF( Seconds() - nTime < .34 .AND. nmRow == ADm_Row() ;
                          .AND. nmCol == ADm_Col(), ;
                          TBF_Directory( c, cPath, ADvm_Right() ), ) }

IF cSel == ""       // first call
   cPath += "\"
ELSE                // recursive call
   cPath += cSel+"\"
ENDIF   

ADpl_Dirs( 3, nBoxLeftColumn, cPath, bProcess, bConfig ) // dir picklist

RETURN

** Service Routine Below **

PROC TBF_HotKeys( nIndexPos, nKeyCode, cPath )  // hot key handler

IF !nKeyCode == K_F4 .AND. !nKeyCode == K_F6 .AND. !nKeyCode == K_F8  ;
   .AND. ( SubStr( cPath, 1, 1 ) == "A" .OR. SubStr( cPath, 1, 1 ) == "B" )
   
   IF ADbm_IsFloppy( SubStr( cPath, 1, 1 ) )
   ELSE      
      RETURN
   ENDIF
ENDIF
   
DO CASE
   CASE nKeyCode == K_F2
        TBF_Copy( cPath )
   CASE nKeyCode == K_F3
        TBF_Delete( cPath )
   CASE nKeyCode == K_F4
        TBF_Filter()
   CASE nKeyCode == K_F5
        TBF_Prn( cPath )
   CASE nKeyCode == K_F6
        KeyBoard Chr( K_ENTER ) 
   CASE nKeyCode == K_F7
        TBF_View( cPath )
   CASE nKeyCode == K_F8
        ADvm_Abort()
ENDCASE

RETURN

** Service Routine Below **

PROC TBF_LButtons( nIndexPos, nRow, nCol, cPath )  // hot spot handler

IF !nIndexPos == 3 .AND. !nIndexPos == 5 .AND. !nIndexPos == 7 ;
   .AND. ( SubStr( cPath, 1, 1 ) == "A" .OR. SubStr( cPath, 1, 1 ) == "B" )

   IF ADbm_IsFloppy( SubStr( cPath, 1, 1 ) )
   ELSE      
      RETURN
   ENDIF
ENDIF

DO CASE
   CASE nIndexPos == 1
        TBF_Copy( cPath )
   CASE nIndexPos == 2
        TBF_Delete( cPath )
   CASE nIndexPos == 3
        TBF_Filter()
   CASE nIndexPos == 4
        TBF_Prn( cPath )
   CASE nIndexPos == 5
        KeyBoard Chr( K_ENTER )
   CASE nIndexPos == 6
        TBF_View( cPath )
   CASE nIndexPos == 7
        ADvm_Abort()
        ADm_rWait()
ENDCASE

RETURN

**---**---**---**---**---**---**---**--**--**---**---**---**---**---**---**---**

PROC TBF_Filter()  // set a filename mask for displays

LOCAL aMenu, aTrigger, bConfig, nSel, aLabels, aGets
LOCAL cMask, aScn := ADsaveScn( 0, 0, MaxRow(), MaxCol() )

aMenu     := { " *.PRG ", " *.TXT ", " *.BAT ", " *.HLP ", " *.DOC ", ;
               " *.* ", " Custom " }
aTrigger  := { 4, 4, 4, 4, 4, 2, 2 }
bConfig   := { || ADvm_TimeOut( 60, { || TBF_BlankScn() } ) , ;
                  ADvm_Header( " Filter " ) , ;
                  ADvm_Wrap() , ;
                  ADvm_MaxRight( MaxCol() - 2 ) , ;
                  ADvm_Escape( { || ADvm_Abort() } ) }

nSel := ADverMenu( 3, 70, aMenu ,aTrigger, , bConfig )

DO CASE
   CASE nSel == 1
        cFileMask := "*.PRG"
   CASE nSel == 2
        cFileMask := "*.TXT"
   CASE nSel == 3
        cFileMask := "*.BAT"
   CASE nSel == 4
        cFileMask := "*.HLP"
   CASE nSel == 5
        cFileMask := "*.DOC"
   CASE nSel == 6
        cFileMask := "*.*"
   CASE nSel == 7
        aLabels := { "Enter a filename mask: " }
        aGets   := { "            " }
        bConfig := { || ADgm_Labels( aLabels ) , ;
                        ADgm_Pads( { 1, 2, 1, 2, 1 } ) , ;
                        ADgm_Color( { "B/W", "W/B" } ) , ;
                        ADgm_Pictures( { "@!" } ) }

        ADcls( "", "W+/B", 0, 0, MaxRow()-1, MaxCol() )

        ADg_Many( aGets, bConfig )
        
        cMask := aGets[ 1 ]
        IF Empty( cMask ) .OR. ADr_ExitCode() == RX_ABORT
           cFileMask := "*.*"
        ELSE
           cFileMask := AllTrim( cMask )
        ENDIF
   OTHERWISE
        cFileMask := "*.*"
ENDCASE

ADrestScn( aScn )

RETURN

**---**---**---**---**---**---**---**--**--**---**---**---**---**---**---**---**

PROC TBF_Prn( cPath )    // gets array of text files to print

LOCAL aSelections
LOCAL bConfig := { || ;
         ADvm_Header( cPath+cFileMask ) , ;
         ADvm_MaxRight( MaxCol() - 2 ) , ;
         ADvm_MaxBottom( MaxRow() - 3 ) , ;
         ADvm_TagList() , ;
         ADvm_TimeOut( 60, { || TBF_BlankScn() } ) , ;
         ADvm_Extra( , { || ADvm_VersBar() } ) }
LOCAL aScn

aScn := ADsaveScn( 0, 0, MaxRow(), MaxCol() )
ADcls( "", "W+/B", 0, 0, MaxRow()-1, MaxCol() )

ADpl_FilFormat( "SDTA" )
ADpl_FilAttr( "SRHA" )

IF File( cPath+cFileMask ) // are there any files matching the file mask?
   TBF_TagMessage( "PRINT" )
   IF !Empty( aSelections := ADpl_Files( 1, 28, cPath, cFileMask, , bConfig ) )
      TBF_Print( cPath, aSelections )
   ENDIF
ELSE
   TBF_NoFiles( cPath )
ENDIF

ADrestScn( aScn )

RETURN

**---**---**---**---**---**---**---**--**--**---**---**---**---**---**---**---**

PROC TBF_Print( cPath, aSelections )    // print text files

LOCAL e, nKey, nPage, nPrintRow, nLineOfFile, nHandle, i, k, cFileSpec
LOCAL nMaxRow, nBotRow := 64, cLine, nLineLength, nCharsPrinted := 1
LOCAL cLineFrag, nNoNum, nNum, nFoot, lPlainJane, lCancelled := FALSE
LOCAL aScn2 := ADsaveScn( 0, 0, MaxRow(), MaxCol() ), aScn
LOCAL lLineNum, lFoot, lEOFmsg, lEjectBefore, lEjectAfter, nCpiCtr := 0

ADflLength( 1024 )
TBF_Footer()
DO WHILE TRUE
   nCpiCtr := 0
   ADcls( "", "W+/B", 0, 0, MaxRow()-1, MaxCol() )

   IF Empty( aSel )  // if the first time thru, stuff array
      FOR i = 1 TO 11
          Aadd( aSel, FALSE )
      NEXT
   ENDIF

   e := ADrb_Create( { || ADrb_ChkBox(), ADrb_OkButton( " Proceed ", 2 ) } )

   ADrb_Add( e, 8 , 51, "Print Line numbers   ",  7, IF( aSel[  1 ], .T., .F. ) )
   ADrb_Add( e, 9 , 51, "Print Footer         ",  7, IF( aSel[  2 ], .T., .F. ) )
   ADrb_Add( e, 10, 51, "Print ** EOF ** label", 10, IF( aSel[  3 ], .T., .F. ) )
   ADrb_Add( e, 11, 51, "10 CPI               ",  1, IF( aSel[  4 ], .T., .F. ) )
   ADrb_Add( e, 12, 51, "12 CPI  Recommended!",  2, IF( aSel[  5 ], .T., .F. ) )
   ADrb_Add( e, 13, 51, "15 CPI               ",  2, IF( aSel[  6 ], .T., .F. ) )
   ADrb_Add( e, 14, 51, "17 CPI               ",  2, IF( aSel[  7 ], .T., .F. ) )
   ADrb_Add( e, 15, 51, "20 CPI               ",  2, IF( aSel[  8 ], .T., .F. ) )
   ADrb_Add( e, 16, 51, "Eject Before printing",  7, IF( aSel[  9 ], .T., .F. ) )
   ADrb_Add( e, 17, 51, "Eject After printing ",  7, IF( aSel[ 10 ], .T., .F. ) )
   ADrb_Add( e, 18, 51, 'Print "Plain Jane"   ',  8, IF( aSel[ 11 ], .T., .F. ) )
   
   DispBegin()
   
   ADrb_Show( e )

   ADmessage( { " Print text file(s) from "+cPath+" "  }, ;
                        2, 1, FALSE, FALSE, { "B/W" } )

   ADmessage( { " " , ;
                " () Indicates a menu option is enabled. " , ;
                "  To toggle an option, highlight it using " , ;
                "  the Arrow keys then press the Space Bar " , ;
                "  or click on the option to be toggled.   " , ;
                "                                          " , ;
                " Select the CPI menu option that matches " , ;
                "  the pitch setting on the printer.       " , ;
                "                                          " , ;
                ' Press Enter or click "Proceed" to print ' , ;
                "                                          " , ;
                " Press Esc or click right button to quit " , ;
                " " } , ;
                7, 1, FALSE, FALSE, { "B/W" } )

   ADm_rWait()

   DispEnd()
   
   IF !Empty( aSel := ADrb_Activate( e ) )
      lLineNum     := IF( aSel[  1 ], TRUE, FALSE )
      lFoot        := IF( aSel[  2 ], TRUE, FALSE )
      lEOFmsg      := IF( aSel[  3 ], TRUE, FALSE )
      lEjectBefore := IF( aSel[  9 ], TRUE, FALSE )
      lEjectAfter  := IF( aSel[ 10 ], TRUE, FALSE )
      lPlainJane   := IF( aSel[ 11 ], TRUE, FALSE )
   ELSE
      EXIT
   ENDIF   

   nMaxRow := IF( lFoot, 62, 64 )
      
   FOR i = 4 TO 8  // count number of "cpi"s selected.  one to a customer!
       IF aSel[ i ]
          nCpiCtr += 1
       ENDIF
   NEXT

   IF nCpiCtr == 1 // only one cpi selected
   ELSE
      EXIT
   ENDIF
       
   DO CASE  // base characters per line on cpi selected
      CASE aSel[ 4 ] // 10 cpi
           nNum   := 68
           nNoNum := 76
           nFoot  := 80
      CASE aSel[ 5 ] // 12 cpi
           nNum   := 84
           nNoNum := 92
           nFoot  := 96
      CASE aSel[ 6 ] // 15 cpi
           nNum   := 108
           nNoNum := 116
           nFoot  := 15
      CASE aSel[ 7 ] // 17 cpi
           nNum   := 124
           nNoNum := 132
           nFoot  := 136
      CASE aSel[ 8 ] // 20 cpi
           nNum   := 148
           nNoNum := 156
           nFoot  := 160
   ENDCASE

   SET CONSOLE OFF
   SET DEVICE TO PRINT

   IF lEjectBefore
      EJECT
   ENDIF

   nKey := InKey()
   
   FOR i = 1 TO Len( aSelections )
       IF nKey == InKey() .AND. ADm_Button() == 0 .AND. !lCancelled
       ELSE
          EXIT
       ENDIF   
       nPage := 1
       nPrintRow := 1
       nLineOfFile := 0
       cFileSpec := cPath+AllTrim( SubStr( aSelections[ i ], 1, 12 ) )
       nHandle := Fopen( cFileSpec )
       ADcls( "", "W+/B", 0, 0, MaxRow()-1, MaxCol() )

       IF lPlainJane
       ELSE 
          aScn := ADmessage( { " " , ;
                    " Printing "+cFileSpec+" " , ;
                    " " , ;
                    " Press any key or button to cancel... " , ;
                    " " },,, FALSE, FALSE, { "B/W" } )
       ENDIF

       nKey := InKey()   

       DO WHILE !ADfEof( nHandle ) .AND. nkey == InKey() .AND. ADm_Button() == 0
          IF lPlainJane
             ADfPrint( cFileSpec )
             EXIT
          ENDIF
          IF !ADbm_IsPrinter()
             lCancelled := TRUE
             EXIT
          ELSE             
             cLine := Trim( ADfGetL( nHandle ) )
             nLineOfFile += 1
             nLineLength := Len( cLine )
             nCharsPrinted := 1    

             IF "" $ cLine
                @nPrintRow, 4  SAY ;
                           IF( lLineNum, AllTrim( Str( nLineOfFile ) ) , "" )
                IF Len( AllTrim( cLine ) ) == 1  // on a line by itself
                   TBF_BotRow( nPage, cFileSpec, nBotRow, lFoot, nFoot )
                   nPrintRow := 1
                   nPage += 1
                ELSE
                   FOR k = 1 TO Len( cLine )
                       IF "" $ SubStr( cLine, k, 1 )
                          TBF_BotRow( nPage, cFileSpec, nBotRow, lFoot, nFoot ) 
                          nPrintRow := 1
                          nPage += 1
                          @nPrintRow, 4  SAY ;
                             IF( lLineNum, AllTrim( Str( nLineOfFile ) ) , "" )
                       ELSE
                          @nPrintRow, IF( !lLineNum, 4, 12 ) + k ;
                          SAY SubStr( cLine, k, 1 )
                       ENDIF   
                   NEXT    
                   nPrintRow += 1
                ENDIF
                LOOP
             ENDIF

             IF nLineLength > IF( lLineNum, nNum, nNoNum )
                @nPrintRow, 4  SAY ;
                             IF( lLineNum, AllTrim( Str( nLineOfFile ) ), "" )
                DO WHILE nLineLength >= 0
                   cLineFrag := SubStr( cLine, nCharsPrinted, ;
                                       IF( lLineNum, nNum, nNoNum ) )
                   @nPrintRow, IF( !lLineNum, 4, 12 ) SAY cLineFrag
                   nCharsPrinted += IF( lLineNum, nNum, nNoNum )
                   nLineLength -= IF( lLineNum, nNum, nNoNum )
                   IF nPrintRow >= nMaxRow
                      TBF_BotRow( nPage, cFileSpec, nBotRow, lFoot, nFoot )
                      nPrintRow := 1
                      nPage += 1
                   ELSE
                      nPrintRow += 1
                   ENDIF
                ENDDO
             ELSE
                @nPrintRow, 4  SAY ;
                          IF( lLineNum, AllTrim( Str( nLineOfFile ) ) , "" )
                @nPrintRow, IF( !lLineNum, 4, 12 ) SAY cLine
                IF nPrintRow >= nMaxRow
                   TBF_BotRow( nPage, cFileSpec, nBotRow, lFoot, nFoot )
                   nPrintRow := 1
                   nPage += 1
                ELSE
                   nPrintRow += 1
                ENDIF
             ENDIF
         ENDIF
      ENDDO

      IF !lCancelled .AND. ADbm_IsPrinter()
         IF lEofMsg
            IF ADfEof( nHandle )
               @nPrintRow + 1, 4 SAY "***  End Of File  ***"
            ELSE
               @nPrintRow + 1, 4 SAY "***  Interrupted!  NOT End Of File  ***"
            ENDIF
         ENDIF
         TBF_BotRow( nPage, cFileSpec, nBotRow, lFoot, nFoot )
      ENDIF

      Fclose( nHandle )
      InKey( 2 )  // let user read the "printing..." message

      IF lPlainJane
      ELSE
         ADrestScn( aScn )
      ENDIF
   NEXT

   IF !lCancelled .AND. ADbm_IsPrinter() .AND. lEjectAfter 
      EJECT
   ENDIF

   SET DEVICE TO SCREEN
   SET CONSOLE ON
   EXIT
ENDDO

ADrestScn( aScn2 )

RETURN

** Service Routine Below **

PROC TBF_BotRow( nPage, cFileSpec, nBotRow, lFoot, nFoot )  // prints footer

IF lFoot
   @nBotRow, 1 SAY PadC( Dtoc( Date() )+"   "+Time() ;
    +"   "+AllTrim( cFileSpec )+"   Page "+AllTrim( Str( nPage ) ), nFoot )
ENDIF

EJECT

RETURN

**---**---**---**---**---**---**---**--**--**---**---**---**---**---**---**---**

PROC TBF_Copy( cPath )  // gets array of files to copy

LOCAL aSelections, bProcess, nmRow, nmCol, nTime, nBoxLeftColumn := 2, bMoveEnd
LOCAL bConfig := { || ;
         ADvm_Header( cPath+cFileMask ) , ;
         ADvm_MaxRight( MaxCol() - 2 ) , ;
         ADvm_MaxBottom( MaxRow() - 3 ) , ;
         ADvm_TagList() , ;
         ADvm_TimeOut( 60, { || TBF_BlankScn() } ) , ;
         ADvm_Extra( , { || ADvm_VersBar() } ) }
LOCAL aScn := ADsaveScn( 0, 0, MaxRow(), MaxCol() )

ADpl_FilFormat( "SDTA" )
ADpl_FilAttr( "SRHA" )
ADcls( "", "W+/B", 0, 0, MaxRow()-1, MaxCol() )

IF File( cPath+cFileMask ) // are there any files matching the file mask?
   TBF_TagMessage( "COPY" )

   IF !Empty( aSelections := ADpl_Files( 1, 28, cPath, cFileMask, , bConfig ) )

      ADcls( "", "W+/B", 0, 0, MaxRow()-1, MaxCol() )
      ADmessage( { " " , ;
             "  Select a Drive and Directory from the      ", ;
             "   menus that follow by double clicking.      ", ;
             "                                              ", ;
             "  When the desired Drive/Directory filespec  ", ;
             "   appears across the top of the pop up menu  ", ;
             "   boxes, press a Hot Key or click the top    ", ;
             "   row menu option you wish to execute.       ", ;
             " " , ;
             "  Press any key or button to continue...     ", ;
             " " },,, FALSE, FALSE, { "B/W" } )

      ADm_rWait()
      ADwait( 60 )
      ADm_rWait()
      ADcls( "", "W+/B", 0, 0, MaxRow()-1, MaxCol() )
      ADsay( 0, 0, "   F2-Copy                          " ; // paint a pseudo menu
                  +"                                  F8-Quit   ", "B/W" )
      ADsay( 1, 0, Replicate( "", 80 ), "B/W" )

      bProcess := { | c | nmRow := ADm_Row(), ;
                    nmCol := ADm_Col(), ;
                    nTime := Seconds(), ;
                    ADwait( 1 ), ;
                    IF( Seconds() - nTime < .34 .AND. nmRow == ADm_Row() ;
                   .AND. nmCol == ADm_Col(), ;
                    TBF_CopyDir( cPath, "", c, ADvm_Right(), ;
                    aSelections ) , ) }

      bMoveEnd := { || ADsay( ADvm_Top()+1, nBoxLeftColumn+1, Replicate( ;
                    " ", ( ( ADvm_Right() - nBoxLeftColumn ) -1 ) ), "R/W" ), ;
                     ADcSay( ADvm_Top()+1, nBoxLeftColumn+1, ADvm_Right()-1, ;
                          " "+ADvm_Current()+" ", "R/W" ) }
      bConfig  := { || ADvm_Header( "...." ), ;
                       ADvm_Move( , bMoveEnd ), ;
                       ADvm_Keys( { K_F2, K_F8 }, { | n,k | ;
                                 TBF_CopyHotKeys( n,k, cPath, ADvm_Current()+"\", ;
                                 aSelections ) } ) , ;
                       ADvm_lButtons( { { 0, 6, 0, 9 }, { 0, 70, 0, 76 } }, ;
                                  { | n,r,c | TBF_CopyLButtons( n,r,c, ;
                                  cPath, ADvm_Current()+"\", aSelections ) } ) , ;
                       ADvm_TimeOut( 60, { || TBF_BlankScn() } ) }
      ADpl_Drives( 3, nBoxLeftColumn, 3, bProcess, bConfig )
  
   ENDIF

ELSE
   TBF_NoFiles( cPath )
ENDIF

ADrestScn( aScn )

RETURN

** Service Routine Below **

PROC TBF_CopyDir( cPath, cSel, cTargetPath, nBoxLeftColumn, aSelections )
/* recursive target filespec picklist */

LOCAL aScn := ADsaveScn( 0, 0, MaxRow(), MaxCol() ), nmRow, nmCol, nTime
LOCAL bMoveEnd := { || ADsay( ADvm_Top()+1, nBoxLeftColumn+1, Replicate( ;
                    " ", ( ( ADvm_Right() - nBoxLeftColumn ) -1 ) ), "R/W" ), ;
                     ADcSay( ADvm_Top()+1, nBoxLeftColumn+1, ADvm_Right()-1, ;
                          "\"+ADvm_Current(), "R/W" ) }
LOCAL bConfig := { || ;
   ADvm_Header( "........." ) , ;
   IF( cSel == "", ,ADvm_InitSel( 3 ) ), ;   
   ADvm_Keys( { K_F2, K_F8 }, { | n,k | ;
              TBF_CopyHotKeys( n,k, cPath, ;
                  cTargetPath+ADvm_Current()+"\", aSelections ) } ) , ;
   ADvm_lButtons( { { 0, 6, 0, 9 }, { 0, 70, 0, 76 } }, ;
   { | n,r,c | TBF_CopyLButtons( n,r,c, cPath, ;
                  cTargetPath+ADvm_Current()+"\", aSelections ) } ) , ;
   ADvm_MaxBottom( MaxRow() - 3 ) , ;
   ADvm_TimeOut( 60, { || TBF_BlankScn() } ) , ;
   ADvm_Move( ,bMoveEnd ), ;
   ADvm_Extra( , { || ADvm_VersBar() }, ) }

LOCAL bProcess := { | c | nmRow := ADm_Row(), ;
                          nmCol := ADm_Col(), ;
                          nTime := Seconds(), ;
                          ADwait( 1 ), ;
                          IF( Seconds() - nTime < .34 .AND. nmRow == ADm_Row() ;
                          .AND. nmCol == ADm_Col(), ;
                          TBF_CopyDir( cPath, c, cTargetPath, ;
                          ADvm_Right(), aSelections ), ) }


IF cSel == ""  // first call
   cTargetPath += "\"
ELSE               // recursive call
   cTargetPath += cSel+"\"
ENDIF 

ADpl_Dirs( 3, nBoxLeftColumn, cTargetPath, bProcess, bConfig )

ADrestScn( aScn )
                                            
RETURN

** Service Routine Below **

PROC TBF_CopyHotKeys( nIndexPos, nKeyCode, cPath, cTargetPath, aSelections )
/* hot key handler */

DO CASE
   CASE nKeyCode == K_F2
        IF SubStr( cTargetPath, 1, 1 ) == "A" .OR. ;
           SubStr( cTargetPath, 1, 1 ) == "B"
           
           IF ADbm_IsFloppy( SubStr( cTargetPath, 1, 1 ) )
              TBF_CopyFiles( cPath, cTargetPath, aSelections )
           ENDIF
        ELSE      
           TBF_CopyFiles( cPath, cTargetPath, aSelections )
        ENDIF 
   CASE nKeyCode == K_F8
        ADvm_Abort()
ENDCASE

RETURN

** Service Routine Below **

PROC TBF_CopyLButtons( nIndexPos, nRow, nCol, cPath, cTargetPath, aSelections )
/* hot spot handler */

DO CASE
   CASE nIndexPos == 1
        IF SubStr( cTargetPath, 1, 1 ) == "A" .OR. ;
           SubStr( cTargetPath, 1, 1 ) == "B"
           
           IF ADbm_IsFloppy( SubStr( cTargetPath, 1, 1 ) )
              TBF_CopyFiles( cPath, cTargetPath, aSelections )
           ENDIF
        ELSE      
           TBF_CopyFiles( cPath, cTargetPath, aSelections )
        ENDIF 
   CASE nIndexPos == 2
        ADvm_Abort()
        ADm_rWait()
ENDCASE

RETURN


** Service Routine Below **

PROC TBF_CopyFiles( cPath, cTargetPath, aSelections )
/* handles the file copy chores */

LOCAL i, aTargetInfo, aSourceInfo, cDrives, nDrive, cTargetFile, cSourceFile
LOCAL aPrompt, aOptions, nSel, bConfig, cTargetInfo, cSourceInfo
LOCAL cSourceName, nLongest, nSpaceOnDisk
LOCAL aScn := ADsaveScn( 0, 0, MaxRow(), MaxCol() )

cDrives := ADdrives( 1 )

FOR i = 1 TO Len( cDrives ) // get number of target drive for DiskSpace()
    IF SubStr( cTargetPath, 1, 1 ) $ SubStr( cDrives, i, 1  )    
       nDrive := i
       EXIT
    ENDIF
NEXT
               
FOR i = 1 to Len( aSelections )

    ADcls( "", "W+/B", 0, 0, MaxRow()-1, MaxCol() )

     // check for the existence of the source file in the target directory
     // you only get a hit if the source file is already in the target dir.

    cTargetFile := cTargetPath+AllTrim( SubStr( aSelections[ i ], 1, 12 ) )
    aTargetInfo := Directory( cTargetFile, "HS" )
    cSourceFile := cPath+AllTrim( SubStr( aSelections[ i ], 1, 12 ) )
    aSourceInfo := Directory( cSourceFile, "HS" )

    bConfig := { || ADbm_TimeOut( 60, { || TBF_BlankScn() } ) , ;
                    ADbm_Color( { "R/W", "W+/R", "W+" } ) }

    IF Empty( aTargetInfo )  // file is not already in cTargetPath
    ELSE
       cTargetInfo := Trim( aTargetInfo[1][1] )+"  "+Str( aTargetInfo[1][2] ) ;
                      +"  "+ DtoC( aTargetInfo[1][3] ) +"  "+ aTargetInfo[1][4] 
       cSourceInfo := Trim( aSourceInfo[1][1] )+"  "+ Str( aSourceInfo[1][2] ) ;
                      +"  "+ DtoC( aSourceInfo[1][3] ) +"  "+ aSourceInfo[1][4] 
       nLongest := Max( Len( cTargetFile ), Len( cSourceFile ) )

       IF cTargetFile == cSourceFile
          aPrompt := { " " , ;
             " *** PROBLEM *** " , ;
             " " , ;
             " You cannot copy a file onto itself! " , ;
             " " , ;
             " Target: "+cTargetFile+" ", ;
             " Source: "+cSourceFile+" ", ;
             " ", ;
             " File not copied. ", ; 
             " "   }
          aOptions := { " Continue " }
          TBF_Bell()
          ADboxMenu( aPrompt, aOptions, { 2 },,,,bConfig )
          LOOP
       ENDIF    

       aPrompt := { " " , ;
             " *** WARNING *** " , ;
             " " , ;
             " You are about to OVERWRITE an existing file! " , ;
             " " , ;
             " Target: "+cTargetFile+Space( nLongest-Len( cTargetFile ) ) , ;
             " Source: "+cSourceFile+Space( nLongest-Len( cSourceFile ) ) , ;
             " " , ;
             " Target: "+cTargetInfo+" " , ;
             " Source: "+cSourceInfo+" " , ;
             " " , ;
             " Current system date and time will be stamped on Target File. ", ;
             " ", ;
             " Overwrite Target with Source? " , ;
             " "   }
       aOptions := { " Skip ", " Overwrite " }
       TBF_Bell()
       nSel := ADboxMenu( aPrompt, aOptions, { 2,2 },,,,bConfig )

       IF nSel == 1 // skip
          LOOP
       ENDIF                   
 
    ENDIF

    // check for diskspace() on target drive.

    IF Empty( aTargetInfo )  // file is not already in cTargetPath
       nSpaceOnDisk := DiskSpace( nDrive )
    ELSE
       nSpaceOnDisk := DiskSpace( nDrive )+aSourceInfo[1][2]
    ENDIF              

    IF nSpaceOnDisk >= aSourceInfo[1][2]
    ELSE
       aPrompt := { " " , ;
               " *** PROBLEM *** " , ;
               " " , ;
               " Insufficient Disk Space on Target Drive! " , ;
               " " , ;
               " Disk Space: "+Str( DiskSpace( nDrive ) )+" " , ;
               " File Size:  "+Str( aSourceInfo[1][2] )+" " , ;
               " " , ;               
               " "+cPath+AllTrim( aSourceInfo[1][1] )+" Not Copied. " , ;
               " "   }
       aOptions := { " Continue " }
       TBF_Bell()
       ADboxMenu( aPrompt, aOptions, { 2 },,,,bConfig )
       LOOP    
    ENDIF   

    cSourceName := aSourceInfo[1][1]

    ADmessage( { " " , ;
             " Copy file(s) " , ;
             "  " , ;
             "  " , ;
             " Copying "+cPath+cSourceName+" " , ;
             " " , ;
             "      To "+cTargetPath+cSourceName+" " , ;
             " " },,, FALSE, FALSE, { "B/W" } )

    COPY FILE ( cPath+AllTrim( SubStr( aSelections[ i ], 1, 12 ) ) ) ;
       TO ( cTargetPath+AllTrim( SubStr( aSelections[ i ], 1, 12 ) ) )

    ADm_rWait()
    InKey( 2 )


NEXT

ADrestScn( aScn )

RETURN

**---**---**---**---**---**---**---**--**--**---**---**---**---**---**---**---**

PROC TBF_Delete( cPath )  // gets array of files to delete

LOCAL aSelections, i, nSel, aPrompt, aOptions
LOCAL bConfig := { || ADvm_Header( cPath+cFileMask ) , ;
                      ADvm_MaxRight( MaxCol() - 2 ) , ;
                      ADvm_MaxBottom( MaxRow() - 3 ) , ;
                      ADvm_TagList() , ;
                      ADvm_TimeOut( 60, { || TBF_BlankScn() } ) , ;
                      ADvm_Extra( , { || ADvm_VersBar() } ) }
LOCAL aScn := ADsaveScn( 0, 0, MaxRow(), MaxCol() )

ADpl_FilFormat( "SDTA" )
ADpl_FilAttr( "SRHA" )
ADcls( "", "W+/B", 0, 0, MaxRow()-1, MaxCol() )

IF File( cPath+cFileMask ) // are there any files matching the file mask?
   TBF_TagMessage( "DELETE" )

   IF !Empty( aSelections := ADpl_Files( 1, 28, cPath, cFileMask, , bConfig ) )
      ADcls( "", "W+/B", 0, 0, MaxRow()-1, MaxCol() )
      TBF_Bell()
      bConfig := { || ADbm_TimeOut( 60, { || TBF_BlankScn() } ) , ;
                      ADbm_Color( { "R/W", "W+/R", "W+" } ) }

      FOR i = 1 to Len( aSelections )
          aPrompt := { " " , ;
                 " *** WARNING *** " , ;
                 " " , ;
                 " You are about to DELETE the file: " , ;
                 " " , ;
                 " "+cPath+AllTrim( SubStr( aSelections[ i ], 1, 12 ) )+" " , ;
                 " " }
          aOptions := { " Skip ", " Delete ", " Cancel " }
          nSel := ADboxMenu( aPrompt, aOptions, { 2,2,2 },,,,bConfig )

          DO CASE
             CASE nSel == 2
                  Delete File ( cPath+SubStr( aSelections[ i ], 1, 12 ) )
             CASE nSel == 3
                  EXIT
          ENDCASE                   
      NEXT    
   ENDIF
ELSE
   TBF_NoFiles( cPath )
ENDIF

ADrestScn( aScn )

RETURN

**---**---**---**---**---**---**---**--**--**---**---**---**---**---**---**---**

PROC TBF_View( cPath )  // gets array for file viewer

LOCAL aSelections, bOptions, i, aSelect[0], aFileInfo, nFileSize, aPrompt
LOCAL bConfig := { || ADvm_Header( cPath+cFileMask ) , ;
                      ADvm_MaxRight( MaxCol() - 2 ) , ;
                      ADvm_MaxBottom( MaxRow() - 3 ) , ;
                      ADvm_TagList() , ;
                      ADvm_TimeOut( 60, { || TBF_BlankScn() } ) , ;
                      ADvm_Extra( , { || ADvm_VersBar() } ) }
LOCAL aScn := ADsaveScn( 0, 0, MaxRow(), MaxCol() ), bConfig2, aOptions

ADpl_FilFormat( "SDTA" )
ADpl_FilAttr( "SRHA" )               

ADcls( "", "W+/B", 0, 0, MaxRow()-1, MaxCol() )

IF File( cPath+cFileMask ) // are there any files matching the file mask?

   TBF_TagMessage( "VIEW" )

   IF !Empty( aSelections := ADpl_Files( 1, 28, cPath, cFileMask, , bConfig ) )
      bConfig := { || ADfv_Coords( { 0, 0, MaxRow(), MaxCol() } ) , ;
                      ADfv_TimeOut( 60, { || TBF_BlankScn() } ), ;
                      ADfv_LineLength( 124 ) , ;
                      ADfv_Colors( { "W+/B", "B/W", "B/W" } ) }
      ADcls( " ", "W+/B", 0, 0, MaxRow()-1, MaxCol() )

      FOR i = 1 to Len( aSelections )

          aFileInfo := Directory( cPath+AllTrim( SubStr( aSelections[i], 1, 12 )))
          nFileSize := aFileInfo[1][2]
          IF nFileSize > 65535 .OR. Memory(2) <= ( nFileSize/1024 )
             ADcls( "", "W+/B", 0, 0, MaxRow()-1, MaxCol() )
             aPrompt := { " ", ;
              " *** PROBLEM *** ", ;
              " ", ;
              " "+cPath+Trim( aFileInfo[1][1] )+" ", ;
              " ", ;
              " Cannot be viewed. " ;
              +"To view a file, two conditions must be met: ", ;
              " ", ;
              " 1.) The size of the file must be less than 64K          ", ;
              " 2.) Memory(2) must be greater than the size of the file ", ; 
              " ", ;
              " File Size: "+SubStr( Str( nFileSize ), -7, 8 )+" / 1024 = " ;
                            +SubStr( Str( nFileSize/1024 ), -6, 6 )+"K ", ;
              " Memory(2): "+SubStr( Str( Memory(2) ), -4, 4 )+" " , ;
              " " }
             aOptions := { " Continue " }
             TBF_Bell()
             ADboxMenu( aPrompt, aOptions, { 2 },,,,bConfig2 )
             ADcls( " ", "B/B", 0, 0, MaxRow()-1, MaxCol() )
             LOOP
          ENDIF                                  
      
          aAdd( aSelect, aSelections[ i ] ) // if F10 Print, send current
          bOptions := { || TBF_Print( cPath, aSelect ) }  // file to TBF_Print()
          ADfView( cPath+SubStr( AllTrim( aSelections[ i ] ), 1,12 ), boptions, ;
                  bConfig, cPath+SubStr( AllTrim( aSelections[ i ] ), 1, 12 ) )
          aSelect := {}
      NEXT    

   ENDIF

ELSE
   TBF_NoFiles( cPath )
ENDIF

ADrestScn( aScn )

RETURN

**---**---**---**---**---**---**---**--**--**---**---**---**---**---**---**---**

PROC TBF_Bell()        // make the bell chime

LOCAL i := 1

FOR i = 1 TO 3
    Tone( 700, .1 )
NEXT

RETURN

**---**---**---**---**---**---**---**--**--**---**---**---**---**---**---**---**

PROC TBF_Credit()

LOCAL aScn := ADsaveScn( 0, 0, MaxRow(), MaxCol() )

ADmessage( { " " , ;
    "  Fellow Frankie Library users...                              " , ;
    "   " , ;
    "  You are welcome to use any or all of this code in your own   " , ;
    "  applications.  I submit it in the spirit of sharing and of   " , ;
    '  giving something back to the "community".                    ' , ;
    "  " , ;
    '  I encourage each of you to contribute one of your "Gems" <G> ' , ;
    "  to Lito for inclusion in the User Contributed Demo package.  " , ;
    "  Let's share techniques, ideas and help each other!           " , ;
    "  " , ;
    "  Please contact me with comments, questions, etc.             " , ;
    "  " , ;
    "  Mike Stephens               " , ;
    "  7717 1/2 West 16th Street   " , ;
    "  Tulsa, Oklahoma   74127     " , ;
    "  (918) 241-1142              " , ;
    "  " , ;
    "  CompuServe 73303,2410       " , ;
    "  " },,, FALSE, FALSE, { "B/W" } )

ADm_rWait()
ADwait( 60 )

ADrestScn( aScn )

RETURN

**---**---**---**---**---**---**---**--**--**---**---**---**---**---**---**---**

PROC TBF_Footer()     // paint date, time and heading in footer area

ADsay( MaxRow(), 0, Replicate( " ", 80 ), "B/W" )

ADcSay( MaxRow(), 0, MaxCol(), "The Frankie Library of Mouseable User " ;
        +"Interfaces for Clipper 5.xx", "B/W" )

RETURN

**---**---**---**---**---**---**---**--**--**---**---**---**---**---**---**---**

PROC TBF_NoFiles( cPath )

ADcls( "", "W+/B", 0, 0, MaxRow()-1, MaxCol() )

TBF_Bell()
   
ADmessage( { " " , ;
       " No files in the "+cPath+" " , ;
       " " , ;
       " drive\directory match the "+cFileMask+" file mask. " , ;
       " " , ;
       " Press any key or click a mouse button. " , ;
       " " } ,,, FALSE, FALSE, { "B/W" } )

ADm_rWait()
ADwait( 60 )
ADm_rWait()
    
RETURN

**---**---**---**---**---**---**---**--**--**---**---**---**---**---**---**---**

PROC TBF_TagMessage( cProcess )

ADmessage( { " " , ;
         " "+cProcess+" tagged files" , ;
         " " , ;
         "                     " , ;
         " To tag/untag files " , ;
         "  press the Spacebar " , ;
         "  or click on a file " , ;
         "  name.              " , ;
         "                     " , ;
         " To continue, press " , ;
         "  Enter or click the " , ;
         "  top-left corner of " , ;
         "  the screen.        " , ;
         "                     " , ;
         " To quit, press Esc " , ;
         "  or click the right " , ;
         "  mouse button.      " , ;
         " " } , 1, 1, FALSE, FALSE, { "B/W" } )

ADm_rWait()
             
RETURN

**---**---**---**---**---**---**---**--**--**---**---**---**---**---**---**---**

