/*
    VM_DEM07.PRG
    Copyright (c) The Programmer's Desk, 1992-94.  All rights reserved.

    This program demonstrates how to configure ADvermenu() to display
    behave as a restricted taglist.  In a restricted taglist, you define a
    number of tagging characters, which are concatenated into a string.
    You can select only as may options as there are tagging characters.
    In this example the tagging characters are "123".
*/




//--------------
func vm_demo07()
local nTop := 0, nLeft := 0
local aMenu := {;
                    "On the Cover",;
                    "News",;
                    "Test Drives",;
                    "Features",;
                    "The Experts",;
                    "Application Development",;
                    "The Basics",;
                    "Departments";
               }
local aTrigger := { 8,1,1,1,5,1,5,1 }
local bProcess := {|a| if( len( a ) > 0,;
                           (;
                              ADamodify( a, {|x| x := aMenu[x]} ),;
                              ADmessage( a );
                           ),;
                           ADmessage( {"Nothing was selected"} );
                         );
                  }
local bConfig := {|| ADvm_taglist( "123" ) }

Xinfo()
ADvermenu( nTop, nLeft, aMenu, aTrigger, bProcess, bConfig )
return nil

//-----------------
static func Xinfo()
ADmessage( {;
                "This ADvermenu is a restricted taglist.  You can only",;
                "select a maximum of three options.  Tag them with '1',",;
                "'2', or '3', or click them with the left button.  The",;
                "return value is a sorted array of selections";
           }, 14,, .f. )
return nil




