/*
    HM_DEM03.PRG
    Copyright (c) The Programmer's Desk, 1992-94.  All rights reserved.

    Demonstration of a pulldown menu.  It also demonstrates the use of the
    following APIs:

    ADhm_extra() - designates codeblocks to be EVALuated just before
        displaying the menu, right after displaying the menu, and just
        before exiting.

    ADhm_pulldown() - specifies which menu options are to be automatically
        pulled down when they get highlighted.

    ADhm_abort() - instructs the engine to terminate.

    ADpdmenu() - implements a pulldown vertical menu off the horizontal
        menu
*/



// Uncomment the following line if you are using Clipper 5.01.
// #include "f2_501.ch"

//--------------
func hm_demo03()
local aScn, aScn1
local aMenu := { "Databases", "Utilities", "Quit" }
local bConfig := {|| ADhm_extra(;
                                  {|| aScn := ADsavescn( 1,0,1,79 ),;   
                                      ADsay( 1,0, repl( "", 80 ), ADhm_colors()[1] );   
                                  },;   
                                  ,;
                                  {|| ADrestscn( aScn )};
                                ),;
                      ADhm_pulldown( {1,2,3} );
                 }
local aScn2:= ADcls( "" )[2]

aScn1 := ADmessage( { "The horizontal menu options are _active_ from the pulled down",;
                      "menus via the left mouse buttons, and the ALT combinations of",;
                      "their triggers, Alt-D, Alt-U and Alt-Q" },,, .f., .f. )
altd(0)     // so Clipper will not call the debugger when ALT-D is pressed
ADhormenu( aMenu,;
           ,;
           {;
                {|| X3databases()},;
                {|| X3utilities()},;
                {|| X3quit()};
           },;
           bConfig;
         )
ADrestscn( aScn1 )
ADrestscn( aScn2 )
return nil

//----------------
func X3databases()
local aMenu := { "Client", "Hardware", "Software" }
local aProcess := {;
                    {||ADmessage( { "Client" } )},;
                    {||ADmessage( { "Hardware" } )},;
                    {||ADmessage( { "Software" } )};
                  }
ADpdmenu( aMenu,, aProcess )
return nil


//----------------
func X3utilities()
local aMenu := { "Reindex", "Backup", "ChangeDirectory" }
local aProcess := {;
                    {||ADmessage( { "Reindex" } )},;
                    {||ADmessage( { "Backup" } )},;
                    {||ADmessage( { "ChangeDirectory" } )};
                  }
ADpdmenu( aMenu,, aProcess )
return nil


//-----------
func X3quit()
local aMenu := { "Yes", "No" }
if ADpdmenu( aMenu ) = 1
    ADhm_abort()
endif
return nil


