/*
    DB_DEM22.PRG
    Copyright (c) The Programmer's Desk, 1993.  All rights reserved.
*/


#include "inkey.ch"

// Uncomment the following line if you are using Clipper 5.01.
// #include "f2_501.ch"


//--------------
func db_demo22()
local aScn := ADsavescn( 0,0,24,79 )
local nArea := select()
local aEngines[3], nEngine, lContinue := .t.
local bConfig := {||ADdb_keys( {K_F10}, {||ADdb_exit(nEngine)} ),;
                    ADdb_lbuttons( { {0,0,2,79}, {9,0,11,79}, {17,0,19,79} },;
                                   {|n| Xlbuts24(n, @nEngine)};
                                 ),;
                    ADdb_escape( {||lContinue := .f., .t.});
                 }

if "F_TOUR.EXE" $ ADprogname()
    select 0
    use customer
    select 0
    use hardware
    select 0
    use software
else
    select 0
    use ..\customer
    select 0
    use ..\hardware
    select 0
    use ..\software
    ADset_help( "..\f_tour", { 4,10,20,69 } )
endif


aEngines[1] := { select( "customer" ), customer->( ADdbview( 0,0,8,79, bConfig, .f. ) ) }
aEngines[2] := { select( "hardware" ), hardware->( ADdbview( 9,0,16,79, bConfig, .f. ) ) }
aEngines[3] := { select( "software" ), software->( ADdbview( 17,0,23,79, bConfig, .f. ) ) }

dispbegin()
for nEngine := 1 to len( aEngines )
    ( aEngines[nEngine][1] )->( ADdb_display( aEngines[nEngine][2] ) )
next

ADchgcolor( 0,0,23,79, if( iscolor(), "W/N", "N/W" ) )
ADsay(24,0, space(80), "N/W" )
setpos(24,0)
ADdisplist( "F10",             "R/W",;
            ":NextBrowse   ",  "B/W",;
            "Esc",             "R/W",;
            ":Exit       ",    "B/W";
          )
ADdisplist( "Click Gray Browse to Move To It",   "GR+/W" )
dispend()

nEngine := 1

do while .t.
    (aEngines[nEngine][1])->( ADdb_activate( aEngines[nEngine][2], .f. ) )

    if lContinue
        nEngine := if( nEngine == len( aEngines ), 1, nEngine + 1 )
        ADchgcolor( 0,0,23,79, if( iscolor(), "W/N", "N/W" ) )
    else
        exit
    endif
enddo

dispbegin()
for nEngine := 1 to len( aEngines )
    ADdb_undisplay( aEngines[nEngine][2] )
    ADdb_kill(  aEngines[nEngine][2] )
next
dispend()

customer->( dbclosearea() )
hardware->( dbclosearea() )
software->( dbclosearea() )
select (nArea)
ADrestscn( aScn )
return NIL

//-------------------------------
static func Xlbuts24(n, nEngine)
ADm_rwait()
ADdb_exit(nEngine)
nEngine := n - 1
return NIL    


