/*
    DB_DEM20.PRG
    Copyright (c) The Programmer's Desk, 1993.  All rights reserved.
    Manipulates columns.
*/


#include "inkey.ch"

// Uncomment the following line if you are using Clipper 5.01.
// #include "f2_501.ch"



//--------------
func db_demo20()
local cTitleColor := if( iscolor(), "GR+/W", "N/W" )
local aLegendColor := if ( iscolor(), { "W/R", "W+/R" }, { "W/N", "W+/N" } )
local aTitleScn, aLegend
local nT := 4, nL := 3, nB := 16, nR := 76
local bConfig := {|| ADdb_colread(),;
                     ADdb_extra(;
                                 {||aTitlescn := ADsavescn( nB+1, nL, nB+1, nR ),;
                                    dispbegin(),;
                                    ADsay( nB+1, nL, padc( "The Frankie Column Manipulation Demo Program", nR - nL + 1 ), cTitleColor ),;
                                    aLegend := ADlegend(;
                                                            { "(Alt)Hide", "(Alt)Move", "(Alt)Width", "(Alt)Freeze", "Color", "Reset", "helP" },;
                                                            {      6,           6,           6,            6,        1,       1,           4  },;
                                                            NIL,;
                                                            aLegendColor,;
                                                            nB+2, nL, nR;
                                                       ),;
                                    ADdb_lbuttons(;
                                                        aLegend[2],;
                                                        {|n,r,c|XColumn(n,c,aLegend[2])};
                                                    ),;
                                    ADdb_keys(;
                                                    (;
                                                        aadd( aLegend[3], K_ALT_H ),;
                                                        aadd( aLegend[3], K_ALT_M ),;
                                                        aadd( aLegend[3], K_ALT_W ),;
                                                        aadd( aLegend[3], K_ALT_F ),;
                                                        aadd( aLegend[3], K_ESC ),;
                                                        aLegend[3];
                                                    ),;
                                                    {|n,k|XColumn(n,k)};
                                                ),;
                                    ADdbc_color( 4, "R+/W", "G+/W" );  // changes the color of the 4th column
                                 },;
                                 {||dispend()},;
                                 {|| ADrestscn( aLegend[1] ), ADrestscn( aTitleScn )};
                             );
                 }

ADmessage( {"If this demo seems to be a little complicated at first glance, press",;
            "the 'P' hot key, or click the 'helP' hot spot during the demo." } )
if "F_TOUR.EXE" $ ADprogname()
    use demo
else
    ADcls(,,,,,,.t.)
    use ..\demo
    ADset_help( "..\f_tour", { 4,10,20,69 } )
endif

ADdbview( nT, nL, nB, nR, bConfig )
use
return nil

#define HOTKEYS     7   // number of hotkeys
#define L_HIDE          ascan( { 1, 1+HOTKEYS }, nth ) > 0
#define L_MOVERIGHT     ascan( { 2, 2+HOTKEYS }, nth ) > 0
#define L_DECWIDTH      ascan( { 3, 3+HOTKEYS }, nth ) > 0
#define L_FREEZE        ascan( { 4, 4+HOTKEYS }, nth ) > 0
#define L_COLOR         ascan( { 5, 5+HOTKEYS }, nth ) > 0
#define L_RESET         ascan( { 6, 6+HOTKEYS }, nth ) > 0
#define L_HELP          ascan( { 7, 7+HOTKEYS }, nth ) > 0
#define L_UNHIDE        nth == HOTKEYS * 2 + 1
#define L_MOVELEFT      nth == HOTKEYS * 2 + 2
#define L_INCWIDTH      nth == HOTKEYS * 2 + 3
#define L_UNFREEZE      nth == HOTKEYS * 2 + 4
#define L_EXIT          nth == HOTKEYS * 2 + 5
//--------------------------------------
static func Xcolumn( nth, mCol, aSpots )
static aHiddenCol[0]
local aHiddenHdg[0]
local o := ADdb_object()
local nCol := o:colpos
local nSel, oCol, aGetColor[2], lAlt := .f.

ADm_rwait()

if aSpots != NIL
    lAlt := mCol >= aSpots[nth, 2] .and. mCol <= aSpots[nth, 2] + 4
endif

if L_HIDE .and. !lAlt
    if o:colpos <= o:freeze
        ADmessage( {"Cannot hide a frozen column"} )
    else
        oCol := ADdbc_hide( o:colpos )
    endif

    if oCol != NIL
        aadd( aHiddenCol, oCol )
    endif
elseif L_UNHIDE .or. ( L_HIDE .and. lAlt )
    if len( aHiddenCol ) > 0
        if o:colpos <= o:freeze
            ADmessage( {"Cannot unhide into a frozen column position" } )
        else
            aeval( aHiddenCol, {|x| aadd( aHiddenHdg, x:heading )} )
            nSel := ADvermenu( ,, aHiddenHdg )    

            if nSel > 0                                   
                ADdbc_unhide( o:colpos, aHiddenCol[nSel] )
                adel( aHiddenCol, nSel )
                asize( aHiddenCol, len( aHiddenCol ) - 1 )
            endif
        end
    endif
elseif L_MOVERIGHT .and. !lAlt
    if o:colpos <= o:freeze
        ADmessage( { "Cannot move a frozen column" } )
    else
        ADdbc_move( o:colpos, o:colcount )
    endif
elseif L_MOVELEFT .or. ( L_MOVERIGHT .and. lAlt )
    ADdbc_move( o:colpos, o:freeze + 1 )
elseif L_DECWIDTH .and. !lAlt
    ADdbc_width( nCol, max( ADdbc_width( nCol ) - 1, 1 ), .t. )
elseif L_INCWIDTH .or. ( L_DECWIDTH .and. lAlt )
    ADdbc_width( nCol, ADdbc_width( nCol ) + 1, .t. )
elseif L_FREEZE .and. !lAlt
    ADdbc_freeze( nCol )
elseif L_UNFREEZE .or. ( L_FREEZE .and. lAlt )
    ADdbc_freeze( 0 )
elseif L_COLOR    
    aGetColor := ADdbc_color( o:colpos )

    if ADg_many( aGetColor, {||ADgm_labels( { "Standard color", "Enhanced color" } )} )
        ADdbc_color( o:colpos, aGetColor[1], aGetColor[2], .t. )
    endif
elseif L_RESET
    ADdbc_reset( @aHiddenCol )
elseif L_HELP
    Xhelp()
elseif L_EXIT
    ADdb_exit()
endif

return nil


//-----------------
static func Xhelp()
local aMsg := {;
                "Active Keys",;
                "-----------",;
                "(H)ide       - Hides the current column, except if it is the sole column,",;
                "               or if it is a frozen column",;
                "(Alt-H)ide   - Unhides a hidden column",;
                "(M)ove       - Moves the current column to the rightmost position if the",;
                "               column is not frozen",;
                "(Alt-M)ove   - Moves the current column to the leftmost unfrozen position",;
                "(W)idth      - Reduces the width of the current column by 1, up to a",;
                "               minimum of one",;
                "(Alt-W)idth  - Increase the width of the current column by 1",;
                "(F)reeze     - Freezes columns to the left and including current",;
                "(Alt-F)reeze - Unfreezes frozen columns",;
                "(C)olor      - Changes the color of the current column",;
                "(R)eset      - Reset the column positions to their natural order",;
                "hel(P)       - Displays this Help screen",;
                "Left Mouse Button",;
                "-----------------",;
                "Click the prompt corresponding to the above hot keys.  Clicking",;
                "the '(Alt)' portion is equivalent to pressing the Alt key combination.";
              }
ADmessage( aMsg )
return NIL

