/*
    BM_DEM05.PRG
    Copyright (c) The Programmer's Desk, 1992-94.  All rights reserved.

    This demonstrates how to use the API ADbm_lbuttons() to define
    hot spots for the mouse left button.  All the corners of the
    screen are defined as hot spots in this example.
*/

#include "inkey.ch"

// Uncomment the following line if you are using Clipper 5.01.
// #include "f2_501.ch"


//--------------
func bm_demo05()
local aScn := ADmessage( { "The four screen corners are left button hot spots" },;
                         20,, .f., .f. )
local bConfig := {|| ADbm_lbuttons(;
                                     {;
                                        { 0,0,0,0 },;
                                        { 0,maxcol(),0,maxcol()},;
                                        { maxrow(), maxcol(), maxrow(), maxcol() },;
                                        { maxrow(), 0, maxrow(), 0 };
                                     },;
                                     {|nth,mrow,mcol| Xbuttons5(nth,mrow,mcol)};
                                  );
                 }
local nSel := ADboxmenu( "Which is better?",;
                         { "Alert()", "ADboxmenu()" },;
                         {1,3},;
                         ,,,;
                         bConfig;
                       )

if nSel = 1
    ADmessage( { "No kidding!" } )
else
    ADmessage( { "<G>" } )
endif

ADrestscn( aScn )
return nil

//-----------------------------
func Xbuttons5(nth,mrow, mcol)
ADm_rwait()
ADmessage( { "Clicked this screen coordinate: (" + ADn2s( mrow ) + ", "+ ADn2s(mcol) + ")",;
             "Which is #" + ADn2s(nth) + " in the array of hot spots" } )
return nil

