/*
    BM_DEM03.PRG
    Copyright (c) The Programmer's Desk, 1992-94.  All rights reserved.

    This demonstrates how to implement cascading menus.  Makes use of
    the following APIs:

    ADbm_current() - returns the index position of the currently
        highlighted option.
    ADbm_row() - returns the row position of the options.
    ADbm_col() - returns the column position where the currently 
        highlighted option starts.
    ADbm_abort() - aborts the menu.
*/



// Uncomment the following line if you are using Clipper 5.01.
// #include "f2_501.ch"

//--------------
func bm_demo03()
ADboxmenu( "Programmer?",;
           { "Yes", "No", "Abort" },,;
           {|| Xprogrammer()},;
           8, 4;
         )
return nil


//-----------------
func Xprogrammer()
local nSel := ADbm_current()

if nSel = 1
    ADboxmenu( "Clipper?",;
               { "Yes", "No", "Abort" },,;
               {|| Xclipper()},;
               ADbm_row() + 1,;
               ADbm_col() + 5;
             )
elseif nSel = 2
    ADmessage( { "Sorry, can't hire you!" } )
endif

ADbm_abort()
return nil

//--------------
func Xclipper()
local nSel := ADbm_current()

if nSel = 1
    ADboxmenu( "Version",;
               { "Summer 87", "5.xx", "Abort" },,;
               {|| Xversion()},;
               ADbm_row() + 1,;
               ADbm_col() + 5;
             )
elseif nSel = 2
    ADmessage( { "Sorry, can't hire you!" } )
endif

ADbm_abort()
return nil

//--------------
func Xversion()
local nSel := ADbm_current()

if nSel = 2
    ADboxmenu( "Know Frankie?",;
               { "Yes", "No", "Abort" },,;
               {|| Xfrankie()},;
               ADbm_row() + 1,;
               ADbm_col() + 5;
             )
elseif nSel = 1
    ADmessage( { "Sorry, can't hire you!" } )
endif

ADbm_abort()
return nil


//--------------
func Xfrankie()
local nSel := ADbm_current()

if nSel = 1
    ADmessage( { "You're hired!  Starting salary is 60K" } )
elseif nSel = 2
    ADmessage( { "You're hired!  Starting salary is 40K" } )
endif

ADbm_abort()
return nil

