/*
    FDEM05.PRG
    Copyright 1993, Angelito Dizon.  All rights reserved.


    This program demonstrates how to inactivate push buttons, how to change
    and restore their colors, on the fly.

    To use this demo, you should have Frankie v2.1.  A full-featured
    shareware version is available in these two electronic locations:

        1. CompuServe, Clipper forum, Lib 7
        2. RRR BBS, (301)464-1372, Vendor Support Area

    Look for Frank.zip (Library) and Frankg.zip (NG file).

    To compile: clipper fdem05 /a /b /n /v /w
    To link: blinker (or rtlink) file fdem05 lib frankie 

    Other files needed to run the demo: FDEM05.HLP and FDEM05.HLX (Help files)
*/


//-----------
func fdemo05()
local e, nSel, aCursor, aScn
local lActive := .t.    // all buttons are initially active
local aInactive := {}



if "F_TOUR.EXE" $ ADprogname()
    ADset_help( "newdemo\newdemos" )                  
else
    ADset_help( "newdemos" )                  
endif

ADhelp( "ABOUT06", "About This Demo" )
aCursor := ADsavecsr(0)
aScn := ADcls()[2]
e := ADpb_vertical( 4, 4,;
                    {;
                      { " The    ", "W+/G" },;
                      { " Quick  ", "W+/G" },;
                      { " Brown  ", "W+/G" },;
                      { " Fox    ", "W+/G" },;
                      { " toGgle ", "W+/B" },;
                      { " Help   ", "W+/N" },;
                      { " eXit   ", "W+/N" };
                    },;
                    {2,2,2,2,4,2,3},;  // trigger positions
                    NIL,;
                    NIL,;
                    "PUSHBUTTONS";
                  )
ADpb_show(e, "BG")

do while .t.
    nSel := ADpb_activate( e, aInactive )

    if nSel <= 4 .and. lActive
        if nSel == 1
            ADmessage( { "The" } )
        elseif nSel == 2
            ADmessage( { "Quick" } )
        elseif nSel == 3
            ADmessage( { "Brown" } )
        elseif nSel == 4
            ADmessage( { "Fox" } )
        endif
    elseif nSel == 5
        if lActive
            aInactive := { 1,2,3,4 }
            lActive := .f.
            ADmessage( { "Will toggle OFF the first 4 buttons" } )
            ADpb_chgcolor( e, 1, "W/BG", "W/BG" )
            ADpb_chgcolor( e, 2, "W/BG", "W/BG" )
            ADpb_chgcolor( e, 3, "W/BG", "W/BG" )
            ADpb_chgcolor( e, 4, "W/BG", "W/BG" )
        else
            aInactive := {}
            lActive := .t.
            ADmessage( { "Will toggle ON the first 4 buttons" } )
            ADpb_restcolor( e, 1 )
            ADpb_restcolor( e, 2 )
            ADpb_restcolor( e, 3 )
            ADpb_restcolor( e, 4 )
        endif
    elseif nSel == 6
        ADhelp( "PUSHBUTTONS" )
    elseif nSel == 7
        ADpb_kill(e)
        exit
    endif
enddo

ADrestscn( aScn )
ADrestcsr( aCursor )
return NIL

