/*
    The source code contained within this file is protected under the
    laws of the United States of America and by International Treaty.
    Unless otherwise noted, the source contained herein is:

    Copyright (c)1990-1994 BecknerVision Inc - No Rights Reserved

    Written by John Wm Beckner
    BecknerVision Inc

        ** THIS FILE IS PUBLIC DOMAIN **

        ** Use of this code is at your own risk, absolutely no guarantees
        ** are made to its usefulness  - you must determine for yourself if
        ** this code is of any use to you.  If you do not agree with this, do
        ** not use this code. **
*/

#include "beckner.inc"

////////////////
////////////////
//
// Purpose:
//    Creates a new file containing certain records from another file
//
// Syntax:
//    C> EXTRACT <cFrom> <cTo> <cExpr>
//
// Formal Arguments: (3)
//    Name        Description
//    ___________ ____________
//    cFrom       Source database file
//    cTo         Target database file
//    cExpr       FOR expression
//
// Examples:
//    C> REM The following creates xxfm.db? and xxfmdata.db?
//    C> EXTRACT bvfm xxfm Form_No='XX001'
//    C> EXTRACT bvfmdata xxfmdata Form_No='XX001'
//
// Files:
//    (<cFrom>.dbf[/t])
//    (<cTo>.dbf[/t])
//
// Description:
//    Calls fExtract() to extract records from one file into another based
//    on a filter condition.
//
// See Also:
//    fExtract()
//
// Category:
//    Utility Program
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

FUNCTION Main(cFrom, cTo, cFor)
   IF cFrom=NIL
      ? "Syntax: EXTRACT <fromfile> <tofile> <forcondition>"
   ELSE
      fExtract(cFrom, cTo, cFor, .y.)
   ENDIF
ENDFUNCTION
