/*
    The source code contained within this file is protected under the
    laws of the United States of America and by International Treaty.
    Unless otherwise noted, the source contained herein is:

    Copyright (c)1990, 1991, 1992 BecknerVision Inc - All Rights Reserved

    Written by John Wm Beckner        THIS NOTICE MUST NOT BE REMOVED
    BecknerVision Inc
    PO Box 11945                      SOURCE CODE (THIS FILE) MAY NOT BE
    Winston-Salem NC 27116            DISTRIBUTED!  ONLY REGISTERED USERS
    Fax: 919/760-1003                 OF BECKNER LIBRARY & UTILITIES II MAY
                                      BE IN POSSESSION OF THIS FILE.
*/

#include "beckner.inc"

/*
PURPOSE
-------

A general-purpose word processor, with these features:

01. Maintains list of available letters.
02. Can import from other formats, specifically:
      02-01. ASCII.
03. User defineable keys, which are:
      03-01. <UpLine>.
      03-02. <DownLine>.
      03-03. <LeftChar>.
      03-04. <RightChar>.
      03-05. <UpPage>.
      03-06. <DownPage>.
04. Export capability of letter into these formats:
      04-01. ASCII.
      04-02. Database field.
05. Can execute a code block before and/or after a letter is printed.
06. Can print to various devices/files.
07. Maintains a printer list.
08. Allows embedded codes, which may be invisible, and include:
      08-01. <BoldOn>.
      08-02. <BoldOff>.
      08-03. <UnderlineOn>.
      08-04. <UnderlineOff>.

*/

#include "alias.ch"
#include "memoedit.ch"
#include "inkey.ch"

FUNCTION wp(nLetter)
   LOCAL lScoreboard := Set(_SET_SCOREBOARD)
   LOCAL bOldIns := SetKey(K_INS, {||vInsCursor()})
   LOCAL cVersion := "v1.0"
   vSave()
   vCursSave()
   CLS
   vBackground()
   vTitle({"BecknerVision Word Processor II",;
         "version "+cVersion,;
         "Written by John Wm Beckner",;
         "---",;
         "Copyright (c)1992 BecknerVision Inc",;
         "All Rights Reserved"})
/* temp */
fShare("j:\bpfs\bpacct", "Account")
wpEdit()
/* Restore environment */
   Set(_SET_SCOREBOARD, lScoreboard)
   SetKey(K_INS, bOldIns)
   vRestore()
   vCursRest()
ENDFUNCTION

STATIC FUNCTION wpEdit()
   SET COLOR to /* should be user-defined */ b/w
   CLS
   @ 0, 0 SAY "Page:      Line:     Col:     Mode:" COLOR "g/w+"
   SET PRINT ON
   ?? MemoEdit("", 1, 0, MaxRow(), MaxCol(), .y., "wpEditKey")
   SET PRINT OFF
ENDFUNCTION

FUNCTION wpEditKey(nMode, nLine, nCol)
   @ 0,  6 SAY PageNumber() PICTURE "9999" COLOR "g/w"
   @ 0, 17 SAY nLine PICTURE "999" COLOR "g/w"
   @ 0, 26 SAY nCol PICTURE "999" COLOR "g/w"
   @ 0, 36 SAY iif(ReadInsert(), "INS", "OVR") COLOR "g/w"
   RETURN ME_DEFAULT
ENDFUNCTION

STATIC FUNCTION PageNumber(nNewNumber)
   STATIC nPageNumber := 1
   LOCAL nOldNumber := nPageNumber
   IF nNewNumber=NIL
      nPageNumber := nNewNumber
   ENDIF
   RETURN nOldNumber
ENDFUNCTION
