/*
    The source code contained within this file is protected under the
    laws of the United States of America and by International Treaty.
    Unless otherwise noted, the source contained herein is:

    Copyright (c)1990, 1991, 1992 BecknerVision Inc - All Rights Reserved

    Written by John Wm Beckner        THIS NOTICE MUST NOT BE REMOVED
    BecknerVision Inc
    PO Box 11945                      SOURCE CODE (THIS FILE) MAY NOT BE
    Winston-Salem NC 27116            DISTRIBUTED!  ONLY REGISTERED USERS
    Fax: 919/760-1003                 OF BECKNER LIBRARY & UTILITIES II MAY
                                      BE IN POSSESSION OF THIS FILE.
*/

#include "beckner.inc"

FUNCTION vWindow(nRows, nColumns, lDouble, cTitle, cColor)
   LOCAL nStartRow, nStartCol, nEndRow, nEndCol, nTitleLength, nTitleCol
   LOCAL cTtlColor
   DEFAULT lDouble TO .y., nColumns TO 50, nRows TO 1
   iif(cTitle=NIL, cTitle := "", iif(!empty(cTitle), nRows++,))
   nRows     += 2
   nColumns  += 2
   nStartRow := Int(MaxRow()/2-nRows/2+1)
   nStartCol := Int(MaxCol()/2-nColumns/2+1)
   nEndRow   := nStartRow+nRows-1
   nEndCol   := nStartCol+nColumns-1
   IF iBackground()
      @ nStartRow, nStartCol CLEAR TO nEndRow, nEndCol
   ELSE
      CLS
   ENDIF
   IF lDouble
      @ nStartRow, nStartCol TO nEndRow, nEndCol DOUBLE
   ELSE
      @ nStartRow, nStartCol TO nEndRow, nEndCol
   ENDIF
   IF !Empty(cTitle)
      nTitleLength := Len(cTitle)
      nTitleCol    := Int(maxcol()/2-nTitleLength++/2)
      cTtlColor    := SetColor("i")
      @ nStartRow-1, nTitleCol CLEAR TO nStartRow+1, nTitleCol+nTitleLength
      @ nStartRow-1, nTitleCol TO nStartRow+1, nTitleCol+nTitleLength
      @ nStartRow, ++nTitleCol SAY cTitle
      SetColor(cTtlColor)
      nStartRow++
   ENDIF
   RETURN {++nStartRow, ++nStartCol}
ENDFUNCTION
