/*
    The source code contained within this file is protected under the
    laws of the United States of America and by International Treaty.
    Unless otherwise noted, the source contained herein is:

    Copyright (c)1990, 1991, 1992 BecknerVision Inc - All Rights Reserved

    Written by John Wm Beckner        THIS NOTICE MUST NOT BE REMOVED
    BecknerVision Inc
    PO Box 11945                      SOURCE CODE (THIS FILE) MAY NOT BE
    Winston-Salem NC 27116            DISTRIBUTED!  ONLY REGISTERED USERS
    Fax: 919/760-1003                 OF BECKNER LIBRARY & UTILITIES II MAY
                                      BE IN POSSESSION OF THIS FILE.
*/

#include "beckner.inc"
#include "alias.ch"
#include "inkey.ch"
#define  M_NAME       1
#define  M_CHAR       2
#define  M_CHARNO     3
#define  M_COLUMN     4
#define  C_NORMAL     1
#define  C_CHAR       2
#define  C_ACTIVE     3
#define  C_A_CHAR     4
#define  C_BACKGROUND 5
#define  C_BORDER     6
#define  C_GRAY       7

FUNCTION vPullDown(aMenu, aRowCol, nSpacing, aColor)
   LOCAL GetList := {}, aPrimary := {}, lCenter, nChoice := 1, nLength := 0
   LOCAL nCtr, nKey, nTopLength, nSave, aPullDown, nChoice2 := 0, nChoice3
   LOCAL nPullDown, cOptions, nMax2, lLoop := .n., cTemp
   /* Example menu:

     ^File      ^Maintenance      ^Reports
     ^Add       ^Files      >     ^Report Generator
     ^Delete    ------------      ^Label Generator
     ^Edit      ^Assist           ^Forms Generator
     -------                      ^Word Processor
     ^Scan
     -------
     E^xit

     The pull-down window's length will be the maximum of the top item's
     length and the maximum length of any pull-down item plus 6 (the border
     plus 2 spaces minimum on the inside of the border).  Note the > symbol
     after Files option (under Maintenance), thus allowing another Pull-Down
     to the right if chosen.  The aMenu array for this would be:
     aMenu := {"^File:^Add:^Delete:^Edit:-:^Scan:-:E^xit",;
               "^Maintenance:^Files[^Account:^Policy:^Transactions]:-:^Assist",;
               "^Reports:^Report Generator:^Label Generator:^Forms Generator:Word Processor"}

     A sample command would be:

     MENU aMenu TO nOption  // using defaults, or specify defaults with:
     MENU aMenu TO nOption AT 0 CENTER
   */
   DEFAULT aRowCol TO {0, -1},;
           nSpacing TO 3,;
           aColor TO {"w/n", "u", "n/w", "u", "n", "w", "w+/n"}
           /* Normal, Highlight char, Active, Active Highlight, Background,
              Border, Gray */
   lCenter    := (aRowCol[2]=-1)
   /* Clear row which top menu will be on */
   @ aRowCol[1], 0
   /* nLength := sum of lengths of top menu items */
   aEval(aMenu, {|cItem| nLength += Len(sParse(cItem, ":"))-1})
   /* if centered, figure spacing */
   iif(lCenter, nSpacing := Int((MaxCol()+1)/(Len(aMenu)+2)),)
   /* Set up top row */
         /* 1st element in aPrimary is the word at the top of the screen */
   aEval(aMenu, {|cItem| aAdd(aPrimary, {StrTran(sParse(cItem, ":"), "^"),;
         /* 2nd element is the unique access character for the item */;
         SubStr(cItem, At("^", cItem)+1, 1),;
         /* 3rd element is the character number for access */;
         At("^", cItem)})})
   nTopLength := Len(aPrimary)
   WHILE LOOPING
      pdHighlight(aRowCol, nSpacing, aPrimary, aColor, nChoice)
      nKey := vGetKey()
      DO CASE
      CASE nKey=K_DOWN .or. nKey=K_RIGHT
         nChoice++
         iif(nChoice>nTopLength, nChoice := 1,)
         LOOP
      CASE nKey=K_UP .or. nKey=K_LEFT
         nChoice--
         iif(nChoice=0, nChoice := nTopLength, )
         LOOP
      CASE nKey=K_ESC
         nChoice := 0
         EXIT
      CASE nKey>K_SPACE
         nSave   := nChoice
         nChoice := aScan(a1From2(aPrimary, M_CHAR),;
               {|cChar| Upper(cChar)=Upper(Chr(nKey))})
         IF nChoice=0
            nChoice=nSave
            LOOP
         ENDIF
         pdHighlight(aRowCol, nSpacing, aPrimary, aColor, nChoice)
      OTHERWISE
         IF nKey!=K_ENTER
            pBeep()
            LOOP
         ENDIF
      ENDCASE
      /* 2nd level */
      aPullDown := {}
      cOptions  := aMenu[nChoice]
      nPullDown := 0
      /* Remove top item from pull down items */
      sParse(@cOptions, ":")
      /* Build aPullDown item list */
      WHILE !Empty(cOptions)
         nPullDown++
         IF cOptions="-"
            aAdd(aPullDown, {"", "", 0})
            sParse(@cOptions, ":")
         ELSE
            cTemp := sParse(@cOptions, ":")
            aAdd(aPullDown, {StrTran(cTemp, "^"),;
                  SubStr(cTemp, At("^", cTemp)+1, 1),;
                  At("^", cTemp)})
            /* Handle possible sub-sub-menu */
            IF "["$aTail(aPullDown)[M_NAME]
               aPullDown[nPullDown, M_NAME] := Left(aTail(aPullDown),;
                     AT("[", aTail(aPullDown))-1)+" "+Chr(16)
            ENDIF
         ENDIF
      ENDWHILE
      /* Display submenu */
      nChoice2 := 1
      vSave()
      WHILE LOOPING
         pdHigh2(aRowCol[1], aPrimary[nChoice, M_COLUMN], aPullDown, aColor,;
               nChoice2)
         nKey := vGetKey()
         DO CASE
         CASE nKey=K_RIGHT .or. nKey=K_LEFT
            lLoop := .y.
            KEYBOARD Chr(nKey)
            EXIT
         CASE nKey=K_DOWN
            nChoice2++
            iif(nChoice2>nPullDown, nChoice2 := 1,)
            WHILE aPullDown[nChoice2, M_NAME]==""
               nChoice2++
               iif(nChoice2>nPullDown, nChoice2 := 1,)
            ENDWHILE
            LOOP
         CASE nKey=K_UP
            nChoice2--
            iif(nChoice2=0, nChoice2 := nPullDown, )
            WHILE aPullDown[nChoice2, M_NAME]==""
               nChoice2--
               iif(nChoice2<=0, nChoice2 := nPullDown, )
            ENDWHILE
            LOOP
         CASE nKey=K_ESC
            lLoop    := .y.
            nChoice2 := 0
            EXIT
         CASE nKey>K_SPACE
            nSave    := nChoice2
            nChoice2 := aScan(a1From2(aPullDown, M_CHAR),;
                  {|cChar| Upper(cChar)=Upper(Chr(nKey))})
            IF nChoice2=0
               nChoice2=nSave
               LOOP
            ENDIF
            pdHigh2(aRowCol[1], aPrimary[nChoice, M_COLUMN], aPullDown,;
                  aColor, nChoice2)
         OTHERWISE
            IF nKey!=K_ENTER
               pBeep()
               LOOP
            ENDIF
         ENDCASE
         EXIT
      ENDWHILE
      vRestore()
      IF lLoop
         lLoop := .n.
         LOOP
      ENDIF
      EXIT
   ENDWHILE
   RETURN nChoice+nChoice2/100.00
ENDFUNCTION

STATIC FUNCTION vGetKey()
   RETURN Inkey(0)
ENDFUNCTION

STATIC FUNCTION aMaxLength(aAny)
   LOCAL nLength := 0
   aEval(aAny, {|cItem| iif(ValType(cItem)="C",;
         nLength := Max(Len(cItem), nLength), )})
   RETURN nLength
ENDFUNCTION

STATIC FUNCTION pdHighlight(aRowCol, nSpacing, aPrimary, aColor, nChoice)
   LOCAL nCtr, nMaxEls := Len(aPrimary)
   /* Display top line unhighlighted */
   SetPos(aRowCol[1], iif(aRowCol[2]>0, aRowCol[2], nSpacing-1))
   aEval(aPrimary, {|aItem, nElement| aAdd(aPrimary[nElement], Col()),;
         qQout(aItem[1]+iif(nMaxEls=nElement, "", Space(nSpacing)))})
   /* Highlight all access characters */
   FOR nCtr := 1 TO Len(aPrimary)
      @ aRowCol[1], aPrimary[nCtr, M_COLUMN]+aPrimary[nCtr, M_CHARNO]-1;
      SAY aPrimary[nCtr, M_CHAR];
      COLOR aColor[C_CHAR]
   NEXT
   /* Highlight current option */
   @ aRowCol[1], aPrimary[nChoice, M_COLUMN];
         SAY aPrimary[nChoice, M_NAME];
         COLOR aColor[C_ACTIVE]
   /* Highlight current access character */
   @ aRowCol[1], aPrimary[nChoice, M_COLUMN]+aPrimary[nChoice, M_CHARNO]-1;
         SAY aPrimary[nChoice, M_CHAR];
         COLOR aColor[C_A_CHAR]
ENDFUNCTION

STATIC FUNCTION pdHigh2(nStartRow, nCol, aPullDown, aColor, nChoice2)
   LOCAL nCtr, nMax2, nPullDown, cOldColor
   nPullDown := Len(aPullDown)
   /* Display submenu */
   /* Display top line unhighlighted */
   nMax2 := aMaxLength(a1From2(aPullDown, M_NAME))
   cOldColor := SetColor(aColor[C_BACKGROUND])
   @ nStartRow+1, nCol-3 CLEAR TO nStartRow+nPullDown+2, nCol+nMax2+3
   SetColor(cOldColor)
   @ nStartRow+1, nCol-3 TO nStartRow+nPullDown+2, nCol+nMax2+3;
         COLOR aColor[C_BORDER]
   SetPos(nStartRow+1, nCol)
   aEval(aPullDown, {|aItem| SetPos(Row()+1, nCol-2),;
         iif(aItem[M_NAME]=="", (DevOut(Replicate(Chr(196), nMax2+5), aColor[C_BORDER]),;
         SetPos(Row(), nCol-3), DevOut(Chr(195), aColor[C_BORDER]),;
         SetPos(Row(), nCol+nMax2+3), DevOut(Chr(180), aColor[C_BORDER])),)})
   SetPos(nStartRow+1, nCol)
   aEval(aPullDown, {|aItem| SetPos(Row()+1, nCol),;
         DevOut(sSetLength(aItem[M_NAME], nMax2), aColor[C_NORMAL])})
   /* Highlight all access characters */
   SetPos(nStartRow+1, nCol)
   FOR nCtr := 1 TO nPullDown
      IF !Empty(aPullDown[nCtr, M_NAME])
         @ Row()+1, nCol+aPullDown[nCtr, M_CHARNO]-1;
               SAY aPullDown[nCtr, M_CHAR];
               COLOR aColor[C_CHAR]
      ELSE
         SetPos(Row()+1, Col())
      ENDIF
   NEXT
   /* Highlight current option */
   @ nStartRow+1+nChoice2, nCol;
         SAY sSetLength(aPullDown[nChoice2, M_NAME], nMax2);
         COLOR aColor[C_ACTIVE]
   /* Highlight current access character */
   @ Row(), nCol+aPullDown[nChoice2, M_CHARNO]-1;
      SAY aPullDown[nChoice2, M_CHAR];
      COLOR aColor[C_A_CHAR]
ENDFUNCTION
