/*
    The source code contained within this file is protected under the
    laws of the United States of America and by International Treaty.
    Unless otherwise noted, the source contained herein is:

    Copyright (c)1990, 1991, 1992 BecknerVision Inc - All Rights Reserved

    Written by John Wm Beckner        THIS NOTICE MUST NOT BE REMOVED
    BecknerVision Inc
    PO Box 11945                      SOURCE CODE (THIS FILE) MAY NOT BE
    Winston-Salem NC 27116            DISTRIBUTED!  ONLY REGISTERED USERS
    Fax: 919/760-1003                 OF BECKNER LIBRARY & UTILITIES II MAY
                                      BE IN POSSESSION OF THIS FILE.
*/

#include "beckner.inc"
#include "set.ch"

FUNCTION pUpdate(cStruFile)
   LOCAL nCtr, cTemp1, cTemp2, cTemp3, lExact, cUpdateType, lDeleted, nHandle
   LOCAL cTempString, cChar, nTemp, c255, cFields, nCtr2, nCtr3, nPointer
   LOCAL aTFld := {}, aTType := {}, aTLen := {}, aTDec := {}, f1, f2
   LOCAL aSFld := {}, aSType := {}, aSLen := {}, aSDec := {}
   IF !File(fExtNew(cStruFile, 'DBF'))
      RETURN NIL
   ENDIF
   eSave()
   iShare(.n.)
   lDeleted := Set(_SET_DELETED, .n.)
   lExact   := Set(_SET_EXACT, .y.)
   IF !fNoShare(cStruFile, 'system', .n.)
      pErrorMsg('SYSTEM file already in use', .y.)
   ENDIF
   cTemp1 := 'Integrity check in progress'
   nCtr   := vCenterPos(cTemp1)
   c255   := Chr(255)
   WHILE !EOF()
      @ MaxRow(), 0
      cTemp2 := 'Processing '+System->FileName
      @ 24,0 SAY cTemp2
      cFields := System->Field_List
      IF Left(cFields, 1)=c255
         IF !File(System->FileName)
            nHandle     := fCreate(System->FileName)
            cTempString := SubStr(cFields, 2, 1990)
            FOR nTemp := 1 TO 1990
               cChar := SubStr(cTempString, nTemp, 1)
               IF cChar=c255
                  fWrite(nHandle, Chr(0), 1)
               ELSE
                  fWrite(nHandle, cChar, 1)
               ENDIF
            NEXT
            fClose(nHandle)
         ENDIF
         SKIP
         LOOP
      ELSEIF Left(cFields, 1)=Chr(254)
         IF !File(System->FileName)
            nHandle     := fCreate(System->FileName)
            cTempString := SubStr(cFields, 2, 1034)
            FOR nTemp := 1 to 1034
               cChar := SubStr(cTempString, nTemp, 1)
               IF cChar=c255
                  fWrite(nHandle, Chr(0), 1)
               ELSE
                  fWrite(nHandle, cChar, 1)
               ENDIF
            NEXT
            fClose(nHandle)
         ENDIF
         SKIP
         LOOP
      ENDIF
      IF !File(fExtNew(Trim(System->FileName), "DBF"))
         fCreateDBF(iif('.'$System->FileName, Left(System->FileName,;
               At('.', System->FileName)-1),;
               Trim(System->FileName))+'/'+cFields)
         cUpdateType := 'C'
      ELSE
         SELECT 0
         fCreateDBF('Beckner$/'+cFields)
         fNoShare(Trim(System->FileName), 'Target')
         nTemp := fCount()
         aSize(aTFld, nTemp)
         aSize(aTType, nTemp)
         aSize(aTLen, nTemp)
         aSize(aTDec, nTemp)
         aFields(aTFld, aTType, aTLen, aTDec)
         SELECT 0
         fNoShare('Beckner$', 'Source')
         nTemp := fCount()
         aSize(aSFld, nTemp)
         aSize(aSType, nTemp)
         aSize(aSLen, nTemp)
         aSize(aSDec, nTemp)
         aFields(aSFld, aSType, aSLen, aSDec)
         cUpdateType := 'N' && C/reated  N/o-update  A/ppend-only  F/ull-append
         FOR nCtr2 := 1 TO nTemp
            nPointer := aScan(aTFld, aSFld[nCtr2])
            IF nPointer=0
               cUpdateType := 'A'
            ELSE
               IF aTType[nPointer]!=aSType[nCtr2]
                  cUpdateType := 'F'
                  EXIT
               ELSEIF aTLen[nPointer]!=aSLen[nCtr2];
                     .or. aTDec[nPointer]!=aSDec[nCtr2]
                  cUpdateType := 'A'
               ENDIF
            ENDIF
         NEXT
         * temp change since only 'F' maintains deleted records
         IF cUpdateType='A'
            cUpdateType := 'F'
         ENDIF
         * end change
         IF cUpdateType='A'
            SELECT Target
            CLOSE
            SELECT Source
            APPEND FROM (System->FileName)
            CLOSE
            cTemp3 := fExtNew(Trim(System->FileName), "DBF")
            ERASE (cTemp3)
            RENAME Beckner$.dbf TO (cTemp3)
            IF File('Beckner$.dbt')
               cTemp3 := Left(cTemp3, Len(cTemp3)-1)+'t'
               IF File(cTemp3)
                  ERASE (cTemp3)
               ENDIF
               RENAME Beckner$.dbt TO (cTemp3)
            ENDIF
         ELSEIF cUpdateType='F'
            SET DELETED OFF
            SELECT Target
            GO TOP
            WHILE !EOF()
               SELECT Source
               APPEND BLANK
               FOR nCtr2 := 1 TO nTemp
                  nCtr3 := aScan(aTFld, aSFld[nCtr2])
                  IF nCtr3>0
                     f1 := aSFld[nCtr2]
                     f2 := aTFld[nCtr3]
                     IF aTType[nCtr3]=aSType[nCtr2]
                        repl &f1. with target->&f2.
                     ELSE
                        IF aSType[nCtr2]$'CM'
                           IF aTType[nCtr3]='N'
                              repl &f1. with str(target->&f2.,aSLen[nCtr2],aTDec[nCtr3])
                           ELSEIF aTType[nCtr3]='L'
                              repl &f1. with iif(target->&f2.,'Y','N')
                           ELSEIF aTType[nCtr3]$'CM'
                              repl &f1. with target->&f2.
                           ELSEIF aTType[nCtr3]='D'
                              repl &f1. with dtoc(target->&f2.)
                           ENDIF
                        ELSEIF aSType[nCtr2]='N'
                           IF aTType[nCtr3]$'CM'
                              repl &f1. with iif(len(ltrim(str(val(target->&f2.))))>aSLen[nCtr2],0,val(target->&f2.))
                           ELSEIF aTType[nCtr3]='L'
                              repl &f1. with iif(target->&f2.,1,0)
                           ELSEIF aTType[nCtr3]='D'
                              IF aSLen[nCtr2]>7
                                 repl &f1. with val(dtos(target->&f2.))
                              ENDIF
                           ENDIF
                        ELSEIF aSType[nCtr2]='L'
                           IF !empty(target->&f2.)
                              repl &f1. with .y.
                           ENDIF
                        ELSEIF aSType[nCtr2]='D'
                           IF aTType[nCtr3]$'CM'
                              repl &f1. with ctod(target->&f2.)
                           ENDIF
                        ENDIF
                     ENDIF
                  ENDIF
               NEXT
               SELECT target
               IF deleted()
                  SELECT source
                  DELETE
                  SELECT target
               ENDIF
               SKIP
            ENDWHILE
            SELECT target
            CLOSE
            SELECT source
            CLOSE
            cTemp3 := fExtNew(system->filename, "DBF")
            ERASE (cTemp3)
            RENAME Beckner$.dbf to (cTemp3)
            IF file('Beckner$.dbt')
               cTemp3 := left(cTemp3, len(cTemp3)-1)+'t'
               ERASE (cTemp3)
               RENAME Beckner$.dbt to (cTemp3)
            ENDIF
         ELSE
            SELECT target
            CLOSE
            SELECT source
            CLOSE
         ENDIF
      ENDIF
      SELECT system
      SKIP
   ENDWHILE
   CLOSE
   set(_SET_EXACT, lExact)
   set(_SET_DELETED, lDeleted)
   eRestore()
ENDFUNCTION
