/*
    The source code contained within this file is protected under the
    laws of the United States of America and by International Treaty.
    Unless otherwise noted, the source contained herein is:

    Copyright (c)1990, 1991, 1992 BecknerVision Inc - All Rights Reserved

    Written by John Wm Beckner        THIS NOTICE MUST NOT BE REMOVED
    BecknerVision Inc
    PO Box 11945                      SOURCE CODE (THIS FILE) MAY NOT BE
    Winston-Salem NC 27116            DISTRIBUTED!  ONLY REGISTERED USERS
    Fax: 919/760-1003                 OF BECKNER LIBRARY & UTILITIES II MAY
                                      BE IN POSSESSION OF THIS FILE.
*/

#include "beckner.inc"
#include "inkey.ch"

EXTERNAL StrZero, sConvertName, sZipPicture, dBegMonth, dEndMonth, dSame
EXTERNAL dbEval, dMMYY, fScan

FIELD cMenuName, lReport, cFlName, cDevice, cPrnStart, cPrnEnd, cDBF
FIELD cIndex, cFilter, cRelation, cPriVars
MEMVAR GetList, aList

FUNCTION pRepGen(nReportNum, cReportFile, lSuppress, cColor)
   LOCAL cVersion := "v1.4", nOption := 3
   eSave()
   SET KEY K_F9 TO pCtrlW
   SET KEY K_F2 TO pHelp
   SET KEY K_F7 TO fFieldInfo
   SET DELETED ON
   DEFAULT nReportNum TO 0
   iif(ValType(nReportNum)="C", nReportNum := Val(nReportNum),)
   lSuppress := iif(lSuppress=NIL, nReportNum!=0, iif(ValType(lSuppress)="C",;
         Upper(lSuppress)$"YT", lSuppress))
   HouseKeeping(cReportFile, lSuppress, cColor, cVersion)
   IF nReportNum>0
      IF nReportNum>LastRec()
         RETURN .n.
      ELSE
         RETURN _BVPrint(nReportNum)
      ENDIF
   ENDIF
   iif(!lSuppress, vBackground("Beckner Report Generator"),)
   Keyboard "P"
   WHILE LOOPING
      nOption := vMenu("T/Create/Modify/Delete/Print/Exit")
      IF pInSet(nOption, "0,5")
         EXIT
      ENDIF
      vSave()
      pOnDo(nOption, {"_BVCreate()", "_BVModify()", "_BVDelete()",;
            "_BVPrint("+lTrim(Str(nReportNum))+")"})
      vRestore()
   ENDWHILE
   eRestore()
   CLEAR GETS
   RETURN .y.
ENDFUNCTION

STATIC FUNCTION Housekeeping(cReportFile, lSuppress, cColor, cVersion)
   LOCAL cTemp
   DEFAULT cReportFile to "bvReport"
   IF !lSuppress
      CLS
      vTitle({"Beckner Report & Label Generator II", cVersion, "----",;
            "Written by John Wm Beckner",;
            "Copyright (c)1991, 1992 BecknerVision Inc - All Rights Reserved"})
   ENDIF
   vMessageOn("Initializing...")
   IF !File(cReportFile+".DBF")
      vMessageOff()
      vMessageOn("Creating REPORT file...")
      cTemp := cReportFile+"/cMenuName/C/40/cFLName/C/20/lReport/L/cDBF/M/cIndex/M/"
      cTemp += "cPickIndex/C/30/cFilter/M/cRelation/M/dCreated/D/dPrinted/D/"
      cTemp += "lMerge/L/cNTXExpr/C/100/cDevice/C/12/cGroup/M/cPrnStart/C/20/"
      cTemp += "cPrnEnd/C/20/cRepeat/C/100/cPriVars/C/100/cPriPrompt/C/100/"
      cTemp += "cHeader/C/100/cPrelimExp/C/200"
      fCreateDBF(cTemp)
   ENDIF
   SELECT 0
   fShare(cReportFile, "Report")
   IF !File(cReportFile+".NTX")
      vMessageOff()
      vMessageOn("Indexing...")
      fCreateNTX(cReportFile, "Upper(cMenuName)")
   ENDIF
   SET INDEX to (cReportFile)
   vMessageOff()
ENDFUNCTION

FUNCTION _BVPrint(nReportNum)
   LOCAL aRowCol, nSequence, nBreak, cPrDevice, nWidth, nLength, cStart, c1, c2
   LOCAL cEnd, cTotalFlds, lSaveChg, aReport, cDBFs, cIndices, cFilters, cRels
   LOCAL nWorkArea, cCloseEm := "", cFile2Open, cNTX2Open, lMainArea := .y., c3
   LOCAL c4, lDetail, bPrelim, nCC, GetList := {}, aLabel, cTemp, nLoopX
   LOCAL nMainArea, aFile := {}, lJoin := .n., aJoin := {}, cJoinFile, cOldDevice
   IF nReportNum=0
      nReportNum := vPopWhen("Print Which?", "Report", , "RecNo()",;
            "cMenuName", {4, 40, 22, 78}, , , , {||!Empty(cMenuName)})
      IF nReportNum=0
         RETURN NIL
      ENDIF
   ENDIF
   lDetail := (Upper(vAnswer("Include detail (Y/N)", 1))="Y")
   nCC     := Val(vAnswer("# of copies", 1))
   iif(nCC<1, nCC := 1,)
   vMessageOn("Initializing report...")
   GO nReportNum
   IF !Empty(Report->cPriVars)
      c1 := Trim(Report->cPriVars)
      c2 := Trim(Report->cPriPrompt)
      vSave()
      aRowCol := vWindow(sCount("/", c1)+1, 78, .y., "Primary Information")
      SetPos(aRowCol[1]-1, 0)
      WHILE !Empty(c1)
         c3 := Trim(sSetLength(sParse(@c2, "//"), 28))
         @ Row()+1, aRowCol[2] SAY c3+" "+Replicate(".", 30-Len(c3)+1)
         c3  := sParse(@c1)
         c4  := sParse(@c1, "//")
         pVarMake(c3)
         &c3 := &c4
         @ Row(), Col()+1 GET &c3
      ENDWHILE
      READ
      vRestore()
   ENDIF
   cPrDevice := cDevice
   cStart    := cPrnStart
   cEnd      := cPrnEnd
   cDBFs     := Trim(cDBF)
   cIndices  := Trim(cIndex)
   cFilters  := Trim(cFilter)
   WHILE !Empty(cDBFs)
      cFile2Open := sParse(@cDBFs)
      IF Left(cFile2Open, 1)="("
         lJoin      := .y.
         cFile2Open := sParse(@cFile2Open, ")")
         cFile2Open := Right(cFile2Open, Len(cFile2Open)-1)
      ENDIF
      cNTX2Open := sParse(@cIndices, "//")
      IF (nWorkArea := Select(fExtOff(cFile2Open)))>0
         SELECT (nWorkArea)
      ELSE
         SELECT 0
         fShare(cFile2Open)
         cCloseEm += lTrim(Str(Select()))+"/"
         WHILE !Empty(cNTX2Open)
            dbSetIndex(sParse(@cNTX2Open, ","))
         ENDWHILE
      ENDIF
      iif(lJoin .or. lMainArea, aAdd(aJoin, {Alias()}),)
      aAdd(aFile, {Alias(), lJoin .and. !lMainArea})
      iif(lMainArea, (lMainArea := .n., nMainArea := Select()),)
      c1 := sParse(@cFilters, "//")
      SET FILTER to &c1.
   ENDWHILE
   SELECT (nMainArea)
   iif(Report->lReport, aReport := BVGetRpt(Report->cFLName), ;
         aLabel := BVGetLbl(Report->cFLName))
   iif(lJoin, cJoinFile := BVMakeJoin(aJoin),)
   SELECT Report
   cDBFs := Trim(cDBF)
   cRels := Trim(cRelation)
   WHILE !Empty(cDBFs)
      SELECT (Select(sParse(@cDBFs)))
      cTemp := sParse(@cRels, "//")
      WHILE !Empty(cTemp)
         c1 := sParse(@cTemp)
         c2 := sParse(@cTemp, "|")
         SET RELATION TO &c1 INTO (c2) ADDITIVE
      ENDWHILE
   ENDWHILE
   SELECT (nMainArea)
   IF !Empty(Report->cNTXExpr)
      vMessageOff()
      vMessageOn("Creating SPECIAL index")
      c1 := Trim(Report->cNTXExpr)
      INDEX ON &c1 TO Beckner$
   ENDIF
   vMessageOff()
   vMessageOn("Printing report...")
   IF !Empty(Report->cPrelimExp)
      bPrelim := {||&(Trim(Report->cPrelimExp))}
      Eval(bPrelim)
   ENDIF
   pRoute(cPrDevice)
   pSendCodes(Report->cPrnStart)
   c1 := Trim(Report->cFLName)
   FOR nLoopX := 1 TO nCC
      IF Report->lReport
         GO TOP
         WHILE LOOPING
            IF lDetail
               REPORT FORM &c1 TO PRINT NOCONSOLE WHILE pAbort() HEADING;
               iif(!empty(Report->cHeader), &(Trim(Report->cHeader)), "")
            ELSE
               REPORT FORM &c1 TO PRINT NOCONSOLE WHILE pAbort() SUMMARY HEADING;
               iif(!empty(Report->cHeader), &(Trim(Report->cHeader)), "")
            ENDIF
            IF !Empty(Report->cRepeat)
               GO TOP
               IF &(Trim(Report->cRepeat))
                  LOOP
               ENDIF
            ENDIF
            EXIT
         ENDWHILE
      ELSE
         LABEL FORM &c1 TO PRINT NOCONSOLE WHILE pAbort() SAMPLE
         WHILE LOOPING
            IF !Empty(Report->cRepeat)
               GO TOP
               IF &(Trim(Report->cRepeat))
                  LABEL FORM &c1 TO PRINT NOCONSOLE WHILE pAbort()
                  LOOP
               ENDIF
            ENDIF
            EXIT
         ENDWHILE
      ENDIF
   NEXT
   pSendCodes(Report->cPrnEnd)
   pUnRoute()
   WHILE !Empty(cCloseEm)
      SELECT (Val(sParse(@cCloseEm)))
      CLOSE
   ENDWHILE
   IF Select("Join")>0
      SELECT Join
      CLOSE
      fKill(fExtNew(cJoinFile, "DB?"))
   ENDIF
   fKill("Beckner$.NTX")
   SELECT Report
   c1 := Trim(cPriVars)
   WHILE !Empty(c1)
      pVarRelease(sParse(@c1))
   ENDWHILE
   vMessageOff()
   RETURN .y.
ENDFUNCTION

STATIC FUNCTION BVGetRpt(cFileName)
   IF !File(fExtNew(Trim(cFilename), "FRM"))
      RETURN {"", "", "", "", 80, 0, 0, 58, .n., .n., .y., .n., "", "",;
            .n., .n., "", "", 0}
   ENDIF
   RETURN fReadFRM(cFileName)
ENDFUNCTION

STATIC FUNCTION BVGetLbl(cFileName)
   IF !File(fExtNew(Trim(cFilename), "LBL"))
      RETURN {"Created with Beckner.Lib", 5, 35, 0, 1, 0, 1}
   ENDIF
   RETURN fReadLBL(cFileName)
ENDFUNCTION

FUNCTION _BVCreate()
   fAddRecord()
   Field->lReport := .y.
   Field->dCreated := Date()
   BVGetRptInfo()
   IF !Deleted()
      iif(lReport, BVModRpt(BVGetRpt(cFLName)), BVModLbl(BVGetLbl(cFLName)))
   ENDIF
ENDFUNCTION

FUNCTION _BVModify()
   LOCAL aMenu := {}, nRecord
   dbEval({|| aAdd(aMenu, {cMenuName, Recno()})})
   IF (nRecord := aPickList(a1from2(aMenu, 1)))=0
      RETURN NIL
   ENDIF
   GO aMenu[nRecord, 2]
   BVGetRptInfo()
   IF lReport
      IF Upper(vAnswer("Modify FRM file (Y/N)?", 1))="Y"
         BVModRpt(BVGetRpt(cFLName))
      ENDIF
   ELSE
      IF Upper(vAnswer("Modify LBL file (Y/N)?", 1))="Y"
         BVModLbl(BVGetLbl(cFLName))
      ENDIF
   ENDIF
ENDFUNCTION

STATIC FUNCTION BVGetRptInfo()
   LOCAL aRowCol, nOption
   WHILE LOOPING
      aRowCol := vWindow(16, 78, .y., "Basic Report & Label Information")
      @ aRowCol[1], aRowCol[2] SAY "Menu title .............." GET cMenuName;
            PICTURE "@K"
      @ Row()+1, aRowCol[2] SAY "DOS filename ............" GET cFLName;
            PICTURE "@K!"
      @ Row()+1, aRowCol[2] SAY "Is this a report (Y/N)? ." GET lReport;
            PICTURE "Y"
      @ Row()+1, aRowCol[2] SAY "Date created ............" GET dCreated;
            WHEN !Empty(cDBF)
      @ Row()+1, aRowCol[2] SAY "Date last printed ......." GET dPrinted;
            WHEN !Empty(cDBF)
      @ Row()+1, aRowCol[2] SAY "Use special index (Y/N)? " GET lMerge;
            PICTURE "Y"
      @ Row()+1, aRowCol[2] SAY "Special index expression " GET cNTXExpr;
            PICTURE "@KS50"
      @ Row()+1, aRowCol[2] SAY "Output device ..........." GET cDevice;
            PICTURE "@K!"
      @ Row()+1, aRowCol[2] SAY "Printer start codes ....." GET cPrnStart;
            PICTURE "@K"
      @ Row()+1, aRowCol[2] SAY "Printer end codes ......." GET cPrnEnd;
            PICTURE "@K"
      @ Row()+1, aRowCol[2] SAY "Repeat until expression ." GET cRepeat;
            PICTURE "@KS50"
      @ Row()+1, aRowCol[2] SAY "Primary variables ......." GET cPriVars;
            PICTURE "@KS50"
      @ Row()+1, aRowCol[2] SAY "Primary prompts ........." GET cPriPrompt;
            PICTURE "@KS50"
      @ Row()+1, aRowCol[2] SAY "Report Heading Expression" GET cHeader;
            PICTURE "@KS50"
      @ Row()+1, aRowCol[2] SAY "Preliminary expression .." GET cPrelimExp;
            PICTURE "@KS50"
      @ MaxRow(), 0
      @ MaxRow(), 0 SAY "  <F2> Databases  <F3> Indices  <F4> Filters  "+;
      "<F6> Relationships  <F7> Sequence  <F8> Group"
      SET KEY K_F2 TO SetDBF
      SET KEY K_F3 TO SetNTX
      SET KEY K_F4 TO SetFlt
      SET KEY K_F6 TO SetRel
      SET KEY K_F7 TO SetSeq
      SET KEY K_F8 TO SetGrp
      fLockRec()
      READ
      UNLOCK
      SET KEY K_F2 TO
      SET KEY K_F3 TO
      SET KEY K_F4 TO
      SET KEY K_F6 TO
      SET KEY K_F7 TO
      SET KEY K_F8 TO
      IF Empty(cMenuName)
         vTitle({"This report has been deleted due to no MENU NAME"})
         DELETE
         UNLOCK
         EXIT
      ENDIF
      vSave()
      nOption := vMenu("D/10/8/15/Databases/Indices/Filters/Relationships/"+;
            "Sequences/Groups/Exit")
      vRestore()
      IF nOption!=0 .AND. nOption!=7
         pOnDo(nOption, {"SetDBF()", "SetNTX()", "SetFlt()", "SetRel()",;
               "SetSeq()", "SetGrp()"})
      ENDIF
      IF Empty(cDBF)
         LOOP
      ENDIF
      EXIT
   ENDWHILE
   UNLOCK
ENDFUNCTION

FUNCTION SetDBF()
   LOCAL aCurrent := {}, aAvailable, cTemp, nFile2Add, lJoin
   vSave()
   aAvailable := aSort(a1From2(Directory("*.DBF"), 1))
   cTemp      := Trim(cDBF)
   @ MaxRow(), 0
   WHILE !Empty(cTemp)
      aAdd(aCurrent, sParse(@cTemp))
   ENDWHILE
   @ MaxRow(), 0 SAY "<ESC> Done  <ENTER> Add  <DEL> Delete  "+;
         "<F2> New Master  <F9> Done"
   SET KEY K_F2 TO NewMaster
   SET KEY K_F9 TO Done
   SET KEY K_DEL TO aDelElement
   WHILE LOOPING
      aList(1, 1, MaxRow()-1, 38, aCurrent, "Current DBFs")
      nFile2Add := aPickList(1, 41, MaxRow()-1, 78, aAvailable)
      IF nFile2Add=0
         EXIT
      ENDIF
      IF aDelElement()
         aDelElement(aCurrent /* was aList */, nFile2Add)
         LOOP
      ENDIF
      lJoin := .n.
      aAdd(aCurrent, iif(lJoin, "("+aAvailable[nFile2Add]+")",;
            aAvailable[nFile2Add]))
   ENDWHILE
   fLockRec()
   Field->cDBF := ""
   aEval(aCurrent, {|cDBFName| Field->cDBF += Trim(cDBFName)+"/"})
   SET KEY K_F2 TO SetDBF
   SET KEY K_F9 TO pCtrlW
   SET KEY K_DEL TO
   vRestore()
ENDFUNCTION

STATIC FUNCTION NewMaster()
ENDFUNCTION

STATIC FUNCTION Done()
   KEYBOARD Chr(27)
ENDFUNCTION

FUNCTION SetFlt()
   LOCAL aCurrent := {}, cTemp, aDBF := {}, cTemp2, nFilter, cFlt, aRowCol
   LOCAL GetList := {}
   vSave()
   cTemp  := Trim(cDBF)
   cTemp2 := Trim(cFilter)
   @ MaxRow(), 0
   WHILE !Empty(cTemp)
      aAdd(aDBF, sParse(@cTemp))
      aAdd(aCurrent, sParse(@cTemp2, "//"))
      iif(Empty(aTail(aCurrent)), aCurrent[Len(aCurrent)] := " ",)
   ENDWHILE
   SET KEY K_F9 TO Done
   WHILE LOOPING
      @ MaxRow(), 0 SAY "<ESC> Done  <ENTER> Add/Modify Highlighted Filter  "+;
         "<F9> Done"
      aList(1, 1, MaxRow()-1, 12, aDBF)
      nFilter := aPickList(1, 14, MaxRow()-1, 78, aCurrent)
      IF nFilter=0
         EXIT
      ENDIF
      cFlt    := sSetLength(aCurrent[nFilter], 200)
      aRowCol := vWindow(1, 78, .y., "Enter New Filter for "+aDBF[nFilter])
      @ aRowCol[1], aRowCol[2] GET cFlt PICTURE "@KS78"
      READ
      aCurrent[nFilter] := sSetLength(Trim(cFlt), 200)
   ENDWHILE
   fLockRec()
   Field->cFilter := ""
   aEval(aCurrent, {|cCuFilter| Field->cFilter += Trim(cCuFilter)+"//"})
   SET KEY K_F9 TO pCtrlW
   vRestore()
ENDFUNCTION

FUNCTION SetNTX()
   LOCAL aCurrent := {}, cTemp, aDBF := {}, cTemp2, nIndex, cNtx, aRowCol
   LOCAL GetList := {}
   vSave()
   cTemp  := Trim(cDBF)
   cTemp2 := Trim(cIndex)
   @ MaxRow(), 0
   WHILE !Empty(cTemp)
      aAdd(aDBF, sParse(@cTemp))
      aAdd(aCurrent, sSetLength(sParse(@cTemp2, "//"), 64))
   ENDWHILE
   SET KEY K_F9 TO Done
   WHILE LOOPING
      @ MaxRow(), 0 SAY "<ESC> Done  <ENTER> Add/Modify Highlighted Index List  "+;
            "<F9> Done"
      aList(1, 1, MaxRow()-1, 12, aDBF)
      nIndex := aPickList(1, 14, MaxRow()-1, 78, aCurrent)
      IF nIndex=0
         EXIT
      ENDIF
      cNtx := sSetLength(aCurrent[nIndex], 200)
      aRowCol := vWindow(1, 78, .y., "Enter new index list for "+aDBF[nIndex])
      @ aRowCol[1], aRowCol[2] GET cNtx PICTURE "@KS78"
      READ
      aCurrent[nIndex] := sSetLength(Trim(cNtx), 200)
   ENDWHILE
   fLockRec()
   Field->cIndex := ""
   aEval(aCurrent, {|cCuIndex| Field->cIndex += Trim(cCuIndex)+"//"})
   SET KEY K_F9 TO pCtrlW
   vRestore()
ENDFUNCTION

FUNCTION SetRel()
   LOCAL aCurrent := {}, cTemp, aDBF := {}, cTemp2, nRelation, cRel, aRowCol
   LOCAL GetList := {}, aRel, c2Alias, cFld, nWhich
   vSave()
   cTemp  := Trim(cDBF)
   cTemp2 := Trim(cRelation)
   @ MaxRow(), 0
   WHILE !Empty(cTemp)
      aAdd(aDBF, sParse(@cTemp))
      aAdd(aCurrent, sSetLength(sParse(@cTemp2, "//"), 100))
   ENDWHILE
   SET KEY K_F9 TO Done
   WHILE LOOPING
      @ MaxRow(), 0 SAY "<ESC> Done  <ENTER> Add/Modify Highlighted Relationship  "+;
            "<F9> Done"
      aList(1, 1, MaxRow()-1, 12, aDBF)
      nRelation := aPickList(1, 14, MaxRow()-1, 78, aCurrent)
      IF nRelation=0
         EXIT
      ENDIF
      aRel := {}
      cTemp := aCurrent[nRelation]
      WHILE !Empty(cTemp)
         aAdd(aRel, sSetLength(sParse(@cTemp, "|"), 100))
      ENDWHILE
      aAdd(aRel, "Add new relationship")
      nWhich := aPickList(1, 41, MaxRow()-1, 78, aRel)
      @ MaxRow(), 0 SAY "<ESC> Done  <ENTER> Add/Modify Highlighted Relationship  "+;
            "<F9> Done"
      IF nWhich=0
         LOOP
      ENDIF
      IF nWhich=Len(aRel)
         c2Alias := Space(10)
         cFld := Space(200)
         aRowCol := vWindow(2, 78, .y., "Enter New Relationship")
         @ aRowCol[1], aRowCol[2] SAY "Alias to relate to ..." GET c2Alias;
               PICTURE "@!"
         @ Row()+1, aRowCol[2] SAY "Field expression ....." GET cFld;
               PICTURE "@S55"
         READ
         aCurrent[nRelation] := sSetLength(Trim(aCurrent[nRelation])+Trim(cfLD)+;
               "/"+Trim(c2Alias)+"|", 100)
      ELSE
         c2Alias := Trim(aRel[nWhich])
         cFld    := sSetLength(sParse(@c2Alias), 200)
         c2Alias := sSetLength(c2Alias, 10)
         aRowCol := vWindow(2, 78, .y., "Modify Relationship")
         @ aRowCol[1], aRowCol[2] SAY "Alias to relate to ..." GET c2Alias;
               PICTURE "@K!"
         @ Row()+1, aRowCol[2] SAY "Field expression ....." GET cFld;
               PICTURE "@KS78"
         READ
         IF Empty(c2Alias)
            aRel[nWhich] := NIL
            aPack(aRel, .y.)
         ELSE
            aRel[nWhich] := Trim(cFld)+"/"+Trim(c2Alias)+"|"
         ENDIF
         aCurrent[nRelation] := ""
         aEval(aRel, {|cRel| aCurrent[nRelation] += Trim(cRel)}, 1,;
               Len(aRel)-1)
         aCurrent[nRelation] := sSetLength(aCurrent[nRelation], 100)
      ENDIF
   ENDWHILE
   fLockRec()
   Field->cRelation := ""
   aEval(aCurrent, {|cRelation| Field->cRelation += Trim(cRelation)+"//"})
   SET KEY K_F9 TO pCtrlW
   vRestore()
ENDFUNCTION

FUNCTION SetSeq()
ENDFUNCTION

FUNCTION SetGrp()
ENDFUNCTION

STATIC FUNCTION BVModRpt(aReport)
   LOCAL aRowCol, GetList := {}, cTempFile, cTemp, nCtr, nCtr2
   cTempFile := fUnique()
   cTemp := cTempFile+"/nWidth/N/3//lTotal/L/nDecimals/N/2//cContents/C/254/"
   cTemp += "cHeader1/C/65/cHeader2/C/65/cHeader3/C/65/cHeader4/C/65/"
   cTemp += "nSequence/N/3"
   fCreateDBF(cTemp)
   SELECT 0
   fNoShare(cTempFile)
   fCreateNTX((cTempFile := fExtOff(cTempFile)), "nSequence")
   SET INDEX to (cTempFile)
   FOR nCtr := 1 TO aReport[19]
      fAddRecord()
      FOR nCtr2 := 1 TO fCount()
         FieldPut(nCtr2, aReport[19+nCtr, nCtr2])
      NEXT
   NEXT
   aReport[1]  := sSetLength(aReport[1], 60)
   aReport[2]  := sSetLength(aReport[2], 60)
   aReport[3]  := sSetLength(aReport[3], 60)
   aReport[4]  := sSetLength(aReport[4], 60)
   aReport[14] := sSetLength(aReport[14], 65)
   aReport[18] := sSetLength(aReport[18], 65)
   aReport[13] := sSetLength(aReport[13], 200)
   aReport[17] := sSetLength(aReport[17], 200)
   WHILE LOOPING
      aRowCol := vWindow(16, 78, .Y., "Main Report Parameters")
      @ aRowCol[1], aRowCol[2] SAY "Page heading line 1 ..." GET aReport[1];
            PICTURE "@KS50"
      @ Row()+1, aRowCol[2] SAY "Page heading line 2 ..." GET aReport[2];
            PICTURE "@KS50"
      @ Row()+1, aRowCol[2] SAY "Page heading line 3 ..." GET aReport[3];
            PICTURE "@KS50"
      @ Row()+1, aRowCol[2] SAY "Page heading line 4 ..." GET aReport[4];
            PICTURE "@KS50"
      @ Row()+1, aRowCol[2] SAY "Report width .........." GET aReport[5];
            PICTURE "999"
      @ Row()+1, aRowCol[2] SAY "Left and right margins " GET aReport[6];
            PICTURE "99"
      @ Row(), Col()+1 GET aReport[7] PICTURE "99"
      @ Row()+1, aRowCol[2] SAY "# of printable lines .." GET aReport[8];
            PICTURE "999"
      @ Row()+1, aRowCol[2] SAY "Double space (Y/N)? ..." GET aReport[9];
            PICTURE "Y"
      @ Row()+1, aRowCol[2] SAY "Plain page (Y/N)? ....." GET aReport[10];
            PICTURE "Y"
      @ Row()+1, aRowCol[2] SAY "Eject after? Before? .." GET aReport[11];
            PICTURE "Y"
      @ Row(), Col()+1 GET aReport[12] PICTURE "Y"
      @ Row()+1, aRowCol[2] SAY "Group expression ......" GET aReport[13];
            PICTURE "@KS50"
      @ Row()+1, aRowCol[2] SAY "Group header .........." GET aReport[14];
            PICTURE "@KS50"
      @ Row()+1, aRowCol[2] SAY "Summary only (Y/N)? ..." GET aReport[15];
            PICTURE "Y"
      @ Row()+1, aRowCol[2] SAY "Eject after group? ...." GET aReport[16];
            PICTURE "Y"
      @ Row()+1, aRowCol[2] SAY "Subgroup expression ..." GET aReport[17];
            PICTURE "@KS50"
      @ Row()+1, aRowCol[2] SAY "Subgroup header ......." GET aReport[18];
            PICTURE "@KS50"
      READ
      fBrowse()
      EXIT
   ENDWHILE
   GO TOP
   aSize(aReport, 19)
   WHILE !EOF()
      aAdd(aReport, {})
      FOR nCtr := 1 TO fCount()
         aAdd(aReport[Len(aReport)], FieldGet(nCtr))
      NEXT
      SKIP
   ENDWHILE
   CLOSE
   aReport[19] := Len(aReport)-19
   SELECT Report
   fKill(fExtNew(cTempFile, "DB?"))
   fKill(fExtNew(cTempFile, "NTX"))
   fCreateFRM(cFLName, aReport)
ENDFUNCTION

STATIC FUNCTION BVPutRpt(cFileName, lReport, aReport)
   IF lReport
      fCreateFRM(cFileName, aReport)
   ENDIF
ENDFUNCTION

STATIC FUNCTION BVModLbl(aLabel)
   LOCAL aRowCol, GetList := {}, nCtr, nTemp
   vSave()
   aRowCol := vWindow(7, 78, .y., "Main Label Information")
   aLabel[1] := sSetLength(aLabel[1], 60)
   @ aRowCol[1], aRowCol[2] SAY "Label height (# lines) ....." GET aLabel[2];
         PICTURE "99"
   @ Row()+1, aRowCol[2] SAY "Label width (# characters) ." GET aLabel[3];
         PICTURE "999"
   @ Row()+1, aRowCol[2] SAY "Left margin (# characters) ." GET aLabel[4];
         PICTURE "99"
   @ Row()+1, aRowCol[2] SAY "# lines between labels ....." GET aLabel[5];
         PICTURE "99"
   @ Row()+1, aRowCol[2] SAY "# spaces between labels ...." GET aLabel[6];
         PICTURE "99"
   @ Row()+1, aRowCol[2] SAY "# labels across ............" GET aLabel[7];
         PICTURE "99"
   @ Row()+1, aRowCol[2] SAY "Comments ..................." GET aLabel[1];
         PICTURE "@S40"
   READ
   vRestore()
   aRowCol := vWindow(aLabel[2], 60, .y., "Label Line Expressions")
   aSize(aLabel, 7+aLabel[2])
   FOR nCtr := 1 to aLabel[2]
      nTemp := nCtr+7
      aLabel[nTemp] := iif(aLabel[nTemp]=NIL, Space(200),;
      sSetLength(aLabel[nTemp], 200))
      @ aRowCol[1]+nCtr-1, aRowCol[2] GET aLabel[nTemp] PICTURE "@KS60"
   NEXT
   READ
   fCreateLBL(cFLName, aLabel)
ENDFUNCTION

STATIC FUNCTION BVMakeJoin(aJoin)
   LOCAL nCtr, nNumJoin, cJoinFile, cTemp, nCtr2, nColumn
   vMessageOn({"Creating JOIN file", "---", "This may take awhile",;
         "I'll notify you when I'm through"})
   vSave(MaxRow(), 0, MaxRow(), MaxCol())
   nNumJoin := Len(aJoin)
   cJoinFile := fExtOff(fUnique())
   cTemp := cJoinFile+"/"
   FOR nCtr := 1 to nNumJoin
      SELECT (Select(aJoin[nCtr, 1]))
      aAdd(aJoin[nCtr], dbStruct())
      FOR nCtr2 := 1 to Len(aJoin[nCtr, 2])
         cTemp += aJoin[nCtr, 2, nCtr2, 1]+"/"+aJoin[nCtr, 2, nCtr2, 2]+"/"
         iif(aJoin[nCtr, 2, nCtr2, 2]$"CN",;
         cTemp += lTrim(Str(aJoin[nCtr, 2, nCtr2, 3]))+"/", NIL)
         iif(aJoin[nCtr, 2, nCtr2, 2]="N",;
         cTemp += lTrim(Str(aJoin[nCtr, 2, nCtr2, 4]))+"/", NIL)
      NEXT
   NEXT
   fCreateDBF(cTemp)
   SELECT 0
   fNoShare(cJoinFile, "Join")
   SELECT (Select(aJoin[1, 1]))
   GO TOP
   @ MaxRow(), 0
   @ MaxRow(), 0 SAY "There are "+lTrim(Transform(LastRec(), "99,999,999"))+;
         " records to process.  The current record is "
   nColumn := Col()
   WHILE !eof()
      @ MaxRow(), nColumn SAY lTrim(Transform(RecNo(), "99,999,999"))
      fFieldAdd(Alias(), "Join")
      FOR nCtr := 2 to nNumJoin
         fFieldCopy(aJoin[nCtr, 1], "Join")
      NEXT
      SKIP
   ENDWHILE
   SELECT Join
   vRestore()
   vMessageOff()
   pBeep()
   RETURN cJoinFile
ENDFUNCTION

FUNCTION _BVDelete()
   LOCAL aMenu := {}, nRecord, cFile
   dbEval({|| aAdd(aMenu, {cMenuName, Recno()})})
   IF (nRecord := aPickList(a1from2(aMenu, 1)))=0
      RETURN NIL
   ENDIF
   GO aMenu[nRecord, 2]
   IF !vIsSure()
      RETURN NIL
   ENDIF
   cFile := Trim(cFlName)+iif(lReport, ".frm", ".lbl")
   fLockRec()
   DELETE
   UNLOCK
   IF File(cFile)
      nRecord := Alert("Delete FRM/LBL?", {"No", "Yes"})
      iif(nRecord=2, fKill(cFile),)
   ENDIF
ENDFUNCTION

/*
   1.04  07/09/93 Put directory list in alpha sequence (v1.4)
*/
