/*
    The source code contained within this file is protected under the
    laws of the United States of America and by International Treaty.
    Unless otherwise noted, the source contained herein is:

    Copyright (c)1990, 1991, 1992 BecknerVision Inc - All Rights Reserved

    Written by John Wm Beckner        THIS NOTICE MUST NOT BE REMOVED
    BecknerVision Inc
    PO Box 11945                      SOURCE CODE (THIS FILE) MAY NOT BE
    Winston-Salem NC 27116            DISTRIBUTED!  ONLY REGISTERED USERS
    Fax: 919/760-1003                 OF BECKNER LIBRARY & UTILITIES II MAY
                                      BE IN POSSESSION OF THIS FILE.
*/

#include "beckner.inc"
#include "setcurs.ch"

FIELD cProcName, cVarName, cHelpInfo
MEMVAR GetList

FUNCTION pHelp(cProcedure, nLineNum, cVariable)
   LOCAL lAvailable := .y., lCreate := .n.
   LOCAL nCursorShape := SetCursor(SC_NORMAL)
   PRIVATE GetList := {}
   eSave()
   pKeyClear()
   @ 1, 0 CLEAR TO MaxRow(), MaxCol()
   @ 1, 0 TO MaxRow(), MaxCol() DOUBLE
   @ 3, 1 TO 3, MaxCol()-1
   @ 2, vCenterPos('CONTEXT SPECIFIC HELP') SAY 'CONTEXT SPECIFIC HELP'
   @ 5, 1 TO 5, MaxCol()-1
   @ 4, 3 SAY 'Procedure: '+cProcedure
   @ 4, Col()+2 SAY 'Line #'+lTrim(Str(nLineNum))
   @ 4, Col()+2 SAY 'Variable: '+cVariable
   @ 6, 1 SAY 'One moment, checking...'
   IF !File('HELP.DBF')
      fCreateDBF('HELP/cPROCNAME/C/10/cVARNAME/C/10/cHELPINFO/M')
   ENDIF
   USE Help SHARED NEW
   IF !File('help.ntx')
      INDEX ON cProcName+cVarName TO help
   ELSE
      SET INDEX TO help
   ENDIF
   SEEK sSetLength(cProcedure, 10)+sSetLength(cVariable, 10)
   IF !Found()
      @ 6, 1 CLEAR TO 6, 50
      @ 6, 1 SAY 'NO HELP FOUND!  Create (Y/N)?' GET lCreate PICTURE 'Y'
      READ
      IF lCreate
         fAddRecord()
         Help->cProcName := cProcedure
         Help->cVarName  := cVariable
      ELSE
         lAvailable := .n.
      ENDIF
   ELSE
      fLockRec()
   ENDIF
   IF lAvailable
      Help->cHelpInfo := MemoEdit(cHelpInfo, 6, 1,;
            MaxRow()-1, MaxCol()-1, .y.)
   ENDIF
   CLOSE
   SetCursor(nCursorShape)
   eRestore()
ENDFUNCTION

/*
 1.02 02.06.93 removed duplicate GetList definition
*/
