/*
    The source code contained within this file is protected under the
    laws of the United States of America and by International Treaty.
    Unless otherwise noted, the source contained herein is:

    Copyright (c)1990, 1991, 1992 BecknerVision Inc - All Rights Reserved

    Written by John Wm Beckner        THIS NOTICE MUST NOT BE REMOVED
    BecknerVision Inc
    PO Box 11945                      SOURCE CODE (THIS FILE) MAY NOT BE
    Winston-Salem NC 27116            DISTRIBUTED!  ONLY REGISTERED USERS
    Fax: 919/760-1003                 OF BECKNER LIBRARY & UTILITIES II MAY
                                      BE IN POSSESSION OF THIS FILE.
*/

#include "beckner.inc"
#include "fileio.ch"

FUNCTION pCrashCheck(lStart, cNotes, lDelIndices)
   LOCAL nCurSel := Select(), nErrFile, nOption
   DEFAULT lStart to .y.
   DEFAULT cNotes to ""
   DEFAULT lDelIndices to .y.
   IF !File("CrashChk.dbf")
      fCreateDBF("CrashChk/NetName/C/15/Date/D/Time/C/8/Notes/C/50")
   ENDIF
   SELECT 0
   fShare("CrashChk", "Crash")
   IF lStart
      LOCATE FOR sSetLength(NetName(), 15)=Crash->NetName
      IF Found()
         nOption := Alert("Your terminal CRASHED during the operation of this program!;"+;
               "This is a SERIOUS situation."+iif(lDelIndices,;
               ";All indices are about to be deleted.;Be sure everyone is out"+;
               " of the program;on all terminals, if you are networked.", ""),;
               {"Reindex", "Ignore"})
         lDelIndices := (nOption!=2)
         iif(lDelIndices, fKill("*.ntx"),)
         nErrFile := iif(File("ErrorLog.txt"), fOpen("ErrorLog.txt", FO_WRITE),;
               fCreate("ErrorLog.txt"))
         fSeek(nErrFile, 0, FS_END)
         fWriteLine(nErrFile, "{CRASH} "+sMake(Date())+" "+Time()+" "+;
               NetName()+CRLF)
         fClose(nErrFile)
         fLockRec()
         DELETE
         CLOSE
         fNoShare("CrashChk", "Crash")
         PACK
      ENDIF
      fAddRecord()
      Crash->NetName := NetName()
      Crash->Date    := Date()
      Crash->Time    := Time()
      Crash->Notes   := cNotes
      UNLOCK
   ELSE
      LOCATE FOR sSetLength(NetName(), 15)=Crash->NetName
      IF !Found()
         nErrFile := iif(File("ErrorLog.txt"), fOpen("ErrorLog.txt", FO_WRITE),;
               fCreate("ErrorLog.txt"))
         fSeek(nErrFile, 0, FS_END)
         fWriteLine(nErrFile, "{CRASH} "+sMake(Date())+" "+Time()+" "+;
               NetName()+" ::invalid close"+CRLF)
         fClose(nErrFile)
      ENDIF
      fLockRec()
      DELETE
      CLOSE
      fNoShare("CrashChk")
      PACK
   ENDIF
   CLOSE
   SELECT (nCurSel)
ENDFUNCTION
