/*
    The source code contained within this file is protected under the
    laws of the United States of America and by International Treaty.
    Unless otherwise noted, the source contained herein is:

    Copyright (c)1990-1994 BecknerVision Inc - No Rights Reserved

    Written by John Wm Beckner
    BecknerVision Inc

        ** THIS FILE IS PUBLIC DOMAIN **

        ** Use of this code is at your own risk, absolutely no guarantees
        ** are made to its usefulness  - you must determine for yourself if
        ** this code is of any use to you.  If you do not agree with this, do
        ** not use this code. **
*/

#include "beckner.inc"

/* a better algorithm needs to be found */

////////////////
////////////////
//
// Purpose:
//    Generate pseudo-random numbers.
//
// Syntax:
//    mRandom(<nSeed>) -> nRandom
//
// Formal Arguments: (1)
//    Name        Description
//    ___________ ____________
//    nSeed       Seed value
//
// Returns:
//    nRandom     Pseudo-random number
//
// Files:
//    none
//
// Description:
//    A simple pseudo-random number generator.
//
// Category:
//    Math Function
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

FUNCTION mRandom(nBase)
   LOCAL nMultiplier, nReturn := 0, nX, nJ, nY, nK, nL, nZ, nS, nT
   IF nBase!=0
      nMultiplier := iif(nBase<0, -1, 1)
      nX := Seconds()/100
      nJ := (nX-Int(nX))*100
      nY := Log(SqRt(Seconds()/100))
      nK := (nY-Int(nY))*100
      nL := nJ*nK
      nZ := nL-Int(nL)
      nS := nBase*nZ
      nT := Round(nS, 2)
      nReturn := (Int(nT)+iif(Int(nT)+1<nBase+1, 1, 0))*nMultiplier
   ENDIF
   RETURN nReturn
ENDFUNCTION
