/*
    The source code contained within this file is protected under the
    laws of the United States of America and by International Treaty.
    Unless otherwise noted, the source contained herein is:

    Copyright (c)1990-1994 BecknerVision Inc - No Rights Reserved

    Written by John Wm Beckner
    BecknerVision Inc

        ** THIS FILE IS PUBLIC DOMAIN **

        ** Use of this code is at your own risk, absolutely no guarantees
        ** are made to its usefulness  - you must determine for yourself if
        ** this code is of any use to you.  If you do not agree with this, do
        ** not use this code. **
*/

#include "beckner.inc"

////////////////
////////////////
//
// Purpose:
//    Returns the root name of a file specification
//
// Syntax:
//    fRootName(<cFile>) -> cRoot
//
// Formal Arguments: (1)
//    Name        Description
//    ___________ ____________
//    cFile       Any file specification, with or without path name and drive
//
// Returns:
//    cRoot       Root file name
//
// Examples:
//    #include "beckner.inc"
//    FUNCTION TestIt()
//       LOCAL cTest1 := "C:\AutoExec.bat", cTest2 := "..\x.xxx"
//       ? fRootName(cTest1)        /* "AutoExec" */
//       ? fRootName(cTest2)        /* "x"        */
//    ENDFUNCTION
//
// Files:
//    none
//
// Description:
//    Returns the root file name from a file specification, which can be a 
//    simple file name or a fully-qualified drive-path-file specification.
//
// See Also:
//    fExtName()
//
// Category:
//    File Function
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

FUNCTION fRootName(cFileSpec)
   WHILE "\"$cFileSpec
      sParse(@cFileSpec, "\")
   ENDWHILE
   IF "."$cFileSpec
      cFileSpec := Left(cFileSpec, At(".", cFileSpec)-1)
   ENDIF
   RETURN lTrim(Trim(cFileSpec))
ENDFUNCTION

/*
  1.02 03.23.93 Created
*/
