/*
    The source code contained within this file is protected under the
    laws of the United States of America and by International Treaty.
    Unless otherwise noted, the source contained herein is:

    Copyright (c)1990, 1991, 1992 BecknerVision Inc - All Rights Reserved

    Written by John Wm Beckner        THIS NOTICE MUST NOT BE REMOVED
    BecknerVision Inc
    PO Box 11945                      SOURCE CODE (THIS FILE) MAY NOT BE
    Winston-Salem NC 27116            DISTRIBUTED!  ONLY REGISTERED USERS
    Fax: 919/760-1003                 OF BECKNER LIBRARY & UTILITIES II MAY
                                      BE IN POSSESSION OF THIS FILE.
*/

#include "beckner.inc"
#include "fileio.ch"
#define DELIMITER Chr(254)

FUNCTION fReadBVR(cFile)
   LOCAL cTemp, cPacked, cLine, aRptHdr := {}, aPageHeader := {}
   LOCAL aRptFooter := {}
   LOCAL aPageFooter := {}, aGroupData := {}, aColData := {}, aFileData := {}
   LOCAL aRelations := {}, aExecute := {}, nHandle
   iif(!fExtension(cFile), cFile := fExtNew(cFile, "BVR"),)
   IF !File(cFile)
      RETURN {}
   ENDIF
   nHandle := fOpen(cFile, FO_READ)
   IF fReadStr(nHandle, 3)!="BV~"
      fClose(nHandle)
      RETURN {}
   ENDIF
   cPacked := fReadLine(nHandle)
   WHILE !fEOF(nHandle)
      cLine := fReadLine(nHandle)
      cTemp := sParse(@cLine, 1)
      DO CASE
      CASE cTemp="H"                                  /* report header       */
         aAdd(aRptHdr, cLine)
      CASE cTemp="P"                                  /* page header         */
         aAdd(aPageHeader, cLine)
      CASE cTemp="F"                                  /* page footer         */
         aAdd(aPageFooter, cLine)
      CASE cTemp="E"                                  /* report footer       */
         aAdd(aRptFooter, cLine)
      CASE cTemp="F"                                  /* file data           */
         aAdd(aFileData, {sParse(@cTemp, DELIMITER),  /* filename            */;
                        sParse(@cTemp, DELIMITER),    /* alias               */;
                        sParse(@cTemp, DELIMITER),    /* index list          */;
                        sParse(@cTemp, DELIMITER),    /* relationship list   */;
                        sParse(@cTemp, DELIMITER)})   /* filter expression   */
      CASE cTemp="G"                                  /* group data          */
         aAdd(aGroupData, {sParse(@cTemp, DELIMITER), /* eject after group   */;
                        sParse(@cTemp, DELIMITER),    /* group header        */;
                        sParse(@cTemp, DELIMITER)})   /* group expression    */
      CASE cTemp="C"                                  /* column data         */
         aAdd(aColData, {sParse(@cTemp, DELIMITER),   /* picture             */;
                        sParse(@cTemp, DELIMITER),    /* display expression  */;
                        sParse(@cTemp, DELIMITER)})   /* total expression    */
      CASE cTemp="X"                                  /* Eval() expressions  */
         aAdd(aExecute, cLine)
      ENDCASE
   ENDWHILE
   RETURN {Asc(sParse(@cPacked, 1)),                     /* page length         */;
         Asc(sParse(@cPacked, 1)),                    /* page width          */;
         Asc(sParse(@cPacked, 1)),                    /* left margin         */;
         Asc(sParse(@cPacked, 1)),                    /* right margin        */;
         bTestBit(cTemp := sParse(@cPacked, 1), 1),   /* double space        */;
         bTestBit(cTemp, 2),                          /* plain report        */;
         bTestBit(cTemp, 3),                          /* eject before        */;
         bTestBit(cTemp, 4),                          /* eject after         */;
         bTestBit(cTemp, 5),                          /* summary only        */;
         bTestBit(cTemp, 6),                          /* print final totals  */;
         aRptHdr,                                     /* report header       */;
         aPageHeader,                                 /* page header         */;
         aPageFooter,                                 /* page footer         */;
         aRptFooter,                                  /* report footer       */;
         aGroupData,                                  /* group data          */;
         aColData,                                    /* column data         */;
         aExecute,                                    /* Eval expressions    */;
         aFileData}                                   /* file data           */
ENDFUNCTION

