/*
    The source code contained within this file is protected under the
    laws of the United States of America and by International Treaty.
    Unless otherwise noted, the source contained herein is:

    Copyright (c)1990-1994 BecknerVision Inc - No Rights Reserved

    Written by John Wm Beckner
    BecknerVision Inc

        ** THIS FILE IS PUBLIC DOMAIN **

        ** Use of this code is at your own risk, absolutely no guarantees
        ** are made to its usefulness  - you must determine for yourself if
        ** this code is of any use to you.  If you do not agree with this, do
        ** not use this code. **
*/

#include "beckner.inc"

////////////////
////////////////
//
// Purpose:
//    Determines the existence of a specified directory
//
// Syntax:
//    fIsDir(<cPath>) -> lExists
//
// Formal Arguments: (1)
//    Name        Description
//    ___________ ____________
//    cPath       Path name
//
// Returns:
//    lExists     .y. if a valid path
//
// Examples:
//    #include "beckner.inc"
//    FUNCTION TestIt()
//       LOCAL cPath := "\TESTTEST"
//       fMkDir(cPath)
//       ? fIsDir(cPath)         /* .t. */
//       fRmDir(cPath)           
//       ? fIsDir(cPath)         /* .f. */
//    ENDFUNCTION
//
// Files:
//    none
//
// Description:
//    Returns .true. if the specified path points to an existing directory.
//
// See Also:
//    fChDir()
//    fMkDir()
//    fRmDir()
//
// Category:
//    File Function
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

FUNCTION fIsDir(cDir)
   LOCAL nHandle
   nHandle := fOpen(strtran(cDir+"\NUL","\\","\"))
   IF nHandle<0
      RETURN .n.
   ENDIF
   fClose(nHandle)
   RETURN .y.
ENDFUNCTION
