/*
    The source code contained within this file is protected under the
    laws of the United States of America and by International Treaty.
    Unless otherwise noted, the source contained herein is:

    Copyright (c)1990-1994 BecknerVision Inc - No Rights Reserved

    Written by John Wm Beckner
    BecknerVision Inc

        ** THIS FILE IS PUBLIC DOMAIN **

        ** Use of this code is at your own risk, absolutely no guarantees
        ** are made to its usefulness  - you must determine for yourself if
        ** this code is of any use to you.  If you do not agree with this, do
        ** not use this code. **
*/

#include "beckner.inc"

////////////////
////////////////
//
// Purpose:
//    Returns field name from a field list
//
// Syntax:
//    fFieldInfo([<cAlias>]) -> cFieldName
//
// Formal Arguments: (1)
//    Name        Description
//    ___________ ____________
//    cAlias      Work area [current]
//
// Returns:
//    cFieldName  Field name chosen or null string
//
// Examples:
//
// Files:
//    none
//
// Description:
//    This function presents the operator with a field list form the specified
//    or current work area, and returns the field name chosen by the operator.
//    If the operator presses <ESC>, then a null string is returned.
//
// See Also:
//
// Category:
//    Field Function
//
// Revisions:
//    06/18/94 Added comment blocks
//
////////////////
////////////////

FUNCTION fFieldInfo(cAlias)
   LOCAL nSelect, aFldList, nChoice, aFldLine := {}
   DEFAULT cAlias TO Alias()
   aFldList := dbStruct()
   aEval(aFldList, {|aFld| aAdd(aFldLine, sSetLength(aFld[1], 2)+" "+aFld[2]+;
         " "+Str(aFld[3], 3)+Str(aFld[4], 4))})
   RETURN iif((nChoice := aPickList(aFldList))=0, "", aFldList[nChoice, 1])
ENDFUNCTION
