/*
    The source code contained within this file is protected under the
    laws of the United States of America and by International Treaty.
    Unless otherwise noted, the source contained herein is:

    Copyright (c)1990-1994 BecknerVision Inc - No Rights Reserved

    Written by John Wm Beckner
    BecknerVision Inc

        ** THIS FILE IS PUBLIC DOMAIN **

        ** Use of this code is at your own risk, absolutely no guarantees
        ** are made to its usefulness  - you must determine for yourself if
        ** this code is of any use to you.  If you do not agree with this, do
        ** not use this code. **
*/

#include "beckner.inc"

////////////////
////////////////
//
// Purpose:
//    Copies field contents from one work area to another
//
// Syntax:
//    fFieldCopy(<cFrom>, <cTo>) -> NIL
//
// Formal Arguments: (2)
//    Name        Description
//    ___________ ____________
//    cFrom       Source work area
//    cTo         Target work area
//
// Returns:
//    NIL
//
// Examples:
//
// Files:
//    none
//
// Description:
//    This function copies the contents of the record in the source work area,
//    <cFrom>, into the current record in the target work area, <cTo>.  The
//    fields must be of the same type, as no type conversion is done, however
//    the field names may differ.  All fields are copied on a 1-to-1 
//    correspondence.
//
// See Also:
//
// Category:
//    Field Function
//
// Revisions:
//    06/18/94 Added comment blocks
//
////////////////
////////////////


FUNCTION fFieldCopy(cAliasFrom, cAliasTo)
   RETURN iFieldACM(2, cAliasFrom, cAliasTo)
ENDFUNCTION
