/*
    The source code contained within this file is protected under the
    laws of the United States of America and by International Treaty.
    Unless otherwise noted, the source contained herein is:

    Copyright (c)1990-1994 BecknerVision Inc - No Rights Reserved

    Written by John Wm Beckner
    BecknerVision Inc

        ** THIS FILE IS PUBLIC DOMAIN **

        ** Use of this code is at your own risk, absolutely no guarantees
        ** are made to its usefulness  - you must determine for yourself if
        ** this code is of any use to you.  If you do not agree with this, do
        ** not use this code. **
*/

#include "beckner.inc"

////////////////
////////////////
//
// Purpose:
//    Extracts records from a file
//
// Syntax:
//    fExtract(<cFrom>, <cTo>, <cFilter>, [<lEcho>]) -> NIL
//
// Formal Arguments: (4)
//    Name        Description
//    ___________ ____________
//    cFrom       File to extract records from
//    cTo         New database file name
//    cFilter     Filter string
//    lEcho       .y. to echo records numbers [.n.]
//
// Returns:
//    NIL
//
// Files:
//    (cFrom).dbf
//    (cTo).dbf
//
// Description:
//    Extracts records from <cFrom> database file into a new database file,
//    <cTo> based on the specified filter string <cFilter>.  If <cTo>
//    already exists, nothing happens.  Otherwise, the file is created with
//    the same structure as <cFrom>, with the records extracted based on
//    <cFilter>.  If <lEcho>, then the records numbers of the extracted
//    records are echoed to the screen.
//
// See Also:
//    EXTRACT.PRG
//
// Category:
//    File Function
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

FUNCTION fExtract(cFrom, cTo, cFor, lEcho)
   DEFAULT lEcho TO .n.
   IF File(fExtNew(cTo, "DBF"))
      Alert("Cannot EXTRACT to existing file!")
   ELSE
      fShare(cFrom)
      COPY TO (cTo) FOR &(cFor) .and. iif(lEcho, EchoIt(), .y.)
   ENDIF
ENDFUNCTION

////////////////
////////////////
//
// Purpose:
//    Internal function
//
// Category:
//    Internal Function
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

STATIC FUNCTION EchoIt()
   @ Row(), 0 SAY RecNo() PICTURE "999,999"
   RETURN .y.
ENDFUNCTION

/*
 1.02 03.16.93 Added lEcho functionality
*/
