/*
    The source code contained within this file is protected under the
    laws of the United States of America and by International Treaty.
    Unless otherwise noted, the source contained herein is:

    Copyright (c)1990-1994 BecknerVision Inc - No Rights Reserved

    Written by John Wm Beckner
    BecknerVision Inc

        ** THIS FILE IS PUBLIC DOMAIN **

        ** Use of this code is at your own risk, absolutely no guarantees
        ** are made to its usefulness  - you must determine for yourself if
        ** this code is of any use to you.  If you do not agree with this, do
        ** not use this code. **
*/

#include "beckner.inc"
#include "directry.ch"

////////////////
////////////////
//
// Purpose:
//    Duplicates a floppy disk a number of times
//
// Syntax:
//    fDupDisk([<nTimes>], [<cSource>], [<cTarget>]) -> NIL
//
// Formal Arguments: (3)
//    Name        Description
//    ___________ ____________
//    nTimes      Number of times to duplicate [1]
//    nSource     Source drive ["A:"]
//    nTarget     Target drive ["A:"]
//
// Returns:
//    NIL
//
// Examples:
//    #include "beckner.inc"
//    FUNCTION TestIt()
//       /* This will duplicate the disk in drive A: 3 times */
//       fDupDisk(3)
//    ENDFUNCTION
//
// Files:
//    none
//
// Description:
//    Duplicates a floppy disk a certain number of times.  You are prompted
//    to enter the source disk, then each target disk until <nTimes> disks
//    have been duplicated (defaults to 1).  Both <cSource> and <cTarget>
//    default to drive A:.
//
// Category:
//    File Function
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

FUNCTION fDupDisk(nTimes, cSource, cTarget)
   LOCAL nCtr, aFile2Copy, aSubDir := {""}, nDirCtr := 0, cBaseDir := ""
   LOCAL nCtr2
   CLS
   DEFAULT cSource TO "A:",;
         cTarget TO "A:",;
         nTimes TO 1
   fMkDir("\DISK.DUP")
   iif(Len(cSource)=1, cSource += ":",)
   iif(Len(cTarget)=1, cTarget += ":",)
   vMessageOn("Insert SOURCE diskette in drive "+cSource)
   Inkey(0)
   vMessageOff()
   WHILE nDirCtr++<Len(aSubDir)
      aFile2Copy := Directory(cSource+aSubDir[1]+"*.*", "DH")
      cBaseDir := aSubDir[nDirCtr]
      aEval(aFile2Copy, {|cDir| iif("D"$cDir[F_ATTR],;
            aAdd(aSubDir, cBaseDir+"\"+cDir[F_NAME]),)})
      iif(!Empty(cBaseDir), fMkDir("\DISK.DUP\"+cBaseDir),)
      FOR nCtr := 1 to Len(aFile2Copy)
         IF "D"$aFile2Copy[nCtr, F_ATTR]
            LOOP
         ENDIF
         COPY FILE (cSource+"\"+cBaseDir+aFile2Copy[nCtr, F_NAME]) TO;
         ("\DISK.DUP\"+cBaseDir+aFile2Copy[nCtr, F_NAME])
      NEXT
   ENDWHILE
   FOR nCtr := 1 to nTimes
      cBaseDir := ""
      nDirCtr := 0
      vMessageOn("Insert target diskette #"+lTrim(Str(nCtr)))
      Inkey(0)
      vMessageOff()
      WHILE nDirCtr++<Len(aSubDir)
         aFile2Copy := Directory("\DISK.DUP\"+(cBaseDir := aSubDir[nDirCtr])+;
         "*.*")
         iif(!Empty(cBaseDir), fMkDir(cTarget+"\"+cBaseDir),)
         FOR nCtr2 := 1 to Len(aFile2Copy)
            COPY FILE ("\DISK.DUP\"+cBaseDir+aFile2Copy[nCtr2, F_NAME]) TO;
            (cTarget+"\"+cBaseDir+aFile2Copy[nCtr2, F_NAME])
         NEXT
      ENDWHILE
   NEXT
ENDFUNCTION
