/*
    The source code contained within this file is protected under the
    laws of the United States of America and by International Treaty.
    Unless otherwise noted, the source contained herein is:

    Copyright (c)1990-1994 BecknerVision Inc - No Rights Reserved

    Written by John Wm Beckner
    BecknerVision Inc

        ** THIS FILE IS PUBLIC DOMAIN **

        ** Use of this code is at your own risk, absolutely no guarantees
        ** are made to its usefulness  - you must determine for yourself if
        ** this code is of any use to you.  If you do not agree with this, do
        ** not use this code. **
*/

#include "beckner.inc"

////////////////
////////////////
//
// Purpose:
//    Displays the structure of the file in the specified work area
//
// Syntax:
//    fDispStru([<cAlias>]) -> NIL
//
// Formal Arguments: (1)
//    Name        Description
//    ___________ ____________
//    cAlias      Work area alias [current]
//
// Returns:
//    NIL
//
// Examples:
//    #include "beckner.inc"
//    FUNCTION TestIt()
//       CreateTest()
//       fDispStru()       /* displays the file structure */
//       CLOSE Test
//    ENDFUNCTION
//
//    #include "alias.ch"
//    STATIC FUNCTION CreateTest()
//       fCreateDbf("Test/Name/C/32/Balance/N/12/2/Date/D/Over21/L/Notes/M")
//       USE Test NEW EXCLUSIVE
//    ENDFUNCTION
//
// Files:
//    none
//
// Description:
//    Displays the structure of the file in the specified or current work
//    area.
//
// Category:
//    File Function
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

FUNCTION fDispStru(cAlias)
   LOCAL aStructure := {}, cScreen, nSelect, lOpened := .n.
   nSelect := Select()
   DEFAULT cAlias TO Alias()
   IF Select(cAlias)>0
      SELECT (Select(cAlias))
   ELSE
      USE (cAlias) NEW SHARED READONLY
      lOpened := .y.
   ENDIF
   aStructure := dbStruct()
   IF lOpened
      CLOSE
      SELECT (nSelect)
   ENDIF
   cScreen := vSave()
   vCursSave()
   CLS
   aEval(aStructure, {|aField|Qout(sSetLength(aField[1],10), aField[2],;
         aField[3], aField[4]), vPause()})
   @ MaxRow(), 0
   @ MaxRow(), 0 SAY 'Press any key when through...'
   Inkey(0)
   vRestore(cScreen)
   vCursRest()
ENDFUNCTION
